/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.util;

import com.google.ical.util.TimeUtils;
import com.google.ical.values.DateTimeValue;
import com.google.ical.values.DateTimeValueImpl;
import com.google.ical.values.DateValue;
import com.google.ical.values.DateValueImpl;
import com.google.ical.values.TimeValue;

public class DTBuilder {
    public int year;
    public int month;
    public int day;
    public int hour;
    public int minute;
    public int second;

    public DTBuilder(int year, int month, int day, int hour, int minute, int second) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }

    public DTBuilder(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public DTBuilder(DateValue dv) {
        this.year = dv.year();
        this.month = dv.month();
        this.day = dv.day();
        if (dv instanceof TimeValue) {
            TimeValue tv = (TimeValue)((Object)dv);
            this.hour = tv.hour();
            this.minute = tv.minute();
            this.second = tv.second();
        }
    }

    public DateTimeValue toDateTime() {
        this.normalize();
        return new DateTimeValueImpl(this.year, this.month, this.day, this.hour, this.minute, this.second);
    }

    public DateValue toDate() {
        this.normalize();
        return new DateValueImpl(this.year, this.month, this.day);
    }

    public int compareTo(DateValue dv) {
        long delta;
        long dvComparable = (((long)dv.year() << 4) + (long)dv.month() << 5) + (long)dv.day();
        long dtbComparable = (((long)this.year << 4) + (long)this.month << 5) + (long)this.day;
        if (dv instanceof TimeValue) {
            TimeValue tv = (TimeValue)((Object)dv);
            dvComparable = (((dvComparable << 5) + (long)tv.hour() << 6) + (long)tv.minute() << 6) + (long)tv.second();
            dtbComparable = (((dtbComparable << 5) + (long)this.hour << 6) + (long)this.minute << 6) + (long)this.second;
        }
        return (delta = dtbComparable - dvComparable) < 0L ? -1 : (delta == 0L ? 0 : 1);
    }

    public void normalize() {
        this.normalizeTime();
        this.normalizeDate();
    }

    public String toString() {
        return String.valueOf(this.year) + "-" + this.month + "-" + this.day + " " + this.hour + ":" + this.minute + ":" + this.second;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DTBuilder)) {
            return false;
        }
        DTBuilder that = (DTBuilder)o;
        return this.year == that.year && this.month == that.month && this.day == that.day && this.hour == that.hour && this.minute == that.minute && this.second == that.second;
    }

    public int hashCode() {
        return (((((this.year << 4) + this.month << 5) + this.day << 5) + this.hour << 6) + this.minute << 6) + this.second;
    }

    private void normalizeTime() {
        int addMinutes = (this.second < 0 ? this.second - 59 : this.second) / 60;
        this.second -= addMinutes * 60;
        this.minute += addMinutes;
        int addHours = (this.minute < 0 ? this.minute - 59 : this.minute) / 60;
        this.minute -= addHours * 60;
        this.hour += addHours;
        int addDays = (this.hour < 0 ? this.hour - 23 : this.hour) / 24;
        this.hour -= addDays * 24;
        this.day += addDays;
    }

    private void normalizeDate() {
        int years;
        while (this.day <= 0) {
            int days = TimeUtils.yearLength(this.month > 2 ? this.year : this.year - 1);
            this.day += days;
            --this.year;
        }
        if (this.month <= 0) {
            years = this.month / 12 - 1;
            this.year += years;
            this.month -= 12 * years;
        } else if (this.month > 12) {
            years = (this.month - 1) / 12;
            this.year += years;
            this.month -= 12 * years;
        }
        while (true) {
            int monthLength;
            int yearLength;
            if (this.month == 1 && this.day > (yearLength = TimeUtils.yearLength(this.year))) {
                ++this.year;
                this.day -= yearLength;
            }
            if (this.day <= (monthLength = TimeUtils.monthLength(this.year, this.month))) break;
            this.day -= monthLength;
            if (++this.month <= 12) continue;
            this.month -= 12;
            ++this.year;
        }
    }
}

