/*
 * Decompiled with CFR 0.152.
 */
package com.metaparadigm.jsonrpc;

import com.metaparadigm.jsonrpc.AbstractSerializer;
import com.metaparadigm.jsonrpc.MarshallException;
import com.metaparadigm.jsonrpc.ObjectMatch;
import com.metaparadigm.jsonrpc.SerializerState;
import com.metaparadigm.jsonrpc.UnmarshallException;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONObject;

public class SetSerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 1L;
    private static Class[] _serializableClasses = new Class[]{Set.class, HashSet.class, TreeSet.class, LinkedHashSet.class};
    private static Class[] _JSONClasses = new Class[]{JSONObject.class};

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public boolean canSerialize(Class clazz, Class jsonClazz) {
        return super.canSerialize(clazz, jsonClazz) || (jsonClazz == null || jsonClazz == JSONObject.class) && Set.class.isAssignableFrom(clazz);
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        JSONObject jso = (JSONObject)o;
        String java_class = jso.getString("javaClass");
        if (java_class == null) {
            throw new UnmarshallException("no type hint");
        }
        if (!(java_class.equals("java.util.Set") || java_class.equals("java.util.AbstractSet") || java_class.equals("java.util.LinkedHashSet") || java_class.equals("java.util.TreeSet") || java_class.equals("java.util.HashSet"))) {
            throw new UnmarshallException("not a Set");
        }
        JSONObject jsonset = jso.getJSONObject("set");
        if (jsonset == null) {
            throw new UnmarshallException("set missing");
        }
        ObjectMatch m = new ObjectMatch(-1);
        Iterator i = jsonset.keys();
        String key = null;
        try {
            while (i.hasNext()) {
                key = (String)i.next();
                m = this.ser.tryUnmarshall(state, null, jsonset.get(key)).max(m);
            }
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("key " + key + " " + e.getMessage());
        }
        return m;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        JSONObject jso = (JSONObject)o;
        String java_class = jso.getString("javaClass");
        if (java_class == null) {
            throw new UnmarshallException("no type hint");
        }
        AbstractSet abset = null;
        if (java_class.equals("java.util.Set") || java_class.equals("java.util.AbstractSet") || java_class.equals("java.util.HashSet")) {
            abset = new HashSet();
        } else if (java_class.equals("java.util.TreeSet")) {
            abset = new TreeSet();
        } else if (java_class.equals("java.util.LinkedHashSet")) {
            abset = new LinkedHashSet();
        } else {
            throw new UnmarshallException("not a Set");
        }
        JSONObject jsonset = jso.getJSONObject("set");
        if (jsonset == null) {
            throw new UnmarshallException("set missing");
        }
        Iterator i = jsonset.keys();
        String key = null;
        try {
            while (i.hasNext()) {
                key = (String)i.next();
                Object setElement = jsonset.get(key);
                abset.add(this.ser.unmarshall(state, null, setElement));
            }
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("key " + i + e.getMessage());
        }
        return abset;
    }

    public Object marshall(SerializerState state, Object o) throws MarshallException {
        Set set = (Set)o;
        JSONObject obj = new JSONObject();
        JSONObject setdata = new JSONObject();
        if (this.ser.getMarshallClassHints()) {
            obj.put("javaClass", (Object)o.getClass().getName());
        }
        obj.put("set", (Object)setdata);
        Object key = null;
        Iterator i = set.iterator();
        try {
            while (i.hasNext()) {
                key = i.next();
                setdata.put(key.toString(), this.ser.marshall(state, key));
            }
        }
        catch (MarshallException e) {
            throw new MarshallException("set key " + key + e.getMessage());
        }
        return obj;
    }
}

