/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import java.util.Map;
import org.jruby.RubyModule;
import org.jruby.compiler.ir.IRModule;
import org.jruby.compiler.ir.IRScope;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.GetInstr;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.SearchConstInstr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetConstInstr
extends GetInstr {
    public GetConstInstr(Variable dest, Operand scopeOrObj, String constName) {
        super(Operation.GET_CONST, dest, scopeOrObj, constName);
    }

    @Override
    public Operand simplifyAndGetResult(Map<Operand, Operand> valueMap) {
        this.simplifyOperands(valueMap);
        if (!(this.getSource() instanceof MetaObject)) {
            return null;
        }
        IRScope s2 = ((MetaObject)this.getSource()).scope;
        return s2 instanceof IRModule ? ((IRModule)s2).getConstantValue(this.getName()) : null;
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new SearchConstInstr(ii.getRenamedVariable(this.result), this.getSource().cloneForInlining(ii), this.getName());
    }

    @Override
    public Label interpret(InterpreterContext interp, IRubyObject self) {
        Object source2 = this.getSource().retrieve(interp);
        RubyModule module = source2 instanceof Block ? ((Block)source2).getBinding().getKlass() : (RubyModule)source2;
        this.getResult().store(interp, module.getConstant(this.getName()));
        return null;
    }
}

