/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnBase;
import org.hsqldb.ColumnSchema;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementCursor;
import org.hsqldb.StatementExpression;
import org.hsqldb.StatementHandler;
import org.hsqldb.StatementQuery;
import org.hsqldb.StatementSimple;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.result.Result;
import org.hsqldb.types.Type;

public class StatementCompound
extends Statement {
    final boolean isLoop;
    HsqlNameManager.HsqlName label;
    StatementHandler[] handlers = StatementHandler.emptyExceptionHandlerArray;
    boolean hasUndoHandler;
    StatementQuery loopCursor;
    Statement[] statements;
    StatementExpression condition;
    boolean isAtomic;
    ColumnSchema[] variables = ColumnSchema.emptyArray;
    StatementCursor[] cursors = StatementCursor.emptyArray;
    HashMappedList scopeVariables;
    RangeVariable[] rangeVariables = RangeVariable.emptyArray;
    Table[] tables = Table.emptyArray;
    HashMappedList scopeTables;
    public static final StatementCompound[] emptyStatementArray = new StatementCompound[0];

    StatementCompound(int type, HsqlNameManager.HsqlName label) {
        super(type, 2007);
        this.label = label;
        this.isTransactionStatement = false;
        switch (type) {
            case 46: 
            case 90: 
            case 95: 
            case 97: {
                this.isLoop = true;
                break;
            }
            case 12: 
            case 88: {
                this.isLoop = false;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementCompound");
            }
        }
    }

    public String getSQL() {
        return this.sql;
    }

    protected String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer();
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        sb.append("STATEMENT");
        return sb.toString();
    }

    public void setLocalDeclarations(Object[] declarations) {
        int i;
        int varCount = 0;
        int handlerCount = 0;
        int cursorCount = 0;
        int tableCount = 0;
        for (i = 0; i < declarations.length; ++i) {
            if (declarations[i] instanceof ColumnSchema) {
                ++varCount;
                continue;
            }
            if (declarations[i] instanceof StatementHandler) {
                ++handlerCount;
                continue;
            }
            if (declarations[i] instanceof Table) {
                ++tableCount;
                continue;
            }
            ++cursorCount;
        }
        if (varCount > 0) {
            this.variables = new ColumnSchema[varCount];
        }
        if (handlerCount > 0) {
            this.handlers = new StatementHandler[handlerCount];
        }
        if (tableCount > 0) {
            this.tables = new Table[tableCount];
        }
        if (cursorCount > 0) {
            this.cursors = new StatementCursor[cursorCount];
        }
        varCount = 0;
        handlerCount = 0;
        tableCount = 0;
        cursorCount = 0;
        for (i = 0; i < declarations.length; ++i) {
            if (declarations[i] instanceof ColumnSchema) {
                this.variables[varCount++] = (ColumnSchema)declarations[i];
                continue;
            }
            if (declarations[i] instanceof StatementHandler) {
                StatementHandler handler = (StatementHandler)declarations[i];
                handler.setParent(this);
                this.handlers[handlerCount++] = handler;
                if (handler.handlerType != 7) continue;
                this.hasUndoHandler = true;
                continue;
            }
            if (declarations[i] instanceof Table) {
                Table table = (Table)declarations[i];
                this.tables[tableCount++] = table;
                continue;
            }
            StatementCursor cursor = (StatementCursor)declarations[i];
            this.cursors[cursorCount++] = cursor;
        }
        this.setVariables();
        this.setHandlers();
        this.setTables();
        this.setCursors();
    }

    public void setLoopStatement(StatementQuery cursorStatement) {
        this.loopCursor = cursorStatement;
        HsqlNameManager.HsqlName[] colNames = cursorStatement.queryExpression.getResultColumnNames();
        Type[] colTypes = cursorStatement.queryExpression.getColumnTypes();
        Object[] columns = new ColumnSchema[colNames.length];
        for (int i = 0; i < colNames.length; ++i) {
            columns[i] = new ColumnSchema(colNames[i], colTypes[i], false, false, null);
            ((ColumnBase)columns[i]).setParameterMode((byte)1);
        }
        this.setLocalDeclarations(columns);
    }

    void setStatements(Statement[] statements) {
        for (int i = 0; i < statements.length; ++i) {
            statements[i].setParent(this);
        }
        this.statements = statements;
    }

    public void setCondition(StatementExpression condition) {
        this.condition = condition;
    }

    public Result execute(Session session) {
        Result result;
        switch (this.type) {
            case 12: {
                this.initialiseVariables(session);
                result = this.executeBlock(session);
                break;
            }
            case 46: {
                result = this.executeForLoop(session);
                break;
            }
            case 90: 
            case 95: 
            case 97: {
                result = this.executeLoop(session);
                break;
            }
            case 88: {
                result = this.executeIf(session);
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementCompound");
            }
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    private Result executeBlock(Session session) {
        boolean push;
        Result result = Result.updateZeroResult;
        boolean bl = push = !this.root.isTrigger();
        if (push) {
            session.sessionContext.push();
            if (this.hasUndoHandler) {
                String name = HsqlNameManager.getAutoSavepointNameString(session.actionTimestamp, session.sessionContext.depth);
                session.savepoint(name);
            }
        }
        for (int i = 0; i < this.statements.length; ++i) {
            result = this.statements[i].execute(session);
            if ((result = this.handleCondition(session, result)).isError() || result.getType() == 42 || result.getType() == 3) break;
        }
        if (result.getType() == 42 && result.getErrorCode() == 89) {
            if (result.getMainString() == null) {
                result = Result.updateZeroResult;
            } else if (this.label != null && this.label.name.equals(result.getMainString())) {
                result = Result.updateZeroResult;
            }
        }
        if (push) {
            session.sessionContext.pop();
        }
        return result;
    }

    private Result handleCondition(Session session, Result result) {
        String sqlState = null;
        if (result.isError()) {
            sqlState = result.getSubString();
        } else if (session.getLastWarning() != null) {
            sqlState = session.getLastWarning().getSQLState();
        } else {
            return result;
        }
        if (sqlState != null) {
            for (int i = 0; i < this.handlers.length; ++i) {
                StatementHandler handler = this.handlers[i];
                session.clearWarnings();
                if (!handler.handlesCondition(result.getSubString())) continue;
                session.resetSchema();
                switch (handler.handlerType) {
                    case 5: {
                        result = Result.updateZeroResult;
                        break;
                    }
                    case 7: {
                        session.rollbackToSavepoint();
                        result = Result.newPSMResult(89, this.label.name, null);
                        break;
                    }
                    case 6: {
                        result = Result.newPSMResult(89, null, null);
                    }
                }
                Result actionResult = handler.statement.execute(session);
                if (actionResult.isError()) {
                    result = actionResult;
                    this.handleCondition(session, result);
                    continue;
                }
                return result;
            }
            if (this.parent != null) {
                return this.parent.handleCondition(session, result);
            }
        }
        return result;
    }

    private Result executeForLoop(Session session) {
        Result queryResult = this.loopCursor.getResult(session);
        if (queryResult.isError()) {
            return queryResult;
        }
        Result result = Result.updateZeroResult;
        while (queryResult.navigator.hasNext()) {
            queryResult.navigator.next();
            Object[] data = queryResult.navigator.getCurrent();
            this.initialiseVariables(session, data);
            for (int i = 0; i < this.statements.length && !(result = this.statements[i].execute(session)).isError() && result.getType() != 42 && result.getType() != 3; ++i) {
            }
            if (result.isError()) break;
            if (result.getType() == 42) {
                if (result.getErrorCode() == 102) {
                    if (result.getMainString() != null && (this.label == null || !this.label.name.equals(result.getMainString()))) break;
                    continue;
                }
                if (result.getErrorCode() != 89) break;
                break;
            }
            if (result.getType() != 3) continue;
            break;
        }
        queryResult.navigator.close();
        return result;
    }

    private Result executeLoop(Session session) {
        Result result;
        block9: {
            result = Result.updateZeroResult;
            while (true) {
                if (this.type == 97) {
                    result = this.condition.execute(session);
                    if (result.isError()) break block9;
                    if (!Boolean.TRUE.equals(result.getValueObject())) {
                        result = Result.updateZeroResult;
                        break block9;
                    }
                }
                for (int i = 0; i < this.statements.length && !(result = this.statements[i].execute(session)).isError() && result.getType() != 42 && result.getType() != 3; ++i) {
                }
                if (result.isError()) break block9;
                if (result.getType() == 42) {
                    if (result.getErrorCode() == 102) {
                        if (result.getMainString() == null || this.label != null && this.label.name.equals(result.getMainString())) {
                            continue;
                        }
                        break block9;
                    }
                    if (result.getErrorCode() != 89) break block9;
                    if (result.getMainString() == null) {
                        result = Result.updateZeroResult;
                    }
                    if (this.label != null && this.label.name.equals(result.getMainString())) {
                        result = Result.updateZeroResult;
                    }
                    break block9;
                }
                if (result.getType() == 3) break block9;
                if (this.type != 95) continue;
                result = this.condition.execute(session);
                if (result.isError()) break block9;
                if (Boolean.TRUE.equals(result.getValueObject())) break;
            }
            result = Result.updateZeroResult;
        }
        return result;
    }

    private Result executeIf(Session session) {
        Result result = Result.updateZeroResult;
        boolean execute = false;
        for (int i = 0; i < this.statements.length; ++i) {
            if (this.statements[i].getType() == 1201) {
                if (execute || (result = this.statements[i].execute(session)).isError()) break;
                Object value = result.getValueObject();
                execute = Boolean.TRUE.equals(value);
                ++i;
            }
            result = Result.updateZeroResult;
            if (execute && ((result = this.statements[i].execute(session)).isError() || result.getType() == 42)) break;
        }
        return result;
    }

    public void resolve(Session session) {
        int i;
        int i2;
        for (i2 = 0; i2 < this.statements.length; ++i2) {
            if (this.statements[i2].getType() == 89 || this.statements[i2].getType() == 102) {
                if (this.findLabel((StatementSimple)this.statements[i2])) continue;
                throw Error.error(5508, ((StatementSimple)this.statements[i2]).label.name);
            }
            if (this.statements[i2].getType() != 58 || this.root.isFunction()) continue;
            throw Error.error(5602, "RETURN");
        }
        for (i2 = 0; i2 < this.statements.length; ++i2) {
            this.statements[i2].resolve(session);
        }
        for (i2 = 0; i2 < this.handlers.length; ++i2) {
            this.handlers[i2].resolve(session);
        }
        OrderedHashSet writeTableNamesSet = new OrderedHashSet();
        OrderedHashSet readTableNamesSet = new OrderedHashSet();
        OrderedHashSet set = new OrderedHashSet();
        for (i = 0; i < this.variables.length; ++i) {
            set.addAll(this.variables[i].getReferences());
        }
        if (this.condition != null) {
            set.addAll(this.condition.getReferences());
            readTableNamesSet.addAll(this.condition.getTableNamesForRead());
        }
        for (i = 0; i < this.statements.length; ++i) {
            set.addAll(this.statements[i].getReferences());
            readTableNamesSet.addAll(this.statements[i].getTableNamesForRead());
            writeTableNamesSet.addAll(this.statements[i].getTableNamesForWrite());
        }
        for (i = 0; i < this.handlers.length; ++i) {
            set.addAll(this.handlers[i].getReferences());
            readTableNamesSet.addAll(this.handlers[i].getTableNamesForRead());
            writeTableNamesSet.addAll(this.handlers[i].getTableNamesForWrite());
        }
        readTableNamesSet.removeAll(writeTableNamesSet);
        this.readTableNames = new HsqlNameManager.HsqlName[readTableNamesSet.size()];
        readTableNamesSet.toArray(this.readTableNames);
        this.writeTableNames = new HsqlNameManager.HsqlName[writeTableNamesSet.size()];
        writeTableNamesSet.toArray(this.writeTableNames);
        this.references = set;
    }

    public void setRoot(Routine routine) {
        this.root = routine;
    }

    public String describe(Session session) {
        return "";
    }

    public OrderedHashSet getReferences() {
        return this.references;
    }

    public void setAtomic(boolean atomic) {
        this.isAtomic = atomic;
    }

    private void setVariables() {
        int i;
        HashMappedList list = new HashMappedList();
        if (this.variables.length == 0) {
            this.rangeVariables = this.parent == null ? this.root.getParameterRangeVariables() : this.parent.rangeVariables;
            this.scopeVariables = list;
            return;
        }
        if (this.parent != null && this.parent.scopeVariables != null) {
            for (i = 0; i < this.parent.scopeVariables.size(); ++i) {
                list.add(this.parent.scopeVariables.getKey(i), this.parent.scopeVariables.get(i));
            }
        }
        for (i = 0; i < this.variables.length; ++i) {
            String name = this.variables[i].getName().name;
            boolean added = list.add(name, this.variables[i]);
            if (!added) {
                throw Error.error(5606, name);
            }
            if (this.root.getParameterIndex(name) == -1) continue;
            throw Error.error(5606, name);
        }
        this.scopeVariables = list;
        RangeVariable[] parameterRangeVariables = this.root.getParameterRangeVariables();
        RangeVariable range = new RangeVariable(list, null, true, 4);
        this.rangeVariables = new RangeVariable[parameterRangeVariables.length + 1];
        for (int i2 = 0; i2 < parameterRangeVariables.length; ++i2) {
            this.rangeVariables[i2] = parameterRangeVariables[i2];
        }
        this.rangeVariables[parameterRangeVariables.length] = range;
        this.root.variableCount = list.size();
    }

    private void setHandlers() {
        if (this.handlers.length == 0) {
            return;
        }
        HashSet statesSet = new HashSet();
        OrderedIntHashSet typesSet = new OrderedIntHashSet();
        for (int i = 0; i < this.handlers.length; ++i) {
            int[] types = this.handlers[i].getConditionTypes();
            for (int j = 0; j < types.length; ++j) {
                if (typesSet.add(types[j])) continue;
                throw Error.error(5601);
            }
            String[] states = this.handlers[i].getConditionStates();
            for (int j = 0; j < states.length; ++j) {
                if (statesSet.add(states[j])) continue;
                throw Error.error(5601);
            }
        }
    }

    private void setTables() {
        int i;
        if (this.tables.length == 0) {
            return;
        }
        HashMappedList list = new HashMappedList();
        if (this.parent != null && this.parent.scopeTables != null) {
            for (i = 0; i < this.parent.scopeTables.size(); ++i) {
                list.add(this.parent.scopeTables.getKey(i), this.parent.scopeTables.get(i));
            }
        }
        for (i = 0; i < this.tables.length; ++i) {
            String name = this.tables[i].getName().name;
            boolean added = list.add(name, this.tables[i]);
            if (added) continue;
            throw Error.error(5606, name);
        }
        this.scopeTables = list;
    }

    private void setCursors() {
        if (this.cursors.length == 0) {
            return;
        }
        HashSet list = new HashSet();
        for (int i = 0; i < this.cursors.length; ++i) {
            StatementCursor cursor = this.cursors[i];
            boolean added = list.add(cursor.getCursorName().name);
            if (added) continue;
            throw Error.error(5606, cursor.getCursorName().name);
        }
    }

    private boolean findLabel(StatementSimple statement) {
        if (this.label != null && statement.label.name.equals(this.label.name)) {
            return this.isLoop || statement.getType() != 102;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.findLabel(statement);
    }

    private void initialiseVariables(Session session) {
        Object[] vars = session.sessionContext.routineVariables;
        int offset = this.parent == null ? 0 : this.parent.scopeVariables.size();
        for (int i = 0; i < this.variables.length; ++i) {
            try {
                vars[offset + i] = this.variables[i].getDefaultValue(session);
                continue;
            }
            catch (HsqlException e) {
                // empty catch block
            }
        }
    }

    private void initialiseVariables(Session session, Object[] data) {
        Object[] vars = session.sessionContext.routineVariables;
        int offset = this.parent == null ? 0 : this.parent.scopeVariables.size();
        for (int i = 0; i < data.length; ++i) {
            try {
                vars[offset + i] = data[i];
                continue;
            }
            catch (HsqlException e) {
                // empty catch block
            }
        }
    }

    public RangeVariable[] getRangeVariables() {
        return this.rangeVariables;
    }
}

