/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.LineGroupReader;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.persist.LobStore;
import org.hsqldb.persist.LobStoreInJar;
import org.hsqldb.persist.LobStoreMem;
import org.hsqldb.persist.LobStoreRAFile;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;

public class LobManager {
    static final String resourceFileName = "/org/hsqldb/resources/lob-schema.sql";
    static final String[] starters = new String[]{"/*"};
    Database database;
    LobStore lobStore;
    Session sysLobSession;
    volatile boolean storeModified;
    int lobBlockSize;
    int totalBlockLimitCount = Integer.MAX_VALUE;
    Statement getLob;
    Statement getLobPart;
    Statement deleteLobCall;
    Statement deleteLobPartCall;
    Statement divideLobPartCall;
    Statement createLob;
    Statement createLobPartCall;
    Statement updateLobLength;
    Statement updateLobUsage;
    Statement getNextLobId;
    Statement deleteUnusedLobs;
    Statement getLobCount;
    boolean usageCountChanged;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock writeLock = this.lock.writeLock();
    private static final String initialiseBlocksSQL = "INSERT INTO SYSTEM_LOBS.BLOCKS VALUES(?,?,?)";
    private static final String getLobSQL = "SELECT * FROM SYSTEM_LOBS.LOB_IDS WHERE LOB_ID = ?";
    private static final String getLobPartSQL = "SELECT * FROM SYSTEM_LOBS.LOBS WHERE LOB_ID = ? AND BLOCK_OFFSET + BLOCK_COUNT > ? AND BLOCK_OFFSET < ? ORDER BY BLOCK_OFFSET";
    private static final String deleteLobPartCallSQL = "CALL SYSTEM_LOBS.DELETE_BLOCKS(?,?,?,?)";
    private static final String createLobSQL = "INSERT INTO SYSTEM_LOBS.LOB_IDS VALUES(?, ?, ?, ?)";
    private static final String updateLobLengthSQL = "UPDATE SYSTEM_LOBS.LOB_IDS SET LOB_LENGTH = ? WHERE LOB_ID = ?";
    private static final String createLobPartCallSQL = "CALL SYSTEM_LOBS.ALLOC_BLOCKS(?, ?, ?)";
    private static final String divideLobPartCallSQL = "CALL SYSTEM_LOBS.DIVIDE_BLOCK(?, ?)";
    private static final String getSpanningBlockSQL = "SELECT * FROM SYSTEM_LOBS.LOBS WHERE LOB_ID = ? AND ? > BLOCK_OFFSET AND ? < BLOCK_OFFSET + BLOCK_COUNT";
    private static final String updateLobUsageSQL = "UPDATE SYSTEM_LOBS.LOB_IDS SET LOB_USAGE_COUNT = (CASE LOB_USAGE_COUNT WHEN 2147483647 THEN 0 ELSE LOB_USAGE_COUNT END) + ? WHERE LOB_ID = ?";
    private static final String getNextLobIdSQL = "VALUES NEXT VALUE FOR SYSTEM_LOBS.LOB_ID";
    private static final String deleteLobCallSQL = "CALL SYSTEM_LOBS.DELETE_LOB(?, ?)";
    private static final String deleteUnusedCallSQL = "CALL SYSTEM_LOBS.DELETE_UNUSED()";
    private static final String getLobCountSQL = "SELECT COUNT(*) FROM SYSTEM_LOBS.LOB_IDS";

    public LobManager(Database database) {
        this.database = database;
    }

    public void lock() {
        this.writeLock.lock();
    }

    public void unlock() {
        this.writeLock.unlock();
    }

    public void createSchema() {
        this.sysLobSession = this.database.sessionManager.getSysLobSession();
        InputStream fis = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public InputStream run() {
                return this.getClass().getResourceAsStream(LobManager.resourceFileName);
            }
        });
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(fis, "ISO-8859-1");
        }
        catch (Exception e) {
            // empty catch block
        }
        LineNumberReader lineReader = new LineNumberReader(reader);
        LineGroupReader lg = new LineGroupReader(lineReader, starters);
        HashMappedList map = lg.getAsMap();
        lg.close();
        String sql = (String)map.get("/*lob_schema_definition*/");
        Statement statement = this.sysLobSession.compileStatement(sql);
        Result result = statement.execute(this.sysLobSession);
        if (result.isError()) {
            throw result.getException();
        }
        HsqlNameManager.HsqlName name = this.database.schemaManager.getSchemaHsqlName("SYSTEM_LOBS");
        Table table = this.database.schemaManager.getTable(this.sysLobSession, "BLOCKS", "SYSTEM_LOBS");
        this.compileStatements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileStatements() {
        this.writeLock.lock();
        try {
            this.getLob = this.sysLobSession.compileStatement(getLobSQL);
            this.getLobPart = this.sysLobSession.compileStatement(getLobPartSQL);
            this.createLob = this.sysLobSession.compileStatement(createLobSQL);
            this.createLobPartCall = this.sysLobSession.compileStatement(createLobPartCallSQL);
            this.divideLobPartCall = this.sysLobSession.compileStatement(divideLobPartCallSQL);
            this.deleteLobCall = this.sysLobSession.compileStatement(deleteLobCallSQL);
            this.deleteLobPartCall = this.sysLobSession.compileStatement(deleteLobPartCallSQL);
            this.updateLobLength = this.sysLobSession.compileStatement(updateLobLengthSQL);
            this.updateLobUsage = this.sysLobSession.compileStatement(updateLobUsageSQL);
            this.getNextLobId = this.sysLobSession.compileStatement(getNextLobIdSQL);
            this.deleteUnusedLobs = this.sysLobSession.compileStatement(deleteUnusedCallSQL);
            this.getLobCount = this.sysLobSession.compileStatement(getLobCountSQL);
            Object var2_1 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    public void initialiseLobSpace() {
        Statement statement = this.sysLobSession.compileStatement(initialiseBlocksSQL);
        Object[] params = new Object[]{ValuePool.INTEGER_0, ValuePool.getInt(this.totalBlockLimitCount), ValuePool.getLong(0L)};
        this.sysLobSession.executeCompiledStatement(statement, params);
    }

    public void open() {
        this.lobBlockSize = this.database.logger.getLobBlockSize();
        this.lobStore = this.database.getType() == "res:" ? new LobStoreInJar(this.database, this.lobBlockSize) : (this.database.getType() == "file:" ? new LobStoreRAFile(this.database, this.lobBlockSize) : new LobStoreMem(this.lobBlockSize));
    }

    public void close() {
        this.lobStore.close();
    }

    public LobStore getLobStore() {
        if (this.lobStore == null) {
            this.open();
        }
        return this.lobStore;
    }

    private long getNewLobID() {
        Result result = this.getNextLobId.execute(this.sysLobSession);
        if (result.isError()) {
            return 0L;
        }
        RowSetNavigator navigator = result.getNavigator();
        boolean next = navigator.next();
        if (!next) {
            navigator.close();
            return 0L;
        }
        Object[] data = navigator.getCurrent();
        return (Long)data[0];
    }

    private Object[] getLobHeader(long lobID) {
        ResultMetaData meta = this.getLob.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getLong(lobID);
        this.sysLobSession.sessionContext.pushDynamicArguments(params);
        Result result = this.getLob.execute(this.sysLobSession);
        this.sysLobSession.sessionContext.pop();
        if (result.isError()) {
            return null;
        }
        RowSetNavigator navigator = result.getNavigator();
        boolean next = navigator.next();
        if (!next) {
            navigator.close();
            return null;
        }
        Object[] data = navigator.getCurrent();
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobData getBlob(long lobID) {
        BlobDataID blob;
        block3: {
            this.writeLock.lock();
            try {
                Object[] data = this.getLobHeader(lobID);
                if (data != null) break block3;
                BlobData blobData = null;
                Object var7_5 = null;
                this.writeLock.unlock();
                return blobData;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }
        BlobDataID blobDataID = blob = new BlobDataID(lobID);
        Object var7_6 = null;
        this.writeLock.unlock();
        return blobDataID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClobData getClob(long lobID) {
        ClobDataID clob;
        block3: {
            this.writeLock.lock();
            try {
                Object[] data = this.getLobHeader(lobID);
                if (data != null) break block3;
                ClobData clobData = null;
                Object var7_5 = null;
                this.writeLock.unlock();
                return clobData;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }
        ClobDataID clobDataID = clob = new ClobDataID(lobID);
        Object var7_6 = null;
        this.writeLock.unlock();
        return clobDataID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createBlob(long length) {
        this.writeLock.lock();
        try {
            long lobID = this.getNewLobID();
            ResultMetaData meta = this.createLob.getParametersMetaData();
            Object[] params = new Object[meta.getColumnCount()];
            params[0] = ValuePool.getLong(lobID);
            params[1] = ValuePool.getLong(length);
            params[2] = ValuePool.INTEGER_MAX;
            params[3] = ValuePool.getInt(30);
            Result result = this.sysLobSession.executeCompiledStatement(this.createLob, params);
            this.usageCountChanged = true;
            long l = lobID;
            Object var11_7 = null;
            this.writeLock.unlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createClob(long length) {
        this.writeLock.lock();
        try {
            long lobID = this.getNewLobID();
            ResultMetaData meta = this.createLob.getParametersMetaData();
            Object[] params = new Object[meta.getColumnCount()];
            params[0] = ValuePool.getLong(lobID);
            params[1] = ValuePool.getLong(length);
            params[2] = ValuePool.INTEGER_MAX;
            params[3] = ValuePool.getInt(40);
            Result result = this.sysLobSession.executeCompiledStatement(this.createLob, params);
            this.usageCountChanged = true;
            long l = lobID;
            Object var11_7 = null;
            this.writeLock.unlock();
            return l;
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result deleteLob(long lobID) {
        this.writeLock.lock();
        try {
            ResultMetaData meta = this.deleteLobCall.getParametersMetaData();
            Object[] params = new Object[meta.getColumnCount()];
            params[0] = ValuePool.getLong(lobID);
            params[1] = ValuePool.getLong(0L);
            Result result = this.sysLobSession.executeCompiledStatement(this.deleteLobCall, params);
            this.usageCountChanged = true;
            Result result2 = result;
            Object var8_6 = null;
            this.writeLock.unlock();
            return result2;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result deleteUnusedLobs() {
        block3: {
            this.writeLock.lock();
            try {
                if (this.usageCountChanged) break block3;
                Result result = Result.updateZeroResult;
                Object var4_3 = null;
                this.writeLock.unlock();
                return result;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }
        Result result = this.sysLobSession.executeCompiledStatement(this.deleteUnusedLobs, ValuePool.emptyObjectArray);
        this.usageCountChanged = false;
        Result result2 = result;
        Object var4_4 = null;
        this.writeLock.unlock();
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getLength(long lobID) {
        ResultLob resultLob;
        this.writeLock.lock();
        try {
            Object[] data = this.getLobHeader(lobID);
            if (data == null) {
                throw Error.error(3474);
            }
            long length = (Long)data[1];
            int type = (Integer)data[3];
            resultLob = ResultLob.newLobSetResponse(lobID, length);
            Object var9_8 = null;
        }
        catch (HsqlException e) {
            try {
                Result result = Result.newErrorResult(e);
                Object var9_9 = null;
                this.writeLock.unlock();
                return result;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }
        this.writeLock.unlock();
        return resultLob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int compare(BlobData a, byte[] b) {
        int n;
        block9: {
            int n2;
            block8: {
                int n3;
                block7: {
                    this.writeLock.lock();
                    try {
                        Object[] data = this.getLobHeader(a.getId());
                        long aLength = (Long)data[1];
                        int[][] aAddresses = this.getBlockAddresses(a.getId(), 0, Integer.MAX_VALUE);
                        int aIndex = 0;
                        int bOffset = 0;
                        int aOffset = 0;
                        do {
                            int aBlockOffset = aAddresses[aIndex][0] + aOffset;
                            byte[] aBytes = this.getLobStore().getBlockBytes(aBlockOffset, 1);
                            for (int i = 0; i < aBytes.length; ++i) {
                                if (bOffset + i >= b.length) {
                                    if (aLength == (long)b.length) {
                                        int n4 = 0;
                                        Object var15_15 = null;
                                        this.writeLock.unlock();
                                        return n4;
                                    }
                                    n3 = 1;
                                    break block7;
                                }
                                if (aBytes[i] == b[bOffset + i]) {
                                    continue;
                                }
                                n2 = (aBytes[i] & 0xFF) > (b[bOffset + i] & 0xFF) ? 1 : -1;
                                break block8;
                            }
                            bOffset += this.lobBlockSize;
                            if (++aOffset != aAddresses[aIndex][1]) continue;
                            aOffset = 0;
                            ++aIndex;
                        } while (aIndex != aAddresses.length);
                        n = -1;
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var15_19 = null;
                        this.writeLock.unlock();
                        throw throwable;
                    }
                }
                Object var15_16 = null;
                this.writeLock.unlock();
                return n3;
            }
            Object var15_17 = null;
            this.writeLock.unlock();
            return n2;
        }
        Object var15_18 = null;
        this.writeLock.unlock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compare(BlobData a, BlobData b) {
        block10: {
            long lengthB;
            long lengthA;
            block9: {
                Object[] data;
                block8: {
                    block7: {
                        if (a.getId() == b.getId()) {
                            return 0;
                        }
                        this.writeLock.lock();
                        try {
                            data = this.getLobHeader(a.getId());
                            if (data != null) break block7;
                            int n = 1;
                            Object var10_6 = null;
                            this.writeLock.unlock();
                            return n;
                        }
                        catch (Throwable throwable) {
                            Object var10_11 = null;
                            this.writeLock.unlock();
                            throw throwable;
                        }
                    }
                    lengthA = (Long)data[1];
                    data = this.getLobHeader(b.getId());
                    if (data != null) break block8;
                    int n = -1;
                    Object var10_7 = null;
                    this.writeLock.unlock();
                    return n;
                }
                lengthB = (Long)data[1];
                if (lengthA <= lengthB) break block9;
                int n = 1;
                Object var10_8 = null;
                this.writeLock.unlock();
                return n;
            }
            if (lengthA >= lengthB) break block10;
            int n = -1;
            Object var10_9 = null;
            this.writeLock.unlock();
            return n;
        }
        int n = this.compareBytes(a.getId(), b.getId());
        Object var10_10 = null;
        this.writeLock.unlock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int compare(ClobData a, String b) {
        int n;
        this.writeLock.lock();
        try {
            Object[] data = this.getLobHeader(a.getId());
            long aLength = (Long)data[1];
            int[][] aAddresses = this.getBlockAddresses(a.getId(), 0, Integer.MAX_VALUE);
            int aIndex = 0;
            int bOffset = 0;
            int aOffset = 0;
            do {
                String bString;
                int diff;
                int aBlockOffset = aAddresses[aIndex][0] + aOffset;
                byte[] aBytes = this.getLobStore().getBlockBytes(aBlockOffset, 1);
                long aLimit = aLength - (long)((aAddresses[aIndex][2] + aOffset) * this.lobBlockSize / 2);
                if (aLimit > (long)(this.lobBlockSize / 2)) {
                    aLimit = this.lobBlockSize / 2;
                }
                String aString = new String(ArrayUtil.byteArrayToChars(aBytes), 0, (int)aLimit);
                int bLimit = b.length() - bOffset;
                if (bLimit > this.lobBlockSize / 2) {
                    bLimit = this.lobBlockSize / 2;
                }
                if ((diff = this.database.collation.compare(aString, bString = b.substring(bOffset, bOffset + bLimit))) != 0) {
                    int n2 = diff;
                    Object var20_17 = null;
                    this.writeLock.unlock();
                    return n2;
                }
                bOffset += this.lobBlockSize / 2;
                if (++aOffset != aAddresses[aIndex][1]) continue;
                aOffset = 0;
                ++aIndex;
            } while (aIndex != aAddresses.length);
            n = 0;
        }
        catch (Throwable throwable) {
            Object var20_19 = null;
            this.writeLock.unlock();
            throw throwable;
        }
        Object var20_18 = null;
        this.writeLock.unlock();
        return n;
    }

    public int compare(ClobData a, ClobData b) {
        if (a.getId() == b.getId()) {
            return 0;
        }
        return this.compareText(a.getId(), b.getId());
    }

    private int compareBytes(long aID, long bID) {
        int[][] aAddresses = this.getBlockAddresses(aID, 0, Integer.MAX_VALUE);
        int[][] bAddresses = this.getBlockAddresses(bID, 0, Integer.MAX_VALUE);
        int aIndex = 0;
        int bIndex = 0;
        int aOffset = 0;
        int bOffset = 0;
        do {
            int aBlockOffset = aAddresses[aIndex][0] + aOffset;
            int bBlockOffset = bAddresses[bIndex][0] + bOffset;
            byte[] aBytes = this.getLobStore().getBlockBytes(aBlockOffset, 1);
            byte[] bBytes = this.getLobStore().getBlockBytes(bBlockOffset, 1);
            for (int i = 0; i < aBytes.length; ++i) {
                if (aBytes[i] == bBytes[i]) continue;
                return (aBytes[i] & 0xFF) > (bBytes[i] & 0xFF) ? 1 : -1;
            }
            ++bOffset;
            if (++aOffset == aAddresses[aIndex][1]) {
                aOffset = 0;
                ++aIndex;
            }
            if (bOffset != bAddresses[bIndex][1]) continue;
            bOffset = 0;
            ++bIndex;
        } while (aIndex != aAddresses.length);
        return 0;
    }

    private int compareText(long aID, long bID) {
        Object[] data = this.getLobHeader(aID);
        long aLength = (Long)data[1];
        data = this.getLobHeader(bID);
        long bLength = (Long)data[1];
        int[][] aAddresses = this.getBlockAddresses(aID, 0, Integer.MAX_VALUE);
        int[][] bAddresses = this.getBlockAddresses(bID, 0, Integer.MAX_VALUE);
        int aIndex = 0;
        int bIndex = 0;
        int aOffset = 0;
        int bOffset = 0;
        do {
            String bString;
            String aString;
            int diff;
            long bLimit;
            int aBlockOffset = aAddresses[aIndex][0] + aOffset;
            int bBlockOffset = bAddresses[bIndex][0] + bOffset;
            byte[] aBytes = this.getLobStore().getBlockBytes(aBlockOffset, 1);
            byte[] bBytes = this.getLobStore().getBlockBytes(bBlockOffset, 1);
            long aLimit = aLength - (long)((aAddresses[aIndex][2] + aOffset) * this.lobBlockSize / 2);
            if (aLimit > (long)(this.lobBlockSize / 2)) {
                aLimit = this.lobBlockSize / 2;
            }
            if ((bLimit = bLength - (long)((bAddresses[bIndex][2] + bOffset) * this.lobBlockSize / 2)) > (long)(this.lobBlockSize / 2)) {
                bLimit = this.lobBlockSize / 2;
            }
            if ((diff = this.database.collation.compare(aString = new String(ArrayUtil.byteArrayToChars(aBytes), 0, (int)aLimit), bString = new String(ArrayUtil.byteArrayToChars(bBytes), 0, (int)bLimit))) != 0) {
                return diff;
            }
            ++bOffset;
            if (++aOffset == aAddresses[aIndex][1]) {
                aOffset = 0;
                ++aIndex;
            }
            if (bOffset != bAddresses[bIndex][1]) continue;
            bOffset = 0;
            ++bIndex;
        } while (aIndex != aAddresses.length);
        return 0;
    }

    public Result getLob(long lobID, long offset, long length) {
        throw Error.runtimeError(201, "LobManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result createDuplicateLob(long lobID) {
        long length;
        long newLobID;
        Object[] data;
        block10: {
            block9: {
                this.writeLock.lock();
                try {
                    data = this.getLobHeader(lobID);
                    if (data != null) break block9;
                    Result result = Result.newErrorResult(Error.error(3474));
                    Object var19_5 = null;
                    this.writeLock.unlock();
                    return result;
                }
                catch (Throwable throwable) {
                    Object var19_9 = null;
                    this.writeLock.unlock();
                    throw throwable;
                }
            }
            newLobID = this.getNewLobID();
            Object[] params = new Object[data.length];
            params[0] = ValuePool.getLong(newLobID);
            params[1] = data[1];
            params[2] = data[2];
            params[3] = data[3];
            Result result = this.sysLobSession.executeCompiledStatement(this.createLob, params);
            if (!result.isError()) break block10;
            Result result2 = result;
            Object var19_6 = null;
            this.writeLock.unlock();
            return result2;
        }
        long byteLength = length = ((Long)data[1]).longValue();
        int lobType = (Integer)data[1];
        if (lobType == 40) {
            byteLength *= 2L;
        }
        int newBlockCount = (int)byteLength / this.lobBlockSize;
        if (byteLength % (long)this.lobBlockSize != 0L) {
            ++newBlockCount;
        }
        this.createBlockAddresses(newLobID, 0, newBlockCount);
        int[][] sourceBlocks = this.getBlockAddresses(lobID, 0, Integer.MAX_VALUE);
        int[][] targetBlocks = this.getBlockAddresses(newLobID, 0, Integer.MAX_VALUE);
        try {
            this.copyBlockSet(sourceBlocks, targetBlocks);
        }
        catch (HsqlException e) {
            Result result = Result.newErrorResult(e);
            Object var19_7 = null;
            this.writeLock.unlock();
            return result;
        }
        this.usageCountChanged = true;
        ResultLob resultLob = ResultLob.newLobSetResponse(newLobID, length);
        Object var19_8 = null;
        this.writeLock.unlock();
        return resultLob;
    }

    private void copyBlockSet(int[][] source, int[][] target) {
        int sourceIndex = 0;
        int targetIndex = 0;
        do {
            int sourceOffset = source[sourceIndex][2] + sourceIndex;
            int targetOffset = target[targetIndex][2] + targetIndex;
            byte[] bytes = this.getLobStore().getBlockBytes(sourceOffset, 1);
            this.getLobStore().setBlockBytes(bytes, targetOffset, 1);
            ++targetOffset;
            if (++sourceOffset == source[sourceIndex][1]) {
                sourceOffset = 0;
                ++sourceIndex;
            }
            if (targetOffset != target[sourceIndex][1]) continue;
            targetOffset = 0;
            ++targetIndex;
        } while (sourceIndex != source.length);
        this.storeModified = true;
    }

    public Result getChars(long lobID, long offset, int length) {
        Result result = this.getBytes(lobID, offset * 2L, length * 2);
        if (result.isError()) {
            return result;
        }
        byte[] bytes = ((ResultLob)result).getByteArray();
        char[] chars = ArrayUtil.byteArrayToChars(bytes);
        return ResultLob.newLobGetCharsResponse(lobID, offset, chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result getBytes(long lobID, long offset, int length) {
        ResultLob resultLob;
        block16: {
            Result result;
            block15: {
                this.writeLock.lock();
                try {
                    byte[] bytes;
                    int blockOffset = (int)(offset / (long)this.lobBlockSize);
                    int byteBlockOffset = (int)(offset % (long)this.lobBlockSize);
                    int blockLimit = (int)((offset + (long)length) / (long)this.lobBlockSize);
                    int byteLimitOffset = (int)((offset + (long)length) % (long)this.lobBlockSize);
                    if (byteLimitOffset == 0) {
                        byteLimitOffset = this.lobBlockSize;
                    } else {
                        ++blockLimit;
                    }
                    if (length == 0) {
                        ResultLob resultLob2 = ResultLob.newLobGetBytesResponse(lobID, offset, BinaryData.zeroLengthBytes);
                        Object var20_10 = null;
                        this.writeLock.unlock();
                        return resultLob2;
                    }
                    int dataBytesPosition = 0;
                    byte[] dataBytes = new byte[length];
                    int[][] blockAddresses = this.getBlockAddresses(lobID, blockOffset, blockLimit);
                    if (blockAddresses.length == 0) {
                        result = Result.newErrorResult(Error.error(3474));
                        break block15;
                    }
                    int i = 0;
                    int blockCount = blockAddresses[i][1] + blockAddresses[i][2] - blockOffset;
                    if (blockAddresses[i][1] + blockAddresses[i][2] > blockLimit) {
                        blockCount -= blockAddresses[i][1] + blockAddresses[i][2] - blockLimit;
                    }
                    try {
                        bytes = this.getLobStore().getBlockBytes(blockAddresses[i][0] - blockAddresses[i][2] + blockOffset, blockCount);
                    }
                    catch (HsqlException e) {
                        Result result2 = Result.newErrorResult(e);
                        Object var20_12 = null;
                        this.writeLock.unlock();
                        return result2;
                    }
                    int subLength = this.lobBlockSize * blockCount - byteBlockOffset;
                    if (subLength > length) {
                        subLength = length;
                    }
                    System.arraycopy(bytes, byteBlockOffset, dataBytes, dataBytesPosition, subLength);
                    dataBytesPosition += subLength;
                    ++i;
                    while (i < blockAddresses.length && dataBytesPosition < length) {
                        blockCount = blockAddresses[i][1];
                        if (blockAddresses[i][1] + blockAddresses[i][2] > blockLimit) {
                            blockCount -= blockAddresses[i][1] + blockAddresses[i][2] - blockLimit;
                        }
                        try {
                            bytes = this.getLobStore().getBlockBytes(blockAddresses[i][0], blockCount);
                        }
                        catch (HsqlException e) {
                            Result result3 = Result.newErrorResult(e);
                            Object var20_13 = null;
                            this.writeLock.unlock();
                            return result3;
                        }
                        subLength = this.lobBlockSize * blockCount;
                        if (subLength > length - dataBytesPosition) {
                            subLength = length - dataBytesPosition;
                        }
                        System.arraycopy(bytes, 0, dataBytes, dataBytesPosition, subLength);
                        dataBytesPosition += subLength;
                        ++i;
                    }
                    resultLob = ResultLob.newLobGetBytesResponse(lobID, offset, dataBytes);
                    break block16;
                }
                catch (Throwable throwable) {
                    Object var20_15 = null;
                    this.writeLock.unlock();
                    throw throwable;
                }
            }
            Object var20_11 = null;
            this.writeLock.unlock();
            return result;
        }
        Object var20_14 = null;
        this.writeLock.unlock();
        return resultLob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result setBytesBA(long lobID, byte[] dataBytes, long offset, int length) {
        this.writeLock.lock();
        try {
            int blockOffset = (int)(offset / (long)this.lobBlockSize);
            int byteBlockOffset = (int)(offset % (long)this.lobBlockSize);
            int blockLimit = (int)((offset + (long)length) / (long)this.lobBlockSize);
            int byteLimitOffset = (int)((offset + (long)length) % (long)this.lobBlockSize);
            if (byteLimitOffset == 0) {
                byteLimitOffset = this.lobBlockSize;
            } else {
                ++blockLimit;
            }
            int[][] blockAddresses = this.getBlockAddresses(lobID, blockOffset, blockLimit);
            byte[] newBytes = new byte[(blockLimit - blockOffset) * this.lobBlockSize];
            if (blockAddresses.length > 0) {
                block12: {
                    int blockAddress = blockAddresses[0][0] + (blockOffset - blockAddresses[0][2]);
                    try {
                        byte[] block = this.getLobStore().getBlockBytes(blockAddress, 1);
                        System.arraycopy(block, 0, newBytes, 0, this.lobBlockSize);
                        if (blockAddresses.length > 1) {
                            blockAddress = blockAddresses[blockAddresses.length - 1][0] + (blockLimit - blockAddresses[blockAddresses.length - 1][2] - 1);
                            block = this.getLobStore().getBlockBytes(blockAddress, 1);
                            System.arraycopy(block, 0, newBytes, blockLimit - blockOffset - 1, this.lobBlockSize);
                            break block12;
                        }
                        if (blockLimit - blockOffset > 1) {
                            blockAddress = blockAddresses[0][0] + (blockLimit - blockAddresses[0][2] - 1);
                            block = this.getLobStore().getBlockBytes(blockAddress, 1);
                            System.arraycopy(block, 0, newBytes, (blockLimit - blockOffset - 1) * this.lobBlockSize, this.lobBlockSize);
                        }
                    }
                    catch (HsqlException e) {
                        Result result = Result.newErrorResult(e);
                        Object var17_17 = null;
                        this.writeLock.unlock();
                        return result;
                    }
                }
                this.divideBlockAddresses(lobID, blockOffset);
                this.divideBlockAddresses(lobID, blockLimit);
                this.deleteBlockAddresses(lobID, blockOffset, blockLimit);
            }
            this.createBlockAddresses(lobID, blockOffset, blockLimit - blockOffset);
            System.arraycopy(dataBytes, 0, newBytes, byteBlockOffset, length);
            blockAddresses = this.getBlockAddresses(lobID, blockOffset, blockLimit);
            try {
                for (int i = 0; i < blockAddresses.length; ++i) {
                    this.getLobStore().setBlockBytes(newBytes, blockAddresses[i][0], blockAddresses[i][1]);
                }
            }
            catch (HsqlException e) {
                Result result = Result.newErrorResult(e);
                Object var17_18 = null;
                this.writeLock.unlock();
                return result;
            }
            this.storeModified = true;
            ResultLob resultLob = ResultLob.newLobSetResponse(lobID, 0L);
            Object var17_19 = null;
            this.writeLock.unlock();
            return resultLob;
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Result setBytesIS(long lobID, InputStream inputStream, long length, boolean adjustLength) {
        long writeLength = 0L;
        int blockLimit = (int)(length / (long)this.lobBlockSize);
        int byteLimitOffset = (int)(length % (long)this.lobBlockSize);
        if (byteLimitOffset == 0) {
            byteLimitOffset = this.lobBlockSize;
        } else {
            ++blockLimit;
        }
        this.createBlockAddresses(lobID, 0, blockLimit);
        int[][] blockAddresses = this.getBlockAddresses(lobID, 0, blockLimit);
        byte[] dataBytes = new byte[this.lobBlockSize];
        for (int i = 0; i < blockAddresses.length; ++i) {
            for (int j = 0; j < blockAddresses[i][1]; ++j) {
                int localLength = this.lobBlockSize;
                if (i == blockAddresses.length - 1 && j == blockAddresses[i][1] - 1) {
                    localLength = byteLimitOffset;
                    Arrays.fill(dataBytes, (byte)0);
                }
                try {
                    int count = 0;
                    while (localLength > 0) {
                        int read = inputStream.read(dataBytes, count, localLength);
                        if (read == -1) {
                            if (!adjustLength) return Result.newErrorResult(new EOFException());
                            read = localLength;
                        } else {
                            writeLength += (long)read;
                        }
                        localLength -= read;
                        count += read;
                    }
                }
                catch (IOException e) {
                    return Result.newErrorResult(e);
                }
                try {
                    this.getLobStore().setBlockBytes(dataBytes, blockAddresses[i][0] + j, 1);
                    continue;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e);
                }
            }
        }
        this.storeModified = true;
        return ResultLob.newLobSetResponse(lobID, writeLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setBytes(long lobID, long offset, byte[] dataBytes) {
        Object[] data;
        block5: {
            if (dataBytes.length == 0) {
                return ResultLob.newLobSetResponse(lobID, 0L);
            }
            this.writeLock.lock();
            try {
                data = this.getLobHeader(lobID);
                if (data != null) break block5;
                Result result = Result.newErrorResult(Error.error(3474));
                Object var12_7 = null;
                this.writeLock.unlock();
                return result;
            }
            catch (Throwable throwable) {
                Object var12_9 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }
        long length = (Long)data[1];
        Result result = this.setBytesBA(lobID, dataBytes, offset, dataBytes.length);
        if (offset + (long)dataBytes.length > length) {
            this.setLength(lobID, offset + (long)dataBytes.length);
        }
        Result result2 = result;
        Object var12_8 = null;
        this.writeLock.unlock();
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setBytesForNewBlob(long lobID, InputStream inputStream, long length) {
        if (length == 0L) {
            return ResultLob.newLobSetResponse(lobID, 0L);
        }
        this.writeLock.lock();
        try {
            Result result;
            Result result2 = result = this.setBytesIS(lobID, inputStream, length, false);
            Object var9_6 = null;
            this.writeLock.unlock();
            return result2;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setChars(long lobID, long offset, char[] chars) {
        block8: {
            Result result;
            long length;
            block7: {
                Object[] data;
                block6: {
                    if (chars.length == 0) {
                        return ResultLob.newLobSetResponse(lobID, 0L);
                    }
                    this.writeLock.lock();
                    try {
                        data = this.getLobHeader(lobID);
                        if (data != null) break block6;
                        Result result2 = Result.newErrorResult(Error.error(3474));
                        Object var13_7 = null;
                        this.writeLock.unlock();
                        return result2;
                    }
                    catch (Throwable throwable) {
                        Object var13_11 = null;
                        this.writeLock.unlock();
                        throw throwable;
                    }
                }
                length = (Long)data[1];
                byte[] bytes = ArrayUtil.charArrayToBytes(chars);
                result = this.setBytesBA(lobID, bytes, offset * 2L, chars.length * 2);
                if (!result.isError()) break block7;
                Result result3 = result;
                Object var13_8 = null;
                this.writeLock.unlock();
                return result3;
            }
            if (offset + (long)chars.length <= length || !(result = this.setLength(lobID, offset + (long)chars.length)).isError()) break block8;
            Result result4 = result;
            Object var13_9 = null;
            this.writeLock.unlock();
            return result4;
        }
        ResultLob resultLob = ResultLob.newLobSetResponse(lobID, 0L);
        Object var13_10 = null;
        this.writeLock.unlock();
        return resultLob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result setCharsForNewClob(long lobID, InputStream inputStream, long length, boolean adjustLength) {
        Result result;
        block5: {
            if (length == 0L) {
                return ResultLob.newLobSetResponse(lobID, 0L);
            }
            this.writeLock.lock();
            try {
                result = this.setBytesIS(lobID, inputStream, length * 2L, adjustLength);
                if (!result.isError()) break block5;
                Result result2 = result;
                Object var12_8 = null;
                this.writeLock.unlock();
                return result2;
            }
            catch (Throwable throwable) {
                Object var12_10 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }
        long newLength = ((ResultLob)result).getBlockLength();
        if (newLength < length) {
            Result trunc = this.truncate(lobID, newLength);
        }
        Result result3 = result;
        Object var12_9 = null;
        this.writeLock.unlock();
        return result3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result truncate(long lobID, long offset) {
        Object[] data;
        block4: {
            this.writeLock.lock();
            try {
                data = this.getLobHeader(lobID);
                if (data != null) break block4;
                Result result = Result.newErrorResult(Error.error(3474));
                Object var16_6 = null;
                this.writeLock.unlock();
                return result;
            }
            catch (Throwable throwable) {
                Object var16_8 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }
        long length = (Long)data[1];
        long byteLength = offset;
        if ((Integer)data[3] == 40) {
            byteLength *= 2L;
        }
        int blockOffset = (int)((byteLength + (long)this.lobBlockSize - 1L) / (long)this.lobBlockSize);
        ResultMetaData meta = this.deleteLobPartCall.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getLong(lobID);
        params[1] = new Integer(blockOffset);
        params[2] = new Integer(Integer.MAX_VALUE);
        params[3] = ValuePool.getLong(this.sysLobSession.getTransactionTimestamp());
        Result result = this.sysLobSession.executeCompiledStatement(this.deleteLobPartCall, params);
        this.setLength(lobID, offset);
        ResultLob resultLob = ResultLob.newLobTruncateResponse(lobID);
        Object var16_7 = null;
        this.writeLock.unlock();
        return resultLob;
    }

    private Result setLength(long lobID, long length) {
        ResultMetaData meta = this.updateLobLength.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getLong(length);
        params[1] = ValuePool.getLong(lobID);
        Result result = this.sysLobSession.executeCompiledStatement(this.updateLobLength, params);
        return result;
    }

    public Result adjustUsageCount(Session session, long lobID, int delta) {
        ResultMetaData meta = this.updateLobUsage.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getInt(delta);
        params[1] = ValuePool.getLong(lobID);
        session.sessionContext.pushDynamicArguments(params);
        Result result = this.updateLobUsage.execute(session);
        session.sessionContext.pop();
        return result;
    }

    private int[][] getBlockAddresses(long lobID, int offset, int limit) {
        ResultMetaData meta = this.getLobPart.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getLong(lobID);
        params[1] = ValuePool.getInt(offset);
        params[2] = ValuePool.getInt(limit);
        this.sysLobSession.sessionContext.pushDynamicArguments(params);
        Result result = this.getLobPart.execute(this.sysLobSession);
        this.sysLobSession.sessionContext.pop();
        RowSetNavigator navigator = result.getNavigator();
        int size = navigator.getSize();
        int[][] blocks = new int[size][3];
        for (int i = 0; i < size; ++i) {
            navigator.absolute(i);
            Object[] data = navigator.getCurrent();
            blocks[i][0] = (Integer)data[0];
            blocks[i][1] = (Integer)data[1];
            blocks[i][2] = (Integer)data[2];
        }
        navigator.close();
        return blocks;
    }

    private void deleteBlockAddresses(long lobID, int offset, int limit) {
        ResultMetaData meta = this.deleteLobPartCall.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getLong(lobID);
        params[1] = ValuePool.getInt(offset);
        params[2] = ValuePool.getInt(limit);
        params[3] = ValuePool.getLong(this.sysLobSession.getTransactionTimestamp());
        Result result = this.sysLobSession.executeCompiledStatement(this.deleteLobPartCall, params);
    }

    private void divideBlockAddresses(long lobID, int offset) {
        ResultMetaData meta = this.divideLobPartCall.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getInt(offset);
        params[1] = ValuePool.getLong(lobID);
        Result result = this.sysLobSession.executeCompiledStatement(this.divideLobPartCall, params);
    }

    private void createBlockAddresses(long lobID, int offset, int count) {
        ResultMetaData meta = this.createLobPartCall.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = ValuePool.getInt(count);
        params[1] = ValuePool.getInt(offset);
        params[2] = ValuePool.getLong(lobID);
        Result result = this.sysLobSession.executeCompiledStatement(this.createLobPartCall, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLobCount() {
        RowSetNavigator navigator;
        block3: {
            this.writeLock.lock();
            try {
                this.sysLobSession.sessionContext.pushDynamicArguments(new Object[0]);
                Result result = this.getLobCount.execute(this.sysLobSession);
                this.sysLobSession.sessionContext.pop();
                navigator = result.getNavigator();
                boolean next = navigator.next();
                if (next) break block3;
                navigator.close();
                int n = 0;
                Object var7_6 = null;
                this.writeLock.unlock();
                return n;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }
        Object[] data = navigator.getCurrent();
        int n = ((Number)data[0]).intValue();
        Object var7_7 = null;
        this.writeLock.unlock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synch() {
        if (this.storeModified && this.lobStore != null) {
            this.writeLock.lock();
            try {
                this.lobStore.synch();
                this.storeModified = false;
                Object var2_1 = null;
                this.writeLock.unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }
    }

    private static interface UPDATE_LENGTH {
        public static final int LOB_LENGTH = 0;
        public static final int LOB_ID = 1;
    }

    private static interface UPDATE_USAGE {
        public static final int BLOCK_COUNT = 0;
        public static final int LOB_ID = 1;
    }

    private static interface ALLOC_BLOCKS {
        public static final int BLOCK_COUNT = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int LOB_ID = 2;
    }

    private static interface DELETE_BLOCKS {
        public static final int LOB_ID = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int BLOCK_LIMIT = 2;
        public static final int TX_ID = 3;
    }

    private static interface DIVIDE_BLOCK {
        public static final int BLOCK_OFFSET = 0;
        public static final int LOB_ID = 1;
    }

    private static interface GET_LOB_PART {
        public static final int LOB_ID = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int BLOCK_LIMIT = 2;
    }

    private static interface LOB_IDS {
        public static final int LOB_ID = 0;
        public static final int LOB_LENGTH = 1;
        public static final int LOB_USAGE_COUNT = 2;
        public static final int LOB_TYPE = 3;
    }

    private static interface LOBS {
        public static final int BLOCK_ADDR = 0;
        public static final int BLOCK_COUNT = 1;
        public static final int BLOCK_OFFSET = 2;
        public static final int LOB_ID = 3;
    }
}

