/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.File;
import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileArchiver;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.persist.Crypto;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataFileDefrag;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.ScriptRunner;
import org.hsqldb.persist.TextCache;
import org.hsqldb.scriptio.ScriptReaderBase;
import org.hsqldb.scriptio.ScriptReaderDecode;
import org.hsqldb.scriptio.ScriptReaderText;
import org.hsqldb.scriptio.ScriptWriterBase;
import org.hsqldb.scriptio.ScriptWriterEncode;
import org.hsqldb.scriptio.ScriptWriterText;

public class Log {
    private HsqlDatabaseProperties properties;
    private String fileName;
    private Database database;
    private FileAccess fa;
    ScriptWriterBase dbLogWriter;
    private String scriptFileName;
    private String logFileName;
    private boolean filesReadOnly;
    private long maxLogSize;
    private int writeDelay;
    private DataFileCache cache;
    private HashMap textCacheList = new HashMap();

    Log(Database db) {
        this.database = db;
        this.fa = db.logger.getFileAccess();
        this.fileName = db.getPath();
        this.properties = db.getProperties();
    }

    void initParams() {
        this.maxLogSize = (long)this.database.logger.propLogSize * 1024L * 1024L;
        this.writeDelay = this.database.logger.propWriteDelay;
        this.filesReadOnly = this.database.isFilesReadOnly();
        this.scriptFileName = this.fileName + ".script";
        this.logFileName = this.fileName + ".log";
    }

    void open() {
        this.initParams();
        int state = this.properties.getDBModified();
        switch (state) {
            case 3: {
                break;
            }
            case 1: {
                this.deleteNewAndOldFiles();
                this.deleteOldTempFiles();
                if (this.properties.isVersion18()) {
                    if (this.fa.isStreamElement(this.scriptFileName)) {
                        this.processScript();
                    } else {
                        this.database.schemaManager.createPublicSchema();
                    }
                    HsqlNameManager.HsqlName name = this.database.schemaManager.findSchemaHsqlName("PUBLIC");
                    if (name != null) {
                        this.database.schemaManager.setDefaultSchemaHsqlName(name);
                    }
                } else {
                    this.processScript();
                }
                this.processLog();
                this.checkpoint(false);
                break;
            }
            case 2: {
                this.renameNewDataFile();
                this.renameNewBackup();
                this.renameNewScript();
                this.deleteLog();
                this.properties.setDBModified(0);
            }
            case 0: {
                this.processScript();
                if (this.filesReadOnly || !this.isAnyCacheModified()) break;
                this.properties.setDBModified(1);
                this.checkpoint(false);
            }
        }
        if (!this.filesReadOnly) {
            this.openLog();
            this.properties.setDBModified(1);
        }
    }

    void close(boolean script) {
        this.closeLog();
        this.deleteOldDataFiles();
        this.writeScript(script);
        this.closeAllTextCaches(script);
        if (this.cache != null) {
            this.cache.close(true);
        }
        this.properties.setProperty("hsqldb.script_format", this.database.logger.propScriptFormat);
        this.properties.setDBModified(2);
        this.deleteLog();
        if (this.cache != null) {
            if (script) {
                this.cache.deleteFile();
                this.cache.deleteBackup();
            } else {
                this.cache.backupFile();
                this.cache.renameBackupFile();
            }
        }
        this.renameNewScript();
        this.properties.setDBModified(0);
    }

    void shutdown() {
        if (this.cache != null) {
            this.cache.close(false);
        }
        this.closeAllTextCaches(false);
        this.closeLog();
    }

    void deleteNewAndOldFiles() {
        this.deleteOldDataFiles();
        this.fa.removeElement(this.fileName + ".data" + ".new");
        this.fa.removeElement(this.fileName + ".backup" + ".new");
        this.fa.removeElement(this.scriptFileName + ".new");
    }

    void deleteBackup() {
        this.fa.removeElement(this.fileName + ".backup");
    }

    void deleteData() {
        this.fa.removeElement(this.fileName + ".data");
    }

    void backupData() throws IOException {
        if (this.database.logger.propIncrementBackup) {
            this.fa.removeElement(this.fileName + ".backup");
            return;
        }
        if (this.fa.isStreamElement(this.fileName + ".data")) {
            FileArchiver.archive(this.fileName + ".data", this.fileName + ".backup" + ".new", this.database.logger.getFileAccess(), 1);
        }
    }

    void renameNewDataFile() {
        if (this.fa.isStreamElement(this.fileName + ".data" + ".new")) {
            this.fa.renameElement(this.fileName + ".data" + ".new", this.fileName + ".data");
        }
    }

    void renameNewBackup() {
        this.fa.removeElement(this.fileName + ".backup");
        if (this.fa.isStreamElement(this.fileName + ".backup" + ".new")) {
            this.fa.renameElement(this.fileName + ".backup" + ".new", this.fileName + ".backup");
        }
    }

    void renameNewScript() {
        if (this.fa.isStreamElement(this.scriptFileName + ".new")) {
            this.fa.renameElement(this.scriptFileName + ".new", this.scriptFileName);
        }
    }

    void deleteNewScript() {
        this.fa.removeElement(this.scriptFileName + ".new");
    }

    void deleteNewBackup() {
        this.fa.removeElement(this.fileName + ".backup" + ".new");
    }

    void deleteLog() {
        this.fa.removeElement(this.logFileName);
    }

    boolean isAnyCacheModified() {
        if (this.cache != null && this.cache.isFileModified()) {
            return true;
        }
        return this.isAnyTextCacheModified();
    }

    void checkpoint(boolean defrag) {
        boolean result;
        if (this.filesReadOnly) {
            return;
        }
        if (this.cache == null) {
            defrag = false;
        } else if (this.forceDefrag()) {
            defrag = true;
        }
        if (defrag) {
            try {
                this.defrag();
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (result = this.checkpointClose()) {
            this.checkpointReopen();
        } else {
            this.database.logger.logSevereEvent("checkpoint failed - see previous error", null);
        }
    }

    boolean checkpointClose() {
        if (this.filesReadOnly) {
            return true;
        }
        this.database.lobManager.deleteUnusedLobs();
        this.synchLog();
        this.deleteOldDataFiles();
        try {
            this.writeScript(false);
        }
        catch (HsqlException e) {
            this.deleteNewScript();
            this.database.logger.logSevereEvent("checkpoint failed - recovered", e);
            return false;
        }
        try {
            if (this.cache != null) {
                this.cache.commitChanges();
                this.cache.backupFile();
            }
        }
        catch (Exception ee) {
            this.deleteNewScript();
            this.deleteNewBackup();
            try {
                if (!this.cache.isFileOpen()) {
                    this.cache.open(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.database.logger.logSevereEvent("checkpoint failed - recovered", ee);
            return false;
        }
        this.closeLog();
        this.properties.setProperty("hsqldb.script_format", this.database.logger.propScriptFormat);
        this.properties.setDBModified(2);
        this.deleteLog();
        this.renameNewScript();
        this.renameNewBackup();
        try {
            this.properties.setDBModified(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    boolean checkpointReopen() {
        if (this.filesReadOnly) {
            return true;
        }
        try {
            if (this.cache != null) {
                this.cache.openShadowFile();
            }
            if (this.dbLogWriter != null) {
                this.openLog();
            }
            this.properties.setDBModified(1);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void defrag() {
        if (this.cache.fileFreePosition == (long)this.cache.initialFreePos) {
            return;
        }
        this.database.logger.logInfoEvent("defrag start");
        try {
            this.synchLog();
            this.deleteOldDataFiles();
            DataFileDefrag dfd = this.cache.defrag();
        }
        catch (HsqlException e) {
            throw e;
        }
        catch (Throwable e) {
            this.database.logger.logSevereEvent("defrag failure", e);
            throw Error.error(466, e);
        }
        this.database.logger.logInfoEvent("defrag end");
    }

    boolean forceDefrag() {
        long limit = (long)this.database.logger.propCacheDefragLimit * this.cache.getFileFreePos() / 100L;
        long lostSize = this.cache.freeBlocks.getLostBlocksSize();
        return limit > 0L && lostSize > limit;
    }

    boolean hasCache() {
        return this.cache != null;
    }

    DataFileCache getCache() {
        if (this.cache == null) {
            this.cache = new DataFileCache(this.database, this.fileName);
            this.cache.open(this.filesReadOnly);
        }
        return this.cache;
    }

    void setLogSize(int megas) {
        this.maxLogSize = (long)megas * 1024L * 1024L;
    }

    int getWriteDelay() {
        return this.writeDelay;
    }

    void setWriteDelay(int delay) {
        this.writeDelay = delay;
        if (this.dbLogWriter != null) {
            this.dbLogWriter.forceSync();
            this.dbLogWriter.stop();
            this.dbLogWriter.setWriteDelay(delay);
            this.dbLogWriter.start();
        }
    }

    public void setIncrementBackup(boolean val) {
        if (this.cache != null) {
            this.cache.setIncrementBackup(val);
        }
    }

    void writeStatement(Session session, String s) {
        try {
            this.dbLogWriter.writeLogStatement(session, s);
        }
        catch (IOException e) {
            throw Error.error(452, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.database.logger.setCheckpointRequired();
        }
    }

    void writeInsertStatement(Session session, Row row, Table t) {
        try {
            this.dbLogWriter.writeInsertStatement(session, row, t);
        }
        catch (IOException e) {
            throw Error.error(452, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.database.logger.setCheckpointRequired();
        }
    }

    void writeDeleteStatement(Session session, Table t, Object[] row) {
        try {
            this.dbLogWriter.writeDeleteStatement(session, t, row);
        }
        catch (IOException e) {
            throw Error.error(452, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.database.logger.setCheckpointRequired();
        }
    }

    void writeSequenceStatement(Session session, NumberSequence s) {
        try {
            this.dbLogWriter.writeSequenceStatement(session, s);
        }
        catch (IOException e) {
            throw Error.error(452, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.database.logger.setCheckpointRequired();
        }
    }

    void writeCommitStatement(Session session) {
        try {
            this.dbLogWriter.writeCommitStatement(session);
        }
        catch (IOException e) {
            throw Error.error(452, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.database.logger.setCheckpointRequired();
        }
    }

    void synchLog() {
        if (this.dbLogWriter != null) {
            this.dbLogWriter.forceSync();
        }
    }

    void openLog() {
        if (this.filesReadOnly) {
            return;
        }
        Crypto crypto = this.database.logger.getCrypto();
        try {
            this.dbLogWriter = crypto == null ? new ScriptWriterText(this.database, this.logFileName, false, false, false) : new ScriptWriterEncode(this.database, this.logFileName, crypto);
            this.dbLogWriter.setWriteDelay(this.writeDelay);
            this.dbLogWriter.start();
        }
        catch (Exception e) {
            throw Error.error(452, this.logFileName);
        }
    }

    synchronized void closeLog() {
        if (this.dbLogWriter != null) {
            this.dbLogWriter.close();
        }
    }

    void writeScript(boolean full) {
        ScriptWriterText scw;
        this.deleteNewScript();
        Crypto crypto = this.database.logger.getCrypto();
        if (crypto == null) {
            boolean compressed = this.database.logger.propScriptFormat == 3;
            scw = new ScriptWriterText(this.database, this.scriptFileName + ".new", full, compressed);
        } else {
            scw = new ScriptWriterEncode(this.database, this.scriptFileName + ".new", full, crypto);
        }
        scw.writeAll();
        scw.close();
    }

    private void processScript() {
        ScriptReaderBase scr = null;
        try {
            Crypto crypto = this.database.logger.getCrypto();
            if (crypto == null) {
                boolean compressed = this.database.logger.propScriptFormat == 3;
                scr = new ScriptReaderText(this.database, this.scriptFileName, compressed);
            } else {
                scr = new ScriptReaderDecode(this.database, this.scriptFileName, crypto, false);
            }
            Session session = this.database.sessionManager.getSysSessionForScript(this.database);
            scr.readAll(session);
            scr.close();
        }
        catch (Throwable e) {
            if (scr != null) {
                scr.close();
                if (this.cache != null) {
                    this.cache.close(false);
                }
                this.closeAllTextCaches(false);
            }
            this.database.logger.logWarningEvent("Script processing failure", e);
            if (e instanceof HsqlException) {
                throw (HsqlException)e;
            }
            if (e instanceof IOException) {
                throw Error.error(452, e);
            }
            if (e instanceof OutOfMemoryError) {
                throw Error.error(460);
            }
            throw Error.error(458, e);
        }
    }

    private void processLog() {
        if (this.fa.isStreamElement(this.logFileName)) {
            ScriptRunner.runScript(this.database, this.logFileName);
        }
    }

    DataFileCache openTextCache(Table table, String source, boolean readOnlyData, boolean reversed) {
        this.closeTextCache(table);
        if (this.database.getType() != "res:" && !this.properties.isPropertyTrue("textdb.allow_full_path")) {
            if (source.indexOf("..") != -1) {
                throw Error.error(457, source);
            }
            String path = new File(new File(this.database.getPath() + ".properties").getAbsolutePath()).getParent();
            if (path != null) {
                source = path + File.separator + source;
            }
        }
        TextCache c = new TextCache(table, source);
        c.open(readOnlyData || this.filesReadOnly);
        this.textCacheList.put(table.getName(), c);
        return c;
    }

    void closeTextCache(Table table) {
        TextCache c = (TextCache)this.textCacheList.remove(table.getName());
        if (c != null) {
            try {
                c.close(true);
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
    }

    private void closeAllTextCaches(boolean script) {
        Iterator it = this.textCacheList.values().iterator();
        while (it.hasNext()) {
            TextCache textCache = (TextCache)it.next();
            if (script && !textCache.table.isDataReadOnly()) {
                textCache.purge();
                continue;
            }
            textCache.close(true);
        }
    }

    private void reopenAllTextCaches() {
        Iterator it = this.textCacheList.values().iterator();
        while (it.hasNext()) {
            ((TextCache)it.next()).reopen();
        }
    }

    private boolean isAnyTextCacheModified() {
        Iterator it = this.textCacheList.values().iterator();
        while (it.hasNext()) {
            if (!((TextCache)it.next()).isFileModified()) continue;
            return true;
        }
        return false;
    }

    void deleteOldDataFiles() {
        if (this.database.logger.isStoredFileAccess()) {
            return;
        }
        try {
            File file = new File(this.database.getCanonicalPath());
            File[] list = file.getParentFile().listFiles();
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].getName().startsWith(file.getName()) || !list[i].getName().endsWith(".old")) continue;
                list[i].delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void deleteOldTempFiles() {
        try {
            if (this.database.logger.tempDirectoryPath == null) {
                return;
            }
            File file = new File(this.database.logger.tempDirectoryPath);
            File[] list = file.listFiles();
            for (int i = 0; i < list.length; ++i) {
                list[i].delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

