/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDisk;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowStoreAVLDisk
extends RowStoreAVL {
    DataFileCache cache;
    RowOutputInterface rowOut;

    public RowStoreAVLDisk(PersistentStoreCollection manager, DataFileCache cache, Table table) {
        this.database = table.database;
        this.manager = manager;
        this.table = table;
        this.indexList = table.getIndexList();
        this.accessorList = new CachedObject[this.indexList.length];
        this.cache = cache;
        if (cache != null) {
            this.rowOut = cache.rowOut.duplicate();
            cache.adjustStoreCount(1);
        }
        manager.setStore(table, this);
    }

    public boolean isMemory() {
        return false;
    }

    public int getAccessCount() {
        return this.cache.getAccessCount();
    }

    public void set(CachedObject object) {
        Row row = (Row)object;
        this.database.txManager.setTransactionInfo(row);
    }

    public CachedObject get(int key) {
        CachedObject object = this.cache.get(key, (PersistentStore)this, false);
        return object;
    }

    public CachedObject get(int key, boolean keep) {
        CachedObject object = this.cache.get(key, (PersistentStore)this, keep);
        return object;
    }

    public CachedObject get(CachedObject object, boolean keep) {
        object = this.cache.get(object, (PersistentStore)this, keep);
        return object;
    }

    public int getStorageSize(int i) {
        return this.cache.get(i, (PersistentStore)this, false).getStorageSize();
    }

    public void add(CachedObject object) {
        int size = object.getRealSize(this.rowOut);
        size += this.indexList.length * 16;
        size = this.rowOut.getStorageSize(size);
        object.setStorageSize(size);
        this.cache.add(object);
    }

    public CachedObject get(RowInputInterface in) {
        try {
            return new RowAVLDisk(this.table, in);
        }
        catch (IOException e) {
            throw Error.error(466, e);
        }
    }

    public CachedObject getNewInstance(int size) {
        return null;
    }

    public CachedObject getNewCachedObject(Session session, Object object, boolean tx) {
        RowAVLDisk row = new RowAVLDisk(this.table, (Object[])object, this);
        this.add(row);
        if (tx) {
            RowAction action;
            row.rowAction = action = new RowAction(session, this.table, 1, row, null);
        }
        return row;
    }

    public void indexRow(Session session, Row row) {
        try {
            super.indexRow(session, row);
        }
        catch (HsqlException e) {
            this.database.txManager.removeTransactionInfo(row);
            throw e;
        }
    }

    public void removeAll() {
        this.elementCount = 0;
        ArrayUtil.fillArray(this.accessorList, null);
    }

    public void remove(int i) {
        this.cache.remove(i, this);
    }

    public void removePersistence(int i) {
    }

    public void release(int i) {
        this.cache.release(i);
    }

    public void commitPersistence(CachedObject row) {
    }

    public void commitRow(Session session, Row row, int changeAction, int txModel) {
        Object[] data = row.getData();
        switch (changeAction) {
            case 2: {
                this.database.logger.writeDeleteStatement(session, (Table)this.table, data);
                if (txModel != 0) break;
                this.remove(row.getPos());
                break;
            }
            case 1: {
                this.database.logger.writeInsertStatement(session, row, (Table)this.table);
                break;
            }
            case 4: {
                if (txModel != 0) break;
                this.remove(row.getPos());
                break;
            }
            case 3: {
                this.delete(session, row);
                this.database.txManager.removeTransactionInfo(row);
                this.remove(row.getPos());
            }
        }
    }

    public void rollbackRow(Session session, Row row, int changeAction, int txModel) {
        switch (changeAction) {
            case 2: {
                if (txModel != 0) break;
                row = (Row)this.get(row, true);
                ((RowAVL)row).setNewNodes(this);
                row.keepInMemory(false);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                if (txModel != 0) break;
                this.delete(session, row);
                this.remove(row.getPos());
                break;
            }
            case 4: {
                if (txModel != 0) break;
                this.remove(row.getPos());
            }
        }
    }

    public DataFileCache getCache() {
        return this.cache;
    }

    public void setCache(DataFileCache cache) {
        this.cache = cache;
    }

    public void release() {
        ArrayUtil.fillArray(this.accessorList, null);
        this.cache.adjustStoreCount(-1);
        this.cache = null;
    }

    public CachedObject getAccessor(Index key) {
        NodeAVL node = (NodeAVL)this.accessorList[key.getPosition()];
        if (node == null) {
            return null;
        }
        if (!node.isInMemory()) {
            RowAVL row = (RowAVL)this.get(node.getPos(), false);
            node = row.getNode(key.getPosition());
            this.accessorList[key.getPosition()] = node;
        }
        return node;
    }

    public void setAccessor(Index key, CachedObject accessor) {
        Index index = key;
        this.accessorList[index.getPosition()] = accessor;
    }

    public void setAccessor(Index key, int accessor) {
        CachedObject object = this.get(accessor, false);
        if (object != null) {
            NodeAVL node = ((RowAVL)object).getNode(key.getPosition());
            object = node;
        }
        this.setAccessor(key, object);
    }

    public void resetAccessorKeys(Index[] keys) {
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = keys;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        throw Error.runtimeError(201, "RowStoreAVLDisk");
    }

    public void writeLock() {
        this.cache.writeLock.lock();
    }

    public void writeUnlock() {
        this.cache.writeLock.unlock();
    }
}

