/*
 * Decompiled with CFR 0.152.
 */
package JOscarLib.Packet.Received.Icq;

import JOscarLib.Core.OscarConnection;
import JOscarLib.Integration.Event.MessagingListener;
import JOscarLib.Integration.Event.OfflineMessageEvent;
import JOscarLib.Packet.Received.ReceivedPacket;
import JOscarLib.Packet.Sent.Icq.ClientMeta;
import JOscarLib.RawData;
import JOscarLib.Setting.Enum.MessageTypeEnum;

public class ServerMeta__21_3
extends ReceivedPacket {
    private RawData subCommand;
    private RawData senderUin;
    private RawData year;
    private RawData month;
    private RawData day;
    private RawData hour;
    private RawData minute;
    private RawData messageType;
    private RawData messageFlag;
    private RawData sequence;
    private String message;
    private boolean isOfflineMessage = false;

    public ServerMeta__21_3(byte[] array) {
        super(array, true);
        int position = 0;
        byte[] data = this.getSnac().getDataFieldByteArray();
        this.subCommand = new RawData(data, position += 10, 2);
        this.sequence = new RawData(data, position += 2, 2);
        position += 2;
        if (this.subCommand.getValue() == 16640) {
            this.parseOfflineMessage(data, position);
        }
    }

    public void execute(OscarConnection connection) {
        if (this.subCommand.getValue() == 16896) {
            connection.sendFlap(ClientMeta.ackOfflineMessages(connection));
        }
    }

    public void notifyEvent(OscarConnection connection) {
        if (this.getSubCommand() == 16640) {
            this.notifyOfflineMessage(connection);
        }
    }

    private void notifyOfflineMessage(OscarConnection connection) {
        OfflineMessageEvent e = new OfflineMessageEvent(this);
        for (int i = 0; i < connection.getMessagingListeners().size(); ++i) {
            MessagingListener l = (MessagingListener)connection.getMessagingListeners().elementAt(i);
            l.onOfflineMessage(e);
        }
    }

    private void parseOfflineMessage(byte[] data, int position) {
        this.senderUin = new RawData(data, position, 4);
        this.senderUin.invertIndianness();
        this.year = new RawData(data, position += 4, 2);
        this.year.invertIndianness();
        this.month = new RawData(data, position += 2, 1);
        this.day = new RawData(data, ++position, 1);
        this.hour = new RawData(data, ++position, 1);
        this.minute = new RawData(data, ++position, 1);
        this.messageType = new RawData(data, ++position, 1);
        this.messageFlag = new RawData(data, ++position, 1);
        RawData msgLen = new RawData(data, ++position, 2);
        msgLen.invertIndianness();
        this.message = new String(data, position += 2, msgLen.getValue() - 1);
        this.isOfflineMessage = true;
    }

    public int getSubCommand() {
        return this.subCommand.getValue();
    }

    public String getSenderUin() {
        return String.valueOf(this.senderUin.getValue());
    }

    public int getYear() {
        return this.year.getValue();
    }

    public int getMonth() {
        return this.month.getValue();
    }

    public int getDay() {
        return this.day.getValue();
    }

    public int getHour() {
        return this.day.getValue();
    }

    public int getMinute() {
        return this.minute.getValue();
    }

    public MessageTypeEnum getMessageType() {
        return new MessageTypeEnum(this.messageType.getValue());
    }

    public String getMessage() {
        int nullPos = this.message.indexOf(0);
        if (nullPos != -1) {
            return this.message.substring(0, nullPos);
        }
        return this.message;
    }

    public boolean getIsOfflineMessage() {
        return this.isOfflineMessage;
    }
}

