/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.pacl.checker.AuthorizationProperty;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import java.io.Reader;
import java.io.StringReader;
import java.security.Permission;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.parser.JSqlParser;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.create.index.CreateIndex;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.replace.Replace;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.truncate.Truncate;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.util.TablesNamesFinder;

public class SQLChecker
extends BaseChecker {
    private Set<String> _allTableNames;
    private Set<String> _createTableNames;
    private Set<String> _deleteTableNames;
    private Set<String> _dropTableNames;
    private Set<String> _indexTableNames;
    private Set<String> _insertTableNames;
    private JSqlParser _jSqlParser = new CCJSqlParserManager();
    private Set<String> _replaceTableNames;
    private Set<String> _selectTableNames;
    private Set<String> _sqls;
    private Set<String> _truncateTableNames;
    private Set<String> _updateTableNames;

    @Override
    public void afterPropertiesSet() {
        this.initSQLs();
        this.initTableNames();
    }

    @Override
    public AuthorizationProperty generateAuthorizationProperty(Object ... arguments) {
        if (arguments == null || arguments.length != 1 || !(arguments[0] instanceof String)) {
            return null;
        }
        String sql = (String)arguments[0];
        Statement statement = null;
        try {
            statement = this._jSqlParser.parse((Reader)new StringReader(sql));
        }
        catch (Exception exception) {}
        String key = null;
        String value = null;
        if (statement != null) {
            TablesNamesFinder tablesNamesFinder;
            if (statement instanceof CreateIndex) {
                key = "security-manager-sql-tables-index-create";
                CreateIndex createIndex = (CreateIndex)statement;
                Table table = createIndex.getTable();
                value = table.getName();
            } else if (statement instanceof CreateTable) {
                key = "security-manager-sql-tables-create";
                CreateTable createTable = (CreateTable)statement;
                Table table = createTable.getTable();
                value = table.getName();
            } else if (statement instanceof Delete) {
                key = "security-manager-sql-tables-delete";
                tablesNamesFinder = new TablesNamesFinder();
                Delete delete = (Delete)statement;
                List tableNames = tablesNamesFinder.getTableList(delete);
                value = StringUtil.merge((Collection)tableNames);
            } else if (statement instanceof Drop) {
                key = "security-manager-sql-tables-drop";
                Drop drop = (Drop)statement;
                value = drop.getName();
            } else if (statement instanceof Insert) {
                key = "security-manager-sql-tables-insert";
                tablesNamesFinder = new TablesNamesFinder();
                Insert insert = (Insert)statement;
                List tableNames = tablesNamesFinder.getTableList(insert);
                value = StringUtil.merge((Collection)tableNames);
            } else if (statement instanceof Replace) {
                key = "security-manager-sql-tables-replace";
                tablesNamesFinder = new TablesNamesFinder();
                Replace replace = (Replace)statement;
                List tableNames = tablesNamesFinder.getTableList(replace);
                value = StringUtil.merge((Collection)tableNames);
            } else if (statement instanceof Select) {
                key = "security-manager-sql-tables-select";
                tablesNamesFinder = new TablesNamesFinder();
                Select select = (Select)statement;
                List tableNames = tablesNamesFinder.getTableList(select);
                value = StringUtil.merge((Collection)tableNames);
            } else if (statement instanceof Truncate) {
                key = "security-manager-sql-tables-truncate";
                Truncate truncate = (Truncate)statement;
                Table table = truncate.getTable();
                value = table.getName();
            } else if (statement instanceof Update) {
                key = "security-manager-sql-tables-update";
                tablesNamesFinder = new TablesNamesFinder();
                Update update = (Update)statement;
                List tableNames = tablesNamesFinder.getTableList(update);
                value = StringUtil.merge((Collection)tableNames);
            }
        } else {
            key = "security-manager-sql-statements";
            value = StringUtil.replace((String)sql, (String)",", (String)";");
        }
        AuthorizationProperty authorizationProperty = new AuthorizationProperty();
        authorizationProperty.setKey(key);
        authorizationProperty.setValue(value);
        return authorizationProperty;
    }

    public boolean hasSQL(String sql) {
        Statement statement = null;
        try {
            statement = this._jSqlParser.parse((Reader)new StringReader(sql));
        }
        catch (Exception exception) {}
        if (statement != null) {
            if (statement instanceof CreateIndex) {
                CreateIndex createIndex = (CreateIndex)statement;
                return this.hasSQL(createIndex);
            }
            if (statement instanceof CreateTable) {
                CreateTable createTable = (CreateTable)statement;
                return this.hasSQL(createTable);
            }
            if (statement instanceof Select) {
                Select select = (Select)statement;
                return this.hasSQL(select);
            }
            if (statement instanceof Delete) {
                Delete delete = (Delete)statement;
                return this.hasSQL(delete);
            }
            if (statement instanceof Drop) {
                Drop drop = (Drop)statement;
                return this.hasSQL(drop);
            }
            if (statement instanceof Insert) {
                Insert insert = (Insert)statement;
                return this.hasSQL(insert);
            }
            if (statement instanceof Replace) {
                Replace replace = (Replace)statement;
                return this.hasSQL(replace);
            }
            if (statement instanceof Select) {
                Select select = (Select)statement;
                return this.hasSQL(select);
            }
            if (statement instanceof Truncate) {
                Truncate truncate = (Truncate)statement;
                return this.hasSQL(truncate);
            }
            if (statement instanceof Update) {
                Update update = (Update)statement;
                return this.hasSQL(update);
            }
        } else if (this._sqls.contains(sql = StringUtil.replace((String)sql, (String)",", (String)";"))) {
            return true;
        }
        return false;
    }

    @Override
    public boolean implies(Permission permission) {
        throw new UnsupportedOperationException();
    }

    protected boolean hasSQL(CreateIndex createIndex) {
        return this.isAllowedTable(createIndex.getTable(), this._indexTableNames);
    }

    protected boolean hasSQL(CreateTable createTable) {
        return this.isAllowedTable(createTable.getTable(), this._createTableNames);
    }

    protected boolean hasSQL(Delete delete) {
        TablesNamesFinder tablesNamesFinder = new TablesNamesFinder();
        List tableNames = tablesNamesFinder.getTableList(delete);
        return this.isAllowedTables(tableNames, this._deleteTableNames);
    }

    protected boolean hasSQL(Drop drop) {
        return this.isAllowedTable(drop.getName(), this._dropTableNames);
    }

    protected boolean hasSQL(Insert insert) {
        TablesNamesFinder tablesNamesFinder = new TablesNamesFinder();
        List tableNames = tablesNamesFinder.getTableList(insert);
        return this.isAllowedTables(tableNames, this._insertTableNames);
    }

    protected boolean hasSQL(Replace replace) {
        TablesNamesFinder tablesNamesFinder = new TablesNamesFinder();
        List tableNames = tablesNamesFinder.getTableList(replace);
        return this.isAllowedTables(tableNames, this._replaceTableNames);
    }

    protected boolean hasSQL(Select select) {
        TablesNamesFinder tablesNamesFinder = new TablesNamesFinder();
        List tableNames = tablesNamesFinder.getTableList(select);
        return this.isAllowedTables(tableNames, this._selectTableNames);
    }

    protected boolean hasSQL(Truncate truncate) {
        return this.isAllowedTable(truncate.getTable(), this._truncateTableNames);
    }

    protected boolean hasSQL(Update update) {
        TablesNamesFinder tablesNamesFinder = new TablesNamesFinder();
        List tableNames = tablesNamesFinder.getTableList(update);
        return this.isAllowedTables(tableNames, this._updateTableNames);
    }

    protected void initSQLs() {
        this._sqls = this.getPropertySet("security-manager-sql-statements");
    }

    protected void initTableNames() {
        this._allTableNames = this.getPropertySet("security-manager-sql-tables-all");
        this._createTableNames = this.getPropertySet("security-manager-sql-tables-create");
        this._deleteTableNames = this.getPropertySet("security-manager-sql-tables-delete");
        this._dropTableNames = this.getPropertySet("security-manager-sql-tables-drop");
        this._indexTableNames = this.getPropertySet("security-manager-sql-tables-index");
        this._insertTableNames = this.getPropertySet("security-manager-sql-tables-insert");
        this._replaceTableNames = this.getPropertySet("security-manager-sql-tables-replace");
        this._selectTableNames = this.getPropertySet("security-manager-sql-tables-select");
        this._truncateTableNames = this.getPropertySet("security-manager-sql-tables-truncate");
        this._updateTableNames = this.getPropertySet("security-manager-sql-tables-update");
    }

    protected boolean isAllowedTable(String tableName, Set<String> allowedTableNames) {
        return this._allTableNames.contains(tableName) || allowedTableNames.contains(tableName);
    }

    protected boolean isAllowedTable(Table table, Set<String> allowedTableNames) {
        String tableName = table.getName();
        return this.isAllowedTable(tableName, allowedTableNames);
    }

    protected boolean isAllowedTables(List<String> tableNames, Set<String> allowedTableNames) {
        for (String tableName : tableNames) {
            if (this.isAllowedTable(tableName, allowedTableNames)) continue;
            return false;
        }
        return true;
    }
}

