/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.WikiSession;
import com.ecyrd.jspwiki.auth.AuthorizationManager;
import com.ecyrd.jspwiki.auth.Authorizer;
import com.ecyrd.jspwiki.auth.GroupPrincipal;
import com.ecyrd.jspwiki.auth.SessionMonitor;
import com.ecyrd.jspwiki.auth.WikiSecurityException;
import com.ecyrd.jspwiki.auth.authorize.Role;
import com.ecyrd.jspwiki.auth.authorize.WebAuthorizer;
import com.ecyrd.jspwiki.auth.authorize.WebContainerAuthorizer;
import com.ecyrd.jspwiki.auth.login.AnonymousLoginModule;
import com.ecyrd.jspwiki.auth.login.CookieAssertionLoginModule;
import com.ecyrd.jspwiki.auth.login.CookieAuthenticationLoginModule;
import com.ecyrd.jspwiki.auth.login.UserDatabaseLoginModule;
import com.ecyrd.jspwiki.auth.login.WebContainerCallbackHandler;
import com.ecyrd.jspwiki.auth.login.WebContainerLoginModule;
import com.ecyrd.jspwiki.auth.login.WikiCallbackHandler;
import com.ecyrd.jspwiki.event.WikiEventListener;
import com.ecyrd.jspwiki.event.WikiEventManager;
import com.ecyrd.jspwiki.event.WikiSecurityEvent;
import com.ecyrd.jspwiki.util.TimedCounterList;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AuthenticationManager {
    private static final long LASTLOGINS_CLEANUP_TIME = 600000L;
    private static final long MAX_LOGIN_DELAY = 20000L;
    public static final String COOKIE_MODULE = CookieAssertionLoginModule.class.getName();
    public static final String COOKIE_AUTHENTICATION_MODULE = CookieAuthenticationLoginModule.class.getName();
    public static final String PROP_STOREIPADDRESS = "jspwiki.storeIPAddress";
    public static final String PROP_ALLOW_COOKIE_AUTH = "jspwiki.cookieAuthentication";
    public static final String PROP_SECURITY = "jspwiki.security";
    public static final String SECURITY_OFF = "off";
    public static final String SECURITY_JAAS = "jaas";
    public static final String PROP_LOGIN_THROTTLING = "jspwiki.login.throttling";
    protected static final Logger log = Logger.getLogger(AuthenticationManager.class);
    protected static final String PREFIX_LOGIN_MODULE_OPTIONS = "jspwiki.loginModule.options.";
    protected static final String PROP_ALLOW_COOKIE_ASSERTIONS = "jspwiki.cookieAssertions";
    protected static final String PROP_LOGIN_MODULE = "jspwiki.loginModule.class";
    protected static final Map<String, String> EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    protected Class<? extends LoginModule> m_loginModuleClass = UserDatabaseLoginModule.class;
    protected Map<String, String> m_loginModuleOptions = new HashMap<String, String>();
    protected static final String SECURITY_CONTAINER = "container";
    private static final String DEFAULT_LOGIN_MODULE = "com.ecyrd.jspwiki.auth.login.UserDatabaseLoginModule";
    private static final Set<Principal> NO_PRINCIPALS = new HashSet<Principal>();
    private boolean m_allowsCookieAssertions = true;
    private boolean m_throttleLogins = true;
    private boolean m_allowsCookieAuthentication = false;
    private WikiEngine m_engine = null;
    private boolean m_storeIPAddress = true;
    private boolean m_useJAAS = true;
    private TimedCounterList<String> m_lastLoginAttempts = new TimedCounterList();

    public final void initialize(WikiEngine engine, Properties props) throws WikiException {
        this.m_engine = engine;
        this.m_storeIPAddress = TextUtil.getBooleanProperty(props, PROP_STOREIPADDRESS, this.m_storeIPAddress);
        this.m_useJAAS = SECURITY_JAAS.equals(props.getProperty(PROP_SECURITY, SECURITY_JAAS));
        this.m_allowsCookieAssertions = TextUtil.getBooleanProperty(props, PROP_ALLOW_COOKIE_ASSERTIONS, true);
        this.m_allowsCookieAuthentication = TextUtil.getBooleanProperty(props, PROP_ALLOW_COOKIE_AUTH, false);
        this.m_throttleLogins = TextUtil.getBooleanProperty(props, PROP_LOGIN_THROTTLING, true);
        String loginModuleClassName = TextUtil.getStringProperty(props, PROP_LOGIN_MODULE, DEFAULT_LOGIN_MODULE);
        try {
            this.m_loginModuleClass = Class.forName(loginModuleClassName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new WikiException("Could not instantiate LoginModule class.", e);
        }
        this.initLoginModuleOptions(props);
    }

    public final boolean isContainerAuthenticated() {
        if (!this.m_useJAAS) {
            return true;
        }
        try {
            Authorizer authorizer = this.m_engine.getAuthorizationManager().getAuthorizer();
            if (authorizer instanceof WebContainerAuthorizer) {
                return ((WebContainerAuthorizer)authorizer).isContainerAuthorized();
            }
        }
        catch (WikiException wikiException) {
            // empty catch block
        }
        return false;
    }

    public final boolean login(HttpServletRequest request) throws WikiSecurityException {
        Set<Principal> principals;
        HttpSession httpSession = request.getSession();
        WikiSession session = SessionMonitor.getInstance(this.m_engine).find(httpSession);
        AuthenticationManager authenticationMgr = this.m_engine.getAuthenticationManager();
        AuthorizationManager authorizationMgr = this.m_engine.getAuthorizationManager();
        WebContainerCallbackHandler handler = null;
        Map<String, String> options = EMPTY_MAP;
        if (!session.isAuthenticated()) {
            handler = new WebContainerCallbackHandler(this.m_engine, request);
            principals = authenticationMgr.doJAASLogin(WebContainerLoginModule.class, handler, options);
            if (principals.size() == 0 && authenticationMgr.allowsCookieAuthentication()) {
                principals = authenticationMgr.doJAASLogin(CookieAuthenticationLoginModule.class, handler, options);
            }
            if (principals.size() > 0) {
                this.fireEvent(40, this.getLoginPrincipal(principals), session);
                for (Principal principal : principals) {
                    this.fireEvent(35, principal, session);
                }
                this.injectAuthorizerRoles(session, authorizationMgr.getAuthorizer(), request);
            }
        }
        if (!session.isAuthenticated() && authenticationMgr.allowsCookieAssertions() && (principals = authenticationMgr.doJAASLogin(CookieAssertionLoginModule.class, handler, options)).size() > 0) {
            this.fireEvent(32, this.getLoginPrincipal(principals), session);
        }
        if (session.isAnonymous() && (principals = authenticationMgr.doJAASLogin(AnonymousLoginModule.class, handler, options)).size() > 0) {
            this.fireEvent(31, this.getLoginPrincipal(principals), session);
            return true;
        }
        return false;
    }

    public final boolean login(WikiSession session, String username, String password) throws WikiSecurityException {
        return this.login(session, null, username, password);
    }

    public final boolean login(WikiSession session, HttpServletRequest request, String username, String password) throws WikiSecurityException {
        WikiCallbackHandler handler;
        Set<Principal> principals;
        if (session == null) {
            log.error((Object)"No wiki session provided, cannot log in.");
            return false;
        }
        if (this.m_throttleLogins) {
            this.delayLogin(username);
        }
        if ((principals = this.doJAASLogin(this.m_loginModuleClass, handler = new WikiCallbackHandler(this.m_engine, null, username, password), this.m_loginModuleOptions)).size() > 0) {
            this.fireEvent(40, this.getLoginPrincipal(principals), session);
            for (Principal principal : principals) {
                this.fireEvent(35, principal, session);
            }
            this.injectAuthorizerRoles(session, this.m_engine.getAuthorizationManager().getAuthorizer(), null);
            return true;
        }
        return false;
    }

    private void delayLogin(String username) {
        try {
            this.m_lastLoginAttempts.cleanup(600000L);
            int count = this.m_lastLoginAttempts.count(username);
            long delay = Math.min((long)(1 << count), 20000L);
            log.debug((Object)("Sleeping for " + delay + " ms to allow login."));
            Thread.sleep(delay);
            this.m_lastLoginAttempts.add(username);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public final void logout(HttpServletRequest request) {
        String sid;
        if (request == null) {
            log.error((Object)"No HTTP reqest provided; cannot log out.");
            return;
        }
        HttpSession session = request.getSession();
        String string = sid = session == null ? "(null)" : session.getId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invalidating WikiSession for session ID=" + sid));
        }
        WikiSession wikiSession = WikiSession.getWikiSession(this.m_engine, request);
        Principal originalPrincipal = wikiSession.getLoginPrincipal();
        wikiSession.invalidate();
        WikiSession.removeWikiSession(this.m_engine, request);
        if (session != null) {
            session.invalidate();
        }
        this.fireEvent(44, originalPrincipal, null);
    }

    public final boolean allowsCookieAssertions() {
        return this.m_allowsCookieAssertions;
    }

    public final boolean allowsCookieAuthentication() {
        return this.m_allowsCookieAuthentication;
    }

    public static final boolean isRolePrincipal(Principal principal) {
        return principal instanceof Role || principal instanceof GroupPrincipal;
    }

    public static final boolean isUserPrincipal(Principal principal) {
        return !AuthenticationManager.isRolePrincipal(principal);
    }

    protected Set<Principal> doJAASLogin(Class<? extends LoginModule> clazz, CallbackHandler handler, Map<String, String> options) throws WikiSecurityException {
        LoginModule loginModule = null;
        try {
            loginModule = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new WikiSecurityException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new WikiSecurityException(e.getMessage(), e);
        }
        Subject subject = new Subject();
        loginModule.initialize(subject, handler, EMPTY_MAP, options);
        boolean loginSucceeded = false;
        boolean commitSucceeded = false;
        try {
            loginSucceeded = loginModule.login();
            if (loginSucceeded) {
                commitSucceeded = loginModule.commit();
            }
        }
        catch (LoginException e) {
            // empty catch block
        }
        if (loginSucceeded && commitSucceeded) {
            return subject.getPrincipals();
        }
        return NO_PRINCIPALS;
    }

    protected static final URL findConfigFile(WikiEngine engine, String name) {
        ClassLoader cl;
        URL path;
        File defaultFile = null;
        if (engine.getRootPath() != null) {
            defaultFile = new File(engine.getRootPath() + "/WEB-INF/" + name);
        }
        if (defaultFile != null && defaultFile.exists()) {
            try {
                return defaultFile.toURL();
            }
            catch (MalformedURLException e) {
                log.warn((Object)("Malformed URL: " + e.getMessage()));
            }
        }
        if ((path = (cl = AuthenticationManager.class.getClassLoader()).getResource("/WEB-INF/" + name)) == null) {
            path = cl.getResource("/" + name);
        }
        if (path == null) {
            path = cl.getResource(name);
        }
        if (path == null && engine.getServletContext() != null) {
            try {
                path = engine.getServletContext().getResource("/WEB-INF/" + name);
            }
            catch (MalformedURLException e) {
                log.fatal((Object)"Your code is b0rked.  You are a bad person.");
            }
        }
        return path;
    }

    protected Principal getLoginPrincipal(Set<Principal> principals) {
        for (Principal principal : principals) {
            if (!AuthenticationManager.isUserPrincipal(principal)) continue;
            return principal;
        }
        return null;
    }

    public final synchronized void addWikiEventListener(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener(this, listener);
    }

    public final synchronized void removeWikiEventListener(WikiEventListener listener) {
        WikiEventManager.removeWikiEventListener(this, listener);
    }

    protected final void fireEvent(int type, Principal principal, Object target) {
        if (WikiEventManager.isListening(this)) {
            WikiEventManager.fireEvent(this, new WikiSecurityEvent(this, type, principal, target));
        }
    }

    private void initLoginModuleOptions(Properties props) {
        for (Object key : props.keySet()) {
            String optionKey;
            String propName = key.toString();
            if (!propName.startsWith(PREFIX_LOGIN_MODULE_OPTIONS) || (optionKey = propName.substring(PREFIX_LOGIN_MODULE_OPTIONS.length()).trim()).length() <= 0) continue;
            String optionValue = props.getProperty(propName);
            if (this.m_loginModuleOptions.containsKey(optionKey)) {
                throw new IllegalArgumentException("JAAS LoginModule key " + propName + " cannot be specified twice!");
            }
            this.m_loginModuleOptions.put(optionKey, optionValue);
        }
    }

    private final void injectAuthorizerRoles(WikiSession session, Authorizer authorizer, HttpServletRequest request) {
        for (Principal role : authorizer.getRoles()) {
            WebAuthorizer wa;
            if (authorizer.isUserInRole(session, role)) {
                this.fireEvent(35, role, session);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Added authorizer role " + role.getName() + "."));
                continue;
            }
            if (request == null || !(authorizer instanceof WebAuthorizer) || !(wa = (WebAuthorizer)authorizer).isUserInRole(request, role)) continue;
            this.fireEvent(35, role, session);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Added container role " + role.getName() + "."));
        }
    }
}

