/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.backgroundtask;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatus;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusRegistry;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusRegistryUtil;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BackgroundTaskStatusRegistryImpl
implements BackgroundTaskStatusRegistry {
    private static Log _log = LogFactoryUtil.getLog(BackgroundTaskStatusRegistryImpl.class);
    private final Map<Long, BackgroundTaskStatus> _backgroundTaskStatuses = new HashMap<Long, BackgroundTaskStatus>();
    private ReadWriteLock _readWriteLock = new ReentrantReadWriteLock();

    public BackgroundTaskStatus getBackgroundTaskStatus(long backgroundTaskId) {
        if (!ClusterMasterExecutorUtil.isMaster()) {
            return this.getMasterBackgroundTaskStatus(backgroundTaskId);
        }
        Lock lock = this._readWriteLock.readLock();
        lock.lock();
        try {
            BackgroundTaskStatus backgroundTaskStatus = this._backgroundTaskStatuses.get(backgroundTaskId);
            return backgroundTaskStatus;
        }
        finally {
            lock.unlock();
        }
    }

    public BackgroundTaskStatus registerBackgroundTaskStatus(long backgroundTaskId) {
        Lock lock = this._readWriteLock.writeLock();
        lock.lock();
        try {
            BackgroundTaskStatus backgroundTaskStatus = this._backgroundTaskStatuses.get(backgroundTaskId);
            if (backgroundTaskStatus == null) {
                backgroundTaskStatus = new BackgroundTaskStatus();
                this._backgroundTaskStatuses.put(backgroundTaskId, backgroundTaskStatus);
            }
            BackgroundTaskStatus backgroundTaskStatus2 = backgroundTaskStatus;
            return backgroundTaskStatus2;
        }
        finally {
            lock.unlock();
        }
    }

    public BackgroundTaskStatus unregisterBackgroundTaskStatus(long backgroundTaskId) {
        Lock lock = this._readWriteLock.writeLock();
        lock.lock();
        try {
            BackgroundTaskStatus backgroundTaskStatus;
            BackgroundTaskStatus backgroundTaskStatus2 = backgroundTaskStatus = this._backgroundTaskStatuses.remove(backgroundTaskId);
            return backgroundTaskStatus2;
        }
        finally {
            lock.unlock();
        }
    }

    protected BackgroundTaskStatus getMasterBackgroundTaskStatus(long backgroundTaskId) {
        try {
            MethodHandler methodHandler = new MethodHandler(BackgroundTaskStatusRegistryUtil.class.getDeclaredMethod("getBackgroundTaskStatus", Long.TYPE), new Object[]{backgroundTaskId});
            Future future = ClusterMasterExecutorUtil.executeOnMaster((MethodHandler)methodHandler);
            ClusterNodeResponse clusterNodeResponse = (ClusterNodeResponse)future.get();
            return (BackgroundTaskStatus)clusterNodeResponse.getResult();
        }
        catch (Exception e2) {
            _log.error((Object)"Unable to retrieve status from master node", (Throwable)e2);
            return null;
        }
    }
}

