/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc.aop;

import com.liferay.portal.dao.jdbc.aop.Operation;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Stack;
import javax.sql.DataSource;
import org.springframework.aop.TargetSource;

public class DynamicDataSourceTargetSource
implements TargetSource {
    private static Log _log = LogFactoryUtil.getLog(DynamicDataSourceTargetSource.class);
    private static ThreadLocal<Stack<String>> _methodStack = new ThreadLocal();
    private static ThreadLocal<Operation> _operationType = new ThreadLocal();
    private DataSource _readDataSource;
    private DataSource _writeDataSource;

    public Stack<String> getMethodStack() {
        Stack<String> methodStack = _methodStack.get();
        if (methodStack == null) {
            methodStack = new Stack();
            _methodStack.set(methodStack);
        }
        return methodStack;
    }

    public Operation getOperation() {
        Operation operation = _operationType.get();
        if (operation == null) {
            operation = Operation.WRITE;
            _operationType.set(operation);
        }
        return operation;
    }

    public Object getTarget() throws Exception {
        Operation operationType = this.getOperation();
        if (operationType == Operation.READ) {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)"Returning read data source");
            }
            return this._readDataSource;
        }
        if (_log.isTraceEnabled()) {
            _log.trace((Object)"Returning write data source");
        }
        return this._writeDataSource;
    }

    public Class<DataSource> getTargetClass() {
        return DataSource.class;
    }

    public boolean isStatic() {
        return false;
    }

    public String popMethod() {
        Stack<String> methodStack = this.getMethodStack();
        String method = methodStack.pop();
        this.setOperation(Operation.WRITE);
        return method;
    }

    public void pushMethod(String method) {
        Stack<String> methodStack = this.getMethodStack();
        methodStack.push(method);
    }

    public void releaseTarget(Object target) throws Exception {
    }

    public void setOperation(Operation operation) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Method stack " + this.getMethodStack()));
        }
        if (!this.inOperation() || operation == Operation.WRITE) {
            _operationType.set(operation);
        }
    }

    public void setReadDataSource(DataSource readDataSource) {
        this._readDataSource = readDataSource;
    }

    public void setWriteDataSource(DataSource writeDataSource) {
        this._writeDataSource = writeDataSource;
    }

    protected boolean inOperation() {
        Stack<String> methodStack = this.getMethodStack();
        return !methodStack.empty();
    }
}

