/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.layoutconfiguration.util;

import com.liferay.portal.kernel.executor.CopyThreadLocalCallable;
import com.liferay.portal.kernel.portlet.PortletContainerException;
import com.liferay.portal.kernel.portlet.PortletContainerUtil;
import com.liferay.portal.kernel.portlet.RestrictPortletServletRequest;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.layoutconfiguration.util.ParallelRenderThreadLocalBinderUtil;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.IOException;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletRenderer {
    private static final String _RENDER_PATH = "/html/portal/load_render_portlet.jsp";
    private Integer _columnCount;
    private String _columnId;
    private Integer _columnPos;
    private Portlet _portlet;
    private RestrictPortletServletRequest _restrictPortletServletRequest;

    public PortletRenderer(Portlet portlet, String columnId, Integer columnCount, Integer columnPos) {
        this._portlet = portlet;
        this._columnCount = columnCount;
        this._columnId = columnId;
        this._columnPos = columnPos;
    }

    public void finishParallelRender() {
        if (this._restrictPortletServletRequest != null) {
            this._restrictPortletServletRequest.mergeSharedAttributes();
        }
    }

    public Callable<StringBundler> getCallable(HttpServletRequest request, HttpServletResponse response) {
        return new PortletRendererCallable(request, response);
    }

    public Portlet getPortlet() {
        return this._portlet;
    }

    public StringBundler render(HttpServletRequest request, HttpServletResponse response) throws PortletContainerException {
        request = PortletContainerUtil.setupOptionalRenderParameters((HttpServletRequest)request, null, (String)this._columnId, (Integer)this._columnPos, (Integer)this._columnCount);
        return this._render(request, response);
    }

    public StringBundler renderAjax(HttpServletRequest request, HttpServletResponse response) throws PortletContainerException {
        request = PortletContainerUtil.setupOptionalRenderParameters((HttpServletRequest)request, (String)_RENDER_PATH, (String)this._columnId, (Integer)this._columnPos, (Integer)this._columnCount);
        this._restrictPortletServletRequest = (RestrictPortletServletRequest)request;
        return this._render(request, response);
    }

    public StringBundler renderError(HttpServletRequest request, HttpServletResponse response) throws PortletContainerException {
        request.setAttribute("PARALLEL_RENDERING_TIMEOUT_ERROR", (Object)Boolean.TRUE);
        request = PortletContainerUtil.setupOptionalRenderParameters((HttpServletRequest)request, null, (String)this._columnId, (Integer)this._columnPos, (Integer)this._columnCount);
        this._restrictPortletServletRequest = (RestrictPortletServletRequest)request;
        try {
            StringBundler stringBundler = this._render(request, response);
            return stringBundler;
        }
        finally {
            request.removeAttribute("PARALLEL_RENDERING_TIMEOUT_ERROR");
        }
    }

    private StringBundler _render(HttpServletRequest request, HttpServletResponse response) throws PortletContainerException {
        BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(response);
        Object lock = request.getAttribute("PARALLEL_RENDERING_MERGE_LOCK");
        request.setAttribute("PARALLEL_RENDERING_MERGE_LOCK", null);
        Object portletParallelRender = request.getAttribute("PORTLET_PARALLEL_RENDER");
        request.setAttribute("PORTLET_PARALLEL_RENDER", (Object)Boolean.FALSE);
        try {
            PortletContainerUtil.render((HttpServletRequest)request, (HttpServletResponse)bufferCacheServletResponse, (Portlet)this._portlet);
            StringBundler stringBundler = bufferCacheServletResponse.getStringBundler();
            return stringBundler;
        }
        catch (IOException ioe) {
            throw new PortletContainerException((Throwable)ioe);
        }
        finally {
            request.setAttribute("PARALLEL_RENDERING_MERGE_LOCK", lock);
            request.setAttribute("PORTLET_PARALLEL_RENDER", portletParallelRender);
        }
    }

    private class PortletRendererCallable
    extends CopyThreadLocalCallable<StringBundler> {
        private HttpServletRequest _request;
        private HttpServletResponse _response;

        public PortletRendererCallable(HttpServletRequest request, HttpServletResponse response) {
            super(ParallelRenderThreadLocalBinderUtil.getThreadLocalBinder(), false, true);
            this._request = request;
            this._response = response;
        }

        public StringBundler doCall() throws Exception {
            ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            HttpServletRequest request = PortletContainerUtil.setupOptionalRenderParameters((HttpServletRequest)this._request, null, (String)PortletRenderer.this._columnId, (Integer)PortletRenderer.this._columnPos, (Integer)PortletRenderer.this._columnCount);
            PortletRenderer.this._restrictPortletServletRequest = (RestrictPortletServletRequest)request;
            try {
                themeDisplay = (ThemeDisplay)themeDisplay.clone();
                request.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)themeDisplay);
                return PortletRenderer.this._render(request, this._response);
            }
            catch (Exception e2) {
                Thread currentThread = Thread.currentThread();
                if (!currentThread.isInterrupted()) {
                    throw e2;
                }
                return null;
            }
        }
    }
}

