/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.zip;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.memory.DeleteFileFinalizeAction;
import com.liferay.portal.kernel.memory.FinalizeAction;
import com.liferay.portal.kernel.memory.FinalizeManager;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.DefaultArchiveDetector;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileOutputStream;
import de.schlichtherle.io.archive.spi.ArchiveDriver;
import de.schlichtherle.io.archive.zip.ZipDriver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ZipWriterImpl
implements ZipWriter {
    private static Log _log;
    private de.schlichtherle.io.File _file;

    static {
        de.schlichtherle.io.File.setDefaultArchiveDetector((ArchiveDetector)new DefaultArchiveDetector(ArchiveDetector.ALL, "lar|" + ArchiveDetector.ALL.getSuffixes(), (ArchiveDriver)new ZipDriver()));
        _log = LogFactoryUtil.getLog(ZipWriterImpl.class);
    }

    public ZipWriterImpl() {
        this._file = new de.schlichtherle.io.File(String.valueOf(SystemProperties.get((String)"java.io.tmpdir")) + "/" + PortalUUIDUtil.generate() + ".zip");
        this._file.mkdir();
        FinalizeManager.register((Object)this._file.getDelegate(), (FinalizeAction)new DeleteFileFinalizeAction(this._file.getAbsolutePath()));
    }

    public ZipWriterImpl(File file) {
        this._file = new de.schlichtherle.io.File(file);
        this._file.mkdir();
    }

    public void addEntry(String name, byte[] bytes) throws IOException {
        UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(bytes);
        try {
            this.addEntry(name, (InputStream)unsyncByteArrayInputStream);
        }
        finally {
            unsyncByteArrayInputStream.close();
        }
    }

    public void addEntry(String name, InputStream inputStream) throws IOException {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (inputStream == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Adding " + name));
        }
        FileOutputStream outputStream = new FileOutputStream((File)new de.schlichtherle.io.File(String.valueOf(this.getPath()) + "/" + name));
        try {
            de.schlichtherle.io.File.cat((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            outputStream.close();
        }
    }

    public void addEntry(String name, String s) throws IOException {
        this.addEntry(name, s.getBytes("UTF-8"));
    }

    public void addEntry(String name, StringBuilder sb) throws IOException {
        this.addEntry(name, sb.toString());
    }

    public byte[] finish() throws IOException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        FileInputStream inputStream = new FileInputStream((File)this._file);
        try {
            de.schlichtherle.io.File.cat((InputStream)inputStream, (OutputStream)unsyncByteArrayOutputStream);
        }
        finally {
            unsyncByteArrayOutputStream.close();
            inputStream.close();
        }
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public File getFile() {
        try {
            de.schlichtherle.io.File.umount((de.schlichtherle.io.File)this._file);
        }
        catch (ArchiveException ae) {
            _log.error((Object)ae, (Throwable)ae);
        }
        return this._file.getDelegate();
    }

    public String getPath() {
        return this._file.getPath();
    }
}

