/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.model.impl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBTreeWalker;
import com.liferay.portlet.messageboards.service.MBMessageLocalService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MBTreeWalkerImpl
implements MBTreeWalker {
    private static Log _log = LogFactoryUtil.getLog(MBTreeWalkerImpl.class);
    private Map<Long, Integer> _messageIdsMap = new HashMap<Long, Integer>();
    private List<MBMessage> _messages;
    private boolean _odd;

    public MBTreeWalkerImpl(MBMessage message, int status, MBMessageLocalService messageLocalService) {
        try {
            this._messages = messageLocalService.getThreadMessages(message.getThreadId(), status);
            int i2 = 0;
            while (i2 < this._messages.size()) {
                MBMessage curMessage = this._messages.get(i2);
                long parentMessageId = curMessage.getParentMessageId();
                if (!curMessage.isRoot() && !this._messageIdsMap.containsKey(parentMessageId)) {
                    this._messageIdsMap.put(parentMessageId, i2);
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            _log.error((Throwable)e2);
        }
    }

    public List<MBMessage> getChildren(MBMessage message) {
        ArrayList<MBMessage> children = new ArrayList<MBMessage>();
        int[] range = this.getChildrenRange(message);
        int i2 = range[0];
        while (i2 < range[1]) {
            children.add(this._messages.get(i2));
            ++i2;
        }
        return children;
    }

    public int[] getChildrenRange(MBMessage message) {
        long messageId = message.getMessageId();
        Integer pos = this._messageIdsMap.get(messageId);
        if (pos == null) {
            return new int[2];
        }
        int[] range = new int[2];
        range[0] = pos;
        int i2 = range[0];
        while (i2 < this._messages.size()) {
            MBMessage curMessage = this._messages.get(i2);
            if (curMessage.getParentMessageId() != messageId) break;
            range[1] = i2 + 1;
            ++i2;
        }
        return range;
    }

    public List<MBMessage> getMessages() {
        return this._messages;
    }

    public MBMessage getRoot() {
        return this._messages.get(0);
    }

    public boolean isLeaf(MBMessage message) {
        Long messageIdObj = new Long(message.getMessageId());
        return !this._messageIdsMap.containsKey(messageIdObj);
    }

    public boolean isOdd() {
        this._odd = !this._odd;
        return this._odd;
    }
}

