/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.polls.action;

import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.polls.util.PollsUtil;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.general.PieDataset;

public class ViewChartAction
extends Action {
    public ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            long questionId = ParamUtil.getLong((HttpServletRequest)request, (String)"questionId");
            String chartType = ParamUtil.getString((HttpServletRequest)request, (String)"chartType", (String)"pie");
            String chartName = themeDisplay.translate("vote-results");
            String xName = themeDisplay.translate("choice");
            String yName = themeDisplay.translate("votes");
            CategoryDataset categoryDataset = PollsUtil.getVotesDataset(questionId);
            JFreeChart jFreeChat = null;
            if (chartType.equals("area")) {
                jFreeChat = ChartFactory.createAreaChart((String)chartName, (String)xName, (String)yName, (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            } else if (chartType.equals("horizontal_bar")) {
                jFreeChat = ChartFactory.createBarChart((String)chartName, (String)xName, (String)yName, (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)false, (boolean)false);
            } else if (chartType.equals("line")) {
                jFreeChat = ChartFactory.createLineChart((String)chartName, (String)xName, (String)yName, (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            } else if (chartType.equals("vertical_bar")) {
                jFreeChat = ChartFactory.createBarChart((String)chartName, (String)xName, (String)yName, (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            } else {
                PieDataset pieDataset = DatasetUtilities.createPieDatasetForRow((CategoryDataset)categoryDataset, (int)0);
                jFreeChat = ChartFactory.createPieChart((String)chartName, (PieDataset)pieDataset, (boolean)true, (boolean)false, (boolean)false);
            }
            response.setContentType("image/jpeg");
            ServletOutputStream outputStream = response.getOutputStream();
            ChartUtilities.writeChartAsJPEG((OutputStream)outputStream, (JFreeChart)jFreeChat, (int)400, (int)400);
            return null;
        }
        catch (Exception e2) {
            PortalUtil.sendError((Exception)e2, (HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
    }
}

