/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.header;

import aQute.bnd.osgi.Processor;
import aQute.bnd.version.Version;
import aQute.lib.collections.SortedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attrs
implements Map<String, String> {
    static String EXTENDED = "[\\-0-9a-zA-Z\\._]+";
    static String SCALAR = "String|Version|Long|Double";
    static String LIST = "List\\s*<\\s*(" + SCALAR + ")\\s*>";
    public static final Pattern TYPED = Pattern.compile("\\s*(" + EXTENDED + ")\\s*:\\s*(" + SCALAR + "|" + LIST + ")\\s*");
    private LinkedHashMap<String, String> map;
    private Map<String, Type> types;
    static Map<String, String> EMPTY = Collections.emptyMap();

    public Attrs(Attrs ... attrs) {
        for (Attrs a : attrs) {
            if (a == null) continue;
            this.putAll(a);
            if (a.types == null) continue;
            this.types.putAll(a.types);
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(String name) {
        if (this.map == null) {
            return false;
        }
        return this.map.containsKey(name);
    }

    @Override
    @Deprecated
    public boolean containsKey(Object name) {
        assert (name instanceof String);
        if (this.map == null) {
            return false;
        }
        return this.map.containsKey((String)name);
    }

    public boolean containsValue(String value) {
        if (this.map == null) {
            return false;
        }
        return this.map.containsValue(value);
    }

    @Override
    @Deprecated
    public boolean containsValue(Object value) {
        assert (value instanceof String);
        if (this.map == null) {
            return false;
        }
        return this.map.containsValue((String)value);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        if (this.map == null) {
            return EMPTY.entrySet();
        }
        return this.map.entrySet();
    }

    @Override
    @Deprecated
    public String get(Object key) {
        assert (key instanceof String);
        if (this.map == null) {
            return null;
        }
        return this.map.get((String)key);
    }

    public String get(String key) {
        if (this.map == null) {
            return null;
        }
        return this.map.get(key);
    }

    public String get(String key, String deflt) {
        String s = this.get(key);
        if (s == null) {
            return deflt;
        }
        return s;
    }

    @Override
    public boolean isEmpty() {
        return this.map == null || this.map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        if (this.map == null) {
            return EMPTY.keySet();
        }
        return this.map.keySet();
    }

    @Override
    public String put(String key, String value) {
        Matcher m;
        if (key == null) {
            return null;
        }
        if (this.map == null) {
            this.map = new LinkedHashMap();
        }
        if ((m = TYPED.matcher(key)).matches()) {
            key = m.group(1);
            String type = m.group(2);
            Type t = Type.STRING;
            if (type.startsWith("List")) {
                type = m.group(3);
                if ("String".equals(type)) {
                    t = Type.STRINGS;
                } else if ("Long".equals(type)) {
                    t = Type.LONGS;
                } else if ("Double".equals(type)) {
                    t = Type.DOUBLES;
                } else if ("Version".equals(type)) {
                    t = Type.VERSIONS;
                }
            } else if ("String".equals(type)) {
                t = Type.STRING;
            } else if ("Long".equals(type)) {
                t = Type.LONG;
            } else if ("Double".equals(type)) {
                t = Type.DOUBLE;
            } else if ("Version".equals(type)) {
                t = Type.VERSION;
            }
            if (this.types == null) {
                this.types = new LinkedHashMap<String, Type>();
            }
            this.types.put(key, t);
        }
        return this.map.put(key, value);
    }

    public Type getType(String key) {
        if (this.types == null) {
            return Type.STRING;
        }
        Type t = this.types.get(key);
        if (t == null) {
            return Type.STRING;
        }
        return t;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> map) {
        for (Map.Entry<? extends String, ? extends String> e : map.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    @Deprecated
    public String remove(Object var0) {
        assert (var0 instanceof String);
        if (this.map == null) {
            return null;
        }
        return (String)this.map.remove((String)var0);
    }

    public String remove(String var0) {
        if (this.map == null) {
            return null;
        }
        return (String)this.map.remove(var0);
    }

    @Override
    public int size() {
        if (this.map == null) {
            return 0;
        }
        return this.map.size();
    }

    @Override
    public Collection<String> values() {
        if (this.map == null) {
            return EMPTY.values();
        }
        return this.map.values();
    }

    public String getVersion() {
        return this.get("version");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.append(sb);
        return sb.toString();
    }

    public void append(StringBuilder sb) {
        try {
            String del = "";
            for (Map.Entry<String, String> e : this.entrySet()) {
                Type type;
                sb.append(del);
                sb.append(e.getKey());
                if (this.types != null && (type = this.types.get(e.getKey())) != null) {
                    sb.append(":").append((Object)type);
                }
                sb.append("=");
                Processor.quote(sb, e.getValue());
                del = ";";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @Deprecated
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    @Deprecated
    public int hashCode() {
        return super.hashCode();
    }

    public boolean isEqual(Attrs other) {
        SortedList lo;
        if (this == other) {
            return true;
        }
        if (other == null || this.size() != other.size()) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        SortedList l = new SortedList((Collection<Comparable<?>>)this.keySet());
        if (!l.isEqual(lo = new SortedList((Collection<Comparable<?>>)other.keySet()))) {
            return false;
        }
        for (String key : this.keySet()) {
            String valueo;
            String value = this.get(key);
            if (value == (valueo = other.get(key)) || value != null && value.equals(valueo)) continue;
            return false;
        }
        return true;
    }

    public Object getTyped(String adname) {
        String s = this.get(adname);
        if (s == null) {
            return null;
        }
        Type t = this.getType(adname);
        return this.convert(t, s);
    }

    private Object convert(Type t, String s) {
        if (t.sub == null) {
            switch (t) {
                case STRING: {
                    return s;
                }
                case LONG: {
                    return Long.parseLong(s.trim());
                }
                case VERSION: {
                    return Version.parseVersion(s);
                }
                case DOUBLE: {
                    return Double.parseDouble(s.trim());
                }
                case DOUBLES: 
                case LONGS: 
                case STRINGS: 
                case VERSIONS: {
                    return null;
                }
            }
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        List<String> split = Attrs.splitListAttribute(s);
        for (String p : split) {
            list.add(this.convert(t.sub, p));
        }
        return list;
    }

    static List<String> splitListAttribute(String input) throws IllegalArgumentException {
        LinkedList<String> result = new LinkedList<String>();
        StringBuilder builder = new StringBuilder();
        block4: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\\': {
                    if (++i >= input.length()) {
                        throw new IllegalArgumentException("Trailing blackslash in multi-valued attribute value");
                    }
                    c = input.charAt(i);
                    builder.append(c);
                    continue block4;
                }
                case ',': {
                    result.add(builder.toString());
                    builder = new StringBuilder();
                    continue block4;
                }
                default: {
                    builder.append(c);
                }
            }
        }
        result.add(builder.toString());
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        STRING(null, "String"),
        LONG(null, "Long"),
        VERSION(null, "Version"),
        DOUBLE(null, "Double"),
        STRINGS(STRING, "List<String>"),
        LONGS(LONG, "List<Long>"),
        VERSIONS(VERSION, "List<Version>"),
        DOUBLES(DOUBLE, "List<Double>");

        Type sub;
        String toString;

        private Type(Type sub, String toString) {
            this.sub = sub;
            this.toString = toString;
        }

        public String toString() {
            return this.toString;
        }
    }
}

