/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import java.util.LinkedList;
import java.util.List;
import jodd.csselly.CSSelly;
import jodd.csselly.Combinator;
import jodd.csselly.CssSelector;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.NodeFilter;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeSelector {
    protected final Node rootNode;

    public NodeSelector(Node rootNode) {
        this.rootNode = rootNode;
    }

    public LinkedList<Node> select(String query) {
        String[] singleQueries = StringUtil.splitc(query, ',');
        LinkedList<Node> results = new LinkedList<Node>();
        for (String singleQuery : singleQueries) {
            CSSelly csselly = this.createCSSelly(singleQuery);
            List<CssSelector> selectors = csselly.parse();
            LinkedList<Node> selectedNodes = this.select(this.rootNode, selectors);
            for (Node selectedNode : selectedNodes) {
                if (results.contains(selectedNode)) continue;
                results.add(selectedNode);
            }
        }
        return results;
    }

    protected CSSelly createCSSelly(String cssQuery) {
        return new CSSelly(cssQuery);
    }

    public Node selectFirst(String query) {
        LinkedList<Node> selectedNodes = this.select(query);
        if (selectedNodes.isEmpty()) {
            return null;
        }
        return (Node)selectedNodes.get(0);
    }

    public LinkedList<Node> select(NodeFilter nodeFilter) {
        LinkedList<Node> nodes = new LinkedList<Node>();
        this.walk(this.rootNode, nodeFilter, nodes);
        return nodes;
    }

    public Node selectFirst(NodeFilter nodeFilter) {
        LinkedList<Node> selectedNodes = this.select(nodeFilter);
        if (selectedNodes.isEmpty()) {
            return null;
        }
        return (Node)selectedNodes.get(0);
    }

    protected void walk(Node rootNode, NodeFilter nodeFilter, LinkedList<Node> result) {
        int childCount = rootNode.getChildNodesCount();
        for (int i = 0; i < childCount; ++i) {
            Node node = rootNode.getChild(i);
            if (nodeFilter.accept(node)) {
                result.add(node);
            }
            this.walk(node, nodeFilter, result);
        }
    }

    protected LinkedList<Node> select(Node rootNode, List<CssSelector> selectors) {
        LinkedList<Node> nodes = new LinkedList<Node>();
        nodes.add(rootNode);
        for (CssSelector cssSelector : selectors) {
            LinkedList<Node> selectedNodes = new LinkedList<Node>();
            for (Node node : nodes) {
                this.walk(node, cssSelector, selectedNodes);
            }
            LinkedList<Node> resultNodes = new LinkedList<Node>();
            int index = 0;
            for (Node node : selectedNodes) {
                boolean match = this.filter(selectedNodes, node, cssSelector, index);
                if (match) {
                    resultNodes.add(node);
                }
                ++index;
            }
            nodes = resultNodes;
        }
        return nodes;
    }

    protected void walkDescendantsIteratively(LinkedList<Node> nodes, CssSelector cssSelector, LinkedList<Node> result) {
        while (!nodes.isEmpty()) {
            Node node = nodes.removeFirst();
            this.selectAndAdd(node, cssSelector, result);
            int childCount = node.getChildNodesCount();
            for (int i = childCount - 1; i >= 0; --i) {
                nodes.addFirst(node.getChild(i));
            }
        }
    }

    protected void walk(Node rootNode, CssSelector cssSelector, LinkedList<Node> result) {
        CssSelector previousCssSelector = cssSelector.getPrevCssSelector();
        Combinator combinator = previousCssSelector != null ? previousCssSelector.getCombinator() : Combinator.DESCENDANT;
        switch (combinator) {
            case DESCENDANT: {
                LinkedList<Node> nodes = new LinkedList<Node>();
                int childCount = rootNode.getChildNodesCount();
                for (int i = 0; i < childCount; ++i) {
                    nodes.add(rootNode.getChild(i));
                }
                this.walkDescendantsIteratively(nodes, cssSelector, result);
                break;
            }
            case CHILD: {
                int childCount = rootNode.getChildNodesCount();
                for (int i = 0; i < childCount; ++i) {
                    Node node = rootNode.getChild(i);
                    this.selectAndAdd(node, cssSelector, result);
                }
                break;
            }
            case ADJACENT_SIBLING: {
                Node node = rootNode.getNextSiblingElement();
                if (node == null) break;
                this.selectAndAdd(node, cssSelector, result);
                break;
            }
            case GENERAL_SIBLING: {
                Node node = rootNode;
                while ((node = node.getNextSiblingElement()) != null) {
                    this.selectAndAdd(node, cssSelector, result);
                }
                break;
            }
        }
    }

    protected void selectAndAdd(Node node, CssSelector cssSelector, LinkedList<Node> result) {
        if (node.getNodeType() != Node.NodeType.ELEMENT) {
            return;
        }
        boolean matched = cssSelector.accept(node);
        if (matched) {
            if (result.contains(node)) {
                return;
            }
            result.add(node);
        }
    }

    protected boolean filter(LinkedList<Node> currentResults, Node node, CssSelector cssSelector, int index) {
        return cssSelector.accept(currentResults, node, index);
    }
}

