/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.ui;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.taglib.ui.BreadcrumbEntry;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Account;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.taglib.aui.AUIUtil;
import com.liferay.taglib.util.IncludeTag;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class BreadcrumbTag
extends IncludeTag {
    private static final String _DISPLAY_STYLE = GetterUtil.getString((String)PropsUtil.get((String)"breadcrumb.display.style.default"));
    private static final String[] _DISPLAY_STYLE_OPTIONS = PropsUtil.getArray((String)"breadcrumb.display.style.options");
    private static final String _PAGE = "/html/taglib/ui/breadcrumb/page.jsp";
    private static final boolean _SHOW_GUEST_GROUP = GetterUtil.getBoolean((String)PropsUtil.get((String)"breadcrumb.show.guest.group"));
    private static final boolean _SHOW_PARENT_GROUPS = GetterUtil.getBoolean((String)PropsUtil.get((String)"breadcrumb.show.parent.groups"));
    private static Log _log = LogFactoryUtil.getLog(BreadcrumbTag.class);
    private String _displayStyle = _DISPLAY_STYLE;
    private PortletURL _portletURL;
    private Layout _selLayout;
    private String _selLayoutParam;
    private boolean _showCurrentGroup = true;
    private boolean _showCurrentPortlet = true;
    private boolean _showGuestGroup = _SHOW_GUEST_GROUP;
    private boolean _showLayout = true;
    private Boolean _showParentGroups = null;
    private boolean _showPortletBreadcrumb = true;

    public void setDisplayStyle(String displayStyle) {
        this._displayStyle = displayStyle;
    }

    public void setPortletURL(PortletURL portletURL) {
        this._portletURL = portletURL;
    }

    public void setSelLayout(Layout selLayout) {
        this._selLayout = selLayout;
    }

    public void setSelLayoutParam(String selLayoutParam) {
        this._selLayoutParam = selLayoutParam;
    }

    public void setShowCurrentGroup(boolean showCurrentGroup) {
        this._showCurrentGroup = showCurrentGroup;
    }

    public void setShowCurrentPortlet(boolean showCurrentPortlet) {
        this._showCurrentPortlet = showCurrentPortlet;
    }

    public void setShowGuestGroup(boolean showGuestGroup) {
        this._showGuestGroup = showGuestGroup;
    }

    public void setShowLayout(boolean showLayout) {
        this._showLayout = showLayout;
    }

    public void setShowParentGroups(boolean showParentGroups) {
        this._showParentGroups = showParentGroups;
    }

    public void setShowPortletBreadcrumb(boolean showPortletBreadcrumb) {
        this._showPortletBreadcrumb = showPortletBreadcrumb;
    }

    protected void buildGroupsBreadcrumb(LayoutSet layoutSet, PortletURL portletURL, ThemeDisplay themeDisplay, boolean includeParentGroups, StringBundler sb) throws Exception {
        LayoutSet parentLayoutSet;
        Group group = layoutSet.getGroup();
        if (group.isControlPanel()) {
            return;
        }
        if (includeParentGroups && (parentLayoutSet = this.getParentLayoutSet(layoutSet)) != null) {
            this.buildGroupsBreadcrumb(parentLayoutSet, portletURL, themeDisplay, true, sb);
        }
        int layoutsPageCount = 0;
        layoutsPageCount = layoutSet.isPrivateLayout() ? group.getPrivateLayoutsPageCount() : group.getPublicLayoutsPageCount();
        if (layoutsPageCount > 0 && !group.isGuest()) {
            String layoutSetFriendlyURL = PortalUtil.getLayoutSetFriendlyURL((LayoutSet)layoutSet, (ThemeDisplay)themeDisplay);
            if (themeDisplay.isAddSessionIdToURL()) {
                layoutSetFriendlyURL = PortalUtil.getURLWithSessionId((String)layoutSetFriendlyURL, (String)themeDisplay.getSessionId());
            }
            sb.append("<li><a href=\"");
            sb.append(layoutSetFriendlyURL);
            sb.append("\">");
            sb.append(HtmlUtil.escape((String)group.getDescriptiveName()));
            sb.append("</a><span class=\"divider\">/</span></li>");
        }
    }

    protected void buildGuestGroupBreadcrumb(ThemeDisplay themeDisplay, StringBundler sb) throws Exception {
        Group group = GroupLocalServiceUtil.getGroup((long)themeDisplay.getCompanyId(), (String)"Guest");
        if (group.getPublicLayoutsPageCount() == 0) {
            return;
        }
        sb.append("<li><a href=\"");
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)group.getGroupId(), (boolean)false);
        String layoutSetFriendlyURL = PortalUtil.getLayoutSetFriendlyURL((LayoutSet)layoutSet, (ThemeDisplay)themeDisplay);
        if (themeDisplay.isAddSessionIdToURL()) {
            layoutSetFriendlyURL = PortalUtil.getURLWithSessionId((String)layoutSetFriendlyURL, (String)themeDisplay.getSessionId());
        }
        sb.append(layoutSetFriendlyURL);
        sb.append("\">");
        Account account = themeDisplay.getAccount();
        sb.append(HtmlUtil.escape((String)account.getName()));
        sb.append("</a><span class=\"divider\">/</span></li>");
    }

    protected void buildLayoutBreadcrumb(Layout selLayout, String selLayoutParam, boolean selectedLayout, PortletURL portletURL, ThemeDisplay themeDisplay, StringBundler sb) throws Exception {
        if (selLayout.getParentLayoutId() != 0L) {
            Layout parentLayout = LayoutLocalServiceUtil.getParentLayout((Layout)selLayout);
            this.buildLayoutBreadcrumb(parentLayout, selLayoutParam, false, portletURL, themeDisplay, sb);
        }
        sb.append("<li><a href=\"");
        String layoutURL = this.getBreadcrumbLayoutURL(selLayout, selLayoutParam, portletURL, themeDisplay);
        if (themeDisplay.isAddSessionIdToURL()) {
            layoutURL = PortalUtil.getURLWithSessionId((String)layoutURL, (String)themeDisplay.getSessionId());
        }
        if (selLayout.isTypeControlPanel()) {
            layoutURL = HttpUtil.removeParameter((String)layoutURL, (String)"controlPanelCategory");
        }
        sb.append(layoutURL);
        sb.append("\" ");
        String layoutName = selLayout.getName(themeDisplay.getLocale());
        if (selLayout.isTypeControlPanel()) {
            sb.append("target=\"_top\"");
            if (layoutName.equals("Control Panel")) {
                layoutName = LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"control-panel");
            }
        } else {
            String target = PortalUtil.getLayoutTarget((Layout)selLayout);
            sb.append(target);
        }
        sb.append(">");
        sb.append(HtmlUtil.escape((String)layoutName));
        sb.append("</a><span class=\"divider\">/</span></li>");
    }

    protected void buildPortletBreadcrumb(HttpServletRequest request, boolean showCurrentGroup, boolean showCurrentPortlet, ThemeDisplay themeDisplay, StringBundler sb) throws Exception {
        List breadcrumbEntries = PortalUtil.getPortletBreadcrumbs((HttpServletRequest)request);
        if (breadcrumbEntries == null) {
            return;
        }
        int i = 0;
        while (i < breadcrumbEntries.size()) {
            PortletDisplay portletDisplay;
            String portletTitle;
            String siteGroupName;
            BreadcrumbEntry breadcrumbEntry = (BreadcrumbEntry)breadcrumbEntries.get(i);
            Map data = breadcrumbEntry.getData();
            String breadcrumbTitle = breadcrumbEntry.getTitle();
            String breadcrumbURL = breadcrumbEntry.getURL();
            if (!(!showCurrentGroup && (siteGroupName = themeDisplay.getSiteGroupName()).equals(breadcrumbTitle) || !showCurrentPortlet && (portletTitle = PortalUtil.getPortletTitle((String)(portletDisplay = themeDisplay.getPortletDisplay()).getId(), (User)themeDisplay.getUser())).equals(breadcrumbTitle))) {
                if (!CookieKeys.hasSessionId((HttpServletRequest)request) && Validator.isNotNull((String)breadcrumbURL)) {
                    HttpSession session = request.getSession();
                    breadcrumbURL = PortalUtil.getURLWithSessionId((String)breadcrumbURL, (String)session.getId());
                }
                sb.append("<li>");
                if (i < breadcrumbEntries.size() - 1) {
                    if (Validator.isNotNull((String)breadcrumbURL)) {
                        sb.append("<a href=\"");
                        sb.append(HtmlUtil.escape((String)breadcrumbURL));
                        sb.append("\"");
                        sb.append(AUIUtil.buildData(data));
                        sb.append(">");
                    }
                    sb.append(HtmlUtil.escape((String)breadcrumbTitle));
                    if (Validator.isNotNull((String)breadcrumbURL)) {
                        sb.append("</a>");
                    }
                    sb.append("<span class=\"divider\">/</span>");
                } else {
                    sb.append(HtmlUtil.escape((String)breadcrumbTitle));
                }
                sb.append("</li>");
            }
            ++i;
        }
    }

    @Override
    protected void cleanUp() {
        this._displayStyle = _DISPLAY_STYLE;
        this._portletURL = null;
        this._selLayout = null;
        this._selLayoutParam = null;
        this._showCurrentGroup = true;
        this._showCurrentPortlet = true;
        this._showGuestGroup = _SHOW_GUEST_GROUP;
        this._showLayout = true;
        this._showParentGroups = null;
        this._showPortletBreadcrumb = true;
    }

    protected String getBreadcrumbLayoutURL(Layout selLayout, String selLayoutParam, PortletURL portletURL, ThemeDisplay themeDisplay) throws Exception {
        if (portletURL == null) {
            return PortalUtil.getLayoutFullURL((Layout)selLayout, (ThemeDisplay)themeDisplay);
        }
        portletURL.setParameter(selLayoutParam, String.valueOf(selLayout.getPlid()));
        if (selLayout.isTypeControlPanel()) {
            if (themeDisplay.getDoAsGroupId() > 0L) {
                portletURL.setParameter("doAsGroupId", String.valueOf(themeDisplay.getDoAsGroupId()));
            }
            if (themeDisplay.getRefererPlid() != 0L) {
                portletURL.setParameter("refererPlid", String.valueOf(themeDisplay.getRefererPlid()));
            }
        }
        return portletURL.toString();
    }

    protected String getBreadcrumbString(HttpServletRequest request) {
        int y;
        int x;
        String breadcrumbString;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        StringBundler sb = new StringBundler();
        try {
            LayoutSet parentLayoutSet;
            if (Validator.isNull((Object)this._selLayout)) {
                this.setSelLayout(themeDisplay.getLayout());
            }
            Group group = this._selLayout.getGroup();
            if (this._showGuestGroup) {
                this.buildGuestGroupBreadcrumb(themeDisplay, sb);
            }
            if (this._showParentGroups.booleanValue() && (parentLayoutSet = this.getParentLayoutSet(this._selLayout.getLayoutSet())) != null) {
                this.buildGroupsBreadcrumb(parentLayoutSet, this._portletURL, themeDisplay, true, sb);
            }
            if (this._showCurrentGroup) {
                this.buildGroupsBreadcrumb(this._selLayout.getLayoutSet(), this._portletURL, themeDisplay, false, sb);
            }
            if (this._showLayout && !group.isLayoutPrototype()) {
                this.buildLayoutBreadcrumb(this._selLayout, this._selLayoutParam, true, this._portletURL, themeDisplay, sb);
            }
            if (this._showPortletBreadcrumb) {
                this.buildPortletBreadcrumb(request, this._showCurrentGroup, this._showCurrentPortlet, themeDisplay, sb);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (Validator.isNull((String)(breadcrumbString = sb.toString()))) {
            return "";
        }
        String breadcrumbTruncateClass = "";
        String[] breadcrumbArray = breadcrumbString.split("<li", -1);
        boolean breadcrumbTruncate = false;
        if (breadcrumbArray.length > 3) {
            breadcrumbTruncate = true;
        }
        if (breadcrumbTruncate) {
            breadcrumbTruncateClass = " breadcrumb-truncate";
        }
        if ((x = breadcrumbString.indexOf("<li") + 3) == (y = breadcrumbString.lastIndexOf("<li") + 3)) {
            breadcrumbString = StringUtil.insert((String)breadcrumbString, (String)(" class=\"active only" + breadcrumbTruncateClass + "\""), (int)x);
        } else {
            breadcrumbString = StringUtil.insert((String)breadcrumbString, (String)(" class=\"active last" + breadcrumbTruncateClass + "\""), (int)y);
            breadcrumbString = StringUtil.insert((String)breadcrumbString, (String)(" class=\"first" + breadcrumbTruncateClass + "\""), (int)x);
        }
        if (breadcrumbTruncate) {
            y = breadcrumbString.lastIndexOf("<li");
            int z = breadcrumbString.lastIndexOf("<li", y - 1) + 3;
            breadcrumbString = StringUtil.insert((String)breadcrumbString, (String)(" class=\"current-parent" + breadcrumbTruncateClass + "\""), (int)z);
        }
        return breadcrumbString;
    }

    @Override
    protected String getPage() {
        return _PAGE;
    }

    protected LayoutSet getParentLayoutSet(LayoutSet layoutSet) throws Exception {
        User user;
        List organizations;
        Group group = layoutSet.getGroup();
        if (group.isSite()) {
            Group parentGroup = group.getParentGroup();
            if (parentGroup != null) {
                return LayoutSetLocalServiceUtil.getLayoutSet((long)parentGroup.getGroupId(), (boolean)layoutSet.isPrivateLayout());
            }
        } else if (group.isUser() && !(organizations = OrganizationLocalServiceUtil.getUserOrganizations((long)(user = UserLocalServiceUtil.getUser((long)group.getClassPK())).getUserId())).isEmpty()) {
            Organization organization = (Organization)organizations.get(0);
            Group parentGroup = organization.getGroup();
            return LayoutSetLocalServiceUtil.getLayoutSet((long)parentGroup.getGroupId(), (boolean)layoutSet.isPrivateLayout());
        }
        return null;
    }

    protected void initShowParentGroups(HttpServletRequest request) {
        if (this._showParentGroups != null) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            if (Validator.isNull((Object)this._selLayout)) {
                this.setSelLayout(themeDisplay.getLayout());
            }
            Group group = this._selLayout.getGroup();
            UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
            this._showParentGroups = GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("breadcrumbShowParentGroups"), (boolean)_SHOW_PARENT_GROUPS);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    @Override
    protected void setAttributes(HttpServletRequest request) {
        this.initShowParentGroups(request);
        request.setAttribute("liferay-ui:breadcrumb:breadcrumbString", (Object)this.getBreadcrumbString(request));
        String displayStyle = this._displayStyle;
        if (!ArrayUtil.contains((Object[])_DISPLAY_STYLE_OPTIONS, (Object)displayStyle)) {
            displayStyle = _DISPLAY_STYLE_OPTIONS[0];
        }
        request.setAttribute("liferay-ui:breadcrumb:displayStyle", (Object)displayStyle);
        request.setAttribute("liferay-ui:breadcrumb:portletURL", (Object)this._portletURL);
        request.setAttribute("liferay-ui:breadcrumb:selLayout", (Object)this._selLayout);
        request.setAttribute("liferay-ui:breadcrumb:selLayoutParam", (Object)this._selLayoutParam);
        request.setAttribute("liferay-ui:breadcrumb:showCurrentGroup", (Object)String.valueOf(this._showCurrentGroup));
        request.setAttribute("liferay-ui:breadcrumb:showCurrentPortlet", (Object)String.valueOf(this._showCurrentPortlet));
        request.setAttribute("liferay-ui:breadcrumb:showGuestGroup", (Object)String.valueOf(this._showGuestGroup));
        request.setAttribute("liferay-ui:breadcrumb:showLayout", (Object)String.valueOf(this._showLayout));
        request.setAttribute("liferay-ui:breadcrumb:showParentGroups", (Object)String.valueOf(this._showParentGroups));
        request.setAttribute("liferay-ui:breadcrumb:showPortletBreadcrumb", (Object)String.valueOf(this._showPortletBreadcrumb));
    }
}

