/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox;

import org.apache.pdfbox.ConvertColorspace;
import org.apache.pdfbox.Decrypt;
import org.apache.pdfbox.Encrypt;
import org.apache.pdfbox.ExtractImages;
import org.apache.pdfbox.ExtractText;
import org.apache.pdfbox.Overlay;
import org.apache.pdfbox.OverlayPDF;
import org.apache.pdfbox.PDFDebugger;
import org.apache.pdfbox.PDFMerger;
import org.apache.pdfbox.PDFReader;
import org.apache.pdfbox.PDFSplit;
import org.apache.pdfbox.PDFToImage;
import org.apache.pdfbox.PrintPDF;
import org.apache.pdfbox.TextToPDF;
import org.apache.pdfbox.Version;
import org.apache.pdfbox.WriteDecodedDoc;

public class PDFBox {
    public static void main(String[] args) {
        if (args.length > 0) {
            String command = args[0];
            String[] arguments = new String[args.length - 1];
            System.arraycopy(args, 1, arguments, 0, arguments.length);
            boolean exitAfterCallingMain = true;
            try {
                if (command.equals("ConvertColorspace")) {
                    ConvertColorspace.main(arguments);
                } else if (command.equals("Decrypt")) {
                    Decrypt.main(arguments);
                } else if (command.equals("Encrypt")) {
                    Encrypt.main(arguments);
                } else if (command.equals("ExtractText")) {
                    ExtractText.main(arguments);
                } else if (command.equals("ExtractImages")) {
                    ExtractImages.main(arguments);
                } else if (command.equals("Overlay")) {
                    Overlay.main(arguments);
                } else if (command.equals("OverlayPDF")) {
                    OverlayPDF.main(arguments);
                } else if (command.equals("PrintPDF")) {
                    PrintPDF.main(arguments);
                } else if (command.equals("PDFDebugger")) {
                    PDFDebugger.main(arguments);
                    exitAfterCallingMain = false;
                } else if (command.equals("PDFMerger")) {
                    PDFMerger.main(arguments);
                } else if (command.equals("PDFReader")) {
                    PDFReader.main(arguments);
                    exitAfterCallingMain = false;
                } else if (command.equals("PDFSplit")) {
                    PDFSplit.main(arguments);
                } else if (command.equals("PDFToImage")) {
                    PDFToImage.main(arguments);
                } else if (command.equals("TextToPDF")) {
                    TextToPDF.main(arguments);
                } else if (command.equals("WriteDecodedDoc")) {
                    WriteDecodedDoc.main(arguments);
                } else {
                    PDFBox.showMessageAndExit();
                }
                if (exitAfterCallingMain) {
                    System.exit(0);
                }
            }
            catch (Exception e) {
                System.err.println(command + " failed with the following exception:");
                e.printStackTrace();
                System.exit(1);
            }
        } else {
            PDFBox.showMessageAndExit();
        }
    }

    private static void showMessageAndExit() {
        System.err.println("PDFDBox version: \"" + Version.getVersion() + "\"");
        System.err.println("\nUsage: java pdfbox-app-x.y.z.jar <command> <args..>");
        System.err.println("\nPossible commands are:\n");
        System.err.println("  ConvertColorspace");
        System.err.println("  Decrypt");
        System.err.println("  Encrypt");
        System.err.println("  ExtractText");
        System.err.println("  ExtractImages");
        System.err.println("  Overlay");
        System.err.println("  OverlayPDF");
        System.err.println("  PrintPDF");
        System.err.println("  PDFDebugger");
        System.err.println("  PDFMerger");
        System.err.println("  PDFReader");
        System.err.println("  PDFSplit");
        System.err.println("  PDFToImage");
        System.err.println("  TextToPDF");
        System.err.println("  WriteDecodedDoc");
        System.exit(1);
    }
}

