/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.Environment;
import org.jamwiki.db.DatabaseConnection;
import org.jamwiki.db.QueryHandler;
import org.jamwiki.model.Category;
import org.jamwiki.model.Interwiki;
import org.jamwiki.model.LogItem;
import org.jamwiki.model.Namespace;
import org.jamwiki.model.RecentChange;
import org.jamwiki.model.Role;
import org.jamwiki.model.RoleMap;
import org.jamwiki.model.Topic;
import org.jamwiki.model.TopicType;
import org.jamwiki.model.TopicVersion;
import org.jamwiki.model.VirtualWiki;
import org.jamwiki.model.WikiFile;
import org.jamwiki.model.WikiFileVersion;
import org.jamwiki.model.WikiGroup;
import org.jamwiki.model.WikiUser;
import org.jamwiki.model.WikiUserDetails;
import org.jamwiki.utils.Pagination;
import org.jamwiki.utils.WikiLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnsiQueryHandler
implements QueryHandler {
    private static final WikiLogger logger = WikiLogger.getLogger(AnsiQueryHandler.class.getName());
    protected static final String SQL_PROPERTY_FILE_NAME = "sql.ansi.properties";
    protected static String STATEMENT_CONNECTION_VALIDATION_QUERY = null;
    protected static String STATEMENT_CREATE_AUTHORITIES_TABLE = null;
    protected static String STATEMENT_CREATE_CATEGORY_TABLE = null;
    protected static String STATEMENT_CREATE_CATEGORY_INDEX = null;
    protected static String STATEMENT_CREATE_CONFIGURATION_TABLE = null;
    protected static String STATEMENT_CREATE_GROUP_AUTHORITIES_TABLE = null;
    protected static String STATEMENT_CREATE_GROUP_MEMBERS_TABLE = null;
    protected static String STATEMENT_CREATE_GROUP_TABLE = null;
    protected static String STATEMENT_CREATE_INTERWIKI_TABLE = null;
    protected static String STATEMENT_CREATE_LOG_TABLE = null;
    protected static String STATEMENT_CREATE_NAMESPACE_TABLE = null;
    protected static String STATEMENT_CREATE_NAMESPACE_TRANSLATION_TABLE = null;
    protected static String STATEMENT_CREATE_RECENT_CHANGE_TABLE = null;
    protected static String STATEMENT_CREATE_ROLE_TABLE = null;
    protected static String STATEMENT_CREATE_TOPIC_CURRENT_VERSION_CONSTRAINT = null;
    protected static String STATEMENT_CREATE_TOPIC_TABLE = null;
    protected static String STATEMENT_CREATE_TOPIC_LINKS_TABLE = null;
    protected static String STATEMENT_CREATE_TOPIC_LINKS_INDEX = null;
    protected static String STATEMENT_CREATE_TOPIC_PAGE_NAME_INDEX = null;
    protected static String STATEMENT_CREATE_TOPIC_PAGE_NAME_LOWER_INDEX = null;
    protected static String STATEMENT_CREATE_TOPIC_NAMESPACE_INDEX = null;
    protected static String STATEMENT_CREATE_TOPIC_VIRTUAL_WIKI_INDEX = null;
    protected static String STATEMENT_CREATE_TOPIC_CURRENT_VERSION_INDEX = null;
    protected static String STATEMENT_CREATE_TOPIC_VERSION_TABLE = null;
    protected static String STATEMENT_CREATE_TOPIC_VERSION_TOPIC_INDEX = null;
    protected static String STATEMENT_CREATE_TOPIC_VERSION_PREVIOUS_INDEX = null;
    protected static String STATEMENT_CREATE_TOPIC_VERSION_USER_DISPLAY_INDEX = null;
    protected static String STATEMENT_CREATE_TOPIC_VERSION_USER_ID_INDEX = null;
    protected static String STATEMENT_CREATE_USERS_TABLE = null;
    protected static String STATEMENT_CREATE_VIRTUAL_WIKI_TABLE = null;
    protected static String STATEMENT_CREATE_WATCHLIST_TABLE = null;
    protected static String STATEMENT_CREATE_WIKI_FILE_TABLE = null;
    protected static String STATEMENT_CREATE_WIKI_FILE_VERSION_TABLE = null;
    protected static String STATEMENT_CREATE_WIKI_USER_TABLE = null;
    protected static String STATEMENT_CREATE_WIKI_USER_LOGIN_INDEX = null;
    protected static String STATEMENT_DELETE_AUTHORITIES = null;
    protected static String STATEMENT_DELETE_CONFIGURATION = null;
    protected static String STATEMENT_DELETE_GROUP_AUTHORITIES = null;
    protected static String STATEMENT_DELETE_INTERWIKI = null;
    protected static String STATEMENT_DELETE_LOG_ITEMS = null;
    protected static String STATEMENT_DELETE_NAMESPACE_TRANSLATIONS = null;
    protected static String STATEMENT_DELETE_RECENT_CHANGES = null;
    protected static String STATEMENT_DELETE_RECENT_CHANGES_TOPIC = null;
    protected static String STATEMENT_DELETE_TOPIC_CATEGORIES = null;
    protected static String STATEMENT_DELETE_TOPIC_LINKS = null;
    protected static String STATEMENT_DELETE_WATCHLIST_ENTRY = null;
    protected static String STATEMENT_DROP_AUTHORITIES_TABLE = null;
    protected static String STATEMENT_DROP_CATEGORY_TABLE = null;
    protected static String STATEMENT_DROP_CONFIGURATION_TABLE = null;
    protected static String STATEMENT_DROP_GROUP_AUTHORITIES_TABLE = null;
    protected static String STATEMENT_DROP_GROUP_MEMBERS_TABLE = null;
    protected static String STATEMENT_DROP_GROUP_TABLE = null;
    protected static String STATEMENT_DROP_INTERWIKI_TABLE = null;
    protected static String STATEMENT_DROP_LOG_TABLE = null;
    protected static String STATEMENT_DROP_NAMESPACE_TABLE = null;
    protected static String STATEMENT_DROP_NAMESPACE_TRANSLATION_TABLE = null;
    protected static String STATEMENT_DROP_RECENT_CHANGE_TABLE = null;
    protected static String STATEMENT_DROP_ROLE_TABLE = null;
    protected static String STATEMENT_DROP_TOPIC_CURRENT_VERSION_CONSTRAINT = null;
    protected static String STATEMENT_DROP_TOPIC_TABLE = null;
    protected static String STATEMENT_DROP_TOPIC_LINKS_TABLE = null;
    protected static String STATEMENT_DROP_TOPIC_VERSION_TABLE = null;
    protected static String STATEMENT_DROP_USERS_TABLE = null;
    protected static String STATEMENT_DROP_VIRTUAL_WIKI_TABLE = null;
    protected static String STATEMENT_DROP_WATCHLIST_TABLE = null;
    protected static String STATEMENT_DROP_WIKI_FILE_TABLE = null;
    protected static String STATEMENT_DROP_WIKI_FILE_VERSION_TABLE = null;
    protected static String STATEMENT_DROP_WIKI_USER_TABLE = null;
    protected static String STATEMENT_INSERT_AUTHORITY = null;
    protected static String STATEMENT_INSERT_CATEGORY = null;
    protected static String STATEMENT_INSERT_CONFIGURATION = null;
    protected static String STATEMENT_INSERT_GROUP = null;
    protected static String STATEMENT_INSERT_GROUP_AUTO_INCREMENT = null;
    protected static String STATEMENT_INSERT_GROUP_AUTHORITY = null;
    protected static String STATEMENT_INSERT_GROUP_MEMBER = null;
    protected static String STATEMENT_INSERT_GROUP_MEMBER_AUTO_INCREMENT = null;
    protected static String STATEMENT_INSERT_INTERWIKI = null;
    protected static String STATEMENT_INSERT_LOG_ITEM = null;
    protected static String STATEMENT_INSERT_LOG_ITEMS_BY_TOPIC_VERSION_TYPE = null;
    protected static String STATEMENT_INSERT_LOG_ITEMS_IMPORT = null;
    protected static String STATEMENT_INSERT_LOG_ITEMS_MOVE = null;
    protected static String STATEMENT_INSERT_LOG_ITEMS_UPLOAD = null;
    protected static String STATEMENT_INSERT_LOG_ITEMS_USER = null;
    protected static String STATEMENT_INSERT_NAMESPACE = null;
    protected static String STATEMENT_INSERT_NAMESPACE_TRANSLATION = null;
    protected static String STATEMENT_INSERT_RECENT_CHANGE = null;
    protected static String STATEMENT_INSERT_RECENT_CHANGES_LOGS = null;
    protected static String STATEMENT_INSERT_RECENT_CHANGES_VERSIONS = null;
    protected static String STATEMENT_INSERT_ROLE = null;
    protected static String STATEMENT_INSERT_TOPIC = null;
    protected static String STATEMENT_INSERT_TOPIC_AUTO_INCREMENT = null;
    protected static String STATEMENT_INSERT_TOPIC_LINKS = null;
    protected static String STATEMENT_INSERT_TOPIC_VERSION = null;
    protected static String STATEMENT_INSERT_TOPIC_VERSION_AUTO_INCREMENT = null;
    protected static String STATEMENT_INSERT_USER = null;
    protected static String STATEMENT_INSERT_VIRTUAL_WIKI = null;
    protected static String STATEMENT_INSERT_VIRTUAL_WIKI_AUTO_INCREMENT = null;
    protected static String STATEMENT_INSERT_WATCHLIST_ENTRY = null;
    protected static String STATEMENT_INSERT_WIKI_FILE = null;
    protected static String STATEMENT_INSERT_WIKI_FILE_AUTO_INCREMENT = null;
    protected static String STATEMENT_INSERT_WIKI_FILE_VERSION = null;
    protected static String STATEMENT_INSERT_WIKI_FILE_VERSION_AUTO_INCREMENT = null;
    protected static String STATEMENT_INSERT_WIKI_USER = null;
    protected static String STATEMENT_INSERT_WIKI_USER_AUTO_INCREMENT = null;
    protected static String STATEMENT_SELECT_AUTHORITIES_AUTHORITY = null;
    protected static String STATEMENT_SELECT_AUTHORITIES_LOGIN = null;
    protected static String STATEMENT_SELECT_AUTHORITIES_USER = null;
    protected static String STATEMENT_SELECT_CATEGORIES = null;
    protected static String STATEMENT_SELECT_CATEGORY_TOPICS = null;
    protected static String STATEMENT_SELECT_CONFIGURATION = null;
    protected static String STATEMENT_SELECT_GROUP = null;
    protected static String STATEMENT_SELECT_GROUP_AUTHORITIES = null;
    protected static String STATEMENT_SELECT_GROUPS_AUTHORITIES = null;
    protected static String STATEMENT_SELECT_GROUP_MEMBERS_SEQUENCE = null;
    protected static String STATEMENT_SELECT_GROUP_SEQUENCE = null;
    protected static String STATEMENT_SELECT_INTERWIKIS = null;
    protected static String STATEMENT_SELECT_LOG_ITEMS = null;
    protected static String STATEMENT_SELECT_LOG_ITEMS_BY_TYPE = null;
    protected static String STATEMENT_SELECT_NAMESPACE_SEQUENCE = null;
    protected static String STATEMENT_SELECT_NAMESPACES = null;
    protected static String STATEMENT_SELECT_RECENT_CHANGES = null;
    protected static String STATEMENT_SELECT_ROLES = null;
    protected static String STATEMENT_SELECT_TOPIC_BY_ID = null;
    protected static String STATEMENT_SELECT_TOPIC_BY_TYPE = null;
    protected static String STATEMENT_SELECT_TOPIC_COUNT = null;
    protected static String STATEMENT_SELECT_TOPIC = null;
    protected static String STATEMENT_SELECT_TOPIC_HISTORY = null;
    protected static String STATEMENT_SELECT_TOPIC_LINK_ORPHANS = null;
    protected static String STATEMENT_SELECT_TOPIC_LINKS = null;
    protected static String STATEMENT_SELECT_TOPIC_LOWER = null;
    protected static String STATEMENT_SELECT_TOPIC_NAME = null;
    protected static String STATEMENT_SELECT_TOPIC_NAME_LOWER = null;
    protected static String STATEMENT_SELECT_TOPIC_NAMES = null;
    protected static String STATEMENT_SELECT_TOPICS_ADMIN = null;
    protected static String STATEMENT_SELECT_TOPIC_SEQUENCE = null;
    protected static String STATEMENT_SELECT_TOPIC_VERSION = null;
    protected static String STATEMENT_SELECT_TOPIC_VERSION_NEXT_ID = null;
    protected static String STATEMENT_SELECT_TOPIC_VERSION_SEQUENCE = null;
    protected static String STATEMENT_SELECT_USERS_AUTHENTICATION = null;
    protected static String STATEMENT_SELECT_VIRTUAL_WIKIS = null;
    protected static String STATEMENT_SELECT_VIRTUAL_WIKI_SEQUENCE = null;
    protected static String STATEMENT_SELECT_WATCHLIST = null;
    protected static String STATEMENT_SELECT_WATCHLIST_CHANGES = null;
    protected static String STATEMENT_SELECT_WIKI_FILE = null;
    protected static String STATEMENT_SELECT_WIKI_FILE_COUNT = null;
    protected static String STATEMENT_SELECT_WIKI_FILE_SEQUENCE = null;
    protected static String STATEMENT_SELECT_WIKI_FILE_VERSION_SEQUENCE = null;
    protected static String STATEMENT_SELECT_WIKI_FILE_VERSIONS = null;
    protected static String STATEMENT_SELECT_WIKI_USER = null;
    protected static String STATEMENT_SELECT_WIKI_USER_CHANGES_ANONYMOUS = null;
    protected static String STATEMENT_SELECT_WIKI_USER_CHANGES_LOGIN = null;
    protected static String STATEMENT_SELECT_WIKI_USER_COUNT = null;
    protected static String STATEMENT_SELECT_WIKI_USER_DETAILS_PASSWORD = null;
    protected static String STATEMENT_SELECT_WIKI_USER_LOGIN = null;
    protected static String STATEMENT_SELECT_WIKI_USER_SEQUENCE = null;
    protected static String STATEMENT_SELECT_WIKI_USERS = null;
    protected static String STATEMENT_UPDATE_GROUP = null;
    protected static String STATEMENT_UPDATE_ROLE = null;
    protected static String STATEMENT_UPDATE_NAMESPACE = null;
    protected static String STATEMENT_UPDATE_TOPIC = null;
    protected static String STATEMENT_UPDATE_TOPIC_NAMESPACE = null;
    protected static String STATEMENT_UPDATE_TOPIC_VERSION_PREVIOUS_VERSION_ID = null;
    protected static String STATEMENT_UPDATE_USER = null;
    protected static String STATEMENT_UPDATE_VIRTUAL_WIKI = null;
    protected static String STATEMENT_UPDATE_WIKI_FILE = null;
    protected static String STATEMENT_UPDATE_WIKI_USER = null;
    private Properties props = Environment.loadProperties("sql.ansi.properties");

    protected AnsiQueryHandler() {
        this.init(this.props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authenticateUser(String username, String encryptedPassword, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_SELECT_USERS_AUTHENTICATION);
            stmt.setString(1, username);
            stmt.setString(2, encryptedPassword);
            boolean bl = stmt.executeQuery().next();
            return bl;
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    @Override
    public boolean autoIncrementPrimaryKeys() {
        return false;
    }

    @Override
    public String connectionValidationQuery() {
        return STATEMENT_CONNECTION_VALIDATION_QUERY;
    }

    @Override
    public void createTables(Connection conn) throws SQLException {
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_VIRTUAL_WIKI_TABLE, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_USERS_TABLE, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_WIKI_USER_TABLE, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_WIKI_USER_LOGIN_INDEX, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_NAMESPACE_TABLE, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_NAMESPACE_TRANSLATION_TABLE, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_TOPIC_TABLE, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_TOPIC_PAGE_NAME_INDEX, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_TOPIC_PAGE_NAME_LOWER_INDEX, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_TOPIC_NAMESPACE_INDEX, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_TOPIC_VIRTUAL_WIKI_INDEX, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_TOPIC_CURRENT_VERSION_INDEX, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_TOPIC_VERSION_TABLE, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_TOPIC_VERSION_TOPIC_INDEX, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_TOPIC_VERSION_PREVIOUS_INDEX, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_TOPIC_VERSION_USER_DISPLAY_INDEX, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_TOPIC_VERSION_USER_ID_INDEX, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_TOPIC_CURRENT_VERSION_CONSTRAINT, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_TOPIC_LINKS_TABLE, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_TOPIC_LINKS_INDEX, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_WIKI_FILE_TABLE, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_WIKI_FILE_VERSION_TABLE, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_CATEGORY_TABLE, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_CATEGORY_INDEX, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_GROUP_TABLE, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_GROUP_MEMBERS_TABLE, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_ROLE_TABLE, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_AUTHORITIES_TABLE, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_GROUP_AUTHORITIES_TABLE, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_LOG_TABLE, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_RECENT_CHANGE_TABLE, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_WATCHLIST_TABLE, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_INTERWIKI_TABLE, conn);
        DatabaseConnection.executeUpdate(STATEMENT_CREATE_CONFIGURATION_TABLE, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteGroupAuthorities(int groupId, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_DELETE_GROUP_AUTHORITIES);
            stmt.setInt(1, groupId);
            stmt.executeUpdate();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteInterwiki(Interwiki interwiki, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_DELETE_INTERWIKI);
            stmt.setString(1, interwiki.getInterwikiPrefix());
            stmt.executeUpdate();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRecentChanges(int topicId, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_DELETE_RECENT_CHANGES_TOPIC);
            stmt.setInt(1, topicId);
            stmt.executeUpdate();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTopicCategories(int childTopicId, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_DELETE_TOPIC_CATEGORIES);
            stmt.setInt(1, childTopicId);
            stmt.executeUpdate();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTopicLinks(int topicId, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_DELETE_TOPIC_LINKS);
            stmt.setInt(1, topicId);
            stmt.executeUpdate();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteUserAuthorities(String username, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_DELETE_AUTHORITIES);
            stmt.setString(1, username);
            stmt.executeUpdate();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteWatchlistEntry(int virtualWikiId, String topicName, int userId, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_DELETE_WATCHLIST_ENTRY);
            stmt.setInt(1, virtualWikiId);
            stmt.setString(2, topicName);
            stmt.setInt(3, userId);
            stmt.executeUpdate();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    @Override
    public void dropTables(Connection conn) {
        try {
            DatabaseConnection.executeUpdate(STATEMENT_DROP_CONFIGURATION_TABLE, conn);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        try {
            DatabaseConnection.executeUpdate(STATEMENT_DROP_INTERWIKI_TABLE, conn);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        try {
            DatabaseConnection.executeUpdate(STATEMENT_DROP_WATCHLIST_TABLE, conn);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        try {
            DatabaseConnection.executeUpdate(STATEMENT_DROP_RECENT_CHANGE_TABLE, conn);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        try {
            DatabaseConnection.executeUpdate(STATEMENT_DROP_LOG_TABLE, conn);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        try {
            DatabaseConnection.executeUpdate(STATEMENT_DROP_GROUP_AUTHORITIES_TABLE, conn);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        try {
            DatabaseConnection.executeUpdate(STATEMENT_DROP_AUTHORITIES_TABLE, conn);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        try {
            DatabaseConnection.executeUpdate(STATEMENT_DROP_ROLE_TABLE, conn);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        try {
            DatabaseConnection.executeUpdate(STATEMENT_DROP_GROUP_MEMBERS_TABLE, conn);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        try {
            DatabaseConnection.executeUpdate(STATEMENT_DROP_GROUP_TABLE, conn);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        try {
            DatabaseConnection.executeUpdate(STATEMENT_DROP_CATEGORY_TABLE, conn);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        try {
            DatabaseConnection.executeUpdate(STATEMENT_DROP_WIKI_FILE_VERSION_TABLE, conn);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        try {
            DatabaseConnection.executeUpdate(STATEMENT_DROP_WIKI_FILE_TABLE, conn);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        try {
            DatabaseConnection.executeUpdate(STATEMENT_DROP_TOPIC_LINKS_TABLE, conn);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        try {
            DatabaseConnection.executeUpdate(STATEMENT_DROP_TOPIC_CURRENT_VERSION_CONSTRAINT, conn);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        try {
            DatabaseConnection.executeUpdate(STATEMENT_DROP_TOPIC_VERSION_TABLE, conn);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        try {
            DatabaseConnection.executeUpdate(STATEMENT_DROP_TOPIC_TABLE, conn);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        try {
            DatabaseConnection.executeUpdate(STATEMENT_DROP_NAMESPACE_TRANSLATION_TABLE, conn);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        try {
            DatabaseConnection.executeUpdate(STATEMENT_DROP_NAMESPACE_TABLE, conn);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        try {
            DatabaseConnection.executeUpdate(STATEMENT_DROP_WIKI_USER_TABLE, conn);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        try {
            DatabaseConnection.executeUpdate(STATEMENT_DROP_USERS_TABLE, conn);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        try {
            DatabaseConnection.executeUpdate(STATEMENT_DROP_VIRTUAL_WIKI_TABLE, conn);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeUpgradeQuery(String prop, Connection conn) throws SQLException {
        String sql = this.props.getProperty(prop);
        if (sql == null) {
            throw new SQLException("No property found for " + prop);
        }
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.executeQuery();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeUpgradeUpdate(String prop, Connection conn) throws SQLException {
        String sql = this.props.getProperty(prop);
        if (sql == null) {
            throw new SQLException("No property found for " + prop);
        }
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.executeUpdate();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    @Override
    public String existenceValidationQuery() {
        return STATEMENT_SELECT_VIRTUAL_WIKIS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WikiFileVersion> getAllWikiFileVersions(WikiFile wikiFile, boolean descending) throws SQLException {
        ArrayList<WikiFileVersion> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = conn.prepareStatement(STATEMENT_SELECT_WIKI_FILE_VERSIONS);
            stmt.setInt(1, wikiFile.getFileId());
            rs = stmt.executeQuery();
            ArrayList<WikiFileVersion> fileVersions = new ArrayList<WikiFileVersion>();
            while (rs.next()) {
                fileVersions.add(this.initWikiFileVersion(rs));
            }
            arrayList = fileVersions;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Category> getCategories(int virtualWikiId, String virtualWikiName, Pagination pagination) throws SQLException {
        ArrayList<Category> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = this.getCategoriesStatement(conn, virtualWikiId, virtualWikiName, pagination);
            rs = stmt.executeQuery();
            ArrayList<Category> results = new ArrayList<Category>();
            while (rs.next()) {
                Category category = new Category();
                category.setName(rs.getString("category_name"));
                category.setVirtualWiki(virtualWikiName);
                category.setSortKey(rs.getString("sort_key"));
                results.add(category);
            }
            arrayList = results;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    protected PreparedStatement getCategoriesStatement(Connection conn, int virtualWikiId, String virtualWikiName, Pagination pagination) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_CATEGORIES);
        stmt.setInt(1, virtualWikiId);
        stmt.setInt(2, pagination.getNumResults());
        stmt.setInt(3, pagination.getOffset());
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LogItem> getLogItems(int virtualWikiId, String virtualWikiName, int logType, Pagination pagination, boolean descending) throws SQLException {
        ArrayList<LogItem> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<LogItem> logItems = new ArrayList<LogItem>();
        try {
            conn = DatabaseConnection.getConnection();
            stmt = this.getLogItemsStatement(conn, virtualWikiId, virtualWikiName, logType, pagination, descending);
            rs = stmt.executeQuery();
            while (rs.next()) {
                logItems.add(this.initLogItem(rs, virtualWikiName));
            }
            arrayList = logItems;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    protected PreparedStatement getLogItemsStatement(Connection conn, int virtualWikiId, String virtualWikiName, int logType, Pagination pagination, boolean descending) throws SQLException {
        int index = 1;
        PreparedStatement stmt = null;
        if (logType == -1) {
            stmt = conn.prepareStatement(STATEMENT_SELECT_LOG_ITEMS);
        } else {
            stmt = conn.prepareStatement(STATEMENT_SELECT_LOG_ITEMS_BY_TYPE);
            stmt.setInt(index++, logType);
        }
        stmt.setInt(index++, virtualWikiId);
        stmt.setInt(index++, pagination.getNumResults());
        stmt.setInt(index++, pagination.getOffset());
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RecentChange> getRecentChanges(String virtualWiki, Pagination pagination, boolean descending) throws SQLException {
        ArrayList<RecentChange> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = this.getRecentChangesStatement(conn, virtualWiki, pagination, descending);
            rs = stmt.executeQuery();
            ArrayList<RecentChange> recentChanges = new ArrayList<RecentChange>();
            while (rs.next()) {
                recentChanges.add(this.initRecentChange(rs));
            }
            arrayList = recentChanges;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    protected PreparedStatement getRecentChangesStatement(Connection conn, String virtualWiki, Pagination pagination, boolean descending) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_RECENT_CHANGES);
        stmt.setString(1, virtualWiki);
        stmt.setInt(2, pagination.getNumResults());
        stmt.setInt(3, pagination.getOffset());
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RoleMap> getRoleMapByLogin(String loginFragment) throws SQLException {
        ArrayList<RoleMap> arrayList;
        if (StringUtils.isBlank((String)loginFragment)) {
            return new ArrayList<RoleMap>();
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = conn.prepareStatement(STATEMENT_SELECT_AUTHORITIES_LOGIN);
            loginFragment = '%' + loginFragment.toLowerCase() + '%';
            stmt.setString(1, loginFragment);
            rs = stmt.executeQuery();
            LinkedHashMap<Integer, RoleMap> roleMaps = new LinkedHashMap<Integer, RoleMap>();
            while (rs.next()) {
                Integer userId = rs.getInt("wiki_user_id");
                RoleMap roleMap = new RoleMap();
                if (roleMaps.containsKey(userId)) {
                    roleMap = (RoleMap)roleMaps.get(userId);
                } else {
                    roleMap.setUserId(userId);
                    roleMap.setUserLogin(rs.getString("username"));
                }
                roleMap.addRole(rs.getString("authority"));
                roleMaps.put(userId, roleMap);
            }
            arrayList = new ArrayList<RoleMap>(roleMaps.values());
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RoleMap> getRoleMapByRole(String authority) throws SQLException {
        ArrayList<RoleMap> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = conn.prepareStatement(STATEMENT_SELECT_AUTHORITIES_AUTHORITY);
            stmt.setString(1, authority);
            stmt.setString(2, authority);
            rs = stmt.executeQuery();
            LinkedHashMap<String, RoleMap> roleMaps = new LinkedHashMap<String, RoleMap>();
            while (rs.next()) {
                int userId = rs.getInt("wiki_user_id");
                int groupId = rs.getInt("group_id");
                RoleMap roleMap = new RoleMap();
                String key = userId + "|" + groupId;
                if (roleMaps.containsKey(key)) {
                    roleMap = (RoleMap)roleMaps.get(key);
                } else {
                    if (userId > 0) {
                        roleMap.setUserId(userId);
                        roleMap.setUserLogin(rs.getString("username"));
                    }
                    if (groupId > 0) {
                        roleMap.setGroupId(groupId);
                        roleMap.setGroupName(rs.getString("group_name"));
                    }
                }
                roleMap.addRole(rs.getString("authority"));
                roleMaps.put(key, roleMap);
            }
            arrayList = new ArrayList<RoleMap>(roleMaps.values());
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Role> getRoleMapGroup(String groupName) throws SQLException {
        ArrayList<Role> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = conn.prepareStatement(STATEMENT_SELECT_GROUP_AUTHORITIES);
            stmt.setString(1, groupName);
            rs = stmt.executeQuery();
            ArrayList<Role> roles = new ArrayList<Role>();
            while (rs.next()) {
                roles.add(this.initRole(rs));
            }
            arrayList = roles;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RoleMap> getRoleMapGroups() throws SQLException {
        ArrayList<RoleMap> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = conn.prepareStatement(STATEMENT_SELECT_GROUPS_AUTHORITIES);
            rs = stmt.executeQuery();
            LinkedHashMap<Integer, RoleMap> roleMaps = new LinkedHashMap<Integer, RoleMap>();
            while (rs.next()) {
                Integer groupId = rs.getInt("group_id");
                RoleMap roleMap = new RoleMap();
                if (roleMaps.containsKey(groupId)) {
                    roleMap = (RoleMap)roleMaps.get(groupId);
                } else {
                    roleMap.setGroupId(groupId);
                    roleMap.setGroupName(rs.getString("group_name"));
                }
                roleMap.addRole(rs.getString("authority"));
                roleMaps.put(groupId, roleMap);
            }
            arrayList = new ArrayList<RoleMap>(roleMaps.values());
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Role> getRoleMapUser(String login) throws SQLException {
        ArrayList<Role> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = conn.prepareStatement(STATEMENT_SELECT_AUTHORITIES_USER);
            stmt.setString(1, login);
            rs = stmt.executeQuery();
            ArrayList<Role> roles = new ArrayList<Role>();
            while (rs.next()) {
                roles.add(this.initRole(rs));
            }
            arrayList = roles;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Role> getRoles() throws SQLException {
        ArrayList<Role> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = conn.prepareStatement(STATEMENT_SELECT_ROLES);
            rs = stmt.executeQuery();
            ArrayList<Role> roles = new ArrayList<Role>();
            while (rs.next()) {
                roles.add(this.initRole(rs));
            }
            arrayList = roles;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RecentChange> getTopicHistory(int topicId, Pagination pagination, boolean descending) throws SQLException {
        ArrayList<RecentChange> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = this.getTopicHistoryStatement(conn, topicId, pagination, descending);
            rs = stmt.executeQuery();
            ArrayList<RecentChange> recentChanges = new ArrayList<RecentChange>();
            while (rs.next()) {
                recentChanges.add(this.initRecentChange(rs));
            }
            arrayList = recentChanges;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    protected PreparedStatement getTopicHistoryStatement(Connection conn, int topicId, Pagination pagination, boolean descending) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_TOPIC_HISTORY);
        stmt.setInt(1, topicId);
        stmt.setInt(2, pagination.getNumResults());
        stmt.setInt(3, pagination.getOffset());
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getTopicsAdmin(int virtualWikiId, Pagination pagination) throws SQLException {
        ArrayList<String> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = this.getTopicsAdminStatement(conn, virtualWikiId, pagination);
            rs = stmt.executeQuery();
            ArrayList<String> results = new ArrayList<String>();
            while (rs.next()) {
                results.add(rs.getString("topic_name"));
            }
            arrayList = results;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    protected PreparedStatement getTopicsAdminStatement(Connection conn, int virtualWikiId, Pagination pagination) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_TOPICS_ADMIN);
        stmt.setInt(1, virtualWikiId);
        stmt.setInt(2, pagination.getNumResults());
        stmt.setInt(3, pagination.getOffset());
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RecentChange> getUserContributionsByLogin(String virtualWiki, String login, Pagination pagination, boolean descending) throws SQLException {
        ArrayList<RecentChange> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = this.getUserContributionsByLoginStatement(conn, virtualWiki, login, pagination, descending);
            rs = stmt.executeQuery();
            ArrayList<RecentChange> recentChanges = new ArrayList<RecentChange>();
            while (rs.next()) {
                recentChanges.add(this.initRecentChange(rs));
            }
            arrayList = recentChanges;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    protected PreparedStatement getUserContributionsByLoginStatement(Connection conn, String virtualWiki, String login, Pagination pagination, boolean descending) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_WIKI_USER_CHANGES_LOGIN);
        stmt.setString(1, virtualWiki);
        stmt.setString(2, login);
        stmt.setInt(3, pagination.getNumResults());
        stmt.setInt(4, pagination.getOffset());
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RecentChange> getUserContributionsByUserDisplay(String virtualWiki, String userDisplay, Pagination pagination, boolean descending) throws SQLException {
        ArrayList<RecentChange> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = this.getUserContributionsByUserDisplayStatement(conn, virtualWiki, userDisplay, pagination, descending);
            rs = stmt.executeQuery();
            ArrayList<RecentChange> recentChanges = new ArrayList<RecentChange>();
            while (rs.next()) {
                recentChanges.add(this.initRecentChange(rs));
            }
            arrayList = recentChanges;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    protected PreparedStatement getUserContributionsByUserDisplayStatement(Connection conn, String virtualWiki, String userDisplay, Pagination pagination, boolean descending) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_WIKI_USER_CHANGES_ANONYMOUS);
        stmt.setString(1, virtualWiki);
        stmt.setString(2, userDisplay);
        stmt.setInt(3, pagination.getNumResults());
        stmt.setInt(4, pagination.getOffset());
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<VirtualWiki> getVirtualWikis(Connection conn) throws SQLException {
        ArrayList<VirtualWiki> arrayList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_SELECT_VIRTUAL_WIKIS);
            rs = stmt.executeQuery();
            ArrayList<VirtualWiki> results = new ArrayList<VirtualWiki>();
            while (rs.next()) {
                VirtualWiki virtualWiki = new VirtualWiki(rs.getString("virtual_wiki_name"));
                virtualWiki.setVirtualWikiId(rs.getInt("virtual_wiki_id"));
                virtualWiki.setRootTopicName(rs.getString("default_topic_name"));
                virtualWiki.setLogoImageUrl(rs.getString("logo_image_url"));
                virtualWiki.setMetaDescription(rs.getString("meta_description"));
                virtualWiki.setSiteName(rs.getString("site_name"));
                results.add(virtualWiki);
            }
            arrayList = results;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(null, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(null, stmt, rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getWatchlist(int virtualWikiId, int userId) throws SQLException {
        ArrayList<String> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = conn.prepareStatement(STATEMENT_SELECT_WATCHLIST);
            stmt.setInt(1, virtualWikiId);
            stmt.setInt(2, userId);
            rs = stmt.executeQuery();
            ArrayList<String> watchedTopicNames = new ArrayList<String>();
            while (rs.next()) {
                watchedTopicNames.add(rs.getString("topic_name"));
            }
            arrayList = watchedTopicNames;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RecentChange> getWatchlist(int virtualWikiId, int userId, Pagination pagination) throws SQLException {
        ArrayList<RecentChange> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = this.getWatchlistStatement(conn, virtualWikiId, userId, pagination);
            rs = stmt.executeQuery();
            ArrayList<RecentChange> recentChanges = new ArrayList<RecentChange>();
            while (rs.next()) {
                recentChanges.add(this.initRecentChange(rs));
            }
            arrayList = recentChanges;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    protected PreparedStatement getWatchlistStatement(Connection conn, int virtualWikiId, int userId, Pagination pagination) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_WATCHLIST_CHANGES);
        stmt.setInt(1, virtualWikiId);
        stmt.setInt(2, userId);
        stmt.setInt(3, pagination.getNumResults());
        stmt.setInt(4, pagination.getOffset());
        return stmt;
    }

    protected void init(Properties properties) {
        this.props = properties;
        STATEMENT_CONNECTION_VALIDATION_QUERY = this.props.getProperty("STATEMENT_CONNECTION_VALIDATION_QUERY");
        STATEMENT_CREATE_CONFIGURATION_TABLE = this.props.getProperty("STATEMENT_CREATE_CONFIGURATION_TABLE");
        STATEMENT_CREATE_GROUP_TABLE = this.props.getProperty("STATEMENT_CREATE_GROUP_TABLE");
        STATEMENT_CREATE_INTERWIKI_TABLE = this.props.getProperty("STATEMENT_CREATE_INTERWIKI_TABLE");
        STATEMENT_CREATE_NAMESPACE_TABLE = this.props.getProperty("STATEMENT_CREATE_NAMESPACE_TABLE");
        STATEMENT_CREATE_NAMESPACE_TRANSLATION_TABLE = this.props.getProperty("STATEMENT_CREATE_NAMESPACE_TRANSLATION_TABLE");
        STATEMENT_CREATE_ROLE_TABLE = this.props.getProperty("STATEMENT_CREATE_ROLE_TABLE");
        STATEMENT_CREATE_VIRTUAL_WIKI_TABLE = this.props.getProperty("STATEMENT_CREATE_VIRTUAL_WIKI_TABLE");
        STATEMENT_CREATE_WIKI_USER_TABLE = this.props.getProperty("STATEMENT_CREATE_WIKI_USER_TABLE");
        STATEMENT_CREATE_WIKI_USER_LOGIN_INDEX = this.props.getProperty("STATEMENT_CREATE_WIKI_USER_LOGIN_INDEX");
        STATEMENT_CREATE_TOPIC_CURRENT_VERSION_CONSTRAINT = this.props.getProperty("STATEMENT_CREATE_TOPIC_CURRENT_VERSION_CONSTRAINT");
        STATEMENT_CREATE_TOPIC_TABLE = this.props.getProperty("STATEMENT_CREATE_TOPIC_TABLE");
        STATEMENT_CREATE_TOPIC_LINKS_TABLE = this.props.getProperty("STATEMENT_CREATE_TOPIC_LINKS_TABLE");
        STATEMENT_CREATE_TOPIC_LINKS_INDEX = this.props.getProperty("STATEMENT_CREATE_TOPIC_LINKS_INDEX");
        STATEMENT_CREATE_TOPIC_PAGE_NAME_INDEX = this.props.getProperty("STATEMENT_CREATE_TOPIC_PAGE_NAME_INDEX");
        STATEMENT_CREATE_TOPIC_PAGE_NAME_LOWER_INDEX = this.props.getProperty("STATEMENT_CREATE_TOPIC_PAGE_NAME_LOWER_INDEX");
        STATEMENT_CREATE_TOPIC_NAMESPACE_INDEX = this.props.getProperty("STATEMENT_CREATE_TOPIC_NAMESPACE_INDEX");
        STATEMENT_CREATE_TOPIC_VIRTUAL_WIKI_INDEX = this.props.getProperty("STATEMENT_CREATE_TOPIC_VIRTUAL_WIKI_INDEX");
        STATEMENT_CREATE_TOPIC_CURRENT_VERSION_INDEX = this.props.getProperty("STATEMENT_CREATE_TOPIC_CURRENT_VERSION_INDEX");
        STATEMENT_CREATE_TOPIC_VERSION_TABLE = this.props.getProperty("STATEMENT_CREATE_TOPIC_VERSION_TABLE");
        STATEMENT_CREATE_TOPIC_VERSION_TOPIC_INDEX = this.props.getProperty("STATEMENT_CREATE_TOPIC_VERSION_TOPIC_INDEX");
        STATEMENT_CREATE_TOPIC_VERSION_PREVIOUS_INDEX = this.props.getProperty("STATEMENT_CREATE_TOPIC_VERSION_PREVIOUS_INDEX");
        STATEMENT_CREATE_TOPIC_VERSION_USER_DISPLAY_INDEX = this.props.getProperty("STATEMENT_CREATE_TOPIC_VERSION_USER_DISPLAY_INDEX");
        STATEMENT_CREATE_TOPIC_VERSION_USER_ID_INDEX = this.props.getProperty("STATEMENT_CREATE_TOPIC_VERSION_USER_ID_INDEX");
        STATEMENT_CREATE_USERS_TABLE = this.props.getProperty("STATEMENT_CREATE_USERS_TABLE");
        STATEMENT_CREATE_WIKI_FILE_TABLE = this.props.getProperty("STATEMENT_CREATE_WIKI_FILE_TABLE");
        STATEMENT_CREATE_WIKI_FILE_VERSION_TABLE = this.props.getProperty("STATEMENT_CREATE_WIKI_FILE_VERSION_TABLE");
        STATEMENT_CREATE_AUTHORITIES_TABLE = this.props.getProperty("STATEMENT_CREATE_AUTHORITIES_TABLE");
        STATEMENT_CREATE_CATEGORY_TABLE = this.props.getProperty("STATEMENT_CREATE_CATEGORY_TABLE");
        STATEMENT_CREATE_CATEGORY_INDEX = this.props.getProperty("STATEMENT_CREATE_CATEGORY_INDEX");
        STATEMENT_CREATE_GROUP_AUTHORITIES_TABLE = this.props.getProperty("STATEMENT_CREATE_GROUP_AUTHORITIES_TABLE");
        STATEMENT_CREATE_GROUP_MEMBERS_TABLE = this.props.getProperty("STATEMENT_CREATE_GROUP_MEMBERS_TABLE");
        STATEMENT_CREATE_LOG_TABLE = this.props.getProperty("STATEMENT_CREATE_LOG_TABLE");
        STATEMENT_CREATE_RECENT_CHANGE_TABLE = this.props.getProperty("STATEMENT_CREATE_RECENT_CHANGE_TABLE");
        STATEMENT_CREATE_WATCHLIST_TABLE = this.props.getProperty("STATEMENT_CREATE_WATCHLIST_TABLE");
        STATEMENT_DELETE_AUTHORITIES = this.props.getProperty("STATEMENT_DELETE_AUTHORITIES");
        STATEMENT_DELETE_CONFIGURATION = this.props.getProperty("STATEMENT_DELETE_CONFIGURATION");
        STATEMENT_DELETE_GROUP_AUTHORITIES = this.props.getProperty("STATEMENT_DELETE_GROUP_AUTHORITIES");
        STATEMENT_DELETE_INTERWIKI = this.props.getProperty("STATEMENT_DELETE_INTERWIKI");
        STATEMENT_DELETE_LOG_ITEMS = this.props.getProperty("STATEMENT_DELETE_LOG_ITEMS");
        STATEMENT_DELETE_NAMESPACE_TRANSLATIONS = this.props.getProperty("STATEMENT_DELETE_NAMESPACE_TRANSLATIONS");
        STATEMENT_DELETE_RECENT_CHANGES = this.props.getProperty("STATEMENT_DELETE_RECENT_CHANGES");
        STATEMENT_DELETE_RECENT_CHANGES_TOPIC = this.props.getProperty("STATEMENT_DELETE_RECENT_CHANGES_TOPIC");
        STATEMENT_DELETE_TOPIC_CATEGORIES = this.props.getProperty("STATEMENT_DELETE_TOPIC_CATEGORIES");
        STATEMENT_DELETE_TOPIC_LINKS = this.props.getProperty("STATEMENT_DELETE_TOPIC_LINKS");
        STATEMENT_DELETE_WATCHLIST_ENTRY = this.props.getProperty("STATEMENT_DELETE_WATCHLIST_ENTRY");
        STATEMENT_DROP_AUTHORITIES_TABLE = this.props.getProperty("STATEMENT_DROP_AUTHORITIES_TABLE");
        STATEMENT_DROP_CATEGORY_TABLE = this.props.getProperty("STATEMENT_DROP_CATEGORY_TABLE");
        STATEMENT_DROP_CONFIGURATION_TABLE = this.props.getProperty("STATEMENT_DROP_CONFIGURATION_TABLE");
        STATEMENT_DROP_GROUP_AUTHORITIES_TABLE = this.props.getProperty("STATEMENT_DROP_GROUP_AUTHORITIES_TABLE");
        STATEMENT_DROP_GROUP_MEMBERS_TABLE = this.props.getProperty("STATEMENT_DROP_GROUP_MEMBERS_TABLE");
        STATEMENT_DROP_GROUP_TABLE = this.props.getProperty("STATEMENT_DROP_GROUP_TABLE");
        STATEMENT_DROP_INTERWIKI_TABLE = this.props.getProperty("STATEMENT_DROP_INTERWIKI_TABLE");
        STATEMENT_DROP_LOG_TABLE = this.props.getProperty("STATEMENT_DROP_LOG_TABLE");
        STATEMENT_DROP_NAMESPACE_TABLE = this.props.getProperty("STATEMENT_DROP_NAMESPACE_TABLE");
        STATEMENT_DROP_NAMESPACE_TRANSLATION_TABLE = this.props.getProperty("STATEMENT_DROP_NAMESPACE_TRANSLATION_TABLE");
        STATEMENT_DROP_RECENT_CHANGE_TABLE = this.props.getProperty("STATEMENT_DROP_RECENT_CHANGE_TABLE");
        STATEMENT_DROP_ROLE_TABLE = this.props.getProperty("STATEMENT_DROP_ROLE_TABLE");
        STATEMENT_DROP_TOPIC_CURRENT_VERSION_CONSTRAINT = this.props.getProperty("STATEMENT_DROP_TOPIC_CURRENT_VERSION_CONSTRAINT");
        STATEMENT_DROP_TOPIC_TABLE = this.props.getProperty("STATEMENT_DROP_TOPIC_TABLE");
        STATEMENT_DROP_TOPIC_LINKS_TABLE = this.props.getProperty("STATEMENT_DROP_TOPIC_LINKS_TABLE");
        STATEMENT_DROP_TOPIC_VERSION_TABLE = this.props.getProperty("STATEMENT_DROP_TOPIC_VERSION_TABLE");
        STATEMENT_DROP_USERS_TABLE = this.props.getProperty("STATEMENT_DROP_USERS_TABLE");
        STATEMENT_DROP_VIRTUAL_WIKI_TABLE = this.props.getProperty("STATEMENT_DROP_VIRTUAL_WIKI_TABLE");
        STATEMENT_DROP_WATCHLIST_TABLE = this.props.getProperty("STATEMENT_DROP_WATCHLIST_TABLE");
        STATEMENT_DROP_WIKI_USER_TABLE = this.props.getProperty("STATEMENT_DROP_WIKI_USER_TABLE");
        STATEMENT_DROP_WIKI_FILE_TABLE = this.props.getProperty("STATEMENT_DROP_WIKI_FILE_TABLE");
        STATEMENT_DROP_WIKI_FILE_VERSION_TABLE = this.props.getProperty("STATEMENT_DROP_WIKI_FILE_VERSION_TABLE");
        STATEMENT_INSERT_AUTHORITY = this.props.getProperty("STATEMENT_INSERT_AUTHORITY");
        STATEMENT_INSERT_CATEGORY = this.props.getProperty("STATEMENT_INSERT_CATEGORY");
        STATEMENT_INSERT_CONFIGURATION = this.props.getProperty("STATEMENT_INSERT_CONFIGURATION");
        STATEMENT_INSERT_GROUP = this.props.getProperty("STATEMENT_INSERT_GROUP");
        STATEMENT_INSERT_GROUP_AUTO_INCREMENT = this.props.getProperty("STATEMENT_INSERT_GROUP_AUTO_INCREMENT");
        STATEMENT_INSERT_GROUP_AUTHORITY = this.props.getProperty("STATEMENT_INSERT_GROUP_AUTHORITY");
        STATEMENT_INSERT_GROUP_MEMBER = this.props.getProperty("STATEMENT_INSERT_GROUP_MEMBER");
        STATEMENT_INSERT_GROUP_MEMBER_AUTO_INCREMENT = this.props.getProperty("STATEMENT_INSERT_GROUP_MEMBER_AUTO_INCREMENT");
        STATEMENT_INSERT_INTERWIKI = this.props.getProperty("STATEMENT_INSERT_INTERWIKI");
        STATEMENT_INSERT_LOG_ITEM = this.props.getProperty("STATEMENT_INSERT_LOG_ITEM");
        STATEMENT_INSERT_LOG_ITEMS_BY_TOPIC_VERSION_TYPE = this.props.getProperty("STATEMENT_INSERT_LOG_ITEMS_BY_TOPIC_VERSION_TYPE");
        STATEMENT_INSERT_LOG_ITEMS_IMPORT = this.props.getProperty("STATEMENT_INSERT_LOG_ITEMS_IMPORT");
        STATEMENT_INSERT_LOG_ITEMS_MOVE = this.props.getProperty("STATEMENT_INSERT_LOG_ITEMS_MOVE");
        STATEMENT_INSERT_LOG_ITEMS_UPLOAD = this.props.getProperty("STATEMENT_INSERT_LOG_ITEMS_UPLOAD");
        STATEMENT_INSERT_LOG_ITEMS_USER = this.props.getProperty("STATEMENT_INSERT_LOG_ITEMS_USER");
        STATEMENT_INSERT_NAMESPACE = this.props.getProperty("STATEMENT_INSERT_NAMESPACE");
        STATEMENT_INSERT_NAMESPACE_TRANSLATION = this.props.getProperty("STATEMENT_INSERT_NAMESPACE_TRANSLATION");
        STATEMENT_INSERT_RECENT_CHANGE = this.props.getProperty("STATEMENT_INSERT_RECENT_CHANGE");
        STATEMENT_INSERT_RECENT_CHANGES_LOGS = this.props.getProperty("STATEMENT_INSERT_RECENT_CHANGES_LOGS");
        STATEMENT_INSERT_RECENT_CHANGES_VERSIONS = this.props.getProperty("STATEMENT_INSERT_RECENT_CHANGES_VERSIONS");
        STATEMENT_INSERT_ROLE = this.props.getProperty("STATEMENT_INSERT_ROLE");
        STATEMENT_INSERT_TOPIC = this.props.getProperty("STATEMENT_INSERT_TOPIC");
        STATEMENT_INSERT_TOPIC_AUTO_INCREMENT = this.props.getProperty("STATEMENT_INSERT_TOPIC_AUTO_INCREMENT");
        STATEMENT_INSERT_TOPIC_LINKS = this.props.getProperty("STATEMENT_INSERT_TOPIC_LINKS");
        STATEMENT_INSERT_TOPIC_VERSION = this.props.getProperty("STATEMENT_INSERT_TOPIC_VERSION");
        STATEMENT_INSERT_TOPIC_VERSION_AUTO_INCREMENT = this.props.getProperty("STATEMENT_INSERT_TOPIC_VERSION_AUTO_INCREMENT");
        STATEMENT_INSERT_USER = this.props.getProperty("STATEMENT_INSERT_USER");
        STATEMENT_INSERT_VIRTUAL_WIKI = this.props.getProperty("STATEMENT_INSERT_VIRTUAL_WIKI");
        STATEMENT_INSERT_VIRTUAL_WIKI_AUTO_INCREMENT = this.props.getProperty("STATEMENT_INSERT_VIRTUAL_WIKI_AUTO_INCREMENT");
        STATEMENT_INSERT_WATCHLIST_ENTRY = this.props.getProperty("STATEMENT_INSERT_WATCHLIST_ENTRY");
        STATEMENT_INSERT_WIKI_FILE = this.props.getProperty("STATEMENT_INSERT_WIKI_FILE");
        STATEMENT_INSERT_WIKI_FILE_AUTO_INCREMENT = this.props.getProperty("STATEMENT_INSERT_WIKI_FILE_AUTO_INCREMENT");
        STATEMENT_INSERT_WIKI_FILE_VERSION = this.props.getProperty("STATEMENT_INSERT_WIKI_FILE_VERSION");
        STATEMENT_INSERT_WIKI_FILE_VERSION_AUTO_INCREMENT = this.props.getProperty("STATEMENT_INSERT_WIKI_FILE_VERSION_AUTO_INCREMENT");
        STATEMENT_INSERT_WIKI_USER = this.props.getProperty("STATEMENT_INSERT_WIKI_USER");
        STATEMENT_INSERT_WIKI_USER_AUTO_INCREMENT = this.props.getProperty("STATEMENT_INSERT_WIKI_USER_AUTO_INCREMENT");
        STATEMENT_SELECT_AUTHORITIES_AUTHORITY = this.props.getProperty("STATEMENT_SELECT_AUTHORITIES_AUTHORITY");
        STATEMENT_SELECT_AUTHORITIES_LOGIN = this.props.getProperty("STATEMENT_SELECT_AUTHORITIES_LOGIN");
        STATEMENT_SELECT_AUTHORITIES_USER = this.props.getProperty("STATEMENT_SELECT_AUTHORITIES_USER");
        STATEMENT_SELECT_CATEGORIES = this.props.getProperty("STATEMENT_SELECT_CATEGORIES");
        STATEMENT_SELECT_CATEGORY_TOPICS = this.props.getProperty("STATEMENT_SELECT_CATEGORY_TOPICS");
        STATEMENT_SELECT_CONFIGURATION = this.props.getProperty("STATEMENT_SELECT_CONFIGURATION");
        STATEMENT_SELECT_GROUP = this.props.getProperty("STATEMENT_SELECT_GROUP");
        STATEMENT_SELECT_GROUP_AUTHORITIES = this.props.getProperty("STATEMENT_SELECT_GROUP_AUTHORITIES");
        STATEMENT_SELECT_GROUPS_AUTHORITIES = this.props.getProperty("STATEMENT_SELECT_GROUPS_AUTHORITIES");
        STATEMENT_SELECT_GROUP_MEMBERS_SEQUENCE = this.props.getProperty("STATEMENT_SELECT_GROUP_MEMBERS_SEQUENCE");
        STATEMENT_SELECT_GROUP_SEQUENCE = this.props.getProperty("STATEMENT_SELECT_GROUP_SEQUENCE");
        STATEMENT_SELECT_INTERWIKIS = this.props.getProperty("STATEMENT_SELECT_INTERWIKIS");
        STATEMENT_SELECT_LOG_ITEMS = this.props.getProperty("STATEMENT_SELECT_LOG_ITEMS");
        STATEMENT_SELECT_LOG_ITEMS_BY_TYPE = this.props.getProperty("STATEMENT_SELECT_LOG_ITEMS_BY_TYPE");
        STATEMENT_SELECT_NAMESPACE_SEQUENCE = this.props.getProperty("STATEMENT_SELECT_NAMESPACE_SEQUENCE");
        STATEMENT_SELECT_NAMESPACES = this.props.getProperty("STATEMENT_SELECT_NAMESPACES");
        STATEMENT_SELECT_RECENT_CHANGES = this.props.getProperty("STATEMENT_SELECT_RECENT_CHANGES");
        STATEMENT_SELECT_ROLES = this.props.getProperty("STATEMENT_SELECT_ROLES");
        STATEMENT_SELECT_TOPIC_BY_ID = this.props.getProperty("STATEMENT_SELECT_TOPIC_BY_ID");
        STATEMENT_SELECT_TOPIC_BY_TYPE = this.props.getProperty("STATEMENT_SELECT_TOPIC_BY_TYPE");
        STATEMENT_SELECT_TOPIC_COUNT = this.props.getProperty("STATEMENT_SELECT_TOPIC_COUNT");
        STATEMENT_SELECT_TOPIC = this.props.getProperty("STATEMENT_SELECT_TOPIC");
        STATEMENT_SELECT_TOPIC_HISTORY = this.props.getProperty("STATEMENT_SELECT_TOPIC_HISTORY");
        STATEMENT_SELECT_TOPIC_LINK_ORPHANS = this.props.getProperty("STATEMENT_SELECT_TOPIC_LINK_ORPHANS");
        STATEMENT_SELECT_TOPIC_LINKS = this.props.getProperty("STATEMENT_SELECT_TOPIC_LINKS");
        STATEMENT_SELECT_TOPIC_LOWER = this.props.getProperty("STATEMENT_SELECT_TOPIC_LOWER");
        STATEMENT_SELECT_TOPIC_NAME = this.props.getProperty("STATEMENT_SELECT_TOPIC_NAME");
        STATEMENT_SELECT_TOPIC_NAME_LOWER = this.props.getProperty("STATEMENT_SELECT_TOPIC_NAME_LOWER");
        STATEMENT_SELECT_TOPIC_NAMES = this.props.getProperty("STATEMENT_SELECT_TOPIC_NAMES");
        STATEMENT_SELECT_TOPICS_ADMIN = this.props.getProperty("STATEMENT_SELECT_TOPICS_ADMIN");
        STATEMENT_SELECT_TOPIC_SEQUENCE = this.props.getProperty("STATEMENT_SELECT_TOPIC_SEQUENCE");
        STATEMENT_SELECT_TOPIC_VERSION = this.props.getProperty("STATEMENT_SELECT_TOPIC_VERSION");
        STATEMENT_SELECT_TOPIC_VERSION_NEXT_ID = this.props.getProperty("STATEMENT_SELECT_TOPIC_VERSION_NEXT_ID");
        STATEMENT_SELECT_TOPIC_VERSION_SEQUENCE = this.props.getProperty("STATEMENT_SELECT_TOPIC_VERSION_SEQUENCE");
        STATEMENT_SELECT_USERS_AUTHENTICATION = this.props.getProperty("STATEMENT_SELECT_USERS_AUTHENTICATION");
        STATEMENT_SELECT_VIRTUAL_WIKIS = this.props.getProperty("STATEMENT_SELECT_VIRTUAL_WIKIS");
        STATEMENT_SELECT_VIRTUAL_WIKI_SEQUENCE = this.props.getProperty("STATEMENT_SELECT_VIRTUAL_WIKI_SEQUENCE");
        STATEMENT_SELECT_WATCHLIST = this.props.getProperty("STATEMENT_SELECT_WATCHLIST");
        STATEMENT_SELECT_WATCHLIST_CHANGES = this.props.getProperty("STATEMENT_SELECT_WATCHLIST_CHANGES");
        STATEMENT_SELECT_WIKI_FILE = this.props.getProperty("STATEMENT_SELECT_WIKI_FILE");
        STATEMENT_SELECT_WIKI_FILE_COUNT = this.props.getProperty("STATEMENT_SELECT_WIKI_FILE_COUNT");
        STATEMENT_SELECT_WIKI_FILE_SEQUENCE = this.props.getProperty("STATEMENT_SELECT_WIKI_FILE_SEQUENCE");
        STATEMENT_SELECT_WIKI_FILE_VERSION_SEQUENCE = this.props.getProperty("STATEMENT_SELECT_WIKI_FILE_VERSION_SEQUENCE");
        STATEMENT_SELECT_WIKI_FILE_VERSIONS = this.props.getProperty("STATEMENT_SELECT_WIKI_FILE_VERSIONS");
        STATEMENT_SELECT_WIKI_USER = this.props.getProperty("STATEMENT_SELECT_WIKI_USER");
        STATEMENT_SELECT_WIKI_USER_CHANGES_ANONYMOUS = this.props.getProperty("STATEMENT_SELECT_WIKI_USER_CHANGES_ANONYMOUS");
        STATEMENT_SELECT_WIKI_USER_CHANGES_LOGIN = this.props.getProperty("STATEMENT_SELECT_WIKI_USER_CHANGES_LOGIN");
        STATEMENT_SELECT_WIKI_USER_COUNT = this.props.getProperty("STATEMENT_SELECT_WIKI_USER_COUNT");
        STATEMENT_SELECT_WIKI_USER_DETAILS_PASSWORD = this.props.getProperty("STATEMENT_SELECT_WIKI_USER_DETAILS_PASSWORD");
        STATEMENT_SELECT_WIKI_USER_LOGIN = this.props.getProperty("STATEMENT_SELECT_WIKI_USER_LOGIN");
        STATEMENT_SELECT_WIKI_USER_SEQUENCE = this.props.getProperty("STATEMENT_SELECT_WIKI_USER_SEQUENCE");
        STATEMENT_SELECT_WIKI_USERS = this.props.getProperty("STATEMENT_SELECT_WIKI_USERS");
        STATEMENT_UPDATE_GROUP = this.props.getProperty("STATEMENT_UPDATE_GROUP");
        STATEMENT_UPDATE_NAMESPACE = this.props.getProperty("STATEMENT_UPDATE_NAMESPACE");
        STATEMENT_UPDATE_TOPIC_NAMESPACE = this.props.getProperty("STATEMENT_UPDATE_TOPIC_NAMESPACE");
        STATEMENT_UPDATE_ROLE = this.props.getProperty("STATEMENT_UPDATE_ROLE");
        STATEMENT_UPDATE_TOPIC = this.props.getProperty("STATEMENT_UPDATE_TOPIC");
        STATEMENT_UPDATE_TOPIC_VERSION_PREVIOUS_VERSION_ID = this.props.getProperty("STATEMENT_UPDATE_TOPIC_VERSION_PREVIOUS_VERSION_ID");
        STATEMENT_UPDATE_USER = this.props.getProperty("STATEMENT_UPDATE_USER");
        STATEMENT_UPDATE_VIRTUAL_WIKI = this.props.getProperty("STATEMENT_UPDATE_VIRTUAL_WIKI");
        STATEMENT_UPDATE_WIKI_FILE = this.props.getProperty("STATEMENT_UPDATE_WIKI_FILE");
        STATEMENT_UPDATE_WIKI_USER = this.props.getProperty("STATEMENT_UPDATE_WIKI_USER");
    }

    private Category initCategory(ResultSet rs, String virtualWikiName) throws SQLException {
        Category category = new Category();
        category.setName("category_name");
        category.setVirtualWiki(virtualWikiName);
        category.setChildTopicName(rs.getString("topic_name"));
        category.setSortKey(rs.getString("sort_key"));
        category.setTopicType(TopicType.findTopicType(rs.getInt("topic_type")));
        return category;
    }

    public LogItem initLogItem(ResultSet rs, String virtualWikiName) throws SQLException {
        int topicVersionId;
        LogItem logItem = new LogItem();
        int userId = rs.getInt("wiki_user_id");
        if (userId > 0) {
            logItem.setUserId(userId);
        }
        logItem.setUserDisplayName(rs.getString("display_name"));
        int topicId = rs.getInt("topic_id");
        if (topicId > 0) {
            logItem.setTopicId(topicId);
        }
        if ((topicVersionId = rs.getInt("topic_version_id")) > 0) {
            logItem.setTopicVersionId(topicVersionId);
        }
        logItem.setLogDate(rs.getTimestamp("log_date"));
        logItem.setLogComment(rs.getString("log_comment"));
        logItem.setLogParamString(rs.getString("log_params"));
        logItem.setLogType(rs.getInt("log_type"));
        logItem.setVirtualWiki(virtualWikiName);
        return logItem;
    }

    public RecentChange initRecentChange(ResultSet rs) throws SQLException {
        int logType;
        int topicId;
        int previousTopicVersionId;
        RecentChange change = new RecentChange();
        int topicVersionId = rs.getInt("topic_version_id");
        if (topicVersionId > 0) {
            change.setTopicVersionId(topicVersionId);
        }
        if ((previousTopicVersionId = rs.getInt("previous_topic_version_id")) > 0) {
            change.setPreviousTopicVersionId(previousTopicVersionId);
        }
        if ((topicId = rs.getInt("topic_id")) > 0) {
            change.setTopicId(topicId);
        }
        change.setTopicName(rs.getString("topic_name"));
        change.setCharactersChanged(rs.getInt("characters_changed"));
        change.setChangeDate(rs.getTimestamp("change_date"));
        change.setChangeComment(rs.getString("change_comment"));
        int userId = rs.getInt("wiki_user_id");
        if (userId > 0) {
            change.setAuthorId(userId);
        }
        change.setAuthorName(rs.getString("display_name"));
        int editType = rs.getInt("edit_type");
        if (editType > 0) {
            change.setEditType(editType);
            change.initChangeWikiMessageForVersion(editType, rs.getString("log_params"));
        }
        if ((logType = rs.getInt("log_type")) > 0) {
            change.setLogType(logType);
            change.initChangeWikiMessageForLog(logType, rs.getString("log_params"));
        }
        change.setVirtualWiki(rs.getString("virtual_wiki_name"));
        return change;
    }

    private Role initRole(ResultSet rs) throws SQLException {
        Role role = new Role(rs.getString("role_name"));
        role.setDescription(rs.getString("role_description"));
        return role;
    }

    private Topic initTopic(ResultSet rs, String virtualWikiName) throws SQLException {
        Topic topic = new Topic(virtualWikiName, rs.getString("topic_name"));
        topic.setAdminOnly(rs.getInt("topic_admin_only") != 0);
        int currentVersionId = rs.getInt("current_version_id");
        if (currentVersionId > 0) {
            topic.setCurrentVersionId(currentVersionId);
        }
        topic.setTopicContent(rs.getString("version_content"));
        if (topic.getTopicContent() == null) {
            topic.setTopicContent("");
        }
        topic.setTopicId(rs.getInt("topic_id"));
        topic.setReadOnly(rs.getInt("topic_read_only") != 0);
        topic.setDeleteDate(rs.getTimestamp("delete_date"));
        topic.setTopicType(TopicType.findTopicType(rs.getInt("topic_type")));
        topic.setRedirectTo(rs.getString("redirect_to"));
        if (rs.getTimestamp("delete_date") != null && rs.next()) {
            topic = this.initTopic(rs, virtualWikiName);
        }
        return topic;
    }

    private TopicVersion initTopicVersion(ResultSet rs) throws SQLException {
        int userId;
        int previousTopicVersionId;
        TopicVersion topicVersion = new TopicVersion();
        topicVersion.setTopicVersionId(rs.getInt("topic_version_id"));
        topicVersion.setTopicId(rs.getInt("topic_id"));
        topicVersion.setEditComment(rs.getString("edit_comment"));
        topicVersion.setVersionContent(rs.getString("version_content"));
        if (topicVersion.getVersionContent() == null) {
            topicVersion.setVersionContent("");
        }
        if ((previousTopicVersionId = rs.getInt("previous_topic_version_id")) > 0) {
            topicVersion.setPreviousTopicVersionId(previousTopicVersionId);
        }
        if ((userId = rs.getInt("wiki_user_id")) > 0) {
            topicVersion.setAuthorId(userId);
        }
        topicVersion.setCharactersChanged(rs.getInt("characters_changed"));
        topicVersion.setVersionParamString(rs.getString("version_params"));
        topicVersion.setEditDate(rs.getTimestamp("edit_date"));
        topicVersion.setEditType(rs.getInt("edit_type"));
        topicVersion.setAuthorDisplay(rs.getString("wiki_user_display"));
        return topicVersion;
    }

    private WikiFile initWikiFile(ResultSet rs, String virtualWikiName) throws SQLException {
        WikiFile wikiFile = new WikiFile();
        wikiFile.setFileId(rs.getInt("file_id"));
        wikiFile.setAdminOnly(rs.getInt("file_admin_only") != 0);
        wikiFile.setFileName(rs.getString("file_name"));
        wikiFile.setVirtualWiki(virtualWikiName);
        wikiFile.setUrl(rs.getString("file_url"));
        wikiFile.setTopicId(rs.getInt("topic_id"));
        wikiFile.setReadOnly(rs.getInt("file_read_only") != 0);
        wikiFile.setDeleteDate(rs.getTimestamp("delete_date"));
        wikiFile.setMimeType(rs.getString("mime_type"));
        wikiFile.setFileSize(rs.getInt("file_size"));
        return wikiFile;
    }

    private WikiFileVersion initWikiFileVersion(ResultSet rs) throws SQLException {
        WikiFileVersion wikiFileVersion = new WikiFileVersion();
        wikiFileVersion.setFileVersionId(rs.getInt("file_version_id"));
        wikiFileVersion.setFileId(rs.getInt("file_id"));
        wikiFileVersion.setUploadComment(rs.getString("upload_comment"));
        wikiFileVersion.setUrl(rs.getString("file_url"));
        int userId = rs.getInt("wiki_user_id");
        if (userId > 0) {
            wikiFileVersion.setAuthorId(userId);
        }
        wikiFileVersion.setUploadDate(rs.getTimestamp("upload_date"));
        wikiFileVersion.setMimeType(rs.getString("mime_type"));
        wikiFileVersion.setAuthorDisplay(rs.getString("wiki_user_display"));
        wikiFileVersion.setFileSize(rs.getInt("file_size"));
        return wikiFileVersion;
    }

    private WikiGroup initWikiGroup(ResultSet rs) throws SQLException {
        WikiGroup wikiGroup = new WikiGroup();
        wikiGroup.setGroupId(rs.getInt("group_id"));
        wikiGroup.setName(rs.getString("group_name"));
        wikiGroup.setDescription(rs.getString("group_description"));
        return wikiGroup;
    }

    private WikiUser initWikiUser(ResultSet rs) throws SQLException {
        String username = rs.getString("login");
        WikiUser user = new WikiUser(username);
        user.setUserId(rs.getInt("wiki_user_id"));
        user.setDisplayName(rs.getString("display_name"));
        user.setCreateDate(rs.getTimestamp("create_date"));
        user.setLastLoginDate(rs.getTimestamp("last_login_date"));
        user.setCreateIpAddress(rs.getString("create_ip_address"));
        user.setLastLoginIpAddress(rs.getString("last_login_ip_address"));
        user.setDefaultLocale(rs.getString("default_locale"));
        user.setEmail(rs.getString("email"));
        user.setEditor(rs.getString("editor"));
        user.setSignature(rs.getString("signature"));
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertCategories(List<Category> categoryList, int virtualWikiId, int topicId, Connection conn) throws SQLException {
        if (topicId == -1) {
            throw new SQLException("Invalid topicId passed to method AnsiQueryHandler.insertCategories");
        }
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_INSERT_CATEGORY);
            for (Category category : categoryList) {
                stmt.setInt(1, topicId);
                stmt.setString(2, category.getName());
                stmt.setString(3, category.getSortKey());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertGroupAuthority(int groupId, String authority, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_INSERT_GROUP_AUTHORITY);
            stmt.setInt(1, groupId);
            stmt.setString(2, authority);
            stmt.executeUpdate();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertGroupMember(String username, int groupId, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            int index = 1;
            if (!this.autoIncrementPrimaryKeys()) {
                stmt = conn.prepareStatement(STATEMENT_INSERT_GROUP_MEMBER);
                int groupMemberId = this.nextGroupMemberId(conn);
                stmt.setInt(index++, groupMemberId);
            } else {
                stmt = conn.prepareStatement(STATEMENT_INSERT_GROUP_MEMBER_AUTO_INCREMENT);
            }
            stmt.setString(index++, username);
            stmt.setInt(index++, groupId);
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeStatement(stmt);
            throw throwable;
        }
        DatabaseConnection.closeStatement(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertInterwiki(Interwiki interwiki, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_INSERT_INTERWIKI);
            stmt.setString(1, interwiki.getInterwikiPrefix());
            stmt.setString(2, interwiki.getInterwikiPattern());
            stmt.setString(3, interwiki.getInterwikiDisplay());
            stmt.setInt(4, interwiki.getInterwikiType());
            stmt.executeUpdate();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertLogItem(LogItem logItem, int virtualWikiId, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_INSERT_LOG_ITEM);
            stmt.setTimestamp(1, logItem.getLogDate());
            stmt.setInt(2, virtualWikiId);
            if (logItem.getUserId() == null) {
                stmt.setNull(3, 4);
            } else {
                stmt.setInt(3, logItem.getUserId());
            }
            stmt.setString(4, logItem.getUserDisplayName());
            stmt.setInt(5, logItem.getLogType());
            stmt.setString(6, logItem.getLogComment());
            stmt.setString(7, logItem.getLogParamString());
            if (logItem.getTopicId() == null) {
                stmt.setNull(8, 4);
            } else {
                stmt.setInt(8, logItem.getTopicId());
            }
            if (logItem.getTopicVersionId() == null) {
                stmt.setNull(9, 4);
            } else {
                stmt.setInt(9, logItem.getTopicVersionId());
            }
            stmt.executeUpdate();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertRecentChange(RecentChange change, int virtualWikiId, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_INSERT_RECENT_CHANGE);
            if (change.getTopicVersionId() == null) {
                stmt.setNull(1, 4);
            } else {
                stmt.setInt(1, change.getTopicVersionId());
            }
            if (change.getPreviousTopicVersionId() == null) {
                stmt.setNull(2, 4);
            } else {
                stmt.setInt(2, change.getPreviousTopicVersionId());
            }
            if (change.getTopicId() == null) {
                stmt.setNull(3, 4);
            } else {
                stmt.setInt(3, change.getTopicId());
            }
            stmt.setString(4, change.getTopicName());
            stmt.setTimestamp(5, change.getChangeDate());
            stmt.setString(6, change.getChangeComment());
            if (change.getAuthorId() == null) {
                stmt.setNull(7, 4);
            } else {
                stmt.setInt(7, change.getAuthorId());
            }
            stmt.setString(8, change.getAuthorName());
            if (change.getEditType() == null) {
                stmt.setNull(9, 4);
            } else {
                stmt.setInt(9, change.getEditType());
            }
            stmt.setInt(10, virtualWikiId);
            stmt.setString(11, change.getVirtualWiki());
            if (change.getCharactersChanged() == null) {
                stmt.setNull(12, 4);
            } else {
                stmt.setInt(12, change.getCharactersChanged());
            }
            if (change.getLogType() == null) {
                stmt.setNull(13, 4);
            } else {
                stmt.setInt(13, change.getLogType());
            }
            stmt.setString(14, change.getParamString());
            stmt.executeUpdate();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertRole(Role role, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_INSERT_ROLE);
            stmt.setString(1, role.getAuthority());
            stmt.setString(2, role.getDescription());
            stmt.executeUpdate();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertTopic(Topic topic, int virtualWikiId, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            int index = 1;
            if (!this.autoIncrementPrimaryKeys()) {
                stmt = conn.prepareStatement(STATEMENT_INSERT_TOPIC);
                int topicId = this.nextTopicId(conn);
                topic.setTopicId(topicId);
                stmt.setInt(index++, topic.getTopicId());
            } else {
                stmt = conn.prepareStatement(STATEMENT_INSERT_TOPIC_AUTO_INCREMENT, 1);
            }
            stmt.setInt(index++, virtualWikiId);
            stmt.setString(index++, topic.getName());
            stmt.setInt(index++, topic.getTopicType().id());
            stmt.setInt(index++, topic.getReadOnly() ? 1 : 0);
            if (topic.getCurrentVersionId() == null) {
                stmt.setNull(index++, 4);
            } else {
                stmt.setInt(index++, topic.getCurrentVersionId());
            }
            stmt.setTimestamp(index++, topic.getDeleteDate());
            stmt.setInt(index++, topic.getAdminOnly() ? 1 : 0);
            stmt.setString(index++, topic.getRedirectTo());
            stmt.setInt(index++, topic.getNamespace().getId());
            stmt.setString(index++, topic.getPageName());
            stmt.setString(index++, topic.getPageName().toLowerCase());
            stmt.executeUpdate();
            if (this.autoIncrementPrimaryKeys()) {
                rs = stmt.getGeneratedKeys();
                if (!rs.next()) {
                    throw new SQLException("Unable to determine auto-generated ID for database record");
                }
                topic.setTopicId(rs.getInt(1));
            }
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(null, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(null, stmt, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertTopicLinks(List<String> links, int topicId, Connection conn) throws SQLException {
        if (topicId == -1) {
            throw new SQLException("Invalid topicId passed to method AnsiQueryHandler.insertTopicLinks");
        }
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_INSERT_TOPIC_LINKS);
            for (String link : links) {
                stmt.setInt(1, topicId);
                stmt.setString(2, link);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertTopicVersion(TopicVersion topicVersion, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            int index = 1;
            if (!this.autoIncrementPrimaryKeys()) {
                stmt = conn.prepareStatement(STATEMENT_INSERT_TOPIC_VERSION);
                int topicVersionId = this.nextTopicVersionId(conn);
                topicVersion.setTopicVersionId(topicVersionId);
                stmt.setInt(index++, topicVersion.getTopicVersionId());
            } else {
                stmt = conn.prepareStatement(STATEMENT_INSERT_TOPIC_VERSION_AUTO_INCREMENT, 1);
            }
            if (topicVersion.getEditDate() == null) {
                Timestamp editDate = new Timestamp(System.currentTimeMillis());
                topicVersion.setEditDate(editDate);
            }
            stmt.setInt(index++, topicVersion.getTopicId());
            stmt.setString(index++, topicVersion.getEditComment());
            stmt.setString(index++, topicVersion.getVersionContent());
            if (topicVersion.getAuthorId() == null) {
                stmt.setNull(index++, 4);
            } else {
                stmt.setInt(index++, topicVersion.getAuthorId());
            }
            stmt.setInt(index++, topicVersion.getEditType());
            stmt.setString(index++, topicVersion.getAuthorDisplay());
            stmt.setTimestamp(index++, topicVersion.getEditDate());
            if (topicVersion.getPreviousTopicVersionId() == null) {
                stmt.setNull(index++, 4);
            } else {
                stmt.setInt(index++, topicVersion.getPreviousTopicVersionId());
            }
            stmt.setInt(index++, topicVersion.getCharactersChanged());
            stmt.setString(index++, topicVersion.getVersionParamString());
            stmt.executeUpdate();
            if (this.autoIncrementPrimaryKeys()) {
                rs = stmt.getGeneratedKeys();
                if (!rs.next()) {
                    throw new SQLException("Unable to determine auto-generated ID for database record");
                }
                topicVersion.setTopicVersionId(rs.getInt(1));
            }
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(null, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(null, stmt, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertUserDetails(WikiUserDetails userDetails, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_INSERT_USER);
            stmt.setString(1, userDetails.getUsername());
            stmt.setString(2, userDetails.getPassword());
            stmt.executeUpdate();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertUserAuthority(String username, String authority, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_INSERT_AUTHORITY);
            stmt.setString(1, username);
            stmt.setString(2, authority);
            stmt.executeUpdate();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertVirtualWiki(VirtualWiki virtualWiki, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            int index = 1;
            if (!this.autoIncrementPrimaryKeys()) {
                stmt = conn.prepareStatement(STATEMENT_INSERT_VIRTUAL_WIKI);
                int virtualWikiId = this.nextVirtualWikiId(conn);
                virtualWiki.setVirtualWikiId(virtualWikiId);
                stmt.setInt(index++, virtualWiki.getVirtualWikiId());
            } else {
                stmt = conn.prepareStatement(STATEMENT_INSERT_VIRTUAL_WIKI_AUTO_INCREMENT, 1);
            }
            stmt.setString(index++, virtualWiki.getName());
            stmt.setString(index++, virtualWiki.isDefaultRootTopicName() ? null : virtualWiki.getRootTopicName());
            stmt.setString(index++, virtualWiki.isDefaultLogoImageUrl() ? null : virtualWiki.getLogoImageUrl());
            stmt.setString(index++, virtualWiki.isDefaultMetaDescription() ? null : virtualWiki.getMetaDescription());
            stmt.setString(index++, virtualWiki.isDefaultSiteName() ? null : virtualWiki.getSiteName());
            stmt.executeUpdate();
            if (this.autoIncrementPrimaryKeys()) {
                rs = stmt.getGeneratedKeys();
                if (!rs.next()) {
                    throw new SQLException("Unable to determine auto-generated ID for database record");
                }
                virtualWiki.setVirtualWikiId(rs.getInt(1));
            }
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(null, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(null, stmt, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertWatchlistEntry(int virtualWikiId, String topicName, int userId, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_INSERT_WATCHLIST_ENTRY);
            stmt.setInt(1, virtualWikiId);
            stmt.setString(2, topicName);
            stmt.setInt(3, userId);
            stmt.executeUpdate();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertWikiFile(WikiFile wikiFile, int virtualWikiId, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            int index = 1;
            if (!this.autoIncrementPrimaryKeys()) {
                stmt = conn.prepareStatement(STATEMENT_INSERT_WIKI_FILE);
                int fileId = this.nextWikiFileId(conn);
                wikiFile.setFileId(fileId);
                stmt.setInt(index++, wikiFile.getFileId());
            } else {
                stmt = conn.prepareStatement(STATEMENT_INSERT_WIKI_FILE_AUTO_INCREMENT, 1);
            }
            stmt.setInt(index++, virtualWikiId);
            stmt.setString(index++, wikiFile.getFileName());
            stmt.setString(index++, wikiFile.getUrl());
            stmt.setString(index++, wikiFile.getMimeType());
            stmt.setInt(index++, wikiFile.getTopicId());
            stmt.setTimestamp(index++, wikiFile.getDeleteDate());
            stmt.setInt(index++, wikiFile.getReadOnly() ? 1 : 0);
            stmt.setInt(index++, wikiFile.getAdminOnly() ? 1 : 0);
            stmt.setLong(index++, wikiFile.getFileSize());
            stmt.executeUpdate();
            if (this.autoIncrementPrimaryKeys()) {
                rs = stmt.getGeneratedKeys();
                if (!rs.next()) {
                    throw new SQLException("Unable to determine auto-generated ID for database record");
                }
                wikiFile.setFileId(rs.getInt(1));
            }
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(null, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(null, stmt, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertWikiFileVersion(WikiFileVersion wikiFileVersion, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            int index = 1;
            if (!this.autoIncrementPrimaryKeys()) {
                stmt = conn.prepareStatement(STATEMENT_INSERT_WIKI_FILE_VERSION);
                int fileVersionId = this.nextWikiFileVersionId(conn);
                wikiFileVersion.setFileVersionId(fileVersionId);
                stmt.setInt(index++, wikiFileVersion.getFileVersionId());
            } else {
                stmt = conn.prepareStatement(STATEMENT_INSERT_WIKI_FILE_VERSION_AUTO_INCREMENT, 1);
            }
            if (wikiFileVersion.getUploadDate() == null) {
                Timestamp uploadDate = new Timestamp(System.currentTimeMillis());
                wikiFileVersion.setUploadDate(uploadDate);
            }
            stmt.setInt(index++, wikiFileVersion.getFileId());
            stmt.setString(index++, wikiFileVersion.getUploadComment());
            stmt.setString(index++, wikiFileVersion.getUrl());
            if (wikiFileVersion.getAuthorId() == null) {
                stmt.setNull(index++, 4);
            } else {
                stmt.setInt(index++, wikiFileVersion.getAuthorId());
            }
            stmt.setString(index++, wikiFileVersion.getAuthorDisplay());
            stmt.setTimestamp(index++, wikiFileVersion.getUploadDate());
            stmt.setString(index++, wikiFileVersion.getMimeType());
            stmt.setLong(index++, wikiFileVersion.getFileSize());
            stmt.executeUpdate();
            if (this.autoIncrementPrimaryKeys()) {
                rs = stmt.getGeneratedKeys();
                if (!rs.next()) {
                    throw new SQLException("Unable to determine auto-generated ID for database record");
                }
                wikiFileVersion.setFileVersionId(rs.getInt(1));
            }
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(null, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(null, stmt, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertWikiGroup(WikiGroup group, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            int index = 1;
            if (!this.autoIncrementPrimaryKeys()) {
                stmt = conn.prepareStatement(STATEMENT_INSERT_GROUP);
                int groupId = this.nextWikiGroupId(conn);
                group.setGroupId(groupId);
                stmt.setInt(index++, group.getGroupId());
            } else {
                stmt = conn.prepareStatement(STATEMENT_INSERT_GROUP_AUTO_INCREMENT, 1);
            }
            stmt.setString(index++, group.getName());
            stmt.setString(index++, group.getDescription());
            stmt.executeUpdate();
            if (this.autoIncrementPrimaryKeys()) {
                rs = stmt.getGeneratedKeys();
                if (!rs.next()) {
                    throw new SQLException("Unable to determine auto-generated ID for database record");
                }
                group.setGroupId(rs.getInt(1));
            }
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(null, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(null, stmt, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertWikiUser(WikiUser user, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            int index = 1;
            if (!this.autoIncrementPrimaryKeys()) {
                stmt = conn.prepareStatement(STATEMENT_INSERT_WIKI_USER);
                int nextUserId = this.nextWikiUserId(conn);
                user.setUserId(nextUserId);
                stmt.setInt(index++, user.getUserId());
            } else {
                stmt = conn.prepareStatement(STATEMENT_INSERT_WIKI_USER_AUTO_INCREMENT, 1);
            }
            stmt.setString(index++, user.getUsername());
            stmt.setString(index++, user.getDisplayName());
            stmt.setTimestamp(index++, user.getCreateDate());
            stmt.setTimestamp(index++, user.getLastLoginDate());
            stmt.setString(index++, user.getCreateIpAddress());
            stmt.setString(index++, user.getLastLoginIpAddress());
            stmt.setString(index++, user.getDefaultLocale());
            stmt.setString(index++, user.getEmail());
            stmt.setString(index++, user.getEditor());
            stmt.setString(index++, user.getSignature());
            stmt.executeUpdate();
            if (this.autoIncrementPrimaryKeys()) {
                rs = stmt.getGeneratedKeys();
                if (!rs.next()) {
                    throw new SQLException("Unable to determine auto-generated ID for database record");
                }
                user.setUserId(rs.getInt(1));
            }
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(null, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(null, stmt, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Category> lookupCategoryTopics(int virtualWikiId, String virtualWikiName, String categoryName) throws SQLException {
        ArrayList<Category> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = conn.prepareStatement(STATEMENT_SELECT_CATEGORY_TOPICS);
            categoryName = categoryName.toLowerCase();
            stmt.setInt(1, virtualWikiId);
            stmt.setString(2, categoryName);
            rs = stmt.executeQuery();
            ArrayList<Category> results = new ArrayList<Category>();
            while (rs.next()) {
                results.add(this.initCategory(rs, virtualWikiName));
            }
            arrayList = results;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> lookupConfiguration() throws SQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        HashMap<String, String> configuration = new HashMap<String, String>();
        try {
            conn = DatabaseConnection.getConnection();
            stmt = conn.prepareStatement(STATEMENT_SELECT_CONFIGURATION);
            rs = stmt.executeQuery();
            while (rs.next()) {
                configuration.put(rs.getString("config_key"), rs.getString("config_value").trim());
            }
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Interwiki> lookupInterwikis(Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        TreeMap<String, Interwiki> interwikis = new TreeMap<String, Interwiki>();
        try {
            stmt = conn.prepareStatement(STATEMENT_SELECT_INTERWIKIS);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String interwikiPrefix = rs.getString("interwiki_prefix");
                String interwikiPattern = rs.getString("interwiki_pattern");
                String interwikiDisplay = rs.getString("interwiki_display");
                int interwikiType = rs.getInt("interwiki_type");
                Interwiki interwiki = new Interwiki(interwikiPrefix, interwikiPattern, interwikiDisplay);
                interwiki.setInterwikiType(interwikiType);
                interwikis.put(interwikiPrefix, interwiki);
            }
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(null, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(null, stmt, rs);
        return new ArrayList<Interwiki>(interwikis.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Namespace> lookupNamespaces(Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        TreeMap<Integer, Namespace> namespaces = new TreeMap<Integer, Namespace>();
        try {
            stmt = conn.prepareStatement(STATEMENT_SELECT_NAMESPACES);
            rs = stmt.executeQuery();
            HashMap<Integer, Namespace> talkNamespaces = new HashMap<Integer, Namespace>();
            while (rs.next()) {
                int namespaceId = rs.getInt("namespace_id");
                Namespace namespace = (Namespace)namespaces.get(namespaceId);
                if (namespace == null) {
                    String namespaceLabel = rs.getString("namespace");
                    namespace = new Namespace(namespaceId, namespaceLabel);
                }
                String virtualWiki = rs.getString("virtual_wiki_name");
                String namespaceTranslation = rs.getString("namespace_translation");
                if (virtualWiki != null) {
                    namespace.getNamespaceTranslations().put(virtualWiki, namespaceTranslation);
                }
                namespaces.put(namespaceId, namespace);
                int mainNamespaceId = rs.getInt("main_namespace_id");
                if (rs.wasNull()) continue;
                talkNamespaces.put(mainNamespaceId, namespace);
            }
            Iterator i$ = talkNamespaces.keySet().iterator();
            while (i$.hasNext()) {
                int mainNamespaceId = (Integer)i$.next();
                Namespace mainNamespace = (Namespace)namespaces.get(mainNamespaceId);
                if (mainNamespace == null) {
                    logger.warn("Invalid namespace reference - bad database data.  Namespace references invalid main namespace with ID " + mainNamespaceId);
                }
                Namespace talkNamespace = (Namespace)talkNamespaces.get(mainNamespaceId);
                talkNamespace.setMainNamespace(mainNamespace);
                namespaces.put(talkNamespace.getId(), talkNamespace);
            }
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(null, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(null, stmt, rs);
        return new ArrayList<Namespace>(namespaces.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Topic lookupTopic(int virtualWikiId, String virtualWikiName, Namespace namespace, String pageName, Connection conn) throws SQLException {
        Topic topic;
        block8: {
            ResultSet rs;
            PreparedStatement stmt;
            block7: {
                if (namespace.getId().equals(-1)) {
                    return null;
                }
                boolean closeConnection = conn == null;
                stmt = null;
                rs = null;
                try {
                    Topic topic2;
                    if (conn == null) {
                        conn = DatabaseConnection.getConnection();
                    }
                    stmt = conn.prepareStatement(STATEMENT_SELECT_TOPIC);
                    stmt.setString(1, pageName);
                    stmt.setInt(2, virtualWikiId);
                    stmt.setInt(3, namespace.getId());
                    rs = stmt.executeQuery();
                    Topic topic3 = topic2 = rs.next() ? this.initTopic(rs, virtualWikiName) : null;
                    if (topic2 == null && !namespace.isCaseSensitive() && !pageName.toLowerCase().equals(pageName)) {
                        stmt = conn.prepareStatement(STATEMENT_SELECT_TOPIC_LOWER);
                        stmt.setString(1, pageName.toLowerCase());
                        stmt.setInt(2, virtualWikiId);
                        stmt.setInt(3, namespace.getId());
                        rs = stmt.executeQuery();
                        topic2 = rs.next() ? this.initTopic(rs, virtualWikiName) : null;
                    }
                    topic = topic2;
                    if (!closeConnection) break block7;
                }
                catch (Throwable throwable) {
                    if (closeConnection) {
                        DatabaseConnection.closeConnection(conn, stmt, rs);
                    } else {
                        DatabaseConnection.closeConnection(null, stmt, rs);
                    }
                    throw throwable;
                }
                DatabaseConnection.closeConnection(conn, stmt, rs);
                break block8;
            }
            DatabaseConnection.closeConnection(null, stmt, rs);
        }
        return topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Topic lookupTopicById(int virtualWikiId, String virtualWikiName, int topicId) throws SQLException {
        Topic topic;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = conn.prepareStatement(STATEMENT_SELECT_TOPIC_BY_ID);
            stmt.setInt(1, virtualWikiId);
            stmt.setInt(2, topicId);
            rs = stmt.executeQuery();
            topic = rs.next() ? this.initTopic(rs, virtualWikiName) : null;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, String> lookupTopicByType(int virtualWikiId, TopicType topicType1, TopicType topicType2, int namespaceStart, int namespaceEnd, Pagination pagination) throws SQLException {
        LinkedHashMap<Integer, String> linkedHashMap;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = this.lookupTopicByTypeStatement(conn, virtualWikiId, topicType1, topicType2, namespaceStart, namespaceEnd, pagination);
            rs = stmt.executeQuery();
            LinkedHashMap<Integer, String> results = new LinkedHashMap<Integer, String>();
            while (rs.next()) {
                results.put(rs.getInt("topic_id"), rs.getString("topic_name"));
            }
            linkedHashMap = results;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return linkedHashMap;
    }

    protected PreparedStatement lookupTopicByTypeStatement(Connection conn, int virtualWikiId, TopicType topicType1, TopicType topicType2, int namespaceStart, int namespaceEnd, Pagination pagination) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_TOPIC_BY_TYPE);
        stmt.setInt(1, virtualWikiId);
        stmt.setInt(2, topicType1.id());
        stmt.setInt(3, topicType2.id());
        stmt.setInt(4, namespaceStart);
        stmt.setInt(5, namespaceEnd);
        stmt.setInt(6, pagination.getNumResults());
        stmt.setInt(7, pagination.getOffset());
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lookupTopicCount(int virtualWikiId, int namespaceStart, int namespaceEnd) throws SQLException {
        int n;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = conn.prepareStatement(STATEMENT_SELECT_TOPIC_COUNT);
            stmt.setInt(1, virtualWikiId);
            stmt.setInt(2, namespaceStart);
            stmt.setInt(3, namespaceEnd);
            stmt.setInt(4, TopicType.REDIRECT.id());
            rs = stmt.executeQuery();
            n = rs.next() ? rs.getInt("topic_count") : 0;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lookupTopicName(int virtualWikiId, String virtualWikiName, Namespace namespace, String pageName) throws SQLException {
        String string;
        if (namespace.getId().equals(-1)) {
            return null;
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String topicName;
            conn = DatabaseConnection.getConnection();
            stmt = conn.prepareStatement(STATEMENT_SELECT_TOPIC_NAME);
            stmt.setString(1, pageName);
            stmt.setInt(2, virtualWikiId);
            stmt.setInt(3, namespace.getId());
            rs = stmt.executeQuery();
            String string2 = topicName = rs.next() ? rs.getString("topic_name") : null;
            if (topicName == null && !namespace.isCaseSensitive() && !pageName.toLowerCase().equals(pageName)) {
                stmt = conn.prepareStatement(STATEMENT_SELECT_TOPIC_NAME_LOWER);
                stmt.setString(1, pageName.toLowerCase());
                stmt.setInt(2, virtualWikiId);
                stmt.setInt(3, namespace.getId());
                rs = stmt.executeQuery();
                topicName = rs.next() ? rs.getString("topic_name") : null;
            }
            string = topicName;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> lookupTopicLinks(int virtualWikiId, String topicName) throws SQLException {
        ArrayList<String> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = conn.prepareStatement(STATEMENT_SELECT_TOPIC_LINKS);
            stmt.setInt(1, virtualWikiId);
            stmt.setString(2, topicName);
            rs = stmt.executeQuery();
            ArrayList<String> results = new ArrayList<String>();
            while (rs.next()) {
                results.add(rs.getString("topic_name"));
            }
            arrayList = results;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> lookupTopicLinkOrphans(int virtualWikiId, int namespaceId) throws SQLException {
        ArrayList<String> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = conn.prepareStatement(STATEMENT_SELECT_TOPIC_LINK_ORPHANS);
            stmt.setInt(1, virtualWikiId);
            stmt.setInt(2, namespaceId);
            stmt.setInt(3, TopicType.REDIRECT.id());
            rs = stmt.executeQuery();
            ArrayList<String> results = new ArrayList<String>();
            while (rs.next()) {
                results.add(rs.getString("topic_name"));
            }
            arrayList = results;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, String> lookupTopicNames(int virtualWikiId, boolean includeDeleted, Connection conn) throws SQLException {
        LinkedHashMap<Integer, String> linkedHashMap;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_SELECT_TOPIC_NAMES);
            stmt.setInt(1, virtualWikiId);
            rs = stmt.executeQuery();
            LinkedHashMap<Integer, String> results = new LinkedHashMap<Integer, String>();
            while (rs.next()) {
                if (!includeDeleted && rs.getTimestamp("delete_date") != null) continue;
                results.put(rs.getInt("topic_id"), rs.getString("topic_name"));
            }
            linkedHashMap = results;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(null, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(null, stmt, rs);
        return linkedHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TopicVersion lookupTopicVersion(int topicVersionId) throws SQLException {
        Connection conn = null;
        try {
            conn = DatabaseConnection.getConnection();
            TopicVersion topicVersion = this.lookupTopicVersion(topicVersionId, conn);
            return topicVersion;
        }
        finally {
            DatabaseConnection.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TopicVersion lookupTopicVersion(int topicVersionId, Connection conn) throws SQLException {
        TopicVersion topicVersion;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_SELECT_TOPIC_VERSION);
            stmt.setInt(1, topicVersionId);
            rs = stmt.executeQuery();
            topicVersion = rs.next() ? this.initTopicVersion(rs) : null;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(null, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(null, stmt, rs);
        return topicVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer lookupTopicVersionNextId(int topicVersionId) throws SQLException {
        Integer n;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = conn.prepareStatement(STATEMENT_SELECT_TOPIC_VERSION_NEXT_ID);
            stmt.setInt(1, topicVersionId);
            rs = stmt.executeQuery();
            n = rs.next() ? Integer.valueOf(rs.getInt("topic_version_id")) : null;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WikiFile lookupWikiFile(int virtualWikiId, String virtualWikiName, int topicId) throws SQLException {
        WikiFile wikiFile;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = conn.prepareStatement(STATEMENT_SELECT_WIKI_FILE);
            stmt.setInt(1, virtualWikiId);
            stmt.setInt(2, topicId);
            rs = stmt.executeQuery();
            wikiFile = rs.next() ? this.initWikiFile(rs, virtualWikiName) : null;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return wikiFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lookupWikiFileCount(int virtualWikiId) throws SQLException {
        int n;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = conn.prepareStatement(STATEMENT_SELECT_WIKI_FILE_COUNT);
            stmt.setInt(1, virtualWikiId);
            rs = stmt.executeQuery();
            n = rs.next() ? rs.getInt("file_count") : 0;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WikiGroup lookupWikiGroup(String groupName) throws SQLException {
        WikiGroup wikiGroup;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = conn.prepareStatement(STATEMENT_SELECT_GROUP);
            stmt.setString(1, groupName);
            rs = stmt.executeQuery();
            wikiGroup = rs.next() ? this.initWikiGroup(rs) : null;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return wikiGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WikiUser lookupWikiUser(int userId) throws SQLException {
        WikiUser wikiUser;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = conn.prepareStatement(STATEMENT_SELECT_WIKI_USER);
            stmt.setInt(1, userId);
            rs = stmt.executeQuery();
            wikiUser = rs.next() ? this.initWikiUser(rs) : null;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return wikiUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lookupWikiUser(String username, Connection conn) throws SQLException {
        int n;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_SELECT_WIKI_USER_LOGIN);
            stmt.setString(1, username);
            rs = stmt.executeQuery();
            n = rs.next() ? rs.getInt("wiki_user_id") : -1;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(null, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(null, stmt, rs);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lookupWikiUserCount() throws SQLException {
        int n;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = conn.prepareStatement(STATEMENT_SELECT_WIKI_USER_COUNT);
            rs = stmt.executeQuery();
            n = rs.next() ? rs.getInt("user_count") : 0;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lookupWikiUserEncryptedPassword(String username) throws SQLException {
        String string;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = conn.prepareStatement(STATEMENT_SELECT_WIKI_USER_DETAILS_PASSWORD);
            stmt.setString(1, username);
            rs = stmt.executeQuery();
            string = rs.next() ? rs.getString("password") : null;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> lookupWikiUsers(Pagination pagination) throws SQLException {
        ArrayList<String> arrayList;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = this.lookupWikiUsersStatement(conn, pagination);
            rs = stmt.executeQuery();
            ArrayList<String> results = new ArrayList<String>();
            while (rs.next()) {
                results.add(rs.getString("login"));
            }
            arrayList = results;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return arrayList;
    }

    protected PreparedStatement lookupWikiUsersStatement(Connection conn, Pagination pagination) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(STATEMENT_SELECT_WIKI_USERS);
        stmt.setInt(1, pagination.getNumResults());
        stmt.setInt(2, pagination.getOffset());
        return stmt;
    }

    private int nextGroupMemberId(Connection conn) throws SQLException {
        int nextId = DatabaseConnection.executeSequenceQuery(STATEMENT_SELECT_GROUP_MEMBERS_SEQUENCE, "id", conn);
        return nextId + 1;
    }

    private int nextTopicId(Connection conn) throws SQLException {
        int nextId = DatabaseConnection.executeSequenceQuery(STATEMENT_SELECT_TOPIC_SEQUENCE, "topic_id", conn);
        return nextId + 1;
    }

    public int nextTopicVersionId(Connection conn) throws SQLException {
        int nextId = DatabaseConnection.executeSequenceQuery(STATEMENT_SELECT_TOPIC_VERSION_SEQUENCE, "topic_version_id", conn);
        return nextId + 1;
    }

    private int nextVirtualWikiId(Connection conn) throws SQLException {
        int nextId = DatabaseConnection.executeSequenceQuery(STATEMENT_SELECT_VIRTUAL_WIKI_SEQUENCE, "virtual_wiki_id", conn);
        return nextId + 1;
    }

    private int nextWikiFileId(Connection conn) throws SQLException {
        int nextId = DatabaseConnection.executeSequenceQuery(STATEMENT_SELECT_WIKI_FILE_SEQUENCE, "file_id", conn);
        return nextId + 1;
    }

    private int nextWikiFileVersionId(Connection conn) throws SQLException {
        int nextId = DatabaseConnection.executeSequenceQuery(STATEMENT_SELECT_WIKI_FILE_VERSION_SEQUENCE, "file_version_id", conn);
        return nextId + 1;
    }

    private int nextWikiGroupId(Connection conn) throws SQLException {
        int nextId = DatabaseConnection.executeSequenceQuery(STATEMENT_SELECT_GROUP_SEQUENCE, "group_id", conn);
        return nextId + 1;
    }

    private int nextWikiUserId(Connection conn) throws SQLException {
        int nextId = DatabaseConnection.executeSequenceQuery(STATEMENT_SELECT_WIKI_USER_SEQUENCE, "wiki_user_id", conn);
        return nextId + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadLogItems(int virtualWikiId, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_DELETE_LOG_ITEMS);
            stmt.setInt(1, virtualWikiId);
            stmt.executeUpdate();
            stmt = conn.prepareStatement(STATEMENT_INSERT_LOG_ITEMS_BY_TOPIC_VERSION_TYPE);
            stmt.setInt(1, 1);
            stmt.setString(2, "");
            stmt.setInt(3, virtualWikiId);
            stmt.setInt(4, 5);
            stmt.executeUpdate();
            stmt = conn.prepareStatement(STATEMENT_INSERT_LOG_ITEMS_BY_TOPIC_VERSION_TYPE);
            stmt.setInt(1, 1);
            stmt.setString(2, "|7");
            stmt.setInt(3, virtualWikiId);
            stmt.setInt(4, 7);
            stmt.executeUpdate();
            stmt = conn.prepareStatement(STATEMENT_INSERT_LOG_ITEMS_BY_TOPIC_VERSION_TYPE);
            stmt.setInt(1, 4);
            stmt.setString(2, "");
            stmt.setInt(3, virtualWikiId);
            stmt.setInt(4, 6);
            stmt.executeUpdate();
            stmt = conn.prepareStatement(STATEMENT_INSERT_LOG_ITEMS_IMPORT);
            stmt.setInt(1, 2);
            stmt.setInt(2, 8);
            stmt.setInt(3, virtualWikiId);
            stmt.setInt(4, 8);
            stmt.executeUpdate();
            stmt = conn.prepareStatement(STATEMENT_INSERT_LOG_ITEMS_MOVE);
            stmt.setInt(1, 3);
            stmt.setInt(2, virtualWikiId);
            stmt.setInt(3, 4);
            stmt.executeUpdate();
            stmt = conn.prepareStatement(STATEMENT_INSERT_LOG_ITEMS_UPLOAD);
            stmt.setInt(1, 6);
            stmt.setInt(2, virtualWikiId);
            stmt.setInt(3, 1);
            stmt.executeUpdate();
            stmt = conn.prepareStatement(STATEMENT_INSERT_LOG_ITEMS_USER);
            stmt.setInt(1, virtualWikiId);
            stmt.setInt(2, 7);
            stmt.executeUpdate();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    @Override
    public void orderTopicVersions(Topic topic, int virtualWikiId, List<Integer> topicVersionIdList) throws SQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = DatabaseConnection.getConnection();
            conn.setAutoCommit(false);
            stmt = conn.prepareStatement(STATEMENT_UPDATE_TOPIC_VERSION_PREVIOUS_VERSION_ID);
            Integer previousTopicVersionId = null;
            for (int topicVersionId : topicVersionIdList) {
                if (previousTopicVersionId != null) {
                    stmt.setInt(1, previousTopicVersionId);
                    stmt.setInt(2, topicVersionId);
                    stmt.addBatch();
                }
                previousTopicVersionId = topicVersionId;
            }
            stmt.executeBatch();
            TopicVersion topicVersion = this.lookupTopicVersion(previousTopicVersionId, conn);
            topic.setCurrentVersionId(previousTopicVersionId);
            topic.setTopicContent(topicVersion.getVersionContent());
            this.updateTopic(topic, virtualWikiId, conn);
            conn.commit();
        }
        catch (SQLException e) {
            try {
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                throw e;
            }
            catch (Throwable throwable) {
                DatabaseConnection.closeConnection(conn, stmt);
                throw throwable;
            }
        }
        DatabaseConnection.closeConnection(conn, stmt);
    }

    @Override
    public void reloadRecentChanges(Connection conn) throws SQLException {
        DatabaseConnection.executeUpdate(STATEMENT_DELETE_RECENT_CHANGES, conn);
        DatabaseConnection.executeUpdate(STATEMENT_INSERT_RECENT_CHANGES_VERSIONS, conn);
        DatabaseConnection.executeUpdate(STATEMENT_INSERT_RECENT_CHANGES_LOGS, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConfiguration(Map<String, String> configuration, Connection conn) throws SQLException {
        Statement stmt = null;
        PreparedStatement pstmt = null;
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(STATEMENT_DELETE_CONFIGURATION);
            pstmt = conn.prepareStatement(STATEMENT_INSERT_CONFIGURATION);
            for (String key : configuration.keySet()) {
                pstmt.setString(1, key);
                String value = configuration.get(key);
                if (StringUtils.isBlank((String)value)) {
                    value = " ";
                }
                pstmt.setString(2, value);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeStatement(pstmt);
            DatabaseConnection.closeStatement(stmt);
            throw throwable;
        }
        DatabaseConnection.closeStatement(pstmt);
        DatabaseConnection.closeStatement(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNamespace(Namespace mainNamespace, Namespace commentsNamespace, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            boolean isUpdate;
            boolean bl = isUpdate = mainNamespace.getId() != null && this.lookupNamespaces(conn).indexOf(mainNamespace) != -1;
            if (!isUpdate && mainNamespace.getId() == null) {
                int nextId = DatabaseConnection.executeSequenceQuery(STATEMENT_SELECT_NAMESPACE_SEQUENCE, "namespace_id", conn);
                if (nextId < 200) {
                    nextId = 199;
                }
                mainNamespace.setId(nextId + 1);
                if (commentsNamespace != null) {
                    commentsNamespace.setId(nextId + 2);
                }
            }
            stmt = isUpdate ? conn.prepareStatement(STATEMENT_UPDATE_NAMESPACE) : conn.prepareStatement(STATEMENT_INSERT_NAMESPACE);
            stmt.setString(1, mainNamespace.getDefaultLabel());
            stmt.setNull(2, 4);
            stmt.setInt(3, mainNamespace.getId());
            stmt.addBatch();
            if (commentsNamespace != null) {
                stmt.setString(1, commentsNamespace.getDefaultLabel());
                stmt.setInt(2, commentsNamespace.getMainNamespace().getId());
                stmt.setInt(3, commentsNamespace.getId());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeStatement(stmt);
            throw throwable;
        }
        DatabaseConnection.closeStatement(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNamespaceTranslations(List<Namespace> namespaces, String virtualWiki, int virtualWikiId, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_DELETE_NAMESPACE_TRANSLATIONS);
            stmt.setInt(1, virtualWikiId);
            stmt.executeUpdate();
            stmt = conn.prepareStatement(STATEMENT_INSERT_NAMESPACE_TRANSLATION);
            for (Namespace namespace : namespaces) {
                String translatedNamespace = namespace.getLabel(virtualWiki);
                if (translatedNamespace.equals(namespace.getDefaultLabel())) continue;
                stmt.setInt(1, namespace.getId());
                stmt.setInt(2, virtualWikiId);
                stmt.setString(3, translatedNamespace);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRole(Role role, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_UPDATE_ROLE);
            stmt.setString(1, role.getDescription());
            stmt.setString(2, role.getAuthority());
            stmt.executeUpdate();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTopic(Topic topic, int virtualWikiId, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_UPDATE_TOPIC);
            stmt.setInt(1, virtualWikiId);
            stmt.setString(2, topic.getName());
            stmt.setInt(3, topic.getTopicType().id());
            stmt.setInt(4, topic.getReadOnly() ? 1 : 0);
            if (topic.getCurrentVersionId() == null) {
                stmt.setNull(5, 4);
            } else {
                stmt.setInt(5, topic.getCurrentVersionId());
            }
            stmt.setTimestamp(6, topic.getDeleteDate());
            stmt.setInt(7, topic.getAdminOnly() ? 1 : 0);
            stmt.setString(8, topic.getRedirectTo());
            stmt.setInt(9, topic.getNamespace().getId());
            stmt.setString(10, topic.getPageName());
            stmt.setString(11, topic.getPageName().toLowerCase());
            stmt.setInt(12, topic.getTopicId());
            stmt.executeUpdate();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTopicNamespaces(List<Topic> topics, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_UPDATE_TOPIC_NAMESPACE);
            for (Topic topic : topics) {
                stmt.setInt(1, topic.getNamespace().getId());
                stmt.setString(2, topic.getPageName());
                stmt.setString(3, topic.getPageName().toLowerCase());
                stmt.setInt(4, topic.getTopicId());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUserDetails(WikiUserDetails userDetails, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_UPDATE_USER);
            stmt.setString(1, userDetails.getPassword());
            stmt.setInt(2, 1);
            stmt.setString(3, userDetails.getUsername());
            stmt.executeUpdate();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateVirtualWiki(VirtualWiki virtualWiki, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_UPDATE_VIRTUAL_WIKI);
            stmt.setString(1, virtualWiki.isDefaultRootTopicName() ? null : virtualWiki.getRootTopicName());
            stmt.setString(2, virtualWiki.isDefaultLogoImageUrl() ? null : virtualWiki.getLogoImageUrl());
            stmt.setString(3, virtualWiki.isDefaultMetaDescription() ? null : virtualWiki.getMetaDescription());
            stmt.setString(4, virtualWiki.isDefaultSiteName() ? null : virtualWiki.getSiteName());
            stmt.setInt(5, virtualWiki.getVirtualWikiId());
            stmt.executeUpdate();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateWikiFile(WikiFile wikiFile, int virtualWikiId, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_UPDATE_WIKI_FILE);
            stmt.setInt(1, virtualWikiId);
            stmt.setString(2, wikiFile.getFileName());
            stmt.setString(3, wikiFile.getUrl());
            stmt.setString(4, wikiFile.getMimeType());
            stmt.setInt(5, wikiFile.getTopicId());
            stmt.setTimestamp(6, wikiFile.getDeleteDate());
            stmt.setInt(7, wikiFile.getReadOnly() ? 1 : 0);
            stmt.setInt(8, wikiFile.getAdminOnly() ? 1 : 0);
            stmt.setLong(9, wikiFile.getFileSize());
            stmt.setInt(10, wikiFile.getFileId());
            stmt.executeUpdate();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateWikiGroup(WikiGroup group, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_UPDATE_GROUP);
            stmt.setString(1, group.getName());
            stmt.setString(2, group.getDescription());
            stmt.setInt(3, group.getGroupId());
            stmt.executeUpdate();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateWikiUser(WikiUser user, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(STATEMENT_UPDATE_WIKI_USER);
            stmt.setString(1, user.getUsername());
            stmt.setString(2, user.getDisplayName());
            stmt.setTimestamp(3, user.getLastLoginDate());
            stmt.setString(4, user.getLastLoginIpAddress());
            stmt.setString(5, user.getDefaultLocale());
            stmt.setString(6, user.getEmail());
            stmt.setString(7, user.getEditor());
            stmt.setString(8, user.getSignature());
            stmt.setInt(9, user.getUserId());
            stmt.executeUpdate();
        }
        finally {
            DatabaseConnection.closeStatement(stmt);
        }
    }
}

