/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jamwiki.utils.WikiLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleMap {
    private static final WikiLogger logger = WikiLogger.getLogger(RoleMap.class.getName());
    private Integer groupId = null;
    private String groupName = null;
    private List<String> roleNames = null;
    private Integer userId = null;
    private String userLogin = null;

    public Integer getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Integer groupId) {
        this.groupId = groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void addRole(String roleName) {
        if (this.roleNames == null) {
            this.roleNames = new ArrayList<String>();
        }
        this.roleNames.add(roleName);
    }

    public List<String> getRoleNames() {
        return this.roleNames;
    }

    public void setRoleNames(List<String> roleNames) {
        this.roleNames = roleNames;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public String getUserLogin() {
        return this.userLogin;
    }

    public void setUserLogin(String userLogin) {
        this.userLogin = userLogin;
    }

    public HashMap<String, String> getRoleNamesMap() {
        HashMap<String, String> results = new HashMap<String, String>();
        if (this.roleNames == null) {
            return results;
        }
        for (String key : this.roleNames) {
            String value = this.getUserGroup() + "|" + key;
            results.put(key, value);
        }
        return results;
    }

    public String getUserGroup() {
        StringBuilder result = new StringBuilder();
        if (this.userId != null) {
            result.append(this.userId);
        } else {
            result.append(0);
        }
        result.append('|');
        if (this.groupId != null) {
            result.append(this.groupId);
        } else {
            result.append(0);
        }
        return result.toString();
    }
}

