/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.parser.jflex;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.DataAccessException;
import org.jamwiki.Environment;
import org.jamwiki.WikiBase;
import org.jamwiki.model.Namespace;
import org.jamwiki.model.Topic;
import org.jamwiki.model.TopicType;
import org.jamwiki.parser.ExcessiveNestingException;
import org.jamwiki.parser.ParserException;
import org.jamwiki.parser.ParserInput;
import org.jamwiki.parser.ParserOutput;
import org.jamwiki.parser.jflex.JFlexLexer;
import org.jamwiki.parser.jflex.JFlexParserTag;
import org.jamwiki.parser.jflex.JFlexParserUtil;
import org.jamwiki.parser.jflex.MagicWordUtil;
import org.jamwiki.parser.jflex.ParserFunctionUtil;
import org.jamwiki.utils.LinkUtil;
import org.jamwiki.utils.Utilities;
import org.jamwiki.utils.WikiLink;
import org.jamwiki.utils.WikiLogger;
import org.jamwiki.utils.WikiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateTag
implements JFlexParserTag {
    private static final WikiLogger logger = WikiLogger.getLogger(TemplateTag.class.getName());
    protected static final String TEMPLATE_INCLUSION = "template-inclusion";
    protected static final String TEMPLATE_ONLYINCLUDE = "template-onlyinclude";
    private static final Pattern PARAM_NAME_VALUE_PATTERN = Pattern.compile("[\\s]*([A-Za-z0-9_\\ \\-]+)[\\s]*\\=([\\s\\S]*)");

    private String applyParameter(ParserInput parserInput, ParserOutput parserOutput, String param, Map<String, String> parameterValues) throws ParserException {
        String content = param.substring("{{{".length(), param.length() - "}}}".length());
        content = this.parseTemplateBody(parserInput, parserOutput, content, parameterValues);
        String name = this.parseParamName(content);
        String defaultValue = this.parseParamDefaultValue(parserInput, parserOutput, content);
        String value = parameterValues.get(name);
        if (value == null && defaultValue == null) {
            return param;
        }
        return value == null ? defaultValue : value;
    }

    private boolean isSubstitution(String templateContent) {
        return (templateContent = templateContent.trim()).startsWith("subst:") && templateContent.length() > "subst:".length();
    }

    @Override
    public String parse(JFlexLexer lexer, String raw, Object ... args) throws ParserException {
        if (StringUtils.isBlank((String)raw)) {
            throw new ParserException("Empty template text");
        }
        if (!raw.startsWith("{{") || !raw.endsWith("}}")) {
            throw new ParserException("Invalid template text: " + raw);
        }
        String templateContent = raw.substring("{{".length(), raw.length() - "}}".length());
        if (!this.isSubstitution(templateContent) && lexer.getMode() < 5 || lexer.getMode() < 3) {
            return raw;
        }
        try {
            return this.parseTemplateOutput(lexer.getParserInput(), lexer.getParserOutput(), lexer.getMode(), raw, true);
        }
        catch (ExcessiveNestingException e) {
            logger.warn("Excessive template nesting in topic " + lexer.getParserInput().getTopicName());
            WikiLink wikiLink = this.parseTemplateName(lexer.getParserInput().getVirtualWiki(), templateContent);
            String templateName = wikiLink.getDestination();
            if (!wikiLink.getColon() && !wikiLink.getNamespace().equals(Namespace.namespace(10))) {
                templateName = Namespace.namespace(10).getLabel(lexer.getParserInput().getVirtualWiki()) + ":" + StringUtils.capitalize((String)templateName);
            }
            return "[[" + templateName + "]]";
        }
        catch (DataAccessException e) {
            throw new ParserException("Data access exception while parsing: " + raw, e);
        }
    }

    private String parseTemplateOutput(ParserInput parserInput, ParserOutput parserOutput, int mode, String raw, boolean allowTemplateEdit) throws DataAccessException, ParserException {
        String templateContent = raw.substring("{{".length(), raw.length() - "}}".length());
        parserInput.incrementTemplateDepth();
        if (parserInput.getTemplateDepth() > Environment.getIntValue("parser-max-template-depth")) {
            parserInput.decrementTemplateDepth();
            throw new ExcessiveNestingException("Potentially infinite parsing loop - over " + parserInput.getTemplateDepth() + " template inclusions while parsing topic " + parserInput.getTopicName());
        }
        String[] parserFunctionInfo = ParserFunctionUtil.parseParserFunctionInfo(parserInput, mode, templateContent);
        String result = null;
        if (MagicWordUtil.isMagicWord(templateContent) || parserFunctionInfo != null) {
            result = mode <= 3 ? raw : (MagicWordUtil.isMagicWord(templateContent) ? MagicWordUtil.processMagicWord(parserInput, templateContent) : ParserFunctionUtil.processParserFunction(parserInput, parserOutput, mode, parserFunctionInfo[0], parserFunctionInfo[1]));
            parserInput.decrementTemplateDepth();
            return result;
        }
        raw = "{{" + templateContent + "}}";
        String subst = this.parseSubstitution(parserInput, parserOutput, raw, templateContent);
        if (subst != null) {
            parserInput.decrementTemplateDepth();
            return subst;
        }
        WikiLink wikiLink = this.parseTemplateName(parserInput.getVirtualWiki(), templateContent);
        String name = wikiLink.getDestination();
        name = JFlexParserUtil.parseFragment(parserInput, parserOutput, name, 5);
        Topic templateTopic = null;
        boolean inclusion = wikiLink.getColon();
        String templateName = name;
        if (!wikiLink.getColon()) {
            if (!wikiLink.getNamespace().equals(Namespace.namespace(10))) {
                templateName = Namespace.namespace(10).getLabel(parserInput.getVirtualWiki()) + ":" + StringUtils.capitalize((String)name);
            }
            templateTopic = WikiBase.getDataHandler().lookupTopic(parserInput.getVirtualWiki(), templateName, false, null);
        }
        if (templateTopic != null) {
            name = templateName;
        } else {
            templateTopic = WikiBase.getDataHandler().lookupTopic(parserInput.getVirtualWiki(), name, false, null);
            name = templateTopic == null && !wikiLink.getColon() ? templateName : name;
            inclusion = templateTopic != null || wikiLink.getColon();
        }
        this.processTemplateMetadata(parserOutput, templateTopic, name);
        if (mode <= 3) {
            result = raw;
        } else {
            if (templateTopic != null && templateTopic.getTopicType() == TopicType.REDIRECT) {
                templateTopic = WikiUtil.findRedirectedTopic(templateTopic, 0);
                name = templateTopic.getName();
            }
            if (templateTopic != null && templateTopic.getTopicType() == TopicType.REDIRECT) {
                templateTopic = null;
            }
            result = inclusion ? this.processTemplateInclusion(parserInput, parserOutput, templateTopic, templateContent, name) : (templateTopic == null ? (allowTemplateEdit ? "[[" + name + "]]" : null) : this.processTemplateContent(parserInput, parserOutput, templateTopic, templateContent));
        }
        parserInput.decrementTemplateDepth();
        return result;
    }

    private String parseParamDefaultValue(ParserInput parserInput, ParserOutput parserOutput, String raw) throws ParserException {
        List<String> tokens = JFlexParserUtil.tokenizeParamString(raw);
        if (tokens.size() < 2) {
            return null;
        }
        String param1 = tokens.get(0);
        String value = raw.substring(param1.length() + 1);
        return JFlexParserUtil.parseFragment(parserInput, parserOutput, value, 5);
    }

    private String parseParamName(String raw) throws ParserException {
        int pos = raw.indexOf(124);
        String name = (pos != -1 ? raw.substring(0, pos) : raw).trim();
        if (StringUtils.isBlank((String)name)) {
            throw new ParserException("No parameter name specified");
        }
        return name;
    }

    private String parseSubstitution(ParserInput parserInput, ParserOutput parserOutput, String raw, String templateContent) throws DataAccessException, ParserException {
        if (!this.isSubstitution(templateContent = templateContent.trim())) {
            return null;
        }
        String substContent = templateContent.trim().substring("subst:".length()).trim();
        if (substContent.length() == 0) {
            return null;
        }
        String output = this.parseTemplateOutput(parserInput, parserOutput, 5, "{{" + substContent + "}}", false);
        return output == null ? raw : output;
    }

    private String parseTemplateBody(ParserInput parserInput, ParserOutput parserOutput, String content, Map<String, String> parameterValues) throws ParserException {
        StringBuilder output = new StringBuilder();
        for (int pos = 0; pos < content.length(); ++pos) {
            char case4Char;
            char current = content.charAt(pos);
            String substring = content.substring(pos);
            if (!substring.startsWith("{{{")) {
                output.append(current);
                continue;
            }
            int endPos = Utilities.findMatchingEndTag(content, pos, "{{{", "}}}");
            if (endPos == -1) {
                output.append(current);
                continue;
            }
            int case1EndPos = Utilities.findMatchingEndTag(content, pos, "{", "}");
            if (endPos < case1EndPos && content.substring(case1EndPos - 3, case1EndPos).equals("}}}")) {
                endPos = case1EndPos;
            }
            if (substring.startsWith("{{{{{") && content.substring(endPos - 5, endPos).equals("}}}}}")) {
                output.append("{{");
                ++pos;
                continue;
            }
            int case3EndPos = Utilities.findMatchingEndTag(content, pos + 1, "{{", "}}");
            if (case3EndPos != endPos - 1 && (case4Char = content.charAt(case3EndPos + 1)) != '}') {
                output.append(current);
                continue;
            }
            String param = content.substring(pos, endPos);
            output.append(this.applyParameter(parserInput, parserOutput, param, parameterValues));
            pos = endPos - 1;
        }
        String result = JFlexParserUtil.parseFragment(parserInput, parserOutput, output.toString().trim(), 5);
        return result;
    }

    private WikiLink parseTemplateName(String virtualWiki, String raw) throws ParserException {
        String name = raw;
        int pos = raw.indexOf(124);
        if (pos != -1) {
            name = name.substring(0, pos);
        }
        if (StringUtils.isBlank((String)(name = Utilities.decodeTopicName(name.trim(), true)))) {
            throw new ParserException("No template name specified");
        }
        boolean inclusion = false;
        if (name.startsWith(":")) {
            if (name.length() == 1) {
                throw new ParserException("No template name specified");
            }
            inclusion = true;
            name = name.substring(1).trim();
        }
        WikiLink wikiLink = LinkUtil.parseWikiLink(virtualWiki, name);
        wikiLink.setColon(inclusion);
        return wikiLink;
    }

    private Map<String, String> parseTemplateParameterValues(String templateContent) throws ParserException {
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        List<String> tokens = JFlexParserUtil.tokenizeParamString(templateContent);
        if (tokens.isEmpty()) {
            throw new ParserException("No template name found in " + templateContent);
        }
        int count = -1;
        for (String token : tokens) {
            String value;
            if (++count == 0) continue;
            String[] nameValue = this.tokenizeNameValue(token);
            String string = value = nameValue[1] == null ? null : nameValue[1].trim();
            if (!parameterValues.containsKey(Integer.toString(count))) {
                parameterValues.put(Integer.toString(count), value);
            }
            if (StringUtils.isBlank((String)nameValue[0])) continue;
            parameterValues.put(nameValue[0].trim(), value);
        }
        return parameterValues;
    }

    private String processTemplateContent(ParserInput parserInput, ParserOutput parserOutput, Topic templateTopic, String templateContent) throws ParserException {
        Map<String, String> parameterValues = this.parseTemplateParameterValues(templateContent);
        String templateBody = JFlexParserUtil.parseFragment(parserInput, parserOutput, templateTopic.getTopicContent().trim(), 4);
        if (parserInput.getTempParams().get(TEMPLATE_ONLYINCLUDE) != null) {
            templateBody = (String)parserInput.getTempParams().get(TEMPLATE_ONLYINCLUDE);
            parserInput.getTempParams().remove(TEMPLATE_ONLYINCLUDE);
        }
        return this.parseTemplateBody(parserInput, parserOutput, templateBody, parameterValues);
    }

    private String processTemplateInclusion(ParserInput parserInput, ParserOutput parserOutput, Topic templateTopic, String templateContent, String name) throws ParserException {
        int inclusion;
        if (templateTopic == null) {
            return "[[" + name + "]]";
        }
        int n = inclusion = parserInput.getTempParams().get(TEMPLATE_INCLUSION) == null ? 1 : (Integer)parserInput.getTempParams().get(TEMPLATE_INCLUSION) + 1;
        if (inclusion > Environment.getIntValue("parser-max-inclusions")) {
            throw new ExcessiveNestingException("Potentially infinite inclusions - over " + inclusion + " template inclusions while parsing topic " + parserInput.getTopicName());
        }
        parserInput.getTempParams().put(TEMPLATE_INCLUSION, inclusion);
        return this.processTemplateContent(parserInput, parserOutput, templateTopic, templateContent);
    }

    private void processTemplateMetadata(ParserOutput parserOutput, Topic templateTopic, String name) {
        name = templateTopic != null ? templateTopic.getName() : name;
        parserOutput.addLink(name);
        parserOutput.addTemplate(name);
    }

    private String[] tokenizeNameValue(String content) {
        String[] results = new String[]{null, content};
        Matcher m = PARAM_NAME_VALUE_PATTERN.matcher(content);
        if (m.matches()) {
            results[0] = m.group(1);
            results[1] = m.group(2);
        }
        return results;
    }
}

