/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jamwiki.utils.WikiLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pagination {
    public static final WikiLogger logger = WikiLogger.getLogger(Pagination.class.getName());
    private final int numResults;
    private final int offset;

    public Pagination(int numResults, int offset) {
        this.numResults = numResults;
        this.offset = offset;
    }

    public int getEnd() {
        return this.offset + this.numResults;
    }

    public int getNumResults() {
        return this.numResults;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getStart() {
        return this.offset;
    }

    public static <T> List<T> retrievePaginatedSubset(Pagination pagination, Collection<T> items) {
        ArrayList<T> results = new ArrayList<T>();
        if (items != null && !items.isEmpty()) {
            int count = 0;
            for (T item : items) {
                if (++count < pagination.getOffset() + 1) continue;
                if (count > pagination.getOffset() + pagination.getNumResults()) break;
                results.add(item);
            }
        }
        return results;
    }
}

