/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.binding;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.handler.MessageHandler;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.client.HandlerConfiguration;
import com.sun.xml.ws.handler.HandlerException;
import com.sun.xml.ws.resources.ClientMessages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPFactory;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.soap.MTOMFeature;
import javax.xml.ws.soap.SOAPBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SOAPBindingImpl
extends BindingImpl
implements SOAPBinding {
    public static final String X_SOAP12HTTP_BINDING = "http://java.sun.com/xml/ns/jaxws/2003/05/soap/bindings/HTTP/";
    private static final String ROLE_NONE = "http://www.w3.org/2003/05/soap-envelope/role/none";
    private Set<String> roles;
    protected final SOAPVersion soapVersion;
    private Set<QName> portKnownHeaders = Collections.emptySet();
    private static final WebServiceFeature[] EMPTY_FEATURES = new WebServiceFeature[0];

    SOAPBindingImpl(BindingID bindingId) {
        this(bindingId, EMPTY_FEATURES);
    }

    SOAPBindingImpl(BindingID bindingId, WebServiceFeature ... features) {
        super(bindingId);
        this.soapVersion = bindingId.getSOAPVersion();
        this.roles = new HashSet<String>();
        this.addRequiredRoles();
        this.setFeatures(features);
        this.features.addAll(bindingId.createBuiltinFeatureList());
    }

    public void setPortKnownHeaders(@NotNull Set<QName> headers) {
        this.portKnownHeaders = headers;
        this.setHandlerConfig(this.createHandlerConfig(this.getHandlerChain()));
    }

    @Override
    protected HandlerConfiguration createHandlerConfig(List<Handler> handlerChain) {
        ArrayList<LogicalHandler> logicalHandlers = new ArrayList<LogicalHandler>();
        ArrayList<SOAPHandler> soapHandlers = new ArrayList<SOAPHandler>();
        ArrayList<MessageHandler> messageHandlers = new ArrayList<MessageHandler>();
        HashSet<QName> handlerKnownHeaders = new HashSet<QName>();
        for (Handler handler : handlerChain) {
            Set<QName> headers;
            if (handler instanceof LogicalHandler) {
                logicalHandlers.add((LogicalHandler)handler);
                continue;
            }
            if (handler instanceof SOAPHandler) {
                soapHandlers.add((SOAPHandler)handler);
                headers = ((SOAPHandler)handler).getHeaders();
                if (headers == null) continue;
                handlerKnownHeaders.addAll(headers);
                continue;
            }
            if (handler instanceof MessageHandler) {
                messageHandlers.add((MessageHandler)handler);
                headers = ((MessageHandler)handler).getHeaders();
                if (headers == null) continue;
                handlerKnownHeaders.addAll(headers);
                continue;
            }
            throw new HandlerException("handler.not.valid.type", handler.getClass());
        }
        return new HandlerConfiguration(this.roles, this.portKnownHeaders, handlerChain, logicalHandlers, soapHandlers, messageHandlers, handlerKnownHeaders);
    }

    protected void addRequiredRoles() {
        this.roles.addAll(this.soapVersion.requiredRoles);
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        if (roles == null) {
            roles = new HashSet<String>();
        }
        if (roles.contains(ROLE_NONE)) {
            throw new WebServiceException(ClientMessages.INVALID_SOAP_ROLE_NONE());
        }
        this.roles = roles;
        this.addRequiredRoles();
        HandlerConfiguration oldConfig = this.getHandlerConfig();
        this.setHandlerConfig(new HandlerConfiguration(this.roles, this.portKnownHeaders, oldConfig.getHandlerChain(), oldConfig.getLogicalHandlers(), oldConfig.getSoapHandlers(), oldConfig.getMessageHandlers(), oldConfig.getHandlerKnownHeaders()));
    }

    public boolean isMTOMEnabled() {
        return this.isFeatureEnabled(MTOMFeature.class);
    }

    public void setMTOMEnabled(boolean b) {
        this.setFeatures(new WebServiceFeature[]{new MTOMFeature(b)});
    }

    public SOAPFactory getSOAPFactory() {
        return this.soapVersion.saajSoapFactory;
    }

    public MessageFactory getMessageFactory() {
        return this.soapVersion.saajMessageFactory;
    }
}

