/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.util;

import com.browseengine.bobo.util.BigSegmentedArray;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.lucene.util.BitVector;
import org.apache.lucene.util.OpenBitSet;

public final class BigIntArray
extends BigSegmentedArray
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int[][] _array;
    private static final int BLOCK_SIZE = 1024;
    private static final int SHIFT_SIZE = 10;
    private static final int MASK = 1023;

    public BigIntArray(int size) {
        super(size);
        this._array = new int[this._numrows][];
        for (int i = 0; i < this._numrows; ++i) {
            this._array[i] = new int[1024];
        }
    }

    @Override
    public final void add(int docId, int val) {
        this._array[docId >> 10][docId & 0x3FF] = val;
    }

    @Override
    public final int get(int docId) {
        return this._array[docId >> 10][docId & 0x3FF];
    }

    @Override
    public final int findValue(int val, int docId, int maxId) {
        do {
            if (this._array[docId >> 10][docId & 0x3FF] != val) continue;
            return docId;
        } while (docId++ < maxId);
        return Integer.MAX_VALUE;
    }

    @Override
    public final int findValues(OpenBitSet bitset, int docId, int maxId) {
        do {
            if (!bitset.fastGet(this._array[docId >> 10][docId & 0x3FF])) continue;
            return docId;
        } while (docId++ < maxId);
        return Integer.MAX_VALUE;
    }

    @Override
    public final int findValues(BitVector bitset, int docId, int maxId) {
        do {
            if (!bitset.get(this._array[docId >> 10][docId & 0x3FF])) continue;
            return docId;
        } while (docId++ < maxId);
        return Integer.MAX_VALUE;
    }

    @Override
    public final int findValueRange(int minVal, int maxVal, int docId, int maxId) {
        do {
            int val;
            if ((val = this._array[docId >> 10][docId & 0x3FF]) < minVal || val > maxVal) continue;
            return docId;
        } while (docId++ < maxId);
        return Integer.MAX_VALUE;
    }

    @Override
    public final int findBits(int bits, int docId, int maxId) {
        do {
            if ((this._array[docId >> 10][docId & 0x3FF] & bits) == 0) continue;
            return docId;
        } while (docId++ < maxId);
        return Integer.MAX_VALUE;
    }

    @Override
    public final void fill(int val) {
        for (int[] block : this._array) {
            Arrays.fill(block, val);
        }
    }

    @Override
    public void ensureCapacity(int size) {
        int newNumrows = (size >> 10) + 1;
        if (newNumrows > this._array.length) {
            int[][] newArray = new int[newNumrows][];
            System.arraycopy(this._array, 0, newArray, 0, this._array.length);
            for (int i = this._array.length; i < newNumrows; ++i) {
                newArray[i] = new int[1024];
            }
            this._array = newArray;
        }
        this._numrows = newNumrows;
    }

    @Override
    final int getBlockSize() {
        return 1024;
    }

    @Override
    final int getShiftSize() {
        return 10;
    }

    @Override
    public int maxValue() {
        return Integer.MAX_VALUE;
    }

    public static BigSegmentedArray fromArray(int[] original) {
        BigIntArray result = new BigIntArray(original.length);
        int i = 0;
        for (int c : original) {
            result.add(i++, c);
        }
        return result;
    }

    public static int[] toArray(BigSegmentedArray original) {
        int[] result = new int[original.size()];
        for (int i = 0; i < original.size(); ++i) {
            result[i] = original.get(i);
        }
        return result;
    }
}

