/*
 * Decompiled with CFR 0.152.
 */
package flexjson;

import flexjson.BeanProperty;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanAnalyzer {
    private static ThreadLocal<Map<Class, BeanAnalyzer>> cache = new ThreadLocal();
    private Class clazz;
    private BeanAnalyzer superBean;
    private Map<String, BeanProperty> properties;

    public static BeanAnalyzer analyze(Class clazz) {
        if (cache.get() == null) {
            cache.set(new HashMap());
        }
        if (clazz == null) {
            return null;
        }
        if (!cache.get().containsKey(clazz)) {
            cache.get().put(clazz, new BeanAnalyzer(clazz));
        }
        return cache.get().get(clazz);
    }

    public static void clearCache() {
        cache.remove();
    }

    protected BeanAnalyzer(Class clazz) {
        this.clazz = clazz;
        this.superBean = BeanAnalyzer.analyze(clazz.getSuperclass());
        this.populateProperties();
    }

    private void populateProperties() {
        int modifiers;
        this.properties = new TreeMap<String, BeanProperty>();
        for (Field field : this.clazz.getDeclaredFields()) {
            modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || this.properties.containsKey(field.getName())) continue;
            this.properties.put(field.getName(), new BeanProperty(field, this));
        }
        for (AccessibleObject accessibleObject : this.clazz.getDeclaredMethods()) {
            String property;
            modifiers = ((Method)accessibleObject).getModifiers();
            if (Modifier.isStatic(modifiers)) continue;
            int numberOfArgs = ((Method)accessibleObject).getParameterTypes().length;
            String name = ((Method)accessibleObject).getName();
            if (name.length() <= 3 && !name.startsWith("is")) continue;
            if (numberOfArgs == 0) {
                if (name.startsWith("get")) {
                    property = this.uncapitalize(name.substring(3));
                    if (!this.properties.containsKey(property)) {
                        this.properties.put(property, new BeanProperty(property, this));
                    }
                    this.properties.get(property).setReadMethod((Method)accessibleObject);
                    continue;
                }
                if (!name.startsWith("is")) continue;
                property = this.uncapitalize(name.substring(2));
                if (!this.properties.containsKey(property)) {
                    this.properties.put(property, new BeanProperty(property, this));
                }
                this.properties.get(property).setReadMethod((Method)accessibleObject);
                continue;
            }
            if (numberOfArgs != 1 || !name.startsWith("set")) continue;
            property = this.uncapitalize(name.substring(3));
            if (!this.properties.containsKey(property)) {
                this.properties.put(property, new BeanProperty(property, this));
            }
            this.properties.get(property).addWriteMethod((Method)accessibleObject);
        }
        Iterator<BeanProperty> i = this.properties.values().iterator();
        while (i.hasNext()) {
            BeanProperty property = i.next();
            if (!property.isNonProperty()) continue;
            i.remove();
        }
    }

    public BeanAnalyzer getSuperBean() {
        return this.superBean;
    }

    private String uncapitalize(String value) {
        if (value.length() < 2) {
            return value.toLowerCase();
        }
        if (Character.isUpperCase(value.charAt(0)) && Character.isUpperCase(value.charAt(1))) {
            return value;
        }
        return Character.toLowerCase(value.charAt(0)) + value.substring(1);
    }

    public BeanProperty getProperty(String name) {
        BeanAnalyzer current = this;
        while (current != null) {
            BeanProperty property = current.properties.get(name);
            if (property != null) {
                return property;
            }
            current = current.superBean;
        }
        return null;
    }

    public Collection<BeanProperty> getProperties() {
        TreeMap<String, BeanProperty> properties = new TreeMap<String, BeanProperty>(this.properties);
        BeanAnalyzer current = this.superBean;
        while (current != null) {
            this.merge(properties, current.properties);
            current = current.superBean;
        }
        return properties.values();
    }

    private void merge(Map<String, BeanProperty> destination, Map<String, BeanProperty> source) {
        for (String key : source.keySet()) {
            if (destination.containsKey(key)) continue;
            destination.put(key, source.get(key));
        }
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name) || this.superBean != null && this.superBean.hasProperty(name);
    }

    protected Field getDeclaredField(String name) {
        try {
            return this.clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }
}

