/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.apache.commons.math.Field;
import org.apache.commons.math.FieldElement;
import org.apache.commons.math.util.BigRealField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigReal
implements FieldElement<BigReal>,
Comparable<BigReal>,
Serializable {
    private static final long serialVersionUID = 7887631840434052850L;
    public static final BigReal ZERO = new BigReal(BigDecimal.ZERO);
    public static final BigReal ONE = new BigReal(BigDecimal.ONE);
    private final BigDecimal d;

    public BigReal(BigDecimal val) {
        this.d = val;
    }

    public BigReal(BigInteger val) {
        this.d = new BigDecimal(val);
    }

    public BigReal(BigInteger unscaledVal, int scale) {
        this.d = new BigDecimal(unscaledVal, scale);
    }

    public BigReal(BigInteger unscaledVal, int scale, MathContext mc) {
        this.d = new BigDecimal(unscaledVal, scale, mc);
    }

    public BigReal(BigInteger val, MathContext mc) {
        this.d = new BigDecimal(val, mc);
    }

    public BigReal(char[] in) {
        this.d = new BigDecimal(in);
    }

    public BigReal(char[] in, int offset, int len) {
        this.d = new BigDecimal(in, offset, len);
    }

    public BigReal(char[] in, int offset, int len, MathContext mc) {
        this.d = new BigDecimal(in, offset, len, mc);
    }

    public BigReal(char[] in, MathContext mc) {
        this.d = new BigDecimal(in, mc);
    }

    public BigReal(double val) {
        this.d = new BigDecimal(val);
    }

    public BigReal(double val, MathContext mc) {
        this.d = new BigDecimal(val, mc);
    }

    public BigReal(int val) {
        this.d = new BigDecimal(val);
    }

    public BigReal(int val, MathContext mc) {
        this.d = new BigDecimal(val, mc);
    }

    public BigReal(long val) {
        this.d = new BigDecimal(val);
    }

    public BigReal(long val, MathContext mc) {
        this.d = new BigDecimal(val, mc);
    }

    public BigReal(String val) {
        this.d = new BigDecimal(val);
    }

    public BigReal(String val, MathContext mc) {
        this.d = new BigDecimal(val, mc);
    }

    @Override
    public BigReal add(BigReal a) {
        return new BigReal(this.d.add(a.d));
    }

    @Override
    public BigReal subtract(BigReal a) {
        return new BigReal(this.d.subtract(a.d));
    }

    @Override
    public BigReal divide(BigReal a) throws ArithmeticException {
        return new BigReal(this.d.divide(a.d));
    }

    @Override
    public BigReal multiply(BigReal a) {
        return new BigReal(this.d.multiply(a.d));
    }

    @Override
    public int compareTo(BigReal a) {
        return this.d.compareTo(a.d);
    }

    public double doubleValue() {
        return this.d.doubleValue();
    }

    public BigDecimal bigDecimalValue() {
        return this.d;
    }

    public boolean equals(Object other) {
        try {
            if (other == null) {
                return false;
            }
            return this.d.equals(((BigReal)other).d);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public int hashCode() {
        return this.d.hashCode();
    }

    @Override
    public Field<BigReal> getField() {
        return BigRealField.getInstance();
    }
}

