/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.preferences;

import com.ecyrd.jspwiki.InternalWikiException;
import com.ecyrd.jspwiki.PropertyReader;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.i18n.InternationalizationManager;
import com.ecyrd.jspwiki.util.HttpUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preferences
extends HashMap<String, String> {
    private static final long serialVersionUID = 1L;
    public static final String SESSIONPREFS = "prefs";
    private static Logger log = Logger.getLogger(Preferences.class);

    public static void setupPreferences(PageContext pageContext) {
        HttpSession session = pageContext.getSession();
        if (session.getAttribute(SESSIONPREFS) == null) {
            Preferences.reloadPreferences(pageContext);
        }
    }

    public static void reloadPreferences(PageContext pageContext) {
        Preferences prefs = new Preferences();
        Properties props = PropertyReader.loadWebAppProps(pageContext.getServletContext());
        WikiContext ctx = WikiContext.findContext(pageContext);
        prefs.put("SkinName", TextUtil.getStringProperty(props, "jspwiki.defaultprefs.template.skinname", "PlainVanilla"));
        prefs.put("DateFormat", TextUtil.getStringProperty(props, "jspwiki.defaultprefs.template.dateformat", ctx.getEngine().getInternationalizationManager().get("CoreResources", Preferences.getLocale(ctx), "common.datetimeformat")));
        prefs.put("TimeZone", TextUtil.getStringProperty(props, "jspwiki.defaultprefs.template.timezone", TimeZone.getDefault().getID()));
        prefs.put("Orientation", TextUtil.getStringProperty(props, "jspwiki.defaultprefs.template.orientation", "fav-left"));
        prefs.put("Language", TextUtil.getStringProperty(props, "jspwiki.defaultprefs.template.language", Preferences.getLocale(ctx).toString()));
        prefs.put("SectionEditing", TextUtil.getStringProperty(props, "jspwiki.defaultprefs.template.sectionediting", ""));
        prefs.put("editor", TextUtil.getStringProperty(props, "jspwiki.defaultprefs.template.editor", "plain"));
        Preferences.parseJSONPreferences((HttpServletRequest)pageContext.getRequest(), prefs);
        pageContext.getSession().setAttribute(SESSIONPREFS, (Object)prefs);
    }

    private static void parseJSONPreferences(HttpServletRequest request, Preferences prefs) {
        String prefVal = TextUtil.urlDecodeUTF8(HttpUtil.retrieveCookieValue(request, "JSPWikiUserPrefs"));
        if (prefVal != null) {
            try {
                JSONObject jo = new JSONObject(prefVal);
                Iterator i = jo.keys();
                while (i.hasNext()) {
                    String key = TextUtil.replaceEntities((String)i.next());
                    prefs.put(key, jo.getString(key));
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public static String getPreference(WikiContext wikiContext, String name) {
        HttpServletRequest request = wikiContext.getHttpRequest();
        if (request == null) {
            return null;
        }
        Preferences prefs = (Preferences)request.getSession().getAttribute(SESSIONPREFS);
        if (prefs != null) {
            return (String)prefs.get(name);
        }
        return null;
    }

    public static String getPreference(PageContext pageContext, String name) {
        Preferences prefs = (Preferences)pageContext.getSession().getAttribute(SESSIONPREFS);
        if (prefs != null) {
            return (String)prefs.get(name);
        }
        return null;
    }

    public static Locale getLocale(WikiContext context) {
        Locale loc = null;
        String langSetting = Preferences.getPreference(context, "Language");
        if (langSetting != null) {
            String language = "";
            String country = "";
            String variant = "";
            String[] res = StringUtils.split((String)langSetting, (String)"-_");
            if (res.length > 2) {
                variant = res[2];
            }
            if (res.length > 1) {
                country = res[1];
            }
            if (res.length > 0) {
                language = res[0];
                loc = new Locale(language, country, variant);
            }
        }
        if (loc == null) {
            HttpServletRequest request = context.getHttpRequest();
            loc = request != null ? request.getLocale() : Locale.getDefault();
        }
        return loc;
    }

    public static SimpleDateFormat getDateFormat(WikiContext context, TimeFormat tf) {
        String prefDateFormat;
        InternationalizationManager imgr = context.getEngine().getInternationalizationManager();
        Locale clientLocale = Preferences.getLocale(context);
        String prefTimeZone = Preferences.getPreference(context, "TimeZone");
        log.debug((Object)"Checking for preferences...");
        switch (tf) {
            case DATETIME: {
                prefDateFormat = Preferences.getPreference(context, "DateFormat");
                log.debug((Object)("Preferences fmt = " + prefDateFormat));
                if (prefDateFormat != null) break;
                prefDateFormat = imgr.get("CoreResources", clientLocale, "common.datetimeformat");
                log.debug((Object)("Using locale-format = " + prefDateFormat));
                break;
            }
            case TIME: {
                prefDateFormat = imgr.get("common.timeformat");
                break;
            }
            case DATE: {
                prefDateFormat = imgr.get("common.dateformat");
                break;
            }
            default: {
                throw new InternalWikiException("Got a TimeFormat for which we have no value!");
            }
        }
        try {
            SimpleDateFormat fmt = new SimpleDateFormat(prefDateFormat, clientLocale);
            if (prefTimeZone != null) {
                TimeZone tz = TimeZone.getTimeZone(prefTimeZone);
                fmt.setTimeZone(tz);
            }
            return fmt;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String renderDate(WikiContext context, Date date, TimeFormat tf) {
        SimpleDateFormat df = Preferences.getDateFormat(context, tf);
        return df.format(date);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimeFormat {
        TIME,
        DATE,
        DATETIME;

    }
}

