/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.xmlrpc;

import com.ecyrd.jspwiki.LinkCollector;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.auth.permissions.PagePermission;
import com.ecyrd.jspwiki.auth.permissions.PermissionFactory;
import com.ecyrd.jspwiki.xmlrpc.AbstractRPCHandler;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPCHandlerUTF8
extends AbstractRPCHandler {
    public String getApplicationName() {
        this.checkPermission(PagePermission.VIEW);
        return this.m_engine.getApplicationName();
    }

    public Vector getAllPages() {
        this.checkPermission(PagePermission.VIEW);
        Collection pages = this.m_engine.getRecentChanges();
        Vector<String> result = new Vector<String>();
        for (WikiPage p : pages) {
            if (p instanceof Attachment) continue;
            result.add(p.getName());
        }
        return result;
    }

    @Override
    protected Hashtable<String, Object> encodeWikiPage(WikiPage page) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("name", page.getName());
        Date d = page.getLastModified();
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(14, -(cal.get(15) + (cal.getTimeZone().inDaylightTime(d) ? cal.get(16) : 0)));
        ht.put("lastModified", cal.getTime());
        ht.put("version", page.getVersion());
        if (page.getAuthor() != null) {
            ht.put("author", page.getAuthor());
        }
        return ht;
    }

    @Override
    public Vector getRecentChanges(Date since) {
        this.checkPermission(PagePermission.VIEW);
        Collection pages = this.m_engine.getRecentChanges();
        Vector<Hashtable<String, Object>> result = new Vector<Hashtable<String, Object>>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(since);
        cal.add(14, cal.get(15) + (cal.getTimeZone().inDaylightTime(since) ? cal.get(16) : 0));
        since = cal.getTime();
        for (WikiPage page : pages) {
            if (!page.getLastModified().after(since) || page instanceof Attachment) continue;
            result.add(this.encodeWikiPage(page));
        }
        return result;
    }

    private String parsePageCheckCondition(String pagename) throws XmlRpcException {
        if (!this.m_engine.pageExists(pagename)) {
            throw new XmlRpcException(1, "No such page '" + pagename + "' found, o master.");
        }
        WikiPage p = this.m_engine.getPage(pagename);
        this.checkPermission(PermissionFactory.getPagePermission(p, "view"));
        return pagename;
    }

    public Hashtable getPageInfo(String pagename) throws XmlRpcException {
        pagename = this.parsePageCheckCondition(pagename);
        return this.encodeWikiPage(this.m_engine.getPage(pagename));
    }

    public Hashtable getPageInfoVersion(String pagename, int version) throws XmlRpcException {
        pagename = this.parsePageCheckCondition(pagename);
        return this.encodeWikiPage(this.m_engine.getPage(pagename, version));
    }

    public String getPage(String pagename) throws XmlRpcException {
        pagename = this.parsePageCheckCondition(pagename);
        String text = this.m_engine.getPureText(pagename, -1);
        return text;
    }

    public String getPageVersion(String pagename, int version) throws XmlRpcException {
        pagename = this.parsePageCheckCondition(pagename);
        return this.m_engine.getPureText(pagename, version);
    }

    public String getPageHTML(String pagename) throws XmlRpcException {
        pagename = this.parsePageCheckCondition(pagename);
        return this.m_engine.getHTML(pagename);
    }

    public String getPageHTMLVersion(String pagename, int version) throws XmlRpcException {
        pagename = this.parsePageCheckCondition(pagename);
        return this.m_engine.getHTML(pagename, version);
    }

    public Vector listLinks(String pagename) throws XmlRpcException {
        Hashtable<String, String> ht;
        pagename = this.parsePageCheckCondition(pagename);
        WikiPage page = this.m_engine.getPage(pagename);
        String pagedata = this.m_engine.getPureText(page);
        LinkCollector localCollector = new LinkCollector();
        LinkCollector extCollector = new LinkCollector();
        LinkCollector attCollector = new LinkCollector();
        WikiContext context = new WikiContext(this.m_engine, page);
        context.setVariable("jspwiki.referenceStyle", "absolute");
        this.m_engine.textToHTML(context, pagedata, localCollector, extCollector, attCollector);
        Vector result = new Vector();
        for (String link : localCollector.getLinks()) {
            ht = new Hashtable<String, String>();
            ht.put("page", link);
            ht.put("type", "local");
            if (this.m_engine.pageExists(link)) {
                ht.put("href", context.getViewURL(link));
            } else {
                ht.put("href", context.getURL(WikiContext.EDIT, link));
            }
            result.add(ht);
        }
        for (String link : attCollector.getLinks()) {
            ht = new Hashtable();
            ht.put("page", link);
            ht.put("type", "local");
            ht.put("href", context.getURL(WikiContext.ATTACH, link));
            result.add(ht);
        }
        for (String link : extCollector.getLinks()) {
            ht = new Hashtable();
            ht.put("page", link);
            ht.put("type", "external");
            ht.put("href", link);
            result.add(ht);
        }
        return result;
    }
}

