/*
 * Decompiled with CFR 0.152.
 */
package jodd.csselly;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.LinkedList;
import jodd.csselly.CSSellyException;
import jodd.csselly.Combinator;
import jodd.csselly.CssSelector;

final class CSSellyLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 4096;
    public static final int COMBINATOR = 6;
    public static final int YYINITIAL = 0;
    public static final int ATTR = 4;
    public static final int SELECTOR = 2;
    public static final int PSEUDO_FN = 8;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4};
    private static final String ZZ_CMAP_PACKED = "\t\u0002\u0001\b\u0001\u0007\u0001\u0002\u0001\t\u0001\u0006\u0012\u0002\u0001\b\u0001\u0002\u0001\n\u0001\u000e\u0001\u0014\u0002\u0002\u0001\u000b\u0001\u0011\u0001\u0018\u0001\f\u0001\u0017\u0001\u0002\u0001\u0001\u0001\u000f\u0001\u0002\n\u0005\u0001\u0010\u0002\u0002\u0001\u0012\u0001\u0016\u0002\u0002\u001a\u0000\u0001\r\u0001\u0003\u0001\u0015\u0001\u0014\u0001\u0000\u0001\u0002\u0006\u0004\u0014\u0000\u0001\u0002\u0001\u0014\u0001\u0002\u0001\u0013\u0001\u0002\uff80\u0000";
    private static final char[] ZZ_CMAP = CSSellyLexer.zzUnpackCMap("\t\u0002\u0001\b\u0001\u0007\u0001\u0002\u0001\t\u0001\u0006\u0012\u0002\u0001\b\u0001\u0002\u0001\n\u0001\u000e\u0001\u0014\u0002\u0002\u0001\u000b\u0001\u0011\u0001\u0018\u0001\f\u0001\u0017\u0001\u0002\u0001\u0001\u0001\u000f\u0001\u0002\n\u0005\u0001\u0010\u0002\u0002\u0001\u0012\u0001\u0016\u0002\u0002\u001a\u0000\u0001\r\u0001\u0003\u0001\u0015\u0001\u0014\u0001\u0000\u0001\u0002\u0006\u0004\u0014\u0000\u0001\u0002\u0001\u0014\u0001\u0002\u0001\u0013\u0001\u0002\uff80\u0000");
    private static final int[] ZZ_ACTION = CSSellyLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0003\u0000\u0001\u0001\u0001\u0000\u0001\u0002\u0003\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0003\u0006\u0001\t\u0003\u0007\u0001\n\u0001\u000b\u0001\u0001\u0001\f\u0001\r\u0001\u000e\u0001\u0007\u0001\u000f\u0001\u0000\u0001\u0002\u0001\u0010\u0001\u0000\u0001\u0011\u0002\u0000\u0001\u0012\u0003\u0000\u0001\t\u0002\u0000\u0001\t\u0003\u0000\u0002\u0002\u0001\u0010\u0001\u0011\u0001\u0013\u0001\u0012\u0001\t\u0004\u0000\u0002\t\u0001\u0002\u0002\u0010\u0002\u0011\u0002\u0012\u0002\t\u0002\u0000\u0001\t\u0001\u0002\u0001\u0010\u0001\u0011\u0001\u0012\u0002\t\u0002\u0000\u0001\t\u0002\u0000\u0002\t\u0001\u0002\u0001\u0010\u0001\u0011\u0001\u0012\u0001\t\u0002\u0000\u0001\t\u0001\u0002\u0001\u0010\u0001\u0011\u0001\u0012\u0001\t\u0002\u0000\u0001\t\u0001\u0010\u0001\u0011\u0001\u0012\u0001\t\u0002\u0000\u0001\t\u0004\u0000";
    private static final int[] ZZ_ROWMAP = CSSellyLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u0019\u00002\u0000K\u0000d\u0000}\u0000\u0096\u0000\u00af\u0000\u00c8\u0000\u00e1\u0000\u00af\u0000\u00af\u0000\u00af\u0000\u00af\u0000\u00fa\u0000\u0113\u0000\u012c\u0000\u0145\u0000\u015e\u0000\u0177\u0000\u0190\u0000\u00af\u0000\u00af\u0000\u01a9\u0000\u01c2\u0000\u01db\u0000\u01f4\u0000\u020d\u0000\u00af\u0000\u00c8\u0000\u0226\u0000\u00fa\u0000\u023f\u0000\u0258\u0000\u0271\u0000\u028a\u0000\u02a3\u0000\u02bc\u0000\u02d5\u0000\u0177\u0000\u02ee\u0000\u0307\u0000\u0320\u0000\u0339\u0000\u015e\u0000\u0190\u0000\u020d\u0000\u0352\u0000\u036b\u0000\u0384\u0000\u039d\u0000\u00af\u0000\u03b6\u0000\u03cf\u0000\u03e8\u0000\u0401\u0000\u041a\u0000\u0433\u0000\u044c\u0000\u0465\u0000\u047e\u0000\u0497\u0000\u04b0\u0000\u04c9\u0000\u04e2\u0000\u04fb\u0000\u0514\u0000\u052d\u0000\u0546\u0000\u055f\u0000\u0578\u0000\u0591\u0000\u05aa\u0000\u05c3\u0000\u05dc\u0000\u05f5\u0000\u060e\u0000\u0627\u0000\u0640\u0000\u0659\u0000\u0672\u0000\u068b\u0000\u06a4\u0000\u06bd\u0000\u06d6\u0000\u06ef\u0000\u0708\u0000\u0721\u0000\u073a\u0000\u0753\u0000\u076c\u0000\u0785\u0000\u079e\u0000\u07b7\u0000\u07d0\u0000\u07e9\u0000\u0802\u0000\u081b\u0000\u0834\u0000\u084d\u0000\u0866\u0000\u087f\u0000\u0898\u0000\u08b1\u0000\u08ca\u0000\u08e3\u0000\u08fc\u0000\u0915\u0000\u092e\u0000\u0947\u0000\u0960\u0000\u0979";
    private static final int[] ZZ_TRANS = new int[]{5, 6, 7, 8, 5, 7, 9, 9, 9, 9, 7, 7, 10, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 13, 14, 15, 16, 11, 11, 11, 11, 11, 11, 11, 11, 17, 18, 12, 19, 17, 12, 20, 20, 20, 20, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 21, 12, 12, 12, 22, 22, 22, 22, 22, 22, 23, 23, 23, 23, 22, 22, 22, 22, 22, 22, 22, 22, 22, 24, 22, 22, 25, 26, 22, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 28, 5, 5, -1, 29, 5, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, -1, -1, 29, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, 5, 5, 5, 30, 30, -1, -1, 5, -1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, -1, -1, -1, -1, -1, -1, 9, 9, 9, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 31, 31, -1, 32, 31, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, 34, -1, 35, 33, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 36, 37, -1, 38, 36, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17, 17, -1, 39, 17, 17, 40, 40, 40, 40, -1, -1, 41, -1, -1, -1, -1, -1, 42, 41, 41, -1, -1, -1, -1, 17, -1, -1, 39, 17, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17, 17, 17, 17, 43, 43, -1, -1, 17, -1, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 44, -1, 39, 17, -1, 45, 45, 45, 45, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 23, 23, 23, 23, -1, -1, -1, -1, -1, -1, -1, -1, -1, 24, -1, -1, 25, 26, -1, -1, -1, -1, -1, -1, -1, 24, 24, 24, 24, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 25, 25, 25, 25, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26, 26, 26, 26, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 28, 5, 5, -1, 29, 47, 47, 48, 5, 5, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 31, 31, 31, 31, 49, 49, -1, -1, 31, -1, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 33, 33, -1, 35, 33, 33, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, -1, -1, 35, 33, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, 33, 33, 33, 50, 50, -1, -1, 33, -1, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 36, 36, -1, 38, 36, 36, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 51, -1, -1, -1, -1, -1, -1, -1, 36, -1, -1, 38, 36, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 36, 36, 36, 36, 52, 52, -1, -1, 36, -1, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, -1, -1, -1, -1, -1, -1, 40, 40, 40, 40, -1, -1, 41, -1, -1, -1, -1, -1, 42, 41, 41, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 42, -1, -1, -1, -1, -1, -1, 53, 54, -1, 55, 53, -1, 42, 42, 42, 42, 56, 57, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17, 17, -1, 39, 58, 58, 59, 17, 17, 17, -1, -1, 41, -1, -1, -1, -1, -1, 42, 41, 41, -1, -1, -1, -1, 5, 5, -1, 29, 60, 60, 48, 5, 5, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, 5, -1, 29, 5, 5, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 31, 31, -1, 32, 61, 61, 62, 31, 31, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, 33, -1, 35, 63, 63, 64, 33, 33, 33, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 36, 36, -1, 38, 65, 65, 66, 36, 36, 36, -1, -1, -1, -1, -1, -1, -1, 51, -1, -1, -1, -1, -1, -1, -1, 53, 53, -1, 55, 53, 53, 67, 67, 67, 67, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 53, -1, -1, 55, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 53, 53, 53, 53, 68, 68, -1, -1, 53, -1, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 56, 56, 56, 69, 56, 56, -1, -1, 56, -1, 67, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 70, 57, 57, -1, -1, 57, -1, 57, 67, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 17, 17, -1, 39, 71, 71, 59, 17, 17, 17, -1, -1, 41, -1, -1, -1, -1, -1, 42, 41, 41, -1, -1, -1, -1, 17, 17, -1, 39, 17, 17, 40, 17, 40, 40, -1, -1, 41, -1, -1, -1, -1, -1, 42, 41, 41, -1, -1, -1, -1, 5, 5, -1, 29, 72, 72, 48, 5, 5, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 31, 31, -1, 32, 73, 73, 62, 31, 31, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 31, 31, -1, 32, 31, 31, -1, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, 33, -1, 35, 74, 74, 64, 33, 33, 33, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, 33, -1, 35, 33, 33, -1, 33, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 36, 36, -1, 38, 75, 75, 66, 36, 36, 36, -1, -1, -1, -1, -1, -1, -1, 51, -1, -1, -1, -1, -1, -1, -1, 36, 36, -1, 38, 36, 36, -1, 36, -1, -1, -1, -1, -1, -1, -1, -1, -1, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 67, 67, 67, 67, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 53, 53, -1, 55, 76, 76, 77, 53, 53, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 56, 56, 56, 69, 78, 78, 79, 56, 56, 56, 80, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 70, 81, 81, 82, 57, 57, 57, 57, 83, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 17, 17, -1, 39, 84, 84, 59, 17, 17, 17, -1, -1, 41, -1, -1, -1, -1, -1, 42, 41, 41, -1, -1, -1, -1, 5, 5, -1, 29, 85, 85, 48, 5, 5, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 31, 31, -1, 32, 86, 86, 62, 31, 31, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, 33, -1, 35, 87, 87, 64, 33, 33, 33, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 36, 36, -1, 38, 88, 88, 66, 36, 36, 36, -1, -1, -1, -1, -1, -1, -1, 51, -1, -1, -1, -1, -1, -1, -1, 53, 53, -1, 55, 89, 89, 77, 53, 53, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 53, 53, -1, 55, 53, 53, 67, 53, 67, 67, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 56, 56, 56, 69, 90, 90, 79, 56, 56, 56, 67, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 69, 56, 56, -1, 56, 56, -1, 67, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 69, 56, 56, 67, 67, 80, 67, 67, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 70, 91, 91, 82, 57, 57, 57, 57, 67, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 70, 57, 57, -1, 57, 57, -1, 57, 67, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 70, 57, 57, 67, 67, 83, 67, 57, 67, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 17, 17, -1, 39, 92, 92, 59, 17, 17, 17, -1, -1, 41, -1, -1, -1, -1, -1, 42, 41, 41, -1, -1, -1, -1, 5, 5, -1, 29, 93, 93, 48, 5, 5, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 31, 31, -1, 32, 94, 94, 62, 31, 31, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, 33, -1, 35, 95, 95, 64, 33, 33, 33, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 36, 36, -1, 38, 96, 96, 66, 36, 36, 36, -1, -1, -1, -1, -1, -1, -1, 51, -1, -1, -1, -1, -1, -1, -1, 53, 53, -1, 55, 97, 97, 77, 53, 53, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 56, 56, 56, 69, 98, 98, 79, 56, 56, 56, 67, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 70, 99, 99, 82, 57, 57, 57, 57, 67, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 17, 17, -1, 39, 100, 100, 59, 17, 17, 17, -1, -1, 41, -1, -1, -1, -1, -1, 42, 41, 41, -1, -1, -1, -1, 5, 5, -1, 29, 5, 5, 48, 5, 5, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 31, 31, -1, 32, 101, 101, 62, 31, 31, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, 33, -1, 35, 102, 102, 64, 33, 33, 33, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 36, 36, -1, 38, 103, 103, 66, 36, 36, 36, -1, -1, -1, -1, -1, -1, -1, 51, -1, -1, -1, -1, -1, -1, -1, 53, 53, -1, 55, 104, 104, 77, 53, 53, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 56, 56, 56, 69, 105, 105, 79, 56, 56, 56, 67, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 70, 106, 106, 82, 57, 57, 57, 57, 67, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 17, 17, -1, 39, 17, 17, 59, 17, 17, 17, -1, -1, 41, -1, -1, -1, -1, -1, 42, 41, 41, -1, -1, -1, -1, 31, 31, -1, 32, 31, 31, 62, 31, 31, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, 33, -1, 35, 33, 33, 64, 33, 33, 33, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 36, 36, -1, 38, 36, 36, 66, 36, 36, 36, -1, -1, -1, -1, -1, -1, -1, 51, -1, -1, -1, -1, -1, -1, -1, 53, 53, -1, 55, 107, 107, 77, 53, 53, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 56, 56, 56, 69, 108, 108, 79, 56, 56, 56, 67, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 70, 109, 109, 82, 57, 57, 57, 57, 67, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 53, 53, -1, 55, 53, 53, 77, 53, 53, 53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 56, 56, 56, 69, 110, 110, 79, 56, 56, 56, 67, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 70, 111, 111, 82, 57, 57, 57, 57, 67, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 56, 56, 56, 69, 56, 56, 79, 56, 56, 56, 67, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 70, 57, 57, 82, 57, 57, 57, 57, 67, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = CSSellyLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0003\u0000\u0001\u0001\u0001\u0000\u0002\u0001\u0001\t\u0002\u0001\u0004\t\u0007\u0001\u0002\t\u0005\u0001\u0001\t\u0001\u0000\u0002\u0001\u0001\u0000\u0001\u0001\u0002\u0000\u0001\u0001\u0003\u0000\u0001\u0001\u0002\u0000\u0001\u0001\u0003\u0000\u0004\u0001\u0001\t\u0002\u0001\u0004\u0000\u000b\u0001\u0002\u0000\u0007\u0001\u0002\u0000\u0001\u0001\u0002\u0000\u0007\u0001\u0002\u0000\u0006\u0001\u0002\u0000\u0005\u0001\u0002\u0000\u0001\u0001\u0004\u0000";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[4096];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    LinkedList<CssSelector> selectors = new LinkedList();
    CssSelector cssSelector;
    String pseudoFnName;

    private static int[] zzUnpackAction() {
        int[] result = new int[112];
        int offset = 0;
        offset = CSSellyLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[112];
        int offset = 0;
        offset = CSSellyLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[112];
        int offset = 0;
        offset = CSSellyLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public int position() {
        return this.yychar;
    }

    public int length() {
        return this.yylength();
    }

    public int line() {
        return -1;
    }

    public int column() {
        return -1;
    }

    public void stateReset() {
        this.yybegin(0);
    }

    public void stateSelector() {
        this.yybegin(2);
    }

    public void stateAttr() {
        this.yybegin(4);
    }

    public void stateCombinator() {
        this.yybegin(6);
    }

    public void statePseudoFn() {
        this.yybegin(8);
    }

    public final CharSequence xxtext() {
        return CharBuffer.wrap(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final String yytext(int startIndex) {
        return new String(this.zzBuffer, startIndex += this.zzStartRead, this.zzMarkedPos - startIndex);
    }

    public final String yytext(int startIndex, int endIndexOffset) {
        return new String(this.zzBuffer, startIndex += this.zzStartRead, this.zzMarkedPos - endIndexOffset - startIndex);
    }

    CSSellyLexer(Reader in) {
        this.zzReader = in;
    }

    CSSellyLexer(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 86) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) > 0) {
            this.zzEndRead += numRead;
            return false;
        }
        if (numRead == 0) {
            int c = this.zzReader.read();
            if (c == -1) {
                return true;
            }
            this.zzBuffer[this.zzEndRead++] = (char)c;
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    private void zzDoEOF() throws IOException {
        if (!this.zzEOFDone) {
            this.zzEOFDone = true;
            this.yyclose();
        }
    }

    public int yylex() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block39: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 9: {
                    this.cssSelector.addAttributeSelector(this.yytext());
                }
                case 20: {
                    continue block39;
                }
                case 14: {
                    this.cssSelector.setCombinator(Combinator.ADJACENT_SIBLING);
                    this.stateReset();
                }
                case 21: {
                    continue block39;
                }
                case 5: {
                    this.cssSelector = new CssSelector();
                    this.selectors.add(this.cssSelector);
                    this.stateSelector();
                }
                case 22: {
                    continue block39;
                }
                case 4: 
                case 23: {
                    continue block39;
                }
                case 19: {
                    this.pseudoFnName = this.yytext(1, 1);
                    this.statePseudoFn();
                }
                case 24: {
                    continue block39;
                }
                case 12: {
                    this.cssSelector.setCombinator(Combinator.GENERAL_SIBLING);
                    this.stateReset();
                }
                case 25: {
                    continue block39;
                }
                case 10: {
                    this.stateSelector();
                }
                case 26: {
                    continue block39;
                }
                case 15: {
                    this.cssSelector.addPseudoFunctionSelector(this.pseudoFnName, this.yytext(0, 1));
                    this.stateSelector();
                }
                case 27: {
                    continue block39;
                }
                case 8: {
                    this.stateAttr();
                }
                case 28: {
                    continue block39;
                }
                case 18: {
                    this.cssSelector.addPseudoClassSelector(this.yytext(1));
                }
                case 29: {
                    continue block39;
                }
                case 7: {
                    throw new CSSellyException("Illegal character <" + this.yytext() + ">.", this.yystate(), this.line(), this.column());
                }
                case 30: {
                    continue block39;
                }
                case 6: {
                    this.yypushback(1);
                    this.stateCombinator();
                }
                case 31: {
                    continue block39;
                }
                case 2: {
                    this.cssSelector = new CssSelector(this.yytext());
                    this.selectors.add(this.cssSelector);
                    this.stateSelector();
                }
                case 32: {
                    continue block39;
                }
                case 3: {
                    this.cssSelector = new CssSelector();
                    this.selectors.add(this.cssSelector);
                    this.yypushback(1);
                    this.stateSelector();
                }
                case 33: {
                    continue block39;
                }
                case 1: {
                    this.cssSelector.setCombinator(Combinator.DESCENDANT);
                    this.stateReset();
                }
                case 34: {
                    continue block39;
                }
                case 16: {
                    this.cssSelector.addIdSelector(this.yytext(1));
                }
                case 35: {
                    continue block39;
                }
                case 17: {
                    this.cssSelector.addClassSelector(this.yytext(1));
                }
                case 36: {
                    continue block39;
                }
                case 11: {
                    throw new CSSellyException("Invalid combinator <" + this.yytext() + ">.", this.yystate(), this.line(), this.column());
                }
                case 37: {
                    continue block39;
                }
                case 13: {
                    this.cssSelector.setCombinator(Combinator.CHILD);
                    this.stateReset();
                }
                case 38: {
                    continue block39;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                this.zzDoEOF();
                return 0;
            }
            this.zzScanError(1);
        }
    }
}

