/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto;

import java.io.IOException;
import java.nio.CharBuffer;
import jodd.lagarto.LagartoException;
import jodd.lagarto.LagartoLexer;
import jodd.lagarto.Tag;
import jodd.lagarto.TagType;
import jodd.util.ArraysUtil;

class ParsedTag
implements Tag {
    private static final String ATTR_NAME_ID = "id";
    private String name;
    private int idNdx;
    private TagType type;
    private String tagStart;
    private String tagEnd;
    private int attributesCount;
    private String[] attrNames = new String[10];
    private String[] attrValues = new String[10];
    private final LagartoLexer lexer;
    private final CharBuffer input;
    private int position;
    private int length;
    private int deepLevel;
    private boolean modified;

    ParsedTag(LagartoLexer lexer, CharBuffer input) {
        this.lexer = lexer;
        this.input = input;
    }

    void startTag(String name) {
        this.name = name;
        this.idNdx = -1;
        this.attributesCount = 0;
    }

    void defineTag(TagType type, int start, int length) {
        this.type = type;
        this.position = start;
        this.length = length;
        this.modified = false;
        this.tagStart = type.getStartString();
        this.tagEnd = type.getEndString();
    }

    void increaseDeepLevel() {
        ++this.deepLevel;
    }

    void decreaseDeepLevel() {
        --this.deepLevel;
    }

    void setTagMarks(String start, String end) {
        this.tagStart = start;
        this.tagEnd = end;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        if (this.idNdx == -1) {
            return null;
        }
        return this.attrValues[this.idNdx];
    }

    public TagType getType() {
        return this.type;
    }

    public int getDeepLevel() {
        return this.deepLevel;
    }

    public int getAttributeCount() {
        return this.attributesCount;
    }

    public String getAttributeName(int index) {
        if (index >= this.attributesCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attrNames[index];
    }

    public String getAttributeValue(int index) {
        if (index >= this.attributesCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attrValues[index];
    }

    public String getAttributeValue(String name, boolean caseSensitive) {
        for (int i = 0; i < this.attributesCount; ++i) {
            String current = this.attrNames[i];
            if (!(caseSensitive ? name.equals(current) : name.equalsIgnoreCase(current))) continue;
            return this.attrValues[i];
        }
        return null;
    }

    public int getAttributeIndex(String name, boolean caseSensitive) {
        for (int i = 0; i < this.attributesCount; ++i) {
            String current = this.attrNames[i];
            if (!(caseSensitive ? name.equals(current) : name.equalsIgnoreCase(current))) continue;
            return i;
        }
        return -1;
    }

    public boolean hasAttribute(String name, boolean caseSensitive) {
        return this.getAttributeIndex(name, caseSensitive) > -1;
    }

    public int getTagPosition() {
        return this.position;
    }

    public int getTagLength() {
        return this.length;
    }

    public void setName(String tagName) {
        this.name = tagName;
        this.modified = true;
    }

    public void setType(TagType type) {
        this.type = type;
        this.modified = true;
        this.tagStart = type.getStartString();
        this.tagEnd = type.getEndString();
    }

    public void addAttribute(String name, String value) {
        this.ensureLength();
        this.attrNames[this.attributesCount] = name;
        this.setAttrVal(this.attributesCount, name, value);
        ++this.attributesCount;
        this.modified = true;
    }

    public void setAttribute(String name, boolean caseSensitive, String value) {
        int index = this.getAttributeIndex(name, caseSensitive);
        if (index == -1) {
            this.addAttribute(name, value);
        } else {
            this.setAttrVal(index, name, value);
        }
        this.modified = true;
    }

    public void setAttributeValue(int index, String value) {
        if (index >= this.attributesCount) {
            throw new IndexOutOfBoundsException();
        }
        this.setAttrVal(index, value);
        this.modified = true;
    }

    public void setAttributeValue(String name, boolean caseSensitive, String value) {
        int index = this.getAttributeIndex(name, caseSensitive);
        if (index != -1) {
            this.setAttrVal(index, name, value);
        }
        this.modified = true;
    }

    public void setAttributeName(int index, String name) {
        if (index >= this.attributesCount) {
            throw new IndexOutOfBoundsException();
        }
        this.attrNames[index] = name;
        this.modified = true;
    }

    public void removeAttribute(int index) {
        if (index >= this.attributesCount) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.attrNames, index + 1, this.attrNames, index, this.attributesCount - index);
        System.arraycopy(this.attrValues, index + 1, this.attrValues, index, this.attributesCount - index);
        --this.attributesCount;
        this.modified = true;
    }

    public void removeAttribute(String name, boolean caseSensitive) {
        int index = this.getAttributeIndex(name, caseSensitive);
        if (index != -1) {
            this.removeAttribute(index);
        }
        this.modified = true;
    }

    public void removeAttributes() {
        this.attributesCount = 0;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified() {
        this.modified = true;
    }

    private void ensureLength() {
        if (this.attributesCount + 1 >= this.attrNames.length) {
            this.attrNames = ArraysUtil.resize(this.attrNames, this.attributesCount * 2);
            this.attrValues = ArraysUtil.resize(this.attrValues, this.attributesCount * 2);
        }
    }

    private void setAttrVal(int index, String name, String value) {
        if (this.idNdx == -1 && name.equalsIgnoreCase(ATTR_NAME_ID)) {
            this.idNdx = index;
        }
        this.attrValues[index] = value;
    }

    private void setAttrVal(int index, String value) {
        this.attrValues[index] = value;
    }

    private void appendTo(Appendable out) {
        try {
            out.append(this.tagStart);
            out.append(this.name);
            if (this.attributesCount > 0) {
                for (int i = 0; i < this.attributesCount; ++i) {
                    out.append(' ');
                    out.append(this.attrNames[i]);
                    String value = this.attrValues[i];
                    if (value == null) continue;
                    out.append('=').append('\"');
                    out.append(value);
                    out.append('\"');
                }
            }
            out.append(this.tagEnd);
        }
        catch (IOException ioex) {
            throw new LagartoException(ioex);
        }
    }

    public void writeTo(Appendable out) throws IOException {
        this.writeTo(out, false);
    }

    public void writeTo(Appendable out, boolean forceBuild) throws IOException {
        if (this.modified) {
            forceBuild = true;
        }
        if (forceBuild) {
            this.appendTo(out);
        } else {
            out.append(this.input.subSequence(this.position, this.position + this.length));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.length);
        this.appendTo(sb);
        return sb.toString();
    }

    public LagartoLexer.Position calculateTagPosition() {
        LagartoLexer.Position position = this.lexer.currentPosition();
        int column = position.column;
        if (this.getName() != null) {
            column -= this.getName().length();
        }
        for (int i = 0; i < this.getAttributeCount(); ++i) {
            column -= this.getAttributeName(i).length();
            String value = this.getAttributeValue(i);
            if (value != null) {
                column -= value.length();
                --column;
            }
            --column;
        }
        int diff = position.column - column;
        position.column = column;
        position.offset -= diff;
        return position;
    }
}

