/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.memory;

import com.liferay.portal.cache.memory.MemoryPortalCache;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MemoryPortalCacheManager<K extends Serializable, V>
implements PortalCacheManager<K, V> {
    private int _cacheInitialCapacity = 10000;
    private int _cacheManagerInitialCapacity = 10000;
    private Map<String, PortalCache<K, V>> _portalCaches;

    public void afterPropertiesSet() {
        this._portalCaches = new ConcurrentHashMap<String, PortalCache<K, V>>(this._cacheManagerInitialCapacity);
    }

    public void clearAll() {
        this._portalCaches.clear();
    }

    public PortalCache<K, V> getCache(String name) {
        return this.getCache(name, false);
    }

    public PortalCache<K, V> getCache(String name, boolean blocking) {
        PortalCache<K, V> portalCache = this._portalCaches.get(name);
        if (portalCache == null) {
            portalCache = new MemoryPortalCache(name, this._cacheInitialCapacity);
            this._portalCaches.put(name, portalCache);
        }
        return portalCache;
    }

    public void reconfigureCaches(URL configurationURL) {
    }

    public void removeCache(String name) {
        this._portalCaches.remove(name);
    }

    public void setCacheInitialCapacity(int cacheInitialCapacity) {
        this._cacheInitialCapacity = cacheInitialCapacity;
    }

    public void setCacheManagerInitialCapacity(int cacheManagerInitialCapacity) {
        this._cacheManagerInitialCapacity = cacheManagerInitialCapacity;
    }
}

