/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.ActionResult;
import com.liferay.portal.kernel.portlet.LiferayPortletMode;
import com.liferay.portal.kernel.portlet.PortletContainer;
import com.liferay.portal.kernel.portlet.PortletContainerException;
import com.liferay.portal.kernel.portlet.PortletModeFactory;
import com.liferay.portal.kernel.portlet.WindowStateFactory;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.DirectRequestDispatcherFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletPreferencesIds;
import com.liferay.portal.model.PublicRenderParameter;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.PortletDisplayFactory;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.ActionRequestFactory;
import com.liferay.portlet.ActionRequestImpl;
import com.liferay.portlet.ActionResponseFactory;
import com.liferay.portlet.ActionResponseImpl;
import com.liferay.portlet.EventImpl;
import com.liferay.portlet.EventRequestFactory;
import com.liferay.portlet.EventRequestImpl;
import com.liferay.portlet.EventResponseFactory;
import com.liferay.portlet.EventResponseImpl;
import com.liferay.portlet.InvokerPortlet;
import com.liferay.portlet.InvokerPortletImpl;
import com.liferay.portlet.PortletConfigFactoryUtil;
import com.liferay.portlet.PortletInstanceFactoryUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.PortletQNameUtil;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.PublicRenderParametersPool;
import com.liferay.portlet.RenderParametersPool;
import com.liferay.portlet.ResourceRequestFactory;
import com.liferay.portlet.ResourceRequestImpl;
import com.liferay.portlet.ResourceResponseFactory;
import com.liferay.portlet.ResourceResponseImpl;
import com.liferay.util.SerializableUtil;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class PortletContainerImpl
implements PortletContainer {
    private static Log _log = LogFactoryUtil.getLog(PortletContainerImpl.class);

    public void preparePortlet(HttpServletRequest request, Portlet portlet) throws PortletContainerException {
        try {
            this._doPreparePortlet(request, portlet);
        }
        catch (Exception e2) {
            throw new PortletContainerException((Throwable)e2);
        }
    }

    public ActionResult processAction(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws PortletContainerException {
        try {
            return this._doProcessAction(request, response, portlet);
        }
        catch (Exception e2) {
            throw new PortletContainerException((Throwable)e2);
        }
    }

    public List<Event> processEvent(HttpServletRequest request, HttpServletResponse response, Portlet portlet, Layout layout, Event event) throws PortletContainerException {
        try {
            return this._doProcessEvent(request, response, portlet, layout, event);
        }
        catch (Exception e2) {
            throw new PortletContainerException((Throwable)e2);
        }
    }

    public void render(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws PortletContainerException {
        try {
            this._doRender(request, response, portlet);
        }
        catch (Exception e2) {
            throw new PortletContainerException((Throwable)e2);
        }
    }

    public void serveResource(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws PortletContainerException {
        try {
            this._doServeResource(request, response, portlet);
        }
        catch (Exception e2) {
            throw new PortletContainerException((Throwable)e2);
        }
    }

    protected long getScopeGroupId(HttpServletRequest request, Layout layout, String portletId) throws PortalException, SystemException {
        long scopeGroupId = 0L;
        Layout requestLayout = (Layout)request.getAttribute("LAYOUT");
        try {
            request.setAttribute("LAYOUT", (Object)layout);
            scopeGroupId = PortalUtil.getScopeGroupId((HttpServletRequest)request, (String)portletId);
        }
        finally {
            request.setAttribute("LAYOUT", (Object)requestLayout);
        }
        if (scopeGroupId <= 0L) {
            scopeGroupId = PortalUtil.getScopeGroupId((Layout)layout, (String)portletId);
        }
        return scopeGroupId;
    }

    protected void processPublicRenderParameters(HttpServletRequest request, Layout layout, Portlet portlet) {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Map<String, String[]> publicRenderParameters = PublicRenderParametersPool.get(request, layout.getPlid());
        Map parameters = request.getParameterMap();
        for (Map.Entry entry : parameters.entrySet()) {
            PublicRenderParameter publicRenderParameter;
            String name = (String)entry.getKey();
            QName qName = PortletQNameUtil.getQName((String)name);
            if (qName == null || (publicRenderParameter = portlet.getPublicRenderParameter(qName.getNamespaceURI(), qName.getLocalPart())) == null) continue;
            String publicRenderParameterName = PortletQNameUtil.getPublicRenderParameterName((QName)qName);
            if (name.startsWith("p_r_p_")) {
                Object[] oldValues;
                Object[] values = (String[])entry.getValue();
                if (themeDisplay.isLifecycleAction() && (oldValues = publicRenderParameters.get(publicRenderParameterName)) != null && oldValues.length != 0) {
                    values = (String[])ArrayUtil.append((Object[])values, (Object[])oldValues);
                }
                publicRenderParameters.put(publicRenderParameterName, (String[])values);
                continue;
            }
            publicRenderParameters.remove(publicRenderParameterName);
        }
    }

    protected Event serializeEvent(Event event, ClassLoader portletClassLoader) {
        Serializable value = event.getValue();
        if (value == null) {
            return event;
        }
        Class<?> valueClass = value.getClass();
        String valueClassName = valueClass.getName();
        try {
            Class<?> loadedValueClass = portletClassLoader.loadClass(valueClassName);
            if (loadedValueClass.equals(valueClass)) {
                return event;
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        byte[] serializedValue = SerializableUtil.serialize((Object)value);
        value = (Serializable)SerializableUtil.deserialize((byte[])serializedValue, (ClassLoader)portletClassLoader);
        return new EventImpl(event.getName(), event.getQName(), value);
    }

    private void _doPreparePortlet(HttpServletRequest request, Portlet portlet) throws Exception {
        User user = PortalUtil.getUser((HttpServletRequest)request);
        Layout layout = (Layout)request.getAttribute("LAYOUT");
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long scopeGroupId = PortalUtil.getScopeGroupId((HttpServletRequest)request, (String)portlet.getPortletId());
        themeDisplay.setScopeGroupId(scopeGroupId);
        long siteGroupId = 0L;
        siteGroupId = layout.isTypeControlPanel() ? PortalUtil.getSiteGroupId((long)scopeGroupId) : PortalUtil.getSiteGroupId((long)layout.getGroupId());
        themeDisplay.setSiteGroupId(siteGroupId);
        if (user != null) {
            HttpSession session = request.getSession();
            InvokerPortletImpl.clearResponse(session, layout.getPrimaryKey(), portlet.getPortletId(), LanguageUtil.getLanguageId((HttpServletRequest)request));
        }
        this.processPublicRenderParameters(request, layout, portlet);
        if (themeDisplay.isLifecycleRender() || themeDisplay.isLifecycleResource()) {
            WindowState windowState = WindowStateFactory.getWindowState((String)ParamUtil.getString((HttpServletRequest)request, (String)"p_p_state"));
            if (layout.isTypeControlPanel() && (windowState == null || windowState.equals((Object)WindowState.NORMAL) || Validator.isNull((String)windowState.toString()))) {
                windowState = WindowState.MAXIMIZED;
            }
            PortletMode portletMode = PortletModeFactory.getPortletMode((String)ParamUtil.getString((HttpServletRequest)request, (String)"p_p_mode"));
            PortalUtil.updateWindowState((String)portlet.getPortletId(), (User)user, (Layout)layout, (WindowState)windowState, (HttpServletRequest)request);
            PortalUtil.updatePortletMode((String)portlet.getPortletId(), (User)user, (Layout)layout, (PortletMode)portletMode, (HttpServletRequest)request);
        }
    }

    private ActionResult _doProcessAction(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws Exception {
        Layout layout = (Layout)request.getAttribute("LAYOUT");
        WindowState windowState = WindowStateFactory.getWindowState((String)ParamUtil.getString((HttpServletRequest)request, (String)"p_p_state"));
        if (layout.isTypeControlPanel() && (windowState == null || windowState.equals((Object)WindowState.NORMAL) || Validator.isNull((String)windowState.toString()))) {
            windowState = WindowState.MAXIMIZED;
        }
        PortletMode portletMode = PortletModeFactory.getPortletMode((String)ParamUtil.getString((HttpServletRequest)request, (String)"p_p_mode"));
        PortletPreferencesIds portletPreferencesIds = PortletPreferencesFactoryUtil.getPortletPreferencesIds((HttpServletRequest)request, (String)portlet.getPortletId());
        PortletPreferences portletPreferences = PortletPreferencesLocalServiceUtil.getStrictPreferences((PortletPreferencesIds)portletPreferencesIds);
        ServletContext servletContext = (ServletContext)request.getAttribute("CTX");
        InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        PortletContext portletContext = portletConfig.getPortletContext();
        String contentType = request.getHeader("Content-Type");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Content type " + contentType));
        }
        try {
            ActionRequestImpl actionRequestImpl = ActionRequestFactory.create(request, portlet, invokerPortlet, portletContext, windowState, portletMode, portletPreferences, layout.getPlid());
            User user = PortalUtil.getUser((HttpServletRequest)request);
            ActionResponseImpl actionResponseImpl = ActionResponseFactory.create(actionRequestImpl, response, portlet.getPortletId(), user, layout, windowState, portletMode);
            actionRequestImpl.defineObjects(portletConfig, (PortletResponse)actionResponseImpl);
            ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequestImpl);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
            invokerPortlet.processAction((ActionRequest)actionRequestImpl, (ActionResponse)actionResponseImpl);
            actionResponseImpl.transferHeaders(response);
            RenderParametersPool.put(request, layout.getPlid(), portlet.getPortletId(), actionResponseImpl.getRenderParameterMap());
            List<Event> events = actionResponseImpl.getEvents();
            String redirectLocation = actionResponseImpl.getRedirectLocation();
            if (Validator.isNull((String)redirectLocation) && portlet.isActionURLRedirect()) {
                PortletURLImpl portletURL = new PortletURLImpl((PortletRequest)actionRequestImpl, actionRequestImpl.getPortletName(), layout.getPlid(), "RENDER_PHASE");
                Map<String, String[]> renderParameters = actionResponseImpl.getRenderParameterMap();
                for (Map.Entry<String, String[]> entry : renderParameters.entrySet()) {
                    String key = entry.getKey();
                    String[] value = entry.getValue();
                    portletURL.setParameter(key, value);
                }
                redirectLocation = portletURL.toString();
            }
            ActionResult actionResult = new ActionResult(events, redirectLocation);
            return actionResult;
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
    }

    private List<Event> _doProcessEvent(HttpServletRequest request, HttpServletResponse response, Portlet portlet, Layout layout, Event event) throws Exception {
        ServletContext servletContext = (ServletContext)request.getAttribute("CTX");
        InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        PortletContext portletContext = portletConfig.getPortletContext();
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        WindowState windowState = null;
        windowState = layoutTypePortlet.hasStateMaxPortletId(portlet.getPortletId()) ? WindowState.MAXIMIZED : (layoutTypePortlet.hasStateMinPortletId(portlet.getPortletId()) ? WindowState.MINIMIZED : WindowState.NORMAL);
        PortletMode portletMode = null;
        portletMode = layoutTypePortlet.hasModeAboutPortletId(portlet.getPortletId()) ? LiferayPortletMode.ABOUT : (layoutTypePortlet.hasModeConfigPortletId(portlet.getPortletId()) ? LiferayPortletMode.CONFIG : (layoutTypePortlet.hasModeEditPortletId(portlet.getPortletId()) ? PortletMode.EDIT : (layoutTypePortlet.hasModeEditDefaultsPortletId(portlet.getPortletId()) ? LiferayPortletMode.EDIT_DEFAULTS : (layoutTypePortlet.hasModeEditGuestPortletId(portlet.getPortletId()) ? LiferayPortletMode.EDIT_GUEST : (layoutTypePortlet.hasModeHelpPortletId(portlet.getPortletId()) ? PortletMode.HELP : (layoutTypePortlet.hasModePreviewPortletId(portlet.getPortletId()) ? LiferayPortletMode.PREVIEW : (layoutTypePortlet.hasModePrintPortletId(portlet.getPortletId()) ? LiferayPortletMode.PRINT : PortletMode.VIEW)))))));
        long scopeGroupId = this.getScopeGroupId(request, layout, portlet.getPortletId());
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getPortletSetup((long)scopeGroupId, (Layout)layout, (String)portlet.getPortletId(), null);
        EventRequestImpl eventRequestImpl = EventRequestFactory.create(request, portlet, invokerPortlet, portletContext, windowState, portletMode, portletPreferences, layout.getPlid());
        eventRequestImpl.setEvent(this.serializeEvent(event, invokerPortlet.getPortletClassLoader()));
        User user = PortalUtil.getUser((HttpServletRequest)request);
        Layout requestLayout = (Layout)request.getAttribute("LAYOUT");
        EventResponseImpl eventResponseImpl = EventResponseFactory.create(eventRequestImpl, response, portlet.getPortletId(), user, requestLayout);
        eventRequestImpl.defineObjects(portletConfig, (PortletResponse)eventResponseImpl);
        try {
            invokerPortlet.processEvent((EventRequest)eventRequestImpl, (EventResponse)eventResponseImpl);
            if (eventResponseImpl.isCalledSetRenderParameter()) {
                HashMap<String, String[]> renderParameterMap = new HashMap<String, String[]>();
                renderParameterMap.putAll(eventResponseImpl.getRenderParameterMap());
                RenderParametersPool.put(request, requestLayout.getPlid(), portlet.getPortletId(), renderParameterMap);
            }
            List<Event> list = eventResponseImpl.getEvents();
            return list;
        }
        finally {
            eventRequestImpl.cleanUp();
        }
    }

    private void _doRender(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws Exception {
        PortletResponse portletResponse;
        String instanceId;
        if (portlet != null && portlet.isInstanceable() && !portlet.isAddDefaultResource() && !Validator.isPassword((String)(instanceId = portlet.getInstanceId()))) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Portlet " + portlet.getPortletId() + " is instanceable but does not have a valid " + "instance id"));
            }
            portlet = null;
        }
        if (portlet == null) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletPreferencesFactoryUtil.checkControlPanelPortletPreferences((ThemeDisplay)themeDisplay, (Portlet)portlet);
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        PortletDisplay portletDisplayClone = PortletDisplayFactory.create();
        portletDisplay.copyTo(portletDisplayClone);
        PortletConfig portletConfig = (PortletConfig)request.getAttribute("javax.portlet.config");
        PortletRequest portletRequest = (PortletRequest)request.getAttribute("javax.portlet.request");
        if (!(portletRequest instanceof RenderRequest)) {
            portletRequest = null;
        }
        if (!((portletResponse = (PortletResponse)request.getAttribute("javax.portlet.response")) instanceof RenderResponse)) {
            portletResponse = null;
        }
        String lifecycle = (String)request.getAttribute("javax.portlet.lifecycle_phase");
        request.setAttribute("RENDER_PORTLET", (Object)portlet);
        String path = (String)request.getAttribute("RENDER_PATH");
        if (path == null) {
            path = "/html/portal/render_portlet.jsp";
        }
        RequestDispatcher requestDispatcher = DirectRequestDispatcherFactoryUtil.getRequestDispatcher((ServletRequest)request, (String)path);
        BufferCacheServletResponse bufferCacheServletResponse = null;
        boolean writeOutput = false;
        if (response instanceof BufferCacheServletResponse) {
            bufferCacheServletResponse = (BufferCacheServletResponse)response;
        } else {
            writeOutput = true;
            bufferCacheServletResponse = new BufferCacheServletResponse(response);
        }
        try {
            requestDispatcher.include((ServletRequest)request, (ServletResponse)bufferCacheServletResponse);
            Boolean portletConfiguratorVisibility = (Boolean)request.getAttribute("PORTLET_CONFIGURATOR_VISIBILITY");
            if (portletConfiguratorVisibility != null) {
                request.removeAttribute("PORTLET_CONFIGURATOR_VISIBILITY");
                Layout layout = themeDisplay.getLayout();
                if (!(layout.isTypeControlPanel() || LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)"UPDATE") || PortletPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)portlet.getPortletId(), (String)"CONFIGURATION"))) {
                    bufferCacheServletResponse.setCharBuffer(null);
                    return;
                }
            }
            if (writeOutput) {
                PrintWriter writer = response.getWriter();
                ((Writer)writer).write(bufferCacheServletResponse.getString());
            }
        }
        finally {
            portletDisplay.copyFrom(portletDisplayClone);
            portletDisplayClone.recycle();
            if (portletConfig != null) {
                request.setAttribute("javax.portlet.config", (Object)portletConfig);
            }
            if (portletRequest != null) {
                request.setAttribute("javax.portlet.request", (Object)portletRequest);
            }
            if (portletResponse != null) {
                request.setAttribute("javax.portlet.response", (Object)portletResponse);
            }
            if (lifecycle != null) {
                request.setAttribute("javax.portlet.lifecycle_phase", (Object)lifecycle);
            }
            request.removeAttribute("RENDER_PORTLET");
        }
    }

    private void _doServeResource(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws Exception {
        WindowState windowState = (WindowState)request.getAttribute("WINDOW_STATE");
        PortletMode portletMode = PortletModeFactory.getPortletMode((String)ParamUtil.getString((HttpServletRequest)request, (String)"p_p_mode"));
        PortletPreferencesIds portletPreferencesIds = PortletPreferencesFactoryUtil.getPortletPreferencesIds((HttpServletRequest)request, (String)portlet.getPortletId());
        PortletPreferences portletPreferences = PortletPreferencesLocalServiceUtil.getStrictPreferences((PortletPreferencesIds)portletPreferencesIds);
        ServletContext servletContext = (ServletContext)request.getAttribute("CTX");
        InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        PortletContext portletContext = portletConfig.getPortletContext();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        Layout layout = (Layout)request.getAttribute("LAYOUT");
        String portletPrimaryKey = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portlet.getPortletId());
        portletDisplay.setControlPanelCategory(portlet.getControlPanelEntryCategory());
        portletDisplay.setId(portlet.getPortletId());
        portletDisplay.setInstanceId(portlet.getInstanceId());
        portletDisplay.setNamespace(PortalUtil.getPortletNamespace((String)portlet.getPortletId()));
        portletDisplay.setPortletName(portletConfig.getPortletName());
        portletDisplay.setResourcePK(portletPrimaryKey);
        portletDisplay.setRootPortletId(portlet.getRootPortletId());
        WebDAVStorage webDAVStorage = portlet.getWebDAVStorageInstance();
        if (webDAVStorage != null) {
            portletDisplay.setWebDAVEnabled(true);
        } else {
            portletDisplay.setWebDAVEnabled(false);
        }
        ResourceRequestImpl resourceRequestImpl = ResourceRequestFactory.create(request, portlet, invokerPortlet, portletContext, windowState, portletMode, portletPreferences, layout.getPlid());
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        ResourceResponseImpl resourceResponseImpl = ResourceResponseFactory.create(resourceRequestImpl, response, portlet.getPortletId(), companyId);
        resourceRequestImpl.defineObjects(portletConfig, (PortletResponse)resourceResponseImpl);
        try {
            ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)resourceRequestImpl);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
            invokerPortlet.serveResource((ResourceRequest)resourceRequestImpl, (ResourceResponse)resourceResponseImpl);
            resourceResponseImpl.transferHeaders(response);
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
    }
}

