/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.util;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.persistence.GroupActionableDynamicQuery;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.permission.BookmarksEntryPermission;
import com.liferay.portlet.bookmarks.service.persistence.BookmarksEntryActionableDynamicQuery;
import com.liferay.portlet.bookmarks.service.persistence.BookmarksFolderActionableDynamicQuery;
import java.util.Locale;
import javax.portlet.PortletURL;

public class BookmarksEntryIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{BookmarksEntry.class.getName()};
    public static final String PORTLET_ID = "28";

    public BookmarksEntryIndexer() {
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return BookmarksEntryPermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        this.addStatus(contextQuery, searchContext);
    }

    protected void doDelete(Object obj) throws Exception {
        BookmarksEntry entry = (BookmarksEntry)obj;
        this.deleteDocument(entry.getCompanyId(), entry.getEntryId());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        BookmarksEntry entry = (BookmarksEntry)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)entry);
        document.addText("description", entry.getDescription());
        document.addKeyword("folderId", entry.getFolderId());
        document.addText("title", entry.getName());
        document.addKeyword("treePath", StringUtil.split((String)entry.getTreePath(), (char)'/'));
        document.addText("url", entry.getUrl());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        String entryId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/bookmarks/view_entry");
        portletURL.setParameter("entryId", entryId);
        Summary summary = this.createSummary(document, "title", "url");
        summary.setPortletURL(portletURL);
        return summary;
    }

    protected void doReindex(Object obj) throws Exception {
        BookmarksEntry entry = (BookmarksEntry)obj;
        Document document = this.getDocument(entry);
        SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)entry.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        this.doReindex(entry);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexFolders(companyId);
        this.reindexRoot(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexEntries(long companyId, long groupId, final long folderId) throws PortalException, SystemException {
        BookmarksEntryActionableDynamicQuery actionableDynamicQuery = new BookmarksEntryActionableDynamicQuery(){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                Property folderIdProperty = PropertyFactoryUtil.forName((String)"folderId");
                dynamicQuery.add(folderIdProperty.eq((Object)folderId));
                Property statusProperty = PropertyFactoryUtil.forName((String)"status");
                Object[] statuses = new Integer[]{0, 8};
                dynamicQuery.add(statusProperty.in(statuses));
            }

            protected void performAction(Object object) throws PortalException {
                BookmarksEntry entry = (BookmarksEntry)object;
                Document document = BookmarksEntryIndexer.this.getDocument(entry);
                this.addDocument(document);
            }
        };
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setGroupId(groupId);
        actionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        actionableDynamicQuery.performActions();
    }

    protected void reindexFolders(final long companyId) throws PortalException, SystemException {
        BookmarksFolderActionableDynamicQuery actionableDynamicQuery = new BookmarksFolderActionableDynamicQuery(){

            protected void performAction(Object object) throws PortalException, SystemException {
                BookmarksFolder folder = (BookmarksFolder)object;
                long groupId = folder.getGroupId();
                long folderId = folder.getFolderId();
                BookmarksEntryIndexer.this.reindexEntries(companyId, groupId, folderId);
            }
        };
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.performActions();
    }

    protected void reindexRoot(final long companyId) throws PortalException, SystemException {
        GroupActionableDynamicQuery actionableDynamicQuery = new GroupActionableDynamicQuery(){

            protected void performAction(Object object) throws PortalException, SystemException {
                Group group = (Group)object;
                long groupId = group.getGroupId();
                long folderId = 0L;
                BookmarksEntryIndexer.this.reindexEntries(companyId, groupId, folderId);
            }
        };
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.performActions();
    }
}

