/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalServiceUtil;

public class DLFileEntryTypePermission {
    public static void check(PermissionChecker permissionChecker, DLFileEntryType fileEntryType, String actionId) throws PortalException {
        if (!DLFileEntryTypePermission.contains(permissionChecker, fileEntryType, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long fileEntryTypeId, String actionId) throws PortalException, SystemException {
        if (!DLFileEntryTypePermission.contains(permissionChecker, fileEntryTypeId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, DLFileEntryType fileEntryType, String actionId) {
        Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)fileEntryType.getGroupId(), (String)DLFileEntryType.class.getName(), (long)fileEntryType.getFileEntryTypeId(), (String)"20", (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        if (permissionChecker.hasOwnerPermission(fileEntryType.getCompanyId(), DLFileEntryType.class.getName(), fileEntryType.getFileEntryTypeId(), fileEntryType.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(fileEntryType.getGroupId(), DLFileEntryType.class.getName(), fileEntryType.getFileEntryTypeId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long fileEntryTypeId, String actionId) throws PortalException, SystemException {
        DLFileEntryType fileEntryType = DLFileEntryTypeLocalServiceUtil.getFileEntryType((long)fileEntryTypeId);
        return DLFileEntryTypePermission.contains(permissionChecker, fileEntryType, actionId);
    }
}

