/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jbc.builder;

import java.util.Properties;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.jbc.CacheInstanceManager;
import org.hibernate.cache.jbc.util.CacheHelper;
import org.hibernate.cfg.Settings;
import org.hibernate.transaction.TransactionManagerLookup;
import org.hibernate.util.PropertiesHelper;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheManager;
import org.jboss.cache.CacheManagerImpl;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.config.Configuration;
import org.jgroups.ChannelFactory;
import org.jgroups.JChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiplexingCacheInstanceManager
implements CacheInstanceManager {
    private static final Logger log = LoggerFactory.getLogger(MultiplexingCacheInstanceManager.class);
    public static final String CACHE_FACTORY_RESOURCE_PROP = "hibernate.cache.jbc.configs";
    public static final String LEGACY_CACHE_FACTORY_RESOURCE_PROP = "hibernate.cache.region.jbc2.configs";
    public static final String CHANNEL_FACTORY_RESOURCE_PROP = "hibernate.cache.jbc.jgroups.stacks";
    public static final String LEGACY_CHANNEL_FACTORY_RESOURCE_PROP = "hibernate.cache.region.jbc2.cfg.jgroups.stacks";
    public static final String ENTITY_CACHE_RESOURCE_PROP = "hibernate.cache.jbc.cfg.entity";
    public static final String LEGACY_ENTITY_CACHE_RESOURCE_PROP = "hibernate.cache.region.jbc2.cfg.entity";
    public static final String COLLECTION_CACHE_RESOURCE_PROP = "hibernate.cache.jbc.cfg.collection";
    public static final String LEGACY_COLLECTION_CACHE_RESOURCE_PROP = "hibernate.cache.region.jbc2.cfg.collection";
    public static final String TIMESTAMP_CACHE_RESOURCE_PROP = "hibernate.cache.jbc.cfg.timestamps";
    public static final String LEGACY_TIMESTAMP_CACHE_RESOURCE_PROP = "hibernate.cache.region.jbc2.cfg.ts";
    public static final String QUERY_CACHE_RESOURCE_PROP = "hibernate.cache.jbc.cfg.query";
    public static final String LEGACY_QUERY_CACHE_RESOURCE_PROP = "hibernate.cache.region.jbc2.cfg.query";
    public static final String DEF_CACHE_FACTORY_RESOURCE = "org/hibernate/cache/jbc/builder/jbc-configs.xml";
    public static final String DEF_JGROUPS_RESOURCE = "org/hibernate/cache/jbc/builder/jgroups-stacks.xml";
    public static final String DEF_ENTITY_RESOURCE = "optimistic-entity";
    public static final String DEF_TS_RESOURCE = "timestamps-cache";
    public static final String DEF_QUERY_RESOURCE = "local-query";
    private Cache jbcEntityCache;
    private Cache jbcCollectionCache;
    private Cache jbcTsCache;
    private Cache jbcQueryCache;
    private String entityConfig = null;
    private String collectionConfig = null;
    private String queryConfig = null;
    private String tsConfig = null;
    private CacheManager jbcFactory;
    private ChannelFactory channelFactory;
    private boolean selfCreatedFactory;

    public MultiplexingCacheInstanceManager() {
    }

    public MultiplexingCacheInstanceManager(Cache jbcEntityCache, Cache jbcCollectionCache, Cache jbcTsCache, Cache jbcQueryCache) {
        this.jbcEntityCache = jbcEntityCache;
        this.jbcCollectionCache = jbcCollectionCache;
        this.jbcTsCache = jbcTsCache;
        this.jbcQueryCache = jbcQueryCache;
    }

    public CacheManager getCacheFactory() {
        return this.jbcFactory;
    }

    public void setCacheFactory(CacheManager factory) {
        this.jbcFactory = factory;
    }

    public ChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    public void setChannelFactory(ChannelFactory factory) {
        this.channelFactory = factory;
    }

    public Cache getEntityCacheInstance() {
        return this.jbcEntityCache;
    }

    public Cache getCollectionCacheInstance() {
        return this.jbcCollectionCache;
    }

    public Cache getQueryCacheInstance() {
        if (this.jbcQueryCache != null && this.jbcTsCache == null) {
            throw new CacheException("Timestamps cache must be configured if a query cache is used");
        }
        return this.jbcQueryCache;
    }

    public Cache getTimestampsCacheInstance() {
        if (this.jbcTsCache != null && CacheHelper.isClusteredInvalidation(this.jbcTsCache)) {
            throw new CacheException("Clustered invalidation not supported for timestamps cache");
        }
        return this.jbcTsCache;
    }

    public void start(Settings settings, Properties properties) throws CacheException {
        try {
            boolean buildCaches;
            TransactionManagerLookup tml = settings.getTransactionManagerLookup();
            TransactionManager tm = tml == null ? null : tml.getTransactionManager(properties);
            boolean bl = buildCaches = this.jbcEntityCache == null && this.jbcCollectionCache == null && this.jbcTsCache == null && this.jbcQueryCache == null;
            if (buildCaches && this.jbcFactory == null) {
                String factoryRes;
                if (this.channelFactory == null) {
                    String muxStacks = PropertiesHelper.getString(CHANNEL_FACTORY_RESOURCE_PROP, properties, null);
                    if (muxStacks == null) {
                        muxStacks = PropertiesHelper.getString(LEGACY_CHANNEL_FACTORY_RESOURCE_PROP, properties, DEF_JGROUPS_RESOURCE);
                    }
                    if (muxStacks != null) {
                        this.channelFactory = new JChannelFactory();
                        this.channelFactory.setMultiplexerConfig(muxStacks);
                    }
                }
                if ((factoryRes = PropertiesHelper.getString(CACHE_FACTORY_RESOURCE_PROP, properties, null)) == null) {
                    factoryRes = PropertiesHelper.getString(LEGACY_CACHE_FACTORY_RESOURCE_PROP, properties, DEF_CACHE_FACTORY_RESOURCE);
                }
                this.jbcFactory = new CacheManagerImpl(factoryRes, this.channelFactory);
                ((CacheManagerImpl)this.jbcFactory).start();
                this.selfCreatedFactory = true;
            }
            if (settings.isSecondLevelCacheEnabled()) {
                if (buildCaches) {
                    this.entityConfig = PropertiesHelper.getString(ENTITY_CACHE_RESOURCE_PROP, properties, null);
                    if (this.entityConfig == null) {
                        this.entityConfig = PropertiesHelper.getString(LEGACY_ENTITY_CACHE_RESOURCE_PROP, properties, DEF_ENTITY_RESOURCE);
                    }
                    this.jbcEntityCache = this.jbcFactory.getCache(this.entityConfig, true);
                    this.collectionConfig = PropertiesHelper.getString(COLLECTION_CACHE_RESOURCE_PROP, properties, null);
                    if (this.collectionConfig == null) {
                        this.collectionConfig = PropertiesHelper.getString(LEGACY_COLLECTION_CACHE_RESOURCE_PROP, properties, this.entityConfig);
                    }
                    this.jbcCollectionCache = this.entityConfig.equals(this.collectionConfig) ? this.jbcEntityCache : this.jbcFactory.getCache(this.collectionConfig, true);
                }
                if (this.jbcEntityCache != null) {
                    this.configureTransactionManager(this.jbcEntityCache, tm, false);
                    this.jbcEntityCache.start();
                }
                if (this.jbcCollectionCache != null) {
                    this.configureTransactionManager(this.jbcCollectionCache, tm, false);
                    this.jbcCollectionCache.start();
                }
            } else {
                this.jbcEntityCache = null;
                this.jbcCollectionCache = null;
            }
            if (settings.isQueryCacheEnabled()) {
                if (buildCaches) {
                    String dfltQueryResource = this.entityConfig == null ? DEF_QUERY_RESOURCE : this.entityConfig;
                    this.queryConfig = PropertiesHelper.getString(QUERY_CACHE_RESOURCE_PROP, properties, null);
                    if (this.queryConfig == null) {
                        this.queryConfig = PropertiesHelper.getString(LEGACY_QUERY_CACHE_RESOURCE_PROP, properties, dfltQueryResource);
                    }
                    this.jbcQueryCache = this.queryConfig.equals(this.entityConfig) ? this.jbcEntityCache : (this.queryConfig.equals(this.collectionConfig) ? this.jbcCollectionCache : this.jbcFactory.getCache(this.queryConfig, true));
                    this.tsConfig = PropertiesHelper.getString(TIMESTAMP_CACHE_RESOURCE_PROP, properties, null);
                    if (this.tsConfig == null) {
                        this.tsConfig = PropertiesHelper.getString(LEGACY_TIMESTAMP_CACHE_RESOURCE_PROP, properties, DEF_TS_RESOURCE);
                    }
                    this.jbcTsCache = this.tsConfig.equals(this.queryConfig) ? this.jbcQueryCache : (this.tsConfig.equals(this.entityConfig) ? this.jbcEntityCache : (this.tsConfig.equals(this.collectionConfig) ? this.jbcCollectionCache : this.jbcFactory.getCache(this.tsConfig, true)));
                }
                if (this.jbcQueryCache != null) {
                    this.configureTransactionManager(this.jbcQueryCache, tm, false);
                    this.jbcQueryCache.start();
                }
                if (this.jbcTsCache != null) {
                    this.configureTransactionManager(this.jbcTsCache, tm, true);
                    this.jbcTsCache.start();
                }
            } else {
                this.jbcTsCache = null;
                this.jbcQueryCache = null;
            }
        }
        catch (CacheException ce) {
            throw ce;
        }
        catch (Throwable t) {
            throw new CacheException("Unable to start region factory", t);
        }
    }

    public void stop() {
        this.releaseCaches();
        if (this.selfCreatedFactory) {
            ((CacheManagerImpl)this.jbcFactory).stop();
        }
    }

    private void configureTransactionManager(Cache cache, TransactionManager tm, boolean allowNull) {
        Configuration cacheConfig = cache.getConfiguration();
        TransactionManager cacheTm = cacheConfig.getRuntimeConfig().getTransactionManager();
        if (!this.safeEquals(tm, cacheTm)) {
            if (cache.getCacheStatus() != CacheStatus.INSTANTIATED) {
                if (!allowNull && cacheTm == null) {
                    throw new CacheException("JBoss Cache is already started with no transaction manager configured");
                }
                log.debug("JBoss Cache is already started with a transaction manager (" + cacheTm + ") that is not equal to our own (" + tm + ")");
            } else {
                cacheConfig.getRuntimeConfig().setTransactionManager(tm);
                if (tm == null) {
                    cacheConfig.setTransactionManagerLookupClass(null);
                }
            }
        }
    }

    private void releaseCaches() {
        if (this.jbcEntityCache != null && this.entityConfig != null) {
            try {
                this.jbcFactory.releaseCache(this.entityConfig);
                this.jbcEntityCache = null;
                if (this.entityConfig.equals(this.collectionConfig)) {
                    this.collectionConfig = null;
                }
                if (this.entityConfig.equals(this.queryConfig)) {
                    this.queryConfig = null;
                }
                if (this.entityConfig.equals(this.tsConfig)) {
                    this.tsConfig = null;
                }
                this.entityConfig = null;
            }
            catch (Throwable t) {
                log.info("Unable to release entity cache instance", t);
            }
        }
        if (this.jbcCollectionCache != null && this.collectionConfig != null) {
            try {
                this.jbcFactory.releaseCache(this.collectionConfig);
                this.jbcCollectionCache = null;
                if (this.collectionConfig.equals(this.queryConfig)) {
                    this.queryConfig = null;
                }
                if (this.collectionConfig.equals(this.tsConfig)) {
                    this.tsConfig = null;
                }
                this.collectionConfig = null;
            }
            catch (Throwable t) {
                log.info("Unable to stop collection cache instance", t);
            }
        }
        if (this.jbcQueryCache != null && this.queryConfig != null) {
            try {
                this.jbcFactory.releaseCache(this.queryConfig);
                this.jbcQueryCache = null;
                if (this.queryConfig.equals(this.tsConfig)) {
                    this.tsConfig = null;
                }
                this.queryConfig = null;
            }
            catch (Throwable t) {
                log.info("Unable to stop query cache instance", t);
            }
        }
        if (this.jbcTsCache != null && this.tsConfig != null) {
            try {
                this.jbcFactory.releaseCache(this.tsConfig);
                this.jbcTsCache = null;
                this.tsConfig = null;
            }
            catch (Throwable t) {
                log.info("Unable to stop timestamp cache instance", t);
            }
        }
    }

    private boolean safeEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }
}

