/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnBase;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionAccessor;
import org.hsqldb.ExpressionAggregate;
import org.hsqldb.ExpressionArithmetic;
import org.hsqldb.ExpressionArrayAggregate;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLike;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionOp;
import org.hsqldb.ExpressionOrderBy;
import org.hsqldb.ExpressionTable;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionCustom;
import org.hsqldb.FunctionSQL;
import org.hsqldb.FunctionSQLInvoked;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserBase;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.RangeVariableJoined;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.SqlInvariants;
import org.hsqldb.StatementCursor;
import org.hsqldb.StatementDMQL;
import org.hsqldb.StatementQuery;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.Token;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntKeyHashMap;
import org.hsqldb.result.ResultProperties;
import org.hsqldb.store.BitMap;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Collation;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.Type;
import org.hsqldb.types.Types;

public class ParserDQL
extends ParserBase {
    protected Database database;
    protected Session session;
    protected final CompileContext compileContext;
    HsqlException lastError;

    ParserDQL(Session session, Scanner t) {
        super(t);
        this.session = session;
        this.database = session.getDatabase();
        this.compileContext = new CompileContext(session, this);
    }

    void reset(String sql) {
        super.reset(sql);
        this.compileContext.reset();
        this.lastError = null;
    }

    void checkIsSchemaObjectName() {
        if (this.database.sqlEnforceNames) {
            this.checkIsNonReservedIdentifier();
        } else {
            this.checkIsNonCoreReservedIdentifier();
        }
    }

    Type readTypeDefinition(boolean allowCollation, boolean includeUserTypes) {
        int typeNumber = Integer.MIN_VALUE;
        boolean hasLength = false;
        boolean hasScale = false;
        boolean isCharacter = false;
        boolean readByteOrChar = false;
        this.checkIsIdentifier();
        if (this.token.namePrefix == null) {
            typeNumber = Type.getTypeNr(this.token.tokenString);
        }
        if (typeNumber == Integer.MIN_VALUE) {
            if (includeUserTypes) {
                this.checkIsSchemaObjectName();
                String schemaName = this.session.getSchemaName(this.token.namePrefix);
                Type type = this.database.schemaManager.getDomainOrUDT(this.token.tokenString, schemaName, false);
                if (type != null) {
                    this.getRecordedToken().setExpression(type);
                    this.compileContext.addSchemaObject(type);
                    this.read();
                    return type;
                }
            }
            if (this.token.namePrefix != null) {
                throw Error.error(5509, this.token.tokenString);
            }
            if (this.database.sqlSyntaxOra) {
                switch (this.token.tokenType) {
                    case 563: 
                    case 564: {
                        this.read();
                        return Type.SQL_DOUBLE;
                    }
                    case 601: {
                        this.read();
                        if (this.token.tokenType == 614) {
                            this.read();
                            return Type.getType(61, null, null, 0x1000000L, 0);
                        }
                        return Type.getType(12, null, null, 0x1000000L, 0);
                    }
                    case 452: {
                        this.read();
                        if (this.token.tokenType == 786) {
                            this.read();
                            int precision = this.readInteger();
                            int scale = 0;
                            if (this.token.tokenType == 774) {
                                this.read();
                                scale = this.readInteger();
                            }
                            this.readThis(772);
                            return Type.getType(3, null, null, precision, scale);
                        }
                        return Type.SQL_DECIMAL_DEFAULT;
                    }
                    case 614: {
                        typeNumber = -3;
                        break;
                    }
                    case 628: {
                        typeNumber = 12;
                        readByteOrChar = true;
                    }
                }
            }
            if (this.database.sqlSyntaxMys || this.database.sqlSyntaxPgs) {
                switch (this.token.tokenType) {
                    case 625: {
                        typeNumber = -1;
                        readByteOrChar = true;
                    }
                }
            }
            if (typeNumber == Integer.MIN_VALUE) {
                throw Error.error(5509, this.token.tokenString);
            }
        }
        this.read();
        switch (typeNumber) {
            case 1: {
                if (this.token.tokenType == 313) {
                    this.read();
                    typeNumber = 12;
                    break;
                }
                if (this.token.tokenType != 147) break;
                this.readThis(453);
                this.read();
                typeNumber = 40;
                break;
            }
            case 8: {
                if (this.token.tokenType != 212) break;
                this.read();
                break;
            }
            case 60: {
                if (this.token.tokenType == 313) {
                    this.read();
                    typeNumber = 61;
                    break;
                }
                if (this.token.tokenType != 147) break;
                this.readThis(453);
                this.read();
                typeNumber = 30;
                break;
            }
            case 14: {
                if (this.token.tokenType != 313) break;
                this.read();
                typeNumber = 15;
                break;
            }
            case 10: {
                return this.readIntervalType(false);
            }
        }
        long length = typeNumber == 93 ? 6L : 0L;
        int scale = 0;
        if (Types.requiresPrecision(typeNumber) && this.token.tokenType != 786 && this.database.sqlEnforceSize && !this.session.isProcessingScript) {
            throw Error.error(5599, Type.getDefaultType(typeNumber).getNameString());
        }
        if (Types.acceptsPrecision(typeNumber)) {
            if (this.token.tokenType == 786) {
                int multiplier = 1;
                this.read();
                block18 : switch (this.token.tokenType) {
                    case 845: {
                        if (this.token.dataType.typeCode == 4 || this.token.dataType.typeCode == 25) break;
                        throw this.unexpectedToken();
                    }
                    case 852: {
                        if (typeNumber == 30 || typeNumber == 40) {
                            switch (this.token.lobMultiplierType) {
                                case 426: {
                                    multiplier = 1024;
                                    break block18;
                                }
                                case 435: {
                                    multiplier = 0x100000;
                                    break block18;
                                }
                                case 405: {
                                    multiplier = 0x40000000;
                                    break block18;
                                }
                            }
                            throw this.unexpectedToken();
                        }
                        throw this.unexpectedToken(this.token.getFullString());
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                hasLength = true;
                length = ((Number)this.token.tokenValue).longValue();
                if (length < 0L || length == 0L && !Types.acceptsZeroPrecision(typeNumber)) {
                    throw Error.error(5592);
                }
                length *= (long)multiplier;
                this.read();
                if (typeNumber == 1 || typeNumber == 12 || typeNumber == 40) {
                    if (this.token.tokenType == 355) {
                        this.read();
                    } else if (this.token.tokenType == 454) {
                        this.read();
                        length /= 2L;
                    }
                }
                if (Types.acceptsScaleCreateParam(typeNumber) && this.token.tokenType == 774) {
                    this.read();
                    scale = this.readInteger();
                    if (scale < 0) {
                        throw Error.error(5592);
                    }
                    hasScale = true;
                }
                this.readThis(772);
            } else if (typeNumber == 14) {
                length = 1L;
            } else if (typeNumber == 30 || typeNumber == 40) {
                length = 0x1000000L;
            } else if (this.database.sqlEnforceSize && (typeNumber == 1 || typeNumber == 60)) {
                length = 1L;
            }
            if (typeNumber == 93 || typeNumber == 92) {
                if (length > 9L) {
                    throw Error.error(5592);
                }
                scale = (int)length;
                length = 0L;
                if (this.token.tokenType == 319) {
                    this.read();
                    this.readThis(281);
                    this.readThis(549);
                    typeNumber = typeNumber == 93 ? 95 : 94;
                } else if (this.token.tokenType == 321) {
                    this.read();
                    this.readThis(281);
                    this.readThis(549);
                }
            }
        }
        switch (typeNumber) {
            case -1: {
                typeNumber = this.database.sqlLongvarIsLob ? 40 : 12;
                if (hasLength) break;
                length = 0x1000000L;
                break;
            }
            case -4: {
                typeNumber = this.database.sqlLongvarIsLob ? 30 : 61;
                if (hasLength) break;
                length = 0x1000000L;
                break;
            }
            case 1: 
            case 40: 
            case 100: {
                isCharacter = true;
                break;
            }
            case 12: {
                isCharacter = true;
                if (hasLength) break;
                length = 32768L;
                break;
            }
            case 60: {
                break;
            }
            case 61: {
                if (hasLength) break;
                length = 32768L;
                break;
            }
            case 2: 
            case 3: {
                if (hasLength || hasScale || this.database.sqlEnforceSize) break;
                length = 128L;
                scale = 32;
            }
        }
        if (this.session.ignoreCase && typeNumber == 12) {
            typeNumber = 100;
        }
        if (readByteOrChar && !this.readIfThis(33)) {
            this.readIfThis(568);
        }
        Collation collation = this.database.collation;
        Charset charset = null;
        if (isCharacter) {
            if (this.token.tokenType == 35) {
                this.read();
                this.readThis(254);
                this.checkIsSchemaObjectName();
                String schemaName = this.session.getSchemaName(this.token.namePrefix);
                charset = (Charset)this.database.schemaManager.getSchemaObject(this.token.tokenString, schemaName, 14);
                this.read();
            }
            if (this.token.tokenType == 41) {
                this.read();
                this.checkIsSimpleName();
                try {
                    collation = Collation.getCollation(this.token.tokenString);
                }
                catch (HsqlException e) {
                    collation = (Collation)this.database.schemaManager.getSchemaObject(this.token.tokenString, null, 15);
                }
                this.read();
            }
        }
        Type typeObject = Type.getType(typeNumber, charset, collation, length, scale);
        if (this.token.tokenType == 8) {
            if (typeObject.isLobType()) {
                throw this.unexpectedToken();
            }
            this.read();
            int maxCardinality = 1024;
            if (this.token.tokenType == 781) {
                this.read();
                maxCardinality = this.readInteger();
                if (scale < 0) {
                    throw Error.error(5592);
                }
                this.readThis(790);
            }
            typeObject = new ArrayType(typeObject, maxCardinality);
        }
        return typeObject;
    }

    void readSimpleColumnNames(OrderedHashSet columns, RangeVariable rangeVar) {
        do {
            ColumnSchema col = this.readSimpleColumnName(rangeVar);
            if (columns.add(col.getName().name)) continue;
            throw Error.error(5579, col.getName().name);
        } while (this.readIfThis(774));
        if (this.token.tokenType != 772) {
            throw this.unexpectedToken();
        }
    }

    void readTargetSpecificationList(OrderedHashSet targets, RangeVariable[] rangeVars, LongDeque colIndexList) {
        do {
            Expression target;
            if (targets.add(target = this.XreadTargetSpecification(rangeVars, colIndexList))) continue;
            ColumnSchema col = target.getColumn();
            throw Error.error(5579, col.getName().name);
        } while (this.readIfThis(774));
        if (this.token.tokenType != 772 && this.token.tokenType != 115) {
            throw this.unexpectedToken();
        }
    }

    int[] readColumnList(Table table, boolean ascOrDesc) {
        OrderedHashSet set = this.readColumnNames(ascOrDesc);
        return table.getColumnIndexes(set);
    }

    void readSimpleColumnNames(OrderedHashSet columns, Table table) {
        do {
            ColumnSchema col = this.readSimpleColumnName(table);
            if (columns.add(col.getName().name)) continue;
            throw Error.error(5577, col.getName().name);
        } while (this.readIfThis(774));
        if (this.token.tokenType != 772) {
            throw this.unexpectedToken();
        }
    }

    HsqlNameManager.HsqlName[] readColumnNames(HsqlNameManager.HsqlName tableName) {
        BitMap quotedFlags = new BitMap(32);
        OrderedHashSet set = this.readColumnNames(quotedFlags, false);
        HsqlNameManager.HsqlName[] colList = new HsqlNameManager.HsqlName[set.size()];
        for (int i = 0; i < colList.length; ++i) {
            String name = (String)set.get(i);
            boolean quoted = quotedFlags.isSet(i);
            colList[i] = this.database.nameManager.newHsqlName(tableName.schema, name, quoted, 9, tableName);
        }
        return colList;
    }

    OrderedHashSet readColumnNames(boolean readAscDesc) {
        return this.readColumnNames(null, readAscDesc);
    }

    OrderedHashSet readColumnNames(BitMap quotedFlags, boolean readAscDesc) {
        this.readThis(786);
        OrderedHashSet set = new OrderedHashSet();
        this.readColumnNameList(set, quotedFlags, readAscDesc);
        this.readThis(772);
        return set;
    }

    void readColumnNameList(OrderedHashSet set, BitMap quotedFlags, boolean readAscDesc) {
        int i = 0;
        do {
            if (this.session.isProcessingScript) {
                if (!this.isSimpleName()) {
                    this.token.isDelimitedIdentifier = true;
                }
            } else {
                this.checkIsSimpleName();
            }
            if (!set.add(this.token.tokenString)) {
                throw Error.error(5577, this.token.tokenString);
            }
            if (quotedFlags != null && this.isDelimitedIdentifier()) {
                quotedFlags.set(i);
            }
            this.read();
            ++i;
            if (!readAscDesc || this.token.tokenType != 338 && this.token.tokenType != 389) continue;
            this.read();
        } while (this.readIfThis(774));
    }

    HsqlNameManager.SimpleName[] readColumnNameList(OrderedHashSet set) {
        BitMap columnNameQuoted = new BitMap(32);
        this.readThis(786);
        this.readColumnNameList(set, columnNameQuoted, false);
        this.readThis(772);
        HsqlNameManager.SimpleName[] columnNameList = new HsqlNameManager.SimpleName[set.size()];
        for (int i = 0; i < set.size(); ++i) {
            HsqlNameManager.SimpleName name;
            columnNameList[i] = name = HsqlNameManager.getSimpleName((String)set.get(i), columnNameQuoted.isSet(i));
        }
        return columnNameList;
    }

    int XreadUnionType() {
        int unionType = 0;
        switch (this.token.tokenType) {
            case 298: {
                this.read();
                unionType = 1;
                if (this.token.tokenType == 2) {
                    unionType = 2;
                    this.read();
                    break;
                }
                if (this.token.tokenType != 85) break;
                this.read();
                break;
            }
            case 138: {
                this.read();
                unionType = 3;
                if (this.token.tokenType == 2) {
                    unionType = 4;
                    this.read();
                    break;
                }
                if (this.token.tokenType != 85) break;
                this.read();
                break;
            }
            case 98: 
            case 607: {
                this.read();
                unionType = 6;
                if (this.token.tokenType == 2) {
                    unionType = 5;
                    this.read();
                    break;
                }
                if (this.token.tokenType != 85) break;
                this.read();
                break;
            }
        }
        return unionType;
    }

    void XreadUnionCorrespondingClause(QueryExpression queryExpression) {
        if (this.token.tokenType == 51) {
            this.read();
            queryExpression.setUnionCorresoponding();
            if (this.token.tokenType == 24) {
                this.read();
                OrderedHashSet names = this.readColumnNames(false);
                queryExpression.setUnionCorrespondingColumns(names);
            }
        }
    }

    QueryExpression XreadQueryExpression() {
        if (this.token.tokenType == 319) {
            this.read();
            boolean recursive = this.readIfThis(220);
            this.compileContext.initSubqueryNames();
            while (true) {
                this.checkIsSimpleName();
                HsqlNameManager.HsqlName[] nameList = null;
                HsqlNameManager.HsqlName queryName = this.database.nameManager.newHsqlName(this.token.tokenString, this.isDelimitedIdentifier(), 27);
                queryName.schema = SqlInvariants.SYSTEM_SUBQUERY_HSQLNAME;
                this.read();
                if (this.token.tokenType == 786) {
                    nameList = this.readColumnNames(queryName);
                } else if (recursive) {
                    super.unexpectedTokenRequire("(");
                }
                this.readThis(10);
                this.readThis(786);
                SubQuery subQuery = this.XreadTableNamedSubqueryBody(queryName, nameList, recursive ? 24 : 23);
                this.readThis(772);
                if (this.token.tokenType == 71) {
                    throw super.unsupportedFeature();
                }
                if (recursive && this.token.tokenType == 71) {
                    TableDerived table = subQuery.getTable();
                    int[] cycleColumnList = this.readColumnList(table, false);
                    this.readThis(254);
                    this.checkIsSimpleName();
                    HsqlNameManager.HsqlName name = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.token.isDelimitedIdentifier);
                    ColumnSchema cycleMarkColumn = new ColumnSchema(name, null, true, false, null);
                    if (table.getColumnIndex(name.name) != -1) {
                        throw Error.error(5578, this.token.tokenString);
                    }
                    this.read();
                    this.readThis(285);
                    String cycleMarkValue = this.readQuotedString();
                    if (cycleMarkValue.length() != 1) {
                        throw this.unexpectedToken(cycleMarkValue);
                    }
                    this.readThis(78);
                    String noncycleMarkValue = this.readQuotedString();
                    if (noncycleMarkValue.length() != 1) {
                        throw this.unexpectedToken(noncycleMarkValue);
                    }
                    if (cycleMarkValue.equals(noncycleMarkValue)) {
                        throw this.unexpectedToken(cycleMarkValue);
                    }
                    this.readThis(306);
                    this.checkIsSimpleName();
                    this.checkIsSimpleName();
                    name = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.token.isDelimitedIdentifier);
                    if (table.getColumnIndex(name.name) != -1) {
                        throw Error.error(5578, this.token.tokenString);
                    }
                    this.read();
                    ColumnSchema pathColumn = new ColumnSchema(name, null, true, false, null);
                }
                this.compileContext.registerSubquery(queryName.name, subQuery);
                if (this.token.tokenType != 774) break;
                this.read();
            }
        }
        QueryExpression queryExpression = this.XreadQueryExpressionBody();
        SortAndSlice sortAndSlice = this.XreadOrderByExpression();
        if (queryExpression.sortAndSlice == null) {
            queryExpression.addSortAndSlice(sortAndSlice);
        } else if (queryExpression.sortAndSlice.hasLimit()) {
            if (sortAndSlice.hasLimit()) {
                throw Error.error(5549);
            }
            for (int i = 0; i < sortAndSlice.exprList.size(); ++i) {
                Expression e = (Expression)sortAndSlice.exprList.get(i);
                queryExpression.sortAndSlice.addOrderExpression(e);
            }
        } else {
            queryExpression.addSortAndSlice(sortAndSlice);
        }
        return queryExpression;
    }

    QueryExpression XreadQueryExpressionBody() {
        QueryExpression queryExpression = this.XreadQueryTerm();
        block3: while (true) {
            switch (this.token.tokenType) {
                case 98: 
                case 298: 
                case 607: {
                    queryExpression = this.XreadSetOperation(queryExpression);
                    continue block3;
                }
            }
            break;
        }
        return queryExpression;
    }

    QueryExpression XreadQueryTerm() {
        QueryExpression queryExpression = this.XreadQueryPrimary();
        while (this.token.tokenType == 138) {
            queryExpression = this.XreadSetOperation(queryExpression);
        }
        return queryExpression;
    }

    private QueryExpression XreadSetOperation(QueryExpression queryExpression) {
        queryExpression = new QueryExpression(this.compileContext, queryExpression);
        int unionType = this.XreadUnionType();
        this.XreadUnionCorrespondingClause(queryExpression);
        QueryExpression rightQueryExpression = this.XreadQueryTerm();
        queryExpression.addUnion(rightQueryExpression, unionType);
        return queryExpression;
    }

    QueryExpression XreadQueryPrimary() {
        switch (this.token.tokenType) {
            case 251: 
            case 278: 
            case 308: {
                QuerySpecification select = this.XreadSimpleTable();
                return select;
            }
            case 786: {
                this.read();
                QueryExpression queryExpression = this.XreadQueryExpressionBody();
                SortAndSlice sortAndSlice = this.XreadOrderByExpression();
                this.readThis(772);
                if (queryExpression.sortAndSlice == null) {
                    queryExpression.addSortAndSlice(sortAndSlice);
                } else if (queryExpression.sortAndSlice.hasLimit()) {
                    if (sortAndSlice.hasLimit()) {
                        throw Error.error(5549);
                    }
                    for (int i = 0; i < sortAndSlice.exprList.size(); ++i) {
                        Expression e = (Expression)sortAndSlice.exprList.get(i);
                        queryExpression.sortAndSlice.addOrderExpression(e);
                    }
                } else {
                    queryExpression.addSortAndSlice(sortAndSlice);
                }
                return queryExpression;
            }
        }
        throw this.unexpectedToken();
    }

    QuerySpecification XreadSimpleTable() {
        QuerySpecification select;
        switch (this.token.tokenType) {
            case 278: {
                this.read();
                Table table = this.readTableName();
                if (table.isView()) {
                    table = ((View)table).getSubqueryTable();
                }
                select = new QuerySpecification(this.session, table, this.compileContext, false);
                break;
            }
            case 308: {
                this.read();
                SubQuery sq = this.XreadRowValueExpressionList();
                select = new QuerySpecification(this.session, sq.getTable(), this.compileContext, true);
                break;
            }
            case 251: {
                select = this.XreadQuerySpecification();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        return select;
    }

    QuerySpecification XreadQuerySpecification() {
        QuerySpecification select = this.XreadSelect();
        if (!select.isValueList) {
            this.XreadTableExpression(select);
        }
        return select;
    }

    void XreadTableExpression(QuerySpecification select) {
        this.XreadFromClause(select);
        this.readWhereGroupHaving(select);
    }

    QuerySpecification XreadSelect() {
        QuerySpecification select;
        block9: {
            SortAndSlice sortAndSlice;
            select = new QuerySpecification(this.compileContext);
            this.readThis(251);
            if ((this.token.tokenType == 725 || this.token.tokenType == 598) && (sortAndSlice = this.XreadTopOrLimit()) != null) {
                select.addSortAndSlice(sortAndSlice);
            }
            if (this.token.tokenType == 85) {
                select.isDistinctSelect = true;
                this.read();
            } else if (this.token.tokenType == 2) {
                this.read();
            }
            do {
                Expression e = this.XreadValueExpression();
                if (this.token.tokenType == 10) {
                    this.read();
                    this.checkIsNonCoreReservedIdentifier();
                }
                if (this.isNonCoreReservedIdentifier()) {
                    e.setAlias(HsqlNameManager.getSimpleName(this.token.tokenString, this.isDelimitedIdentifier()));
                    this.read();
                }
                select.addSelectColumnExpression(e);
                if (this.token.tokenType == 115 || this.token.tokenType == 141) break block9;
            } while (this.readIfThis(774));
            if ((this.token.tokenType == 772 || this.token.tokenType == 848) && (this.database.sqlSyntaxMss || this.database.sqlSyntaxMys || this.database.sqlSyntaxPgs)) {
                Expression[] exprList = new Expression[select.exprColumnList.size()];
                select.exprColumnList.toArray(exprList);
                Expression valueList = new Expression(26, exprList);
                for (int i = 0; i < valueList.nodes.length; ++i) {
                    if (valueList.nodes[i].opType == 25) continue;
                    valueList.nodes[i] = new Expression(25, new Expression[]{valueList.nodes[i]});
                }
                this.compileContext.subqueryDepth++;
                SubQuery sq = this.prepareSubquery(valueList);
                select = new QuerySpecification(this.session, sq.getTable(), this.compileContext, true);
                this.compileContext.subqueryDepth--;
                return select;
            }
            throw this.unexpectedToken();
        }
        return select;
    }

    void XreadFromClause(QuerySpecification select) {
        this.readThis(115);
        do {
            this.XreadTableReference(select);
        } while (this.readIfThis(774));
    }

    void XreadTableReference(QuerySpecification select) {
        boolean natural = false;
        RangeVariable range = this.readTableOrSubquery(null);
        select.addRangeVariable(range);
        block17: while (true) {
            boolean left = false;
            boolean right = false;
            boolean end = false;
            int type = this.token.tokenType;
            switch (this.token.tokenType) {
                case 132: {
                    this.read();
                    this.readThis(144);
                    break;
                }
                case 56: {
                    if (natural) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(144);
                    break;
                }
                case 298: {
                    if (natural) {
                        throw this.unexpectedToken();
                    }
                    int position = this.getPosition();
                    this.read();
                    if (this.token.tokenType == 144) {
                        this.read();
                        break;
                    }
                    this.rewind(position);
                    end = true;
                    break;
                }
                case 176: {
                    if (natural) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    natural = true;
                    continue block17;
                }
                case 153: {
                    this.read();
                    this.readIfThis(200);
                    this.readThis(144);
                    left = true;
                    break;
                }
                case 240: {
                    this.read();
                    this.readIfThis(200);
                    this.readThis(144);
                    right = true;
                    break;
                }
                case 116: {
                    this.read();
                    this.readIfThis(200);
                    this.readThis(144);
                    left = true;
                    right = true;
                    break;
                }
                case 144: {
                    this.read();
                    type = 132;
                    break;
                }
                case 774: {
                    if (natural) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    type = 774;
                    break;
                }
                default: {
                    if (natural) {
                        throw this.unexpectedToken();
                    }
                    end = true;
                }
            }
            if (end) break;
            range = this.readTableOrSubquery(null);
            Expression condition = null;
            switch (type) {
                case 774: {
                    range.isBoundary = true;
                    select.addRangeVariable(range);
                    break;
                }
                case 56: {
                    select.addRangeVariable(range);
                    break;
                }
                case 298: {
                    select.addRangeVariable(range);
                    condition = Expression.EXPR_FALSE;
                    range.setJoinType(true, true);
                    break;
                }
                case 116: 
                case 132: 
                case 153: 
                case 240: {
                    OrderedHashSet columns;
                    if (natural) {
                        columns = range.getUniqueColumnNameSet();
                        condition = select.getEquiJoinExpressions(columns, range, false);
                        select.addRangeVariable(range);
                    } else if (this.token.tokenType == 306) {
                        this.read();
                        columns = new OrderedHashSet();
                        this.readThis(786);
                        this.readSimpleColumnNames(columns, range);
                        this.readThis(772);
                        condition = select.getEquiJoinExpressions(columns, range, true);
                        select.addRangeVariable(range);
                    } else if (this.token.tokenType == 194) {
                        this.read();
                        condition = this.XreadBooleanValueExpression();
                        select.addRangeVariable(range);
                    } else {
                        throw this.unexpectedToken();
                    }
                    range.setJoinType(left, right);
                }
            }
            range.addJoinCondition(condition);
            natural = false;
        }
    }

    Expression getRowExpression(OrderedHashSet columnNames) {
        Expression[] elements = new Expression[columnNames.size()];
        for (int i = 0; i < elements.length; ++i) {
            String name = (String)columnNames.get(i);
            elements[i] = new ExpressionColumn(null, null, name);
        }
        return new Expression(25, elements);
    }

    void readWhereGroupHaving(QuerySpecification select) {
        Expression e;
        if (this.token.tokenType == 316) {
            this.read();
            e = this.XreadBooleanValueExpression();
            select.addQueryCondition(e);
        }
        if (this.token.tokenType == 122) {
            this.read();
            this.readThis(24);
            while (true) {
                e = this.XreadValueExpression();
                select.addGroupByColumnExpression(e);
                if (this.token.tokenType != 774) break;
                this.read();
            }
        }
        if (this.token.tokenType == 125) {
            this.read();
            e = this.XreadBooleanValueExpression();
            select.addHavingExpression(e);
        }
    }

    SortAndSlice XreadOrderByExpression() {
        SortAndSlice sortAndSlice = null;
        if (this.token.tokenType == 198) {
            this.read();
            this.readThis(24);
            sortAndSlice = this.XreadOrderBy();
        }
        if (this.token.tokenType == 598 || this.token.tokenType == 107 || this.token.tokenType == 192) {
            if (sortAndSlice == null) {
                sortAndSlice = new SortAndSlice();
            }
            this.XreadLimit(sortAndSlice);
        }
        return sortAndSlice == null ? SortAndSlice.noSort : sortAndSlice;
    }

    private SortAndSlice XreadTopOrLimit() {
        int position;
        Expression e1 = null;
        Expression e2 = null;
        if (this.token.tokenType == 598) {
            position = this.getPosition();
            this.read();
            e1 = this.XreadSimpleValueSpecificationOrNull();
            if (e1 == null) {
                this.rewind(position);
                return null;
            }
            e2 = this.XreadSimpleValueSpecificationOrNull();
            if (e2 == null) {
                throw Error.error(5563, 81);
            }
        } else if (this.token.tokenType == 725) {
            position = this.getPosition();
            this.read();
            e2 = this.XreadSimpleValueSpecificationOrNull();
            if (e2 == null) {
                this.rewind(position);
                return null;
            }
            e1 = new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER);
        }
        boolean valid = true;
        if (e1.isUnresolvedParam()) {
            e1.setDataType(this.session, Type.SQL_INTEGER);
        } else {
            boolean bl = valid = e1.getDataType().typeCode == 4 && (Integer)e1.getValue(null) >= 0;
        }
        if (e2.isUnresolvedParam()) {
            e2.setDataType(this.session, Type.SQL_INTEGER);
        } else {
            valid &= e2.getDataType().typeCode == 4 && (Integer)e2.getValue(null) >= 0;
        }
        if (valid) {
            SortAndSlice sortAndSlice = new SortAndSlice();
            sortAndSlice.addLimitCondition(new ExpressionOp(95, e1, e2));
            return sortAndSlice;
        }
        throw Error.error(5563, 81);
    }

    private void XreadLimit(SortAndSlice sortAndSlice) {
        Expression e1 = null;
        Expression e2 = null;
        if (this.token.tokenType == 192) {
            this.read();
            e1 = this.XreadSimpleValueSpecificationOrNull();
            if (e1 == null) {
                throw Error.error(5563, 81);
            }
            if (this.token.tokenType == 243 || this.token.tokenType == 245) {
                this.read();
            }
        }
        if (this.token.tokenType == 598) {
            this.read();
            e2 = this.XreadSimpleValueSpecificationOrNull();
            if (e2 == null) {
                throw Error.error(5563, 81);
            }
            if (e1 == null && this.token.tokenType == 192) {
                this.read();
                e1 = this.XreadSimpleValueSpecificationOrNull();
            }
        } else if (this.token.tokenType == 107) {
            this.read();
            if (this.token.tokenType == 401 || this.token.tokenType == 448) {
                this.read();
            }
            if ((e2 = this.XreadSimpleValueSpecificationOrNull()) == null) {
                e2 = new ExpressionValue(ValuePool.INTEGER_1, Type.SQL_INTEGER);
            }
            if (this.token.tokenType == 243 || this.token.tokenType == 245) {
                this.read();
            }
            this.readThis(195);
            sortAndSlice.setStrictLimit();
        }
        if (e1 == null) {
            e1 = new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER);
        }
        boolean valid = true;
        if (e1.isUnresolvedParam()) {
            e1.setDataType(this.session, Type.SQL_INTEGER);
        }
        if (e2 != null && e2.isUnresolvedParam()) {
            e2.setDataType(this.session, Type.SQL_INTEGER);
        }
        if (valid) {
            sortAndSlice.addLimitCondition(new ExpressionOp(95, e1, e2));
            return;
        }
        throw Error.error(5563, 81);
    }

    private SortAndSlice XreadOrderBy() {
        SortAndSlice sortAndSlice = new SortAndSlice();
        while (true) {
            Expression e = this.XreadValueExpression();
            ExpressionOrderBy o = new ExpressionOrderBy(e);
            if (this.token.tokenType == 389) {
                o.setDescending();
                this.read();
            } else if (this.token.tokenType == 338) {
                this.read();
            }
            if (this.token.tokenType == 451) {
                this.read();
                if (this.token.tokenType == 401) {
                    this.read();
                } else if (this.token.tokenType == 430) {
                    this.read();
                    o.setNullsLast();
                } else {
                    throw this.unexpectedToken();
                }
            }
            sortAndSlice.addOrderExpression(o);
            if (this.token.tokenType != 774) break;
            this.read();
        }
        return sortAndSlice;
    }

    protected RangeVariable readSimpleRangeVariable(int operation) {
        Table table = this.readTableName();
        HsqlNameManager.SimpleName alias = null;
        if (operation != 1205) {
            if (this.token.tokenType == 10) {
                this.read();
                this.checkIsNonCoreReservedIdentifier();
            }
            if (this.isNonCoreReservedIdentifier()) {
                alias = HsqlNameManager.getSimpleName(this.token.tokenString, this.isDelimitedIdentifier());
                this.read();
            }
        }
        if (table.isView) {
            switch (operation) {
                case 128: {
                    if (table.isTriggerUpdatable() && table.isTriggerDeletable() || table.isUpdatable() && table.isInsertable()) break;
                    throw Error.error(5545);
                }
                case 82: {
                    if (table.isTriggerUpdatable() || table.isUpdatable()) break;
                    throw Error.error(5545);
                }
                case 19: {
                    if (table.isTriggerDeletable() || table.isUpdatable()) break;
                    throw Error.error(5545);
                }
            }
            table = ((View)table).getSubqueryTable();
        }
        RangeVariable range = new RangeVariable(table, alias, null, null, this.compileContext);
        return range;
    }

    protected Table readNamedSubqueryOrNull() {
        if (!this.isSimpleName()) {
            return null;
        }
        SubQuery sq = this.compileContext.getNamedSubQuery(this.token.tokenString);
        if (sq == null) {
            return null;
        }
        this.read();
        return sq.getTable();
    }

    protected RangeVariable readTableOrSubquery(RangeVariable[] outerRanges) {
        Table table = null;
        HsqlNameManager.SimpleName alias = null;
        HsqlNameManager.SimpleName[] columnNameList = null;
        OrderedHashSet columnList = null;
        boolean joinedTable = false;
        switch (this.token.tokenType) {
            case 786: {
                table = this.XreadTableSubqueryOrNull(outerRanges);
                if (table != null) break;
                SubQuery sq = this.XreadJoinedTableAsSubquery();
                table = sq.getTable();
                joinedTable = true;
                break;
            }
            case 301: {
                Expression e = this.XreadCollectionDerivedTable();
                table = e.getTable();
                break;
            }
            case 149: {
                Expression e = this.XreadLateralDerivedTable();
                table = e.getTable();
                break;
            }
            case 278: {
                Expression e = this.XreadTableFunctionDerivedTable();
                table = e.getTable();
                break;
            }
            default: {
                table = this.readNamedSubqueryOrNull();
                if (table == null) {
                    table = this.readTableName();
                }
                if (!table.isView()) break;
                table = ((View)table).getSubqueryTable();
            }
        }
        boolean hasAs = false;
        if (this.token.tokenType == 10) {
            this.read();
            this.checkIsNonCoreReservedIdentifier();
            hasAs = true;
        }
        if (this.isNonCoreReservedIdentifier()) {
            boolean limit = this.token.tokenType == 598 || this.token.tokenType == 192 || this.token.tokenType == 107;
            boolean minus = this.token.tokenType == 607;
            int position = this.getPosition();
            alias = HsqlNameManager.getSimpleName(this.token.tokenString, this.isDelimitedIdentifier());
            this.read();
            if (this.token.tokenType == 786) {
                columnList = new OrderedHashSet();
                columnNameList = this.readColumnNameList(columnList);
            } else if (!hasAs && limit) {
                if (this.token.tokenType == 773 || this.token.tokenType == 788 || this.token.tokenType == 845) {
                    alias = null;
                    this.rewind(position);
                }
            } else if (!hasAs && minus) {
                this.rewind(position);
            }
        }
        RangeVariable range = joinedTable ? new RangeVariableJoined(table, alias, columnList, columnNameList, this.compileContext) : new RangeVariable(table, alias, columnList, columnNameList, this.compileContext);
        return range;
    }

    private Expression readAggregate() {
        int tokenT = this.token.tokenType;
        this.read();
        this.readThis(786);
        Expression e = this.readAggregateExpression(tokenT);
        this.readThis(772);
        this.readFilterClause(e);
        return e;
    }

    private void readFilterClause(Expression e) {
        int position = this.getPosition();
        if (this.token.tokenType == 108) {
            this.read();
            if (this.token.tokenType != 786) {
                this.rewind(position);
                return;
            }
            this.readThis(786);
            this.readThis(316);
            Expression condition = this.XreadBooleanValueExpression();
            e.setCondition(condition);
            this.readThis(772);
        }
    }

    private Expression readAggregateExpression(int tokenT) {
        int type = ParserDQL.getExpressionType(tokenT);
        boolean distinct = false;
        boolean all = false;
        SortAndSlice sort = null;
        String separator = null;
        if (this.token.tokenType == 85) {
            distinct = true;
            this.read();
        } else if (this.token.tokenType == 2) {
            all = true;
            this.read();
        }
        Expression e = this.XreadValueExpression();
        switch (type) {
            case 71: {
                if (e.getType() != 97) break;
                if (((ExpressionColumn)e).tableName != null) {
                    throw this.unexpectedToken();
                }
                if (all || distinct) {
                    throw this.unexpectedToken();
                }
                e.opType = 10;
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                if (!all && !distinct) break;
                throw Error.error(5582, all ? "ALL" : "DISTINCT");
            }
            case 82: 
            case 83: {
                if (this.token.tokenType == 198) {
                    this.read();
                    this.readThis(24);
                    sort = this.XreadOrderBy();
                }
                if (type == 83 && this.token.tokenType == 620) {
                    this.read();
                    super.checkIsValue(1);
                    separator = (String)this.token.tokenValue;
                    this.read();
                }
                return new ExpressionArrayAggregate(type, distinct, e, sort, separator);
            }
            case 85: {
                return new ExpressionArrayAggregate(type, distinct, e, sort, separator);
            }
            default: {
                if (e.getType() != 10) break;
                throw this.unexpectedToken();
            }
        }
        ExpressionAggregate aggregateExp = new ExpressionAggregate(type, distinct, e);
        return aggregateExp;
    }

    Expression XreadValueSpecificationOrNull() {
        Expression e = null;
        boolean minus = false;
        switch (this.token.tokenType) {
            case 787: {
                this.read();
                break;
            }
            case 784: {
                this.read();
                minus = true;
            }
        }
        e = this.XreadUnsignedValueSpecificationOrNull();
        if (e == null) {
            return null;
        }
        if (minus) {
            e = new ExpressionArithmetic(31, e);
        }
        return e;
    }

    Expression XreadUnsignedValueSpecificationOrNull() {
        switch (this.token.tokenType) {
            case 294: {
                this.read();
                return Expression.EXPR_TRUE;
            }
            case 106: {
                this.read();
                return Expression.EXPR_FALSE;
            }
            case 78: {
                if (!this.compileContext.contextuallyTypedExpression) break;
                this.read();
                ExpressionColumn e = new ExpressionColumn(4);
                return e;
            }
            case 186: {
                ExpressionValue e = new ExpressionValue(null, null);
                this.read();
                return e;
            }
            case 845: {
                ExpressionValue e = new ExpressionValue(this.token.tokenValue, this.token.dataType);
                this.read();
                return e;
            }
            case 846: 
            case 847: {
                if (!this.token.isHostParameter) {
                    return null;
                }
                return null;
            }
            case 773: {
                this.read();
                if (this.token.tokenType != 847 && this.token.tokenType != 846) {
                    throw this.unexpectedToken(":");
                }
            }
            case 788: {
                ExpressionColumn e = new ExpressionColumn(8);
                this.compileContext.addParameter(e, this.getPosition());
                this.read();
                return e;
            }
            case 358: {
                return this.XreadCurrentCollationSpec();
            }
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 253: 
            case 277: 
            case 305: 
            case 307: {
                FunctionSQL function = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                if (function == null) {
                    return null;
                }
                return this.readSQLFunction(function);
            }
        }
        return null;
    }

    Expression XreadSimpleValueSpecificationOrNull() {
        switch (this.token.tokenType) {
            case 845: {
                ExpressionValue e = new ExpressionValue(this.token.tokenValue, this.token.dataType);
                this.read();
                return e;
            }
            case 773: {
                this.read();
                if (this.token.tokenType != 847 && this.token.tokenType != 846) {
                    throw this.unexpectedToken(":");
                }
            }
            case 788: {
                ExpressionColumn e = new ExpressionColumn(8);
                this.compileContext.addParameter(e, this.getPosition());
                this.read();
                return e;
            }
            case 846: 
            case 847: {
                this.checkValidCatalogName(this.token.namePrePrePrefix);
                ExpressionColumn e = new ExpressionColumn(this.token.namePrePrefix, this.token.namePrefix, this.token.tokenString);
                this.read();
                return e;
            }
        }
        return null;
    }

    Expression XreadAllTypesValueExpressionPrimary(boolean boole) {
        Expression e = null;
        switch (this.token.tokenType) {
            case 101: 
            case 299: {
                if (!boole) break;
                return this.XreadPredicate();
            }
            case 243: {
                if (boole) break;
                this.read();
                this.readThis(786);
                e = this.XreadRowElementList(true);
                this.readThis(772);
                break;
            }
            default: {
                e = this.XreadSimpleValueExpressionPrimary();
                if (e == null) break;
                e = this.XreadArrayElementReference(e);
            }
        }
        if (e == null && this.token.tokenType == 786) {
            this.read();
            e = this.XreadRowElementList(true);
            this.readThis(772);
        }
        if (boole && e != null) {
            e = this.XreadPredicateRightPart(e);
        }
        return e;
    }

    Expression XreadValueExpressionPrimary() {
        Expression e = this.XreadSimpleValueExpressionPrimary();
        if (e != null) {
            e = this.XreadArrayElementReference(e);
            return e;
        }
        if (this.token.tokenType != 786) {
            return null;
        }
        this.read();
        e = this.XreadValueExpression();
        this.readThis(772);
        return e;
    }

    Expression XreadSimpleValueExpressionPrimary() {
        Expression e = this.XreadUnsignedValueSpecificationOrNull();
        if (e != null) {
            return e;
        }
        int position = this.getPosition();
        switch (this.token.tokenType) {
            case 786: {
                this.read();
                int subqueryPosition = this.getPosition();
                int brackets = this.readOpenBrackets();
                switch (this.token.tokenType) {
                    case 251: 
                    case 278: 
                    case 308: {
                        SubQuery sq = null;
                        this.rewind(subqueryPosition);
                        try {
                            sq = this.XreadSubqueryBody(21);
                            this.readThis(772);
                        }
                        catch (HsqlException ex) {
                            ex.setLevel(this.compileContext.subqueryDepth);
                            if (this.lastError == null || this.lastError.getLevel() < ex.getLevel()) {
                                this.lastError = ex;
                            }
                            this.rewind(position);
                            return null;
                        }
                        e = sq.queryExpression.isSingleColumn() ? new Expression(21, sq) : new Expression(22, sq);
                        if (this.readCloseBrackets(brackets) != brackets) {
                            throw this.unexpectedToken();
                        }
                        return e;
                    }
                }
                this.rewind(position);
                return null;
            }
            case 771: {
                e = new ExpressionColumn(this.token.namePrePrefix, this.token.namePrefix);
                this.getRecordedToken().setExpression(e);
                this.read();
                return e;
            }
            case 678: {
                return this.readLeastExpression();
            }
            case 668: {
                return this.readGreatestExpression();
            }
            case 663: {
                return this.readDecodeExpression();
            }
            case 643: {
                return this.readConcatExpression();
            }
            case 571: {
                return this.readCaseWhenExpression();
            }
            case 29: {
                return this.readCaseExpression();
            }
            case 187: {
                return this.readNullIfExpression();
            }
            case 40: 
            case 670: 
            case 676: {
                return this.readCoalesceExpression();
            }
            case 30: 
            case 49: {
                return this.readCastExpression();
            }
            case 72: 
            case 140: 
            case 281: 
            case 282: {
                e = this.readDateTimeIntervalLiteral();
                if (e == null) break;
                return e;
            }
            case 8: {
                return this.readCollection(19);
            }
            case 6: 
            case 9: 
            case 16: 
            case 52: 
            case 97: 
            case 163: 
            case 168: 
            case 258: 
            case 269: 
            case 270: 
            case 274: 
            case 309: 
            case 310: 
            case 604: 
            case 669: {
                return this.readAggregate();
            }
            case 448: {
                e = this.readSequenceExpressionOrNull(11);
                if (e == null) break;
                return e;
            }
            case 59: {
                e = this.readSequenceExpressionOrNull(12);
                if (e == null) break;
                return e;
            }
            case 579: {
                if (!this.database.sqlSyntaxPgs) break;
                this.read();
                this.readThis(786);
                String spec = this.readQuotedString();
                Scanner scanner = this.session.getScanner();
                scanner.reset(spec);
                scanner.scanNext();
                String schemaName = this.session.getSchemaName(scanner.token.namePrefix);
                NumberSequence sequence = this.database.schemaManager.getSequence(scanner.token.tokenString, schemaName, true);
                e = new ExpressionColumn(sequence, 12);
                this.readThis(772);
                return e;
            }
            case 597: {
                if (!this.database.sqlSyntaxPgs) break;
                this.read();
                this.readThis(786);
                this.readThis(772);
                return FunctionCustom.newCustomFunction("IDENTITY", 128);
            }
            case 609: {
                if (!this.database.sqlSyntaxPgs) break;
                this.read();
                this.readThis(786);
                String spec = this.readQuotedString();
                Scanner scanner = this.session.getScanner();
                scanner.reset(spec);
                scanner.scanNext();
                String schemaName = this.session.getSchemaName(scanner.token.namePrefix);
                NumberSequence sequence = this.database.schemaManager.getSequence(scanner.token.tokenString, schemaName, true);
                e = new ExpressionColumn(sequence, 11);
                this.readThis(772);
                return e;
            }
            case 153: 
            case 240: {
                break;
            }
            case 278: {
                this.read();
                this.readThis(786);
                SubQuery sq = this.XreadSubqueryBody(23);
                this.readThis(772);
                return new Expression(23, sq);
            }
            default: {
                if (!this.isCoreReservedKey()) break;
                throw this.unexpectedToken();
            }
        }
        if ((e = this.readColumnOrFunctionExpression()).isAggregate()) {
            this.readFilterClause(e);
        }
        return e;
    }

    Expression XreadAllTypesPrimary(boolean boole) {
        Expression e = null;
        switch (this.token.tokenType) {
            case 1: 
            case 27: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 103: 
            case 105: 
            case 111: 
            case 156: 
            case 161: 
            case 170: 
            case 182: 
            case 189: 
            case 190: 
            case 203: 
            case 209: 
            case 210: 
            case 211: 
            case 265: 
            case 272: 
            case 273: 
            case 288: 
            case 292: 
            case 304: 
            case 317: {
                FunctionSQL function = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                if (function == null) {
                    throw this.unsupportedFeature();
                }
                e = this.readSQLFunction(function);
                if (e != null) break;
            }
            default: {
                e = this.XreadAllTypesValueExpressionPrimary(boole);
            }
        }
        e = this.XreadModifier(e);
        return e;
    }

    Expression XreadModifier(Expression e) {
        switch (this.token.tokenType) {
            case 13: {
                this.read();
                Expression e1 = null;
                if (this.token.tokenType == 157) {
                    this.read();
                } else {
                    this.readThis(281);
                    this.readThis(549);
                    e1 = this.XreadValueExpressionPrimary();
                    switch (this.token.tokenType) {
                        case 73: 
                        case 127: 
                        case 169: 
                        case 173: 
                        case 250: 
                        case 323: {
                            IntervalType type = this.readIntervalType(false);
                            if (e1.getType() == 33) {
                                e1.dataType = type;
                                break;
                            }
                            e1 = new ExpressionOp(e1, type);
                        }
                    }
                }
                e = new ExpressionOp(92, e, e1);
                break;
            }
            case 73: 
            case 127: 
            case 169: 
            case 173: 
            case 250: 
            case 323: {
                IntervalType type = this.readIntervalType(true);
                if (e.getType() == 33) {
                    e.dataType = type;
                    break;
                }
                e = new ExpressionOp(e, type);
                break;
            }
            case 41: {
                Collation collation;
                this.read();
                if (this.token.namePrefix != null) break;
                try {
                    collation = Collation.getCollation(this.token.tokenString);
                }
                catch (HsqlException ex) {
                    collation = (Collation)this.database.schemaManager.getSchemaObject(this.session.getSchemaName(this.token.namePrefix), this.token.tokenString, 15);
                }
                e.setCollation(collation);
                this.read();
            }
        }
        return e;
    }

    Expression XreadValueExpressionWithContext() {
        this.compileContext.contextuallyTypedExpression = true;
        Expression e = this.XreadValueExpressionOrNull();
        this.compileContext.contextuallyTypedExpression = false;
        return e;
    }

    Expression XreadValueExpressionOrNull() {
        Expression e = this.XreadAllTypesCommonValueExpression(true);
        if (e == null) {
            return null;
        }
        return e;
    }

    Expression XreadValueExpression() {
        Expression e = this.XreadAllTypesCommonValueExpression(true);
        if (this.token.tokenType == 781) {
            this.read();
            Expression e1 = this.XreadNumericValueExpression();
            this.readThis(790);
            e = new ExpressionAccessor(e, e1);
        }
        return e;
    }

    Expression XreadRowOrCommonValueExpression() {
        return this.XreadAllTypesCommonValueExpression(false);
    }

    Expression XreadAllTypesCommonValueExpression(boolean boole) {
        Expression e = this.XreadAllTypesTerm(boole);
        int type = 0;
        boolean end = false;
        while (true) {
            switch (this.token.tokenType) {
                case 787: {
                    type = 32;
                    boole = false;
                    break;
                }
                case 784: {
                    type = 33;
                    boole = false;
                    break;
                }
                case 775: {
                    type = 36;
                    boole = false;
                    break;
                }
                case 197: {
                    if (boole) {
                        type = 50;
                        break;
                    }
                }
                default: {
                    end = true;
                }
            }
            if (end) break;
            this.read();
            Expression a = e;
            e = this.XreadAllTypesTerm(boole);
            e = boole ? new ExpressionLogical(type, a, e) : new ExpressionArithmetic(type, a, e);
        }
        return e;
    }

    Expression XreadAllTypesTerm(boolean boole) {
        Expression e = this.XreadAllTypesFactor(boole);
        int type = 0;
        boolean end = false;
        while (true) {
            switch (this.token.tokenType) {
                case 771: {
                    type = 34;
                    boole = false;
                    break;
                }
                case 776: {
                    type = 35;
                    boole = false;
                    break;
                }
                case 5: {
                    if (boole) {
                        type = 49;
                        break;
                    }
                }
                default: {
                    end = true;
                }
            }
            if (end) break;
            this.read();
            Expression a = e;
            e = this.XreadAllTypesFactor(boole);
            if (e == null) {
                throw this.unexpectedToken();
            }
            e = boole ? new ExpressionLogical(type, a, e) : new ExpressionArithmetic(type, a, e);
        }
        return e;
    }

    Expression XreadAllTypesFactor(boolean boole) {
        boolean minus = false;
        boolean not = false;
        boolean unknown = false;
        switch (this.token.tokenType) {
            case 787: {
                this.read();
                boole = false;
                break;
            }
            case 784: {
                this.read();
                boole = false;
                minus = true;
                break;
            }
            case 183: {
                if (!boole) break;
                this.read();
                not = true;
            }
        }
        Expression e = this.XreadAllTypesPrimary(boole);
        if (boole && this.token.tokenType == 142) {
            this.read();
            if (this.token.tokenType == 183) {
                this.read();
                boolean bl = not = !not;
            }
            if (this.token.tokenType == 294) {
                this.read();
            } else if (this.token.tokenType == 106) {
                this.read();
                not = !not;
            } else if (this.token.tokenType == 300) {
                this.read();
                unknown = true;
            } else {
                throw this.unexpectedToken();
            }
        }
        if (unknown) {
            e = new ExpressionLogical(47, e);
        } else if (minus) {
            e = new ExpressionArithmetic(31, e);
        } else if (not) {
            e = new ExpressionLogical(48, e);
        }
        return e;
    }

    Expression XreadStringValueExpression() {
        return this.XreadCharacterValueExpression();
    }

    Expression XreadCharacterValueExpression() {
        Expression e = this.XreadCharacterPrimary();
        SchemaObject collation = this.readCollateClauseOrNull();
        while (this.token.tokenType == 775) {
            this.read();
            Expression a = e;
            e = this.XreadCharacterPrimary();
            collation = this.readCollateClauseOrNull();
            e = new ExpressionArithmetic(36, a, e);
        }
        return e;
    }

    Expression XreadCharacterPrimary() {
        switch (this.token.tokenType) {
            case 161: 
            case 203: 
            case 272: 
            case 292: 
            case 304: {
                FunctionSQL function = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                Expression e = this.readSQLFunction(function);
                if (e == null) break;
                return e;
            }
        }
        return this.XreadValueExpressionPrimary();
    }

    Expression XreadNumericPrimary() {
        switch (this.token.tokenType) {
            case 1: 
            case 27: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 103: 
            case 105: 
            case 111: 
            case 156: 
            case 170: 
            case 190: 
            case 209: 
            case 211: 
            case 265: {
                FunctionSQL function = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                if (function == null) {
                    throw super.unexpectedToken();
                }
                Expression e = this.readSQLFunction(function);
                if (e == null) break;
                return e;
            }
        }
        return this.XreadValueExpressionPrimary();
    }

    Expression XreadNumericValueExpression() {
        Expression e = this.XreadTerm();
        while (true) {
            int type;
            if (this.token.tokenType == 787) {
                type = 32;
            } else {
                if (this.token.tokenType != 784) break;
                type = 33;
            }
            this.read();
            Expression a = e;
            e = this.XreadTerm();
            e = new ExpressionArithmetic(type, a, e);
        }
        return e;
    }

    Expression XreadTerm() {
        Expression e = this.XreadFactor();
        while (true) {
            int type;
            if (this.token.tokenType == 771) {
                type = 34;
            } else {
                if (this.token.tokenType != 776) break;
                type = 35;
            }
            this.read();
            Expression a = e;
            e = this.XreadFactor();
            if (e == null) {
                throw this.unexpectedToken();
            }
            e = new ExpressionArithmetic(type, a, e);
        }
        return e;
    }

    Expression XreadFactor() {
        boolean minus = false;
        if (this.token.tokenType == 787) {
            this.read();
        } else if (this.token.tokenType == 784) {
            this.read();
            minus = true;
        }
        Expression e = this.XreadNumericPrimary();
        if (e == null) {
            return null;
        }
        if (minus) {
            e = new ExpressionArithmetic(31, e);
        }
        return e;
    }

    Expression XreadDatetimeValueExpression() {
        Expression e = this.XreadDateTimeIntervalTerm();
        while (true) {
            int type;
            if (this.token.tokenType == 787) {
                type = 32;
            } else {
                if (this.token.tokenType != 784) break;
                type = 33;
            }
            this.read();
            Expression a = e;
            e = this.XreadDateTimeIntervalTerm();
            e = new ExpressionArithmetic(type, a, e);
        }
        return e;
    }

    Expression XreadIntervalValueExpression() {
        Expression e = this.XreadDateTimeIntervalTerm();
        while (true) {
            int type;
            if (this.token.tokenType == 787) {
                type = 32;
            } else {
                if (this.token.tokenType != 784) break;
                type = 33;
            }
            this.read();
            Expression a = e;
            e = this.XreadDateTimeIntervalTerm();
            e = new ExpressionArithmetic(type, a, e);
        }
        return e;
    }

    Expression XreadDateTimeIntervalTerm() {
        switch (this.token.tokenType) {
            case 1: 
            case 61: 
            case 66: 
            case 67: 
            case 158: 
            case 159: {
                FunctionSQL function = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                if (function == null) {
                    throw super.unexpectedToken();
                }
                return this.readSQLFunction(function);
            }
        }
        return this.XreadValueExpressionPrimary();
    }

    Expression XreadDateTimeValueFunctionOrNull() {
        FunctionSQL function = null;
        switch (this.token.tokenType) {
            case 61: 
            case 66: 
            case 67: 
            case 158: 
            case 159: {
                function = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                break;
            }
            case 692: 
            case 716: 
            case 724: {
                function = FunctionCustom.newCustomFunction(this.token.tokenString, this.token.tokenType);
                break;
            }
            default: {
                return null;
            }
        }
        if (function == null) {
            throw super.unexpectedToken();
        }
        return this.readSQLFunction(function);
    }

    Expression XreadBooleanValueExpression() {
        try {
            Expression e = this.XreadBooleanTermOrNull();
            if (e == null) {
                throw Error.error(5568);
            }
            while (this.token.tokenType == 197) {
                int type = 50;
                this.read();
                Expression a = e;
                e = this.XreadBooleanTermOrNull();
                if (e == null) {
                    throw Error.error(5568);
                }
                e = new ExpressionLogical(type, a, e);
            }
            if (e == null) {
                throw Error.error(5568);
            }
            return e;
        }
        catch (HsqlException ex) {
            ex.setLevel(this.compileContext.subqueryDepth);
            if (this.lastError != null && this.lastError.getLevel() >= ex.getLevel()) {
                ex = this.lastError;
                this.lastError = null;
            }
            throw ex;
        }
    }

    Expression XreadBooleanTermOrNull() {
        Expression e = this.XreadBooleanFactorOrNull();
        if (e == null) {
            return null;
        }
        while (this.token.tokenType == 5) {
            int type = 49;
            this.read();
            Expression a = e;
            e = this.XreadBooleanFactorOrNull();
            if (e == null) {
                throw this.unexpectedToken();
            }
            e = new ExpressionLogical(type, a, e);
        }
        return e;
    }

    Expression XreadBooleanFactorOrNull() {
        Expression e;
        boolean not = false;
        boolean unknown = false;
        if (this.token.tokenType == 183) {
            this.read();
            not = true;
        }
        if ((e = this.XreadBooleanPrimaryOrNull()) == null) {
            return null;
        }
        if (this.token.tokenType == 142) {
            this.read();
            if (this.token.tokenType == 183) {
                this.read();
                boolean bl = not = !not;
            }
            if (this.token.tokenType == 294) {
                this.read();
            } else if (this.token.tokenType == 106) {
                not = !not;
                this.read();
            } else if (this.token.tokenType == 300) {
                unknown = true;
                this.read();
            } else {
                throw this.unexpectedToken();
            }
        }
        if (unknown) {
            e = new ExpressionLogical(47, e);
        }
        if (not) {
            e = new ExpressionLogical(48, e);
        }
        return e;
    }

    Expression XreadBooleanPrimaryOrNull() {
        int position;
        Expression e = null;
        switch (this.token.tokenType) {
            case 101: 
            case 299: {
                return this.XreadPredicate();
            }
            case 243: {
                this.read();
                this.readThis(786);
                e = this.XreadRowElementList(true);
                this.readThis(772);
                break;
            }
            default: {
                position = this.getPosition();
                try {
                    e = this.XreadAllTypesCommonValueExpression(false);
                    break;
                }
                catch (HsqlException ex) {
                    ex.setLevel(this.compileContext.subqueryDepth);
                    if (this.lastError == null || this.lastError.getLevel() < ex.getLevel()) {
                        this.lastError = ex;
                    }
                    this.rewind(position);
                }
            }
        }
        if (e == null && this.token.tokenType == 786) {
            this.read();
            position = this.getPosition();
            try {
                e = this.XreadRowElementList(true);
                this.readThis(772);
            }
            catch (HsqlException ex) {
                ex.setLevel(this.compileContext.subqueryDepth);
                if (this.lastError == null || this.lastError.getLevel() < ex.getLevel()) {
                    this.lastError = ex;
                }
                this.rewind(position);
                e = this.XreadBooleanValueExpression();
                this.readThis(772);
            }
        }
        if (e != null) {
            e = this.XreadPredicateRightPart(e);
        }
        return e;
    }

    Expression XreadBooleanPredicand() {
        if (this.token.tokenType == 786) {
            this.read();
            Expression e = this.XreadBooleanValueExpression();
            this.readThis(772);
            return e;
        }
        Expression e = this.XreadSimpleValueExpressionPrimary();
        if (e != null) {
            e = this.XreadArrayElementReference(e);
        }
        return e;
    }

    Expression XreadPredicate() {
        switch (this.token.tokenType) {
            case 101: {
                this.read();
                Expression s = this.XreadTableSubquery(55);
                return new ExpressionLogical(55, s);
            }
            case 299: {
                this.read();
                Expression s = this.XreadTableSubquery(57);
                return new ExpressionLogical(57, s);
            }
        }
        Expression a = this.XreadRowValuePredicand();
        return this.XreadPredicateRightPart(a);
    }

    Expression XreadPredicateRightPart(Expression l) {
        boolean hasNot = false;
        ExpressionLogical e = null;
        if (this.token.tokenType == 183) {
            this.read();
            hasNot = true;
        }
        block0 : switch (this.token.tokenType) {
            case 142: {
                if (hasNot) {
                    throw this.unexpectedToken();
                }
                this.read();
                if (this.token.tokenType == 183) {
                    hasNot = true;
                    this.read();
                }
                if (this.token.tokenType == 85) {
                    this.read();
                    this.readThis(115);
                    Expression r = this.XreadRowValuePredicand();
                    e = new ExpressionLogical(58, l, r);
                    hasNot = !hasNot;
                    break;
                }
                if (this.token.tokenType == 186 || this.token.tokenType == 300) {
                    this.read();
                    e = new ExpressionLogical(47, l);
                    break;
                }
                throw this.unexpectedToken();
            }
            case 154: {
                e = this.XreadLikePredicateRightPart(l);
                e.noOptimisation = this.isCheckOrTriggerCondition;
                break;
            }
            case 18: {
                e = this.XreadBetweenPredicateRightPart(l);
                break;
            }
            case 130: {
                e = this.XreadInPredicateRightPart(l);
                e.noOptimisation = this.isCheckOrTriggerCondition;
                break;
            }
            case 202: {
                if (hasNot) {
                    throw this.unexpectedToken();
                }
                e = this.XreadOverlapsPredicateRightPart(l);
                break;
            }
            case 396: 
            case 779: 
            case 780: 
            case 782: 
            case 783: 
            case 785: {
                if (hasNot) {
                    throw this.unexpectedToken();
                }
                int type = ParserDQL.getExpressionType(this.token.tokenType);
                this.read();
                switch (this.token.tokenType) {
                    case 2: 
                    case 6: 
                    case 258: {
                        e = this.XreadQuantifiedComparisonRightPart(type, l);
                        break block0;
                    }
                }
                Expression row = this.XreadRowValuePredicand();
                e = new ExpressionLogical(type, l, row);
                break;
            }
            case 162: {
                e = this.XreadMatchPredicateRightPart(l);
                break;
            }
            default: {
                if (hasNot) {
                    throw this.unexpectedToken();
                }
                return l;
            }
        }
        if (hasNot) {
            e = new ExpressionLogical(48, (Expression)e);
        }
        return e;
    }

    private ExpressionLogical XreadBetweenPredicateRightPart(Expression a) {
        boolean symmetric = false;
        this.read();
        if (this.token.tokenType == 12) {
            this.read();
        } else if (this.token.tokenType == 275) {
            symmetric = true;
            this.read();
        }
        Expression left = this.XreadRowValuePredicand();
        this.readThis(5);
        Expression right = this.XreadRowValuePredicand();
        ExpressionLogical l = new ExpressionLogical(42, a, left);
        ExpressionLogical r = new ExpressionLogical(45, a, right);
        ExpressionLogical leftToRight = new ExpressionLogical(49, l, r);
        if (symmetric) {
            l = new ExpressionLogical(45, a, left);
            r = new ExpressionLogical(42, a, right);
            ExpressionLogical rightToLeft = new ExpressionLogical(49, l, r);
            return new ExpressionLogical(50, leftToRight, rightToLeft);
        }
        return leftToRight;
    }

    private ExpressionLogical XreadQuantifiedComparisonRightPart(int exprType, Expression l) {
        Expression e;
        int tokenT = this.token.tokenType;
        int exprSubType = 0;
        switch (this.token.tokenType) {
            case 6: 
            case 258: {
                exprSubType = 52;
                break;
            }
            case 2: {
                exprSubType = 51;
                break;
            }
            default: {
                throw Error.runtimeError(201, "ParserDQL");
            }
        }
        this.read();
        this.readThis(786);
        int position = this.getPosition();
        this.readOpenBrackets();
        switch (this.token.tokenType) {
            case 251: 
            case 278: 
            case 308: {
                this.rewind(position);
                SubQuery sq = this.XreadSubqueryBody(54);
                e = new Expression(23, sq);
                this.readThis(772);
                break;
            }
            default: {
                this.rewind(position);
                e = this.readAggregateExpression(tokenT);
                this.readThis(772);
                this.readFilterClause(e);
            }
        }
        ExpressionLogical r = new ExpressionLogical(exprType, l, e);
        r.setSubType(exprSubType);
        return r;
    }

    private ExpressionLogical XreadInPredicateRightPart(Expression l) {
        ExpressionLogical r;
        int degree = l.getDegree();
        Expression e = null;
        this.read();
        this.readThis(786);
        int position = this.getPosition();
        int brackets = this.readOpenBrackets();
        switch (this.token.tokenType) {
            case 301: {
                e = this.XreadCollectionDerivedTable();
                e.getTable().getSubQuery().setUniqueRows();
                this.readThis(772);
                this.readCloseBrackets(brackets);
                break;
            }
            case 251: 
            case 278: 
            case 308: {
                this.rewind(position);
                SubQuery sq = this.XreadSubqueryBody(54);
                e = new Expression(23, sq);
                this.readThis(772);
                break;
            }
            default: {
                this.rewind(position);
                e = this.XreadInValueListConstructor(degree);
                this.readThis(772);
            }
        }
        if (this.isCheckOrTriggerCondition) {
            r = new ExpressionLogical(54, l, e);
        } else {
            r = new ExpressionLogical(41, l, e);
            r.setSubType(52);
        }
        return r;
    }

    Expression XreadInValueList(int degree) {
        HsqlArrayList list = new HsqlArrayList();
        while (true) {
            Expression e;
            if ((e = this.XreadValueExpression()).getType() != 25) {
                e = new Expression(25, new Expression[]{e});
            }
            list.add(e);
            if (this.token.tokenType != 774) break;
            this.read();
        }
        Expression[] array = new Expression[list.size()];
        list.toArray(array);
        Expression e = new Expression(26, array);
        for (int i = 0; i < array.length; ++i) {
            Expression[] args;
            if (array[i].getType() != 25) {
                array[i] = new Expression(25, new Expression[]{array[i]});
            }
            if ((args = array[i].nodes).length != degree) {
                throw this.unexpectedToken();
            }
            for (int j = 0; j < degree; ++j) {
                if (args[j].getType() != 25) continue;
                throw this.unexpectedToken();
            }
        }
        return e;
    }

    private ExpressionLogical XreadLikePredicateRightPart(Expression a) {
        this.read();
        Expression b = this.XreadStringValueExpression();
        Expression escape = null;
        if (this.token.tokenString.equals("ESCAPE")) {
            this.read();
            escape = this.XreadStringValueExpression();
        }
        return new ExpressionLike(a, b, escape, this.isCheckOrTriggerCondition);
    }

    private ExpressionLogical XreadMatchPredicateRightPart(Expression a) {
        boolean isUnique = false;
        int matchType = 59;
        this.read();
        if (this.token.tokenType == 299) {
            this.read();
            isUnique = true;
        }
        if (this.token.tokenType == 511) {
            this.read();
            matchType = isUnique ? 62 : 59;
        } else if (this.token.tokenType == 470) {
            this.read();
            matchType = isUnique ? 63 : 60;
        } else if (this.token.tokenType == 116) {
            this.read();
            matchType = isUnique ? 64 : 61;
        }
        int mode = isUnique ? 23 : 54;
        Expression s = this.XreadTableSubquery(mode);
        return new ExpressionLogical(matchType, a, s);
    }

    private ExpressionLogical XreadOverlapsPredicateRightPart(Expression l) {
        if (l.getType() != 25) {
            throw Error.error(5564);
        }
        if (l.nodes.length != 2) {
            throw Error.error(5564);
        }
        this.read();
        if (this.token.tokenType != 786) {
            throw this.unexpectedToken();
        }
        Expression r = this.XreadRowValuePredicand();
        if (r.nodes.length != 2) {
            throw Error.error(5564);
        }
        return new ExpressionLogical(56, l, r);
    }

    Expression XreadRowValueExpression() {
        Expression e = this.XreadExplicitRowValueConstructorOrNull();
        if (e != null) {
            return e;
        }
        return this.XreadRowValueSpecialCase();
    }

    Expression XreadTableRowValueConstructor() {
        Expression e = this.XreadExplicitRowValueConstructorOrNull();
        if (e != null) {
            return e;
        }
        return this.XreadRowValueSpecialCase();
    }

    Expression XreadRowValuePredicand() {
        return this.XreadRowOrCommonValueExpression();
    }

    Expression XreadRowValueSpecialCase() {
        Expression e = this.XreadSimpleValueExpressionPrimary();
        if (e != null) {
            e = this.XreadArrayElementReference(e);
        }
        return e;
    }

    Expression XreadRowValueConstructor() {
        Expression e = this.XreadExplicitRowValueConstructorOrNull();
        if (e != null) {
            return e;
        }
        e = this.XreadRowOrCommonValueExpression();
        if (e != null) {
            return e;
        }
        return this.XreadBooleanValueExpression();
    }

    Expression XreadExplicitRowValueConstructorOrNull() {
        switch (this.token.tokenType) {
            case 786: {
                this.read();
                int position = this.getPosition();
                int brackets = this.readOpenBrackets();
                switch (this.token.tokenType) {
                    case 251: 
                    case 278: 
                    case 308: {
                        this.rewind(position);
                        SubQuery sq = this.XreadSubqueryBody(22);
                        this.readThis(772);
                        return new Expression(22, sq);
                    }
                }
                this.rewind(position);
                Expression e = this.XreadRowElementList(true);
                this.readThis(772);
                return e;
            }
            case 243: {
                this.read();
                this.readThis(786);
                Expression e = this.XreadRowElementList(false);
                this.readThis(772);
                return e;
            }
        }
        return null;
    }

    Expression XreadRowElementList(boolean multiple) {
        Expression e;
        HsqlArrayList list = new HsqlArrayList();
        while (true) {
            e = this.XreadValueExpression();
            list.add(e);
            if (this.token.tokenType != 774) break;
            this.read();
        }
        if (multiple && list.size() == 1) {
            return e;
        }
        Expression[] array = new Expression[list.size()];
        list.toArray(array);
        return new Expression(25, array);
    }

    Expression XreadCurrentCollationSpec() {
        throw Error.error(1500);
    }

    Expression XreadTableSubquery(int mode) {
        this.readThis(786);
        SubQuery sq = this.XreadSubqueryBody(mode);
        this.readThis(772);
        return new Expression(23, sq);
    }

    Table XreadTableSubqueryOrNull(RangeVariable[] outerRanges) {
        boolean joinedTable = false;
        int position = this.getPosition();
        this.readThis(786);
        this.readOpenBrackets();
        switch (this.token.tokenType) {
            case 251: 
            case 278: 
            case 308: 
            case 319: {
                break;
            }
            default: {
                joinedTable = true;
            }
        }
        this.rewind(position);
        if (joinedTable) {
            return null;
        }
        boolean hasOuter = outerRanges != null;
        this.readThis(786);
        SubQuery sq = this.XreadSubqueryBody(23);
        HsqlList unresolved = sq.queryExpression.getUnresolvedExpressions();
        if (hasOuter && unresolved != null) {
            unresolved = Expression.resolveColumnSet(this.session, outerRanges, outerRanges.length, sq.queryExpression.getUnresolvedExpressions(), null);
        }
        ExpressionColumn.checkColumnsResolved(unresolved);
        sq.queryExpression.resolveTypes(this.session);
        sq.prepareTable(this.session);
        this.readThis(772);
        return sq.getTable();
    }

    SubQuery XreadJoinedTableAsSubquery() {
        this.readThis(786);
        int position = this.getPosition();
        this.compileContext.subqueryDepth++;
        QuerySpecification querySpecification = this.XreadJoinedTableAsView();
        querySpecification.resolve(this.session);
        if (querySpecification.rangeVariables.length < 2) {
            throw this.unexpectedTokenRequire("JOIN");
        }
        SubQuery sq = new SubQuery(this.database, this.compileContext.subqueryDepth, (QueryExpression)querySpecification, 23);
        sq.sql = this.getLastPart(position);
        this.readThis(772);
        sq.prepareTable(this.session);
        this.compileContext.subqueryDepth--;
        return sq;
    }

    QuerySpecification XreadJoinedTableAsView() {
        QuerySpecification select = new QuerySpecification(this.compileContext);
        ExpressionColumn e = new ExpressionColumn(97);
        select.addSelectColumnExpression(e);
        this.XreadTableReference(select);
        return select;
    }

    SubQuery XreadTableNamedSubqueryBody(HsqlNameManager.HsqlName name, HsqlNameManager.HsqlName[] columnNames, int type) {
        switch (type) {
            case 24: {
                SubQuery sq = this.XreadRecursiveSubqueryBody(name, columnNames);
                return sq;
            }
            case 23: {
                SubQuery sq = this.XreadSubqueryBody(type);
                ExpressionColumn.checkColumnsResolved(sq.queryExpression.unresolvedExpressions);
                sq.queryExpression.resolveTypes(this.session);
                sq.prepareTable(this.session, name, columnNames);
                return sq;
            }
        }
        throw super.unexpectedToken();
    }

    SubQuery XreadRecursiveSubqueryBody(HsqlNameManager.HsqlName name, HsqlNameManager.HsqlName[] columnNames) {
        int position = this.getPosition();
        this.compileContext.subqueryDepth++;
        this.compileContext.subqueryDepth++;
        QueryExpression queryExpression = this.XreadSimpleTable();
        queryExpression.resolve(this.session);
        SubQuery sq = new SubQuery(this.database, this.compileContext.subqueryDepth, queryExpression, 23);
        this.compileContext.subqueryDepth--;
        sq.prepareTable(this.session, name, columnNames);
        this.compileContext.initSubqueryNames();
        this.compileContext.registerSubquery(name.name, sq);
        RangeVariable range = new RangeVariable(sq.getTable(), this.compileContext.getNextRangeVarIndex());
        RangeVariable[] ranges = new RangeVariable[]{range};
        if (this.token.tokenType != 298) {
            throw this.unexpectedTokenRequire("UNION");
        }
        int unionType = this.XreadUnionType();
        QuerySpecification rightQueryExpression = this.XreadSimpleTable();
        queryExpression = new QueryExpression(this.compileContext, queryExpression);
        ((QueryExpression)rightQueryExpression).resolveReferences(this.session, ranges);
        queryExpression.addUnion(rightQueryExpression, unionType);
        queryExpression.resolve(this.session);
        queryExpression.createTable(this.session);
        sq = new SubQuery(this.database, this.compileContext.subqueryDepth, queryExpression, sq);
        sq.prepareTable(this.session, name, columnNames);
        sq.sql = this.getLastPart(position);
        this.compileContext.subqueryDepth--;
        return sq;
    }

    SubQuery XreadSubqueryBody(int type) {
        int position = this.getPosition();
        this.compileContext.subqueryDepth++;
        QueryExpression queryExpression = this.XreadQueryExpression();
        queryExpression.resolveReferences(this.session, RangeVariable.emptyArray);
        SubQuery sq = new SubQuery(this.database, this.compileContext.subqueryDepth, queryExpression, type);
        sq.sql = this.getLastPart(position);
        this.compileContext.subqueryDepth--;
        return sq;
    }

    SubQuery XreadViewSubquery(View view) {
        QueryExpression queryExpression;
        this.compileContext.subqueryDepth++;
        try {
            queryExpression = this.XreadQueryExpression();
        }
        catch (HsqlException e) {
            queryExpression = this.XreadJoinedTableAsView();
        }
        queryExpression.setView(view);
        queryExpression.resolve(this.session);
        SubQuery sq = new SubQuery(this.database, this.compileContext.subqueryDepth, queryExpression, view);
        this.compileContext.subqueryDepth--;
        return sq;
    }

    Expression XreadContextuallyTypedTable(int degree) {
        int i;
        Expression e = this.readRow();
        Expression[] list = e.nodes;
        boolean isTable = false;
        if (degree == 1) {
            if (e.getType() == 25) {
                e.opType = 26;
                for (int i2 = 0; i2 < list.length; ++i2) {
                    if (list[i2].getType() != 25) {
                        list[i2] = new Expression(25, new Expression[]{list[i2]});
                        continue;
                    }
                    if (list[i2].nodes.length == degree) continue;
                    throw Error.error(5564);
                }
                return e;
            }
            e = new Expression(25, new Expression[]{e});
            e = new Expression(26, new Expression[]{e});
            return e;
        }
        if (e.getType() != 25) {
            throw Error.error(5564);
        }
        for (i = 0; i < list.length; ++i) {
            if (list[i].getType() != 25) continue;
            isTable = true;
            break;
        }
        if (isTable) {
            e.opType = 26;
            for (i = 0; i < list.length; ++i) {
                if (list[i].getType() != 25) {
                    throw Error.error(5564);
                }
                Expression[] args = list[i].nodes;
                if (args.length != degree) {
                    throw Error.error(5564);
                }
                for (int j = 0; j < degree; ++j) {
                    if (args[j].getType() != 25) continue;
                    throw Error.error(5564);
                }
            }
        } else {
            if (list.length != degree) {
                throw Error.error(5564);
            }
            e = new Expression(26, new Expression[]{e});
        }
        return e;
    }

    private Expression XreadInValueListConstructor(int degree) {
        int position = this.getPosition();
        this.compileContext.subqueryDepth++;
        Expression e = this.XreadInValueList(degree);
        SubQuery sq = new SubQuery(this.database, this.compileContext.subqueryDepth, e, 54);
        sq.sql = this.getLastPart(position);
        this.compileContext.subqueryDepth--;
        return e;
    }

    private SubQuery XreadRowValueExpressionList() {
        this.compileContext.subqueryDepth++;
        Expression e = this.XreadRowValueExpressionListBody();
        SubQuery sq = this.prepareSubquery(e);
        this.compileContext.subqueryDepth--;
        return sq;
    }

    private SubQuery prepareSubquery(Expression e) {
        HsqlList unresolved = e.resolveColumnReferences(this.session, RangeVariable.emptyArray, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        e.resolveTypes(this.session, null);
        e.prepareTable(this.session, null, e.nodes[0].nodes.length);
        SubQuery sq = new SubQuery(this.database, this.compileContext.subqueryDepth, e, 26);
        sq.prepareTable(this.session);
        return sq;
    }

    Expression XreadRowValueExpressionListBody() {
        Expression r = null;
        while (true) {
            int brackets = this.readOpenBrackets();
            Expression e = this.readRow();
            this.readCloseBrackets(brackets);
            if (r == null) {
                r = new Expression(25, new Expression[]{e});
            } else {
                r.nodes = (Expression[])ArrayUtil.resizeArray(r.nodes, r.nodes.length + 1);
                r.nodes[r.nodes.length - 1] = e;
            }
            if (this.token.tokenType != 774) break;
            this.read();
        }
        Expression[] list = r.nodes;
        int degree = 1;
        if (list[0].getType() == 25) {
            degree = list[0].nodes.length;
        }
        r.opType = 26;
        for (int i = 0; i < list.length; ++i) {
            if (list[i].getType() == 25) {
                if (list[i].nodes.length == degree) continue;
                throw Error.error(5564);
            }
            if (degree != 1) {
                throw Error.error(5564);
            }
            list[i] = new Expression(25, new Expression[]{list[i]});
        }
        return r;
    }

    Expression XreadTargetSpecification(RangeVariable[] rangeVars, LongDeque colIndexList) {
        ColumnBase column = null;
        int index = -1;
        this.checkIsIdentifier();
        if (this.token.namePrePrePrefix != null) {
            this.checkValidCatalogName(this.token.namePrePrePrefix);
        }
        for (int i = 0; i < rangeVars.length; ++i) {
            if (rangeVars[i] == null || (index = rangeVars[i].findColumn(this.token.tokenString)) <= -1 || !rangeVars[i].resolvesTableName(this.token.namePrefix) || !rangeVars[i].resolvesSchemaName(this.token.namePrePrefix)) continue;
            column = rangeVars[i].getColumn(index);
            this.read();
            break;
        }
        if (column == null) {
            throw Error.error(5501, this.token.tokenString);
        }
        colIndexList.add(index);
        if (this.token.tokenType == 781) {
            if (!column.getDataType().isArrayType()) {
                throw this.unexpectedToken();
            }
            this.read();
            Expression e = this.XreadNumericValueExpression();
            if (e == null) {
                throw Error.error(5501, this.token.tokenString);
            }
            e = new ExpressionAccessor(((ColumnSchema)column).getAccessor(), e);
            this.readThis(790);
            return e;
        }
        return ((ColumnSchema)column).getAccessor();
    }

    Expression XreadCollectionDerivedTable() {
        boolean ordinality = false;
        int position = this.getPosition();
        this.readThis(301);
        this.readThis(786);
        this.compileContext.subqueryDepth++;
        Expression e = this.XreadValueExpression();
        this.compileContext.subqueryDepth--;
        this.readThis(772);
        if (this.token.tokenType == 319) {
            this.read();
            this.readThis(458);
            ordinality = true;
        }
        e = new ExpressionTable(e, null, ordinality);
        SubQuery sq = new SubQuery(this.database, this.compileContext.subqueryDepth, e, 23);
        sq.createTable();
        sq.sql = this.getLastPart(position);
        return e;
    }

    Expression XreadTableFunctionDerivedTable() {
        int position = this.getPosition();
        this.readThis(278);
        this.readThis(786);
        this.compileContext.subqueryDepth++;
        Expression e = this.XreadValueExpression();
        if (e.getType() != 27 && e.getType() != 28) {
            this.compileContext.subqueryDepth--;
            throw this.unexpectedToken("TABLE");
        }
        this.readThis(772);
        e = new ExpressionTable(e, null, false);
        SubQuery sq = new SubQuery(this.database, this.compileContext.subqueryDepth, e, 23);
        sq.createTable();
        sq.sql = this.getLastPart(position);
        this.compileContext.subqueryDepth--;
        return e;
    }

    Expression XreadLateralDerivedTable() {
        this.readThis(149);
        this.readThis(786);
        int position = this.getPosition();
        this.compileContext.subqueryDepth++;
        QueryExpression queryExpression = this.XreadQueryExpression();
        SubQuery sq = new SubQuery(this.database, this.compileContext.subqueryDepth, queryExpression, 23);
        sq.createTable();
        sq.sql = this.getLastPart(position);
        this.compileContext.subqueryDepth--;
        this.readThis(772);
        return new Expression(23, sq);
    }

    Expression XreadArrayConstructor() {
        this.readThis(786);
        int position = this.getPosition();
        this.compileContext.subqueryDepth++;
        QueryExpression queryExpression = this.XreadQueryExpression();
        queryExpression.resolveReferences(this.session, RangeVariable.emptyArray);
        SubQuery sq = new SubQuery(this.database, this.compileContext.subqueryDepth, queryExpression, 23);
        sq.sql = this.getLastPart(position);
        this.compileContext.subqueryDepth--;
        this.readThis(772);
        return new Expression(100, sq);
    }

    SchemaObject readCollateClauseOrNull() {
        if (this.token.tokenType == 41) {
            this.read();
            SchemaObject collation = this.database.schemaManager.getSchemaObject(this.token.namePrefix, this.token.tokenString, 15);
            return collation;
        }
        return null;
    }

    Expression XreadArrayElementReference(Expression e) {
        if (this.token.tokenType == 781) {
            this.read();
            Expression e1 = this.XreadNumericValueExpression();
            this.readThis(790);
            e = new ExpressionAccessor(e, e1);
        }
        return e;
    }

    Expression readRow() {
        Expression r = null;
        while (true) {
            Expression e = this.XreadValueExpressionWithContext();
            if (r == null) {
                r = e;
            } else if (r.getType() == 25) {
                if (e.getType() == 25 && r.nodes[0].getType() != 25) {
                    r = new Expression(25, new Expression[]{r, e});
                } else {
                    r.nodes = (Expression[])ArrayUtil.resizeArray(r.nodes, r.nodes.length + 1);
                    r.nodes[r.nodes.length - 1] = e;
                }
            } else {
                r = new Expression(25, new Expression[]{r, e});
            }
            if (this.token.tokenType != 774) break;
            this.read();
        }
        return r;
    }

    Expression readCaseExpression() {
        Expression predicand = null;
        this.read();
        if (this.token.tokenType != 314) {
            predicand = this.XreadRowValuePredicand();
        }
        return this.readCaseWhen(predicand);
    }

    private Expression readCaseWhen(Expression l) {
        this.readThis(314);
        Expression condition = null;
        if (l == null) {
            condition = this.XreadBooleanValueExpression();
        } else {
            while (true) {
                Expression newCondition;
                if (l == (newCondition = this.XreadPredicateRightPart(l))) {
                    newCondition = new ExpressionLogical(l, this.XreadRowValuePredicand());
                }
                condition = condition == null ? newCondition : new ExpressionLogical(50, condition, newCondition);
                if (this.token.tokenType != 774) break;
                this.read();
            }
        }
        this.readThis(280);
        Expression current = this.XreadValueExpression();
        Expression elseExpr = null;
        if (this.token.tokenType == 314) {
            elseExpr = this.readCaseWhen(l);
        } else if (this.token.tokenType == 92) {
            this.read();
            elseExpr = this.XreadValueExpression();
            this.readThis(94);
            this.readIfThis(29);
        } else {
            elseExpr = new ExpressionValue(null, Type.SQL_ALL_TYPES);
            this.readThis(94);
            this.readIfThis(29);
        }
        ExpressionOp alternatives = new ExpressionOp(96, current, elseExpr);
        ExpressionOp casewhen = new ExpressionOp(93, condition, alternatives);
        return casewhen;
    }

    private Expression readCaseWhenExpression() {
        Expression l = null;
        this.read();
        this.readThis(786);
        l = this.XreadBooleanValueExpression();
        this.readThis(774);
        Expression thenelse = this.XreadValueExpression();
        this.readThis(774);
        thenelse = new ExpressionOp(96, thenelse, this.XreadValueExpression());
        l = new ExpressionOp(93, l, thenelse);
        this.readThis(772);
        return l;
    }

    private Expression readCastExpression() {
        Expression e;
        Type typeObject;
        boolean isConvert = this.token.tokenType == 49;
        this.read();
        this.readThis(786);
        if (isConvert) {
            if (this.database.sqlSyntaxMss) {
                typeObject = this.readTypeDefinition(false, true);
                this.readThis(774);
                e = this.XreadValueExpressionOrNull();
            } else {
                e = this.XreadValueExpressionOrNull();
                this.readThis(774);
                typeObject = Type.getTypeForJDBCConvertToken(this.token.tokenType);
                if (typeObject == null) {
                    typeObject = this.readTypeDefinition(false, true);
                } else {
                    this.read();
                }
            }
        } else {
            e = this.XreadValueExpressionOrNull();
            this.readThis(10);
            typeObject = this.readTypeDefinition(false, true);
        }
        if (e.isUnresolvedParam()) {
            e.setDataType(this.session, typeObject);
        } else {
            e = new ExpressionOp(e, typeObject);
        }
        this.readThis(772);
        return e;
    }

    private Expression readColumnOrFunctionExpression() {
        Expression e;
        String name = this.token.tokenString;
        boolean isSimpleQuoted = this.isDelimitedSimpleName();
        String prefix = this.token.namePrefix;
        String prePrefix = this.token.namePrePrefix;
        String prePrePrefix = this.token.namePrePrePrefix;
        Token recordedToken = this.getRecordedToken();
        this.checkIsIdentifier();
        if (this.isUndelimitedSimpleName()) {
            Expression e2;
            FunctionSQL function = FunctionCustom.newCustomFunction(this.token.tokenString, this.token.tokenType);
            if (function != null) {
                int pos = this.getPosition();
                try {
                    e = this.readSQLFunction(function);
                    if (e != null) {
                        return e;
                    }
                }
                catch (HsqlException ex) {
                    ex.setLevel(this.compileContext.subqueryDepth);
                    if (this.lastError == null || this.lastError.getLevel() < ex.getLevel()) {
                        this.lastError = ex;
                    }
                    this.rewind(pos);
                }
            } else if (this.isReservedKey() && (function = FunctionSQL.newSQLFunction(name, this.compileContext)) != null && (e2 = this.readSQLFunction(function)) != null) {
                return e2;
            }
        }
        this.read();
        if (this.token.tokenType != 786) {
            this.checkValidCatalogName(prePrePrefix);
            ExpressionColumn column = new ExpressionColumn(prePrefix, prefix, name);
            return column;
        }
        if (prePrePrefix != null) {
            throw Error.error(5551, prePrePrefix);
        }
        this.checkValidCatalogName(prePrefix);
        prefix = this.session.getSchemaName(prefix);
        RoutineSchema routineSchema = (RoutineSchema)this.database.schemaManager.findSchemaObject(name, prefix, 16);
        if (routineSchema == null && isSimpleQuoted) {
            HsqlNameManager.HsqlName schema = this.database.schemaManager.getDefaultSchemaHsqlName();
            routineSchema = (RoutineSchema)this.database.schemaManager.findSchemaObject(name, schema.name, 16);
            if (routineSchema == null) {
                Routine.createRoutines(this.session, schema, name);
                routineSchema = (RoutineSchema)this.database.schemaManager.findSchemaObject(name, schema.name, 16);
            }
        }
        if (routineSchema == null) {
            throw Error.error(5501, name);
        }
        HsqlArrayList list = new HsqlArrayList();
        this.readThis(786);
        if (this.token.tokenType == 772) {
            this.read();
        } else {
            while (true) {
                e = this.XreadValueExpression();
                list.add(e);
                if (this.token.tokenType != 774) break;
                this.read();
            }
            this.readThis(772);
        }
        FunctionSQLInvoked function = new FunctionSQLInvoked(routineSchema);
        Expression[] arguments = new Expression[list.size()];
        list.toArray(arguments);
        function.setArguments(arguments);
        this.compileContext.addFunctionCall(function);
        recordedToken.setExpression(routineSchema);
        return function;
    }

    Expression readCollection(int type) {
        this.read();
        if (this.token.tokenType == 786) {
            return this.XreadArrayConstructor();
        }
        this.readThis(781);
        HsqlArrayList list = new HsqlArrayList();
        int i = 0;
        while (true) {
            if (this.token.tokenType == 790) break;
            if (i > 0) {
                this.readThis(774);
            }
            Expression e = this.XreadValueExpressionOrNull();
            list.add(e);
            ++i;
        }
        this.read();
        Expression[] array = new Expression[list.size()];
        list.toArray(array);
        return new Expression(19, array);
    }

    private Expression readDecodeExpression() {
        ExpressionOp casewhen;
        block5: {
            this.read();
            this.readThis(786);
            casewhen = null;
            Expression alternative = null;
            Expression main = this.XreadValueExpression();
            this.readThis(774);
            while (true) {
                Expression v = this.XreadValueExpression();
                if (this.token.tokenType != 774) {
                    if (alternative == null) {
                        throw this.unexpectedToken();
                    }
                    alternative.setRightNode(v);
                    break block5;
                }
                this.readThis(774);
                ExpressionLogical l = new ExpressionLogical(main, v);
                Expression r = this.XreadValueExpression();
                ExpressionOp a = new ExpressionOp(96, r, null);
                ExpressionOp c = new ExpressionOp(93, l, a);
                if (casewhen == null) {
                    casewhen = c;
                } else {
                    alternative.setRightNode(c);
                }
                alternative = a;
                if (this.token.tokenType != 774) break;
                this.readThis(774);
            }
            alternative.setRightNode(new ExpressionValue(null, null));
        }
        this.readThis(772);
        return casewhen;
    }

    private Expression readConcatExpression() {
        this.read();
        this.readThis(786);
        Expression root = this.XreadValueExpression();
        this.readThis(774);
        while (true) {
            Expression r = this.XreadValueExpression();
            root = new ExpressionArithmetic(36, root, r);
            if (this.token.tokenType == 774) {
                this.readThis(774);
                continue;
            }
            if (this.token.tokenType == 772) break;
        }
        this.readThis(772);
        return root;
    }

    private Expression readLeastExpression() {
        this.read();
        this.readThis(786);
        Expression casewhen = null;
        while (true) {
            casewhen = this.readValue(casewhen, 44);
            if (this.token.tokenType != 774) break;
            this.readThis(774);
        }
        this.readThis(772);
        return casewhen;
    }

    private Expression readGreatestExpression() {
        this.read();
        this.readThis(786);
        Expression casewhen = null;
        while (true) {
            casewhen = this.readValue(casewhen, 43);
            if (this.token.tokenType != 774) break;
            this.readThis(774);
        }
        this.readThis(772);
        return casewhen;
    }

    private Expression readValue(Expression e, int opType) {
        Expression r = this.XreadValueExpression();
        if (e == null) {
            return r;
        }
        ExpressionLogical l = new ExpressionLogical(opType, e, r);
        ExpressionOp a = new ExpressionOp(96, e, r);
        return new ExpressionOp(93, l, a);
    }

    private Expression readNullIfExpression() {
        this.read();
        this.readThis(786);
        Expression c = this.XreadValueExpression();
        this.readThis(774);
        ExpressionOp thenelse = new ExpressionOp(96, new ExpressionValue(null, (Type)null), c);
        c = new ExpressionLogical(c, this.XreadValueExpression());
        c = new ExpressionOp(93, c, thenelse);
        this.readThis(772);
        return c;
    }

    private Expression readCoalesceExpression() {
        Expression current;
        ExpressionOp c = null;
        this.read();
        this.readThis(786);
        Expression leaf = null;
        while (true) {
            current = this.XreadValueExpression();
            if (leaf != null && this.token.tokenType == 772) break;
            ExpressionLogical condition = new ExpressionLogical(47, current);
            ExpressionOp alternatives = new ExpressionOp(96, new ExpressionValue(null, (Type)null), current);
            ExpressionOp casewhen = new ExpressionOp(38, condition, alternatives);
            if (c == null) {
                c = casewhen;
            } else {
                leaf.setLeftNode(casewhen);
            }
            leaf = alternatives;
            this.readThis(774);
        }
        this.readThis(772);
        leaf.setLeftNode(current);
        return c;
    }

    Expression readSQLFunction(FunctionSQL function) {
        int position = this.getPosition();
        this.read();
        short[] parseList = function.parseList;
        if (parseList.length == 0) {
            return function;
        }
        HsqlArrayList exprList = new HsqlArrayList();
        boolean isOpenBracket = this.token.tokenType == 786;
        try {
            this.readExpression(exprList, parseList, 0, parseList.length, false);
            this.lastError = null;
        }
        catch (HsqlException e) {
            if (!isOpenBracket) {
                this.rewind(position);
                return null;
            }
            if (function.parseListAlt == null) {
                throw e;
            }
            this.rewind(position);
            this.read();
            parseList = function.parseListAlt;
            exprList = new HsqlArrayList();
            this.readExpression(exprList, parseList, 0, parseList.length, false);
            this.lastError = null;
        }
        Expression[] expr = new Expression[exprList.size()];
        exprList.toArray(expr);
        function.setArguments(expr);
        return function.getFunctionExpression();
    }

    void readExpression(HsqlArrayList exprList, short[] parseList, int start, int count, boolean isOption) {
        block9: for (int i = start; i < start + count; ++i) {
            short exprType = parseList[i];
            switch (exprType) {
                case 788: {
                    Expression e = null;
                    e = this.XreadAllTypesCommonValueExpression(false);
                    exprList.add(e);
                    continue block9;
                }
                case 844: {
                    ExpressionValue e = null;
                    Integer value = this.readIntegerObject();
                    if (value < 0) {
                        throw Error.error(5592);
                    }
                    e = new ExpressionValue(value, Type.SQL_INTEGER);
                    exprList.add(e);
                    continue block9;
                }
                case 842: {
                    int expressionCount = exprList.size();
                    int position = this.getPosition();
                    int n = ++i;
                    ++i;
                    short elementCount = parseList[n];
                    int initialExprIndex = exprList.size();
                    try {
                        this.readExpression(exprList, parseList, i, elementCount, true);
                    }
                    catch (HsqlException ex) {
                        ex.setLevel(this.compileContext.subqueryDepth);
                        if (this.lastError == null || this.lastError.getLevel() < ex.getLevel()) {
                            this.lastError = ex;
                        }
                        this.rewind(position);
                        exprList.setSize(expressionCount);
                        for (int j = i; j < i + elementCount; ++j) {
                            if (parseList[j] != 788 && parseList[j] != 841 && parseList[j] != 844) continue;
                            exprList.add(null);
                        }
                        i += elementCount - 1;
                        continue block9;
                    }
                    if (initialExprIndex == exprList.size()) {
                        exprList.add(null);
                    }
                    i += elementCount - 1;
                    continue block9;
                }
                case 843: {
                    int initialExprIndex;
                    int n = ++i;
                    short elementCount = parseList[n];
                    int parseIndex = ++i;
                    do {
                        initialExprIndex = exprList.size();
                        this.readExpression(exprList, parseList, parseIndex, elementCount, true);
                    } while (exprList.size() != initialExprIndex);
                    i += elementCount - 1;
                    continue block9;
                }
                case 841: {
                    short elementCount = parseList[++i];
                    ExpressionValue e = null;
                    if (ArrayUtil.find(parseList, this.token.tokenType, i + 1, elementCount) == -1) {
                        if (!isOption) {
                            throw this.unexpectedToken();
                        }
                    } else {
                        e = new ExpressionValue(ValuePool.getInt(this.token.tokenType), Type.SQL_INTEGER);
                        this.read();
                    }
                    exprList.add(e);
                    i += elementCount;
                    continue block9;
                }
                default: {
                    if (this.token.tokenType != exprType) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    continue block9;
                }
            }
        }
    }

    private Expression readSequenceExpressionOrNull(int opType) {
        int position = this.getPosition();
        this.read();
        if (this.token.tokenType != 307) {
            this.rewind(position);
            return null;
        }
        this.readThis(307);
        this.readThis(112);
        this.checkIsSchemaObjectName();
        String schema = this.session.getSchemaName(this.token.namePrefix);
        NumberSequence sequence = this.database.schemaManager.getSequence(this.token.tokenString, schema, true);
        Token recordedToken = this.getRecordedToken();
        this.read();
        ExpressionColumn e = new ExpressionColumn(sequence, opType);
        recordedToken.setExpression(sequence);
        this.compileContext.addSequence(sequence);
        return e;
    }

    HsqlNameManager.SimpleName readSimpleName() {
        this.checkIsSimpleName();
        HsqlNameManager.SimpleName name = HsqlNameManager.getSimpleName(this.token.tokenString, this.isDelimitedIdentifier());
        this.read();
        return name;
    }

    HsqlNameManager.HsqlName readNewSchemaName() {
        this.checkIsSchemaObjectName();
        this.checkValidCatalogName(this.token.namePrefix);
        SqlInvariants.checkSchemaNameNotSystem(this.token.tokenString);
        HsqlNameManager.HsqlName name = this.database.nameManager.newHsqlName(this.token.tokenString, this.isDelimitedIdentifier(), 2);
        this.read();
        return name;
    }

    HsqlNameManager.HsqlName readNewSchemaObjectName(int type, boolean checkSchema) {
        this.checkIsSchemaObjectName();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(this.token.tokenString, this.isDelimitedIdentifier(), type);
        if (this.token.namePrefix != null) {
            switch (type) {
                case 1: 
                case 11: 
                case 21: 
                case 22: {
                    throw this.unexpectedToken();
                }
                case 19: {
                    if (this.token.namePrePrefix == null && "MODULE".equals(this.token.namePrefix) && !this.token.isDelimitedPrefix) break;
                    throw this.unexpectedTokenRequire("MODULE");
                }
                case 2: {
                    this.checkValidCatalogName(this.token.namePrefix);
                    if (this.token.namePrePrefix == null) break;
                    throw this.tooManyIdentifiers();
                }
                case 25: 
                case 26: {
                    this.checkValidCatalogName(this.token.namePrefix);
                    if (this.token.namePrePrefix == null) break;
                    throw this.tooManyIdentifiers();
                }
                case 9: {
                    if (this.token.namePrefix == null) break;
                    throw this.tooManyIdentifiers();
                }
                default: {
                    HsqlNameManager.HsqlName schemaName;
                    this.checkValidCatalogName(this.token.namePrePrefix);
                    if (checkSchema) {
                        schemaName = this.session.getSchemaHsqlName(this.token.namePrefix);
                    } else {
                        schemaName = this.session.database.schemaManager.findSchemaHsqlName(this.token.namePrefix);
                        if (schemaName == null) {
                            schemaName = this.database.nameManager.newHsqlName(this.token.namePrefix, this.isDelimitedIdentifier(), 2);
                        }
                    }
                    hsqlName.setSchemaIfNull(schemaName);
                    break;
                }
            }
        }
        this.read();
        return hsqlName;
    }

    HsqlNameManager.HsqlName readNewDependentSchemaObjectName(HsqlNameManager.HsqlName parentName, int type) {
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(type, true);
        name.parent = parentName;
        name.setSchemaIfNull(parentName.schema);
        if (name.schema != null && parentName.schema != null && name.schema != parentName.schema) {
            throw Error.error(5505, this.token.namePrefix);
        }
        return name;
    }

    HsqlNameManager.HsqlName readSchemaName() {
        this.checkIsSchemaObjectName();
        this.checkValidCatalogName(this.token.namePrefix);
        HsqlNameManager.HsqlName schema = this.session.getSchemaHsqlName(this.token.tokenString);
        this.read();
        return schema;
    }

    SchemaObject readSchemaObjectName(int type) {
        this.checkIsSchemaObjectName();
        this.checkValidCatalogName(this.token.namePrePrefix);
        String schema = this.session.getSchemaName(this.token.namePrefix);
        SchemaObject object = this.database.schemaManager.getSchemaObject(this.token.tokenString, schema, type);
        this.read();
        return object;
    }

    SchemaObject readSchemaObjectName(HsqlNameManager.HsqlName schemaName, int type) {
        this.checkIsSchemaObjectName();
        SchemaObject object = this.database.schemaManager.getSchemaObject(this.token.tokenString, schemaName.name, type);
        if (this.token.namePrefix != null) {
            if (!this.token.namePrefix.equals(schemaName.name)) {
                throw Error.error(5505, this.token.namePrefix);
            }
            if (this.token.namePrePrefix != null && !this.token.namePrePrefix.equals(this.database.getCatalogName().name)) {
                throw Error.error(5505, this.token.namePrefix);
            }
        }
        this.read();
        return object;
    }

    Table readTableName() {
        this.checkIsIdentifier();
        if (this.token.namePrePrefix != null) {
            this.checkValidCatalogName(this.token.namePrePrefix);
        }
        Table table = this.database.schemaManager.getTable(this.session, this.token.tokenString, this.token.namePrefix);
        this.getRecordedToken().setExpression(table);
        this.read();
        return table;
    }

    ColumnSchema readSimpleColumnName(RangeVariable rangeVar) {
        ColumnSchema column = null;
        this.checkIsIdentifier();
        if (this.token.namePrefix != null) {
            throw this.tooManyIdentifiers();
        }
        int index = rangeVar.findColumn(this.token.tokenString);
        if (index > -1 && rangeVar.resolvesTableName(this.token.namePrefix) && rangeVar.resolvesSchemaName(this.token.namePrePrefix)) {
            column = rangeVar.getTable().getColumn(index);
            this.read();
            return column;
        }
        throw Error.error(5501, this.token.tokenString);
    }

    ColumnSchema readSimpleColumnName(Table table) {
        this.checkIsIdentifier();
        if (this.token.namePrefix != null) {
            throw this.tooManyIdentifiers();
        }
        int index = table.findColumn(this.token.tokenString);
        if (index == -1) {
            throw Error.error(5501, this.token.tokenString);
        }
        ColumnSchema column = table.getColumn(index);
        this.read();
        return column;
    }

    StatementQuery compileDeclareCursor(boolean isRoutine, RangeVariable[] outerRanges) {
        int sensitivity = 0;
        int scrollability = 0;
        int holdability = 0;
        int returnability = 0;
        int position = super.getPosition();
        this.readThis(77);
        HsqlNameManager.SimpleName cursorName = this.readSimpleName();
        switch (this.token.tokenType) {
            case 252: {
                this.read();
                sensitivity = 2;
                break;
            }
            case 134: {
                this.read();
                sensitivity = 1;
                break;
            }
            case 11: {
                this.read();
            }
        }
        if (this.token.tokenType == 180) {
            this.readThis(248);
        } else if (this.token.tokenType == 248) {
            this.read();
            scrollability = 1;
        }
        if (this.token.tokenType != 70) {
            this.rewind(position);
            return null;
        }
        this.readThis(70);
        for (int round = 0; round < 2; ++round) {
            if (this.token.tokenType == 319) {
                this.read();
                if (round == 0 && this.token.tokenType == 126) {
                    this.read();
                    holdability = 1;
                    continue;
                }
                this.readThis(237);
                ++round;
                returnability = 1;
                continue;
            }
            if (this.token.tokenType != 321) continue;
            this.read();
            if (round == 0 && this.token.tokenType == 126) {
                this.read();
                continue;
            }
            this.readThis(237);
            ++round;
        }
        this.readThis(112);
        int props = ResultProperties.getProperties(sensitivity, 1, scrollability, holdability, returnability);
        StatementQuery cs = this.compileCursorSpecification(props, isRoutine, outerRanges);
        cs.setCursorName(cursorName);
        return cs;
    }

    StatementQuery compileCursorSpecification(int props, boolean isRoutine, RangeVariable[] outerRanges) {
        OrderedHashSet colNames = null;
        QueryExpression queryExpression = this.XreadQueryExpression();
        if (this.token.tokenType == 112) {
            this.read();
            if (this.token.tokenType == 480) {
                this.read();
                this.readThis(195);
            } else {
                this.readThis(303);
                props = ResultProperties.addUpdatable(props, true);
                if (this.token.tokenType == 191) {
                    this.readThis(191);
                    colNames = new OrderedHashSet();
                    this.readColumnNameList(colNames, null, false);
                }
            }
        }
        if (ResultProperties.isUpdatable(props)) {
            queryExpression.isUpdatable = true;
        }
        queryExpression.setReturningResult();
        queryExpression.resolve(this.session, outerRanges, null);
        StatementQuery cs = isRoutine ? new StatementCursor(this.session, queryExpression, this.compileContext) : new StatementQuery(this.session, queryExpression, this.compileContext);
        return cs;
    }

    StatementDMQL compileShortCursorSpecification(int props) {
        QueryExpression queryExpression = this.XreadQueryExpression();
        if (ResultProperties.isUpdatable(props)) {
            queryExpression.isUpdatable = true;
        }
        queryExpression.setReturningResult();
        queryExpression.resolve(this.session);
        StatementQuery cs = new StatementQuery(this.session, queryExpression, this.compileContext);
        return cs;
    }

    int readCloseBrackets(int limit) {
        int count;
        for (count = 0; count < limit && this.token.tokenType == 772; ++count) {
            this.read();
        }
        return count;
    }

    int readOpenBrackets() {
        int count = 0;
        while (this.token.tokenType == 786) {
            ++count;
            this.read();
        }
        return count;
    }

    void checkValidCatalogName(String name) {
        if (name != null && !name.equals(this.database.getCatalogName().name)) {
            throw Error.error(5501, name);
        }
    }

    void rewind(int position) {
        super.rewind(position);
        this.compileContext.rewind(position);
    }

    public static final class CompileContext {
        final Session session;
        final ParserBase parser;
        private int subqueryDepth;
        private HsqlArrayList namedSubqueries;
        private OrderedIntKeyHashMap parameters = new OrderedIntKeyHashMap();
        private HsqlArrayList usedSequences = new HsqlArrayList(true);
        private HsqlArrayList usedRoutines = new HsqlArrayList(true);
        private HsqlArrayList rangeVariables = new HsqlArrayList(true);
        private HsqlArrayList usedObjects = new HsqlArrayList(true);
        Type currentDomain;
        boolean contextuallyTypedExpression;
        Routine callProcedure;
        private int rangeVarIndex = 0;

        public CompileContext(Session session, ParserBase parser) {
            this.session = session;
            this.parser = parser;
            this.reset();
        }

        public void reset() {
            this.reset(1);
        }

        public void reset(int n) {
            this.rangeVarIndex = n;
            this.rangeVariables.clear();
            this.subqueryDepth = 0;
            this.parameters.clear();
            this.usedSequences.clear();
            this.usedRoutines.clear();
            this.callProcedure = null;
            this.usedObjects.clear();
            this.currentDomain = null;
            this.contextuallyTypedExpression = false;
        }

        public void rewind(int position) {
            for (int i = this.rangeVariables.size() - 1; i >= 0; --i) {
                RangeVariable range = (RangeVariable)this.rangeVariables.get(i);
                if (range.parsePosition <= position) continue;
                this.rangeVariables.remove(i);
            }
            Iterator it = this.parameters.keySet().iterator();
            while (it.hasNext()) {
                int pos = it.nextInt();
                if (pos < position) continue;
                it.remove();
            }
        }

        public void registerRangeVariable(RangeVariable range) {
            range.parsePosition = this.parser == null ? 0 : this.parser.getPosition();
            range.rangePosition = this.getNextRangeVarIndex();
            range.level = this.subqueryDepth;
            this.rangeVariables.add(range);
        }

        public int getNextRangeVarIndex() {
            return this.rangeVarIndex++;
        }

        public int getRangeVarCount() {
            return this.rangeVarIndex;
        }

        public RangeVariable[] getRangeVariables() {
            RangeVariable[] array = new RangeVariable[this.rangeVariables.size()];
            this.rangeVariables.toArray(array);
            return array;
        }

        public NumberSequence[] getSequences() {
            if (this.usedSequences.size() == 0) {
                return NumberSequence.emptyArray;
            }
            NumberSequence[] array = new NumberSequence[this.usedSequences.size()];
            this.usedSequences.toArray(array);
            return array;
        }

        public Routine[] getRoutines() {
            if (this.callProcedure == null && this.usedRoutines.size() == 0) {
                return Routine.emptyArray;
            }
            OrderedHashSet set = new OrderedHashSet();
            for (int i = 0; i < this.usedRoutines.size(); ++i) {
                FunctionSQLInvoked function = (FunctionSQLInvoked)this.usedRoutines.get(i);
                set.add(function.routine);
            }
            if (this.callProcedure != null) {
                set.add(this.callProcedure);
            }
            Object[] array = new Routine[set.size()];
            set.toArray(array);
            return array;
        }

        private void initSubqueryNames() {
            HashMappedList set;
            if (this.namedSubqueries == null) {
                this.namedSubqueries = new HsqlArrayList();
            }
            if (this.namedSubqueries.size() <= this.subqueryDepth) {
                this.namedSubqueries.setSize(this.subqueryDepth + 1);
            }
            if ((set = (HashMappedList)this.namedSubqueries.get(this.subqueryDepth)) == null) {
                set = new HashMappedList();
                this.namedSubqueries.set(this.subqueryDepth, set);
            } else {
                set.clear();
            }
        }

        private void registerSubquery(String name, SubQuery subquery) {
            HashMappedList set = (HashMappedList)this.namedSubqueries.get(this.subqueryDepth);
            boolean added = set.add(name, subquery);
            if (!added) {
                throw Error.error(5504);
            }
        }

        private SubQuery getNamedSubQuery(String name) {
            if (this.namedSubqueries == null) {
                return null;
            }
            for (int i = this.subqueryDepth; i >= 0; --i) {
                SubQuery sq;
                HashMappedList set;
                if (this.namedSubqueries.size() <= i || (set = (HashMappedList)this.namedSubqueries.get(i)) == null || (sq = (SubQuery)set.get(name)) == null) continue;
                return sq;
            }
            return null;
        }

        private void addParameter(Expression e, int position) {
            this.parameters.put(position, e);
        }

        private void addSchemaObject(SchemaObject object) {
            this.usedObjects.add(object);
        }

        private void addSequence(SchemaObject object) {
            this.usedSequences.add(object);
        }

        void addFunctionCall(FunctionSQLInvoked function) {
            this.usedRoutines.add(function);
        }

        void addProcedureCall(Routine procedure) {
            this.callProcedure = procedure;
        }

        ExpressionColumn[] getParameters() {
            if (this.parameters.size() == 0) {
                return ExpressionColumn.emptyArray;
            }
            Object[] result = new ExpressionColumn[this.parameters.size()];
            this.parameters.valuesToArray(result);
            this.parameters.clear();
            return result;
        }

        void clearParameters() {
            this.parameters.clear();
        }

        public OrderedHashSet getSchemaObjectNames() {
            SchemaObject object;
            int i;
            OrderedHashSet set = new OrderedHashSet();
            for (i = 0; i < this.usedSequences.size(); ++i) {
                object = (SchemaObject)this.usedSequences.get(i);
                set.add(object.getName());
            }
            for (i = 0; i < this.usedObjects.size(); ++i) {
                object = (SchemaObject)this.usedObjects.get(i);
                set.add(object.getName());
            }
            for (i = 0; i < this.rangeVariables.size(); ++i) {
                RangeVariable range = (RangeVariable)this.rangeVariables.get(i);
                HsqlNameManager.HsqlName name = range.rangeTable.getName();
                if (name.schema != SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) {
                    set.add(range.rangeTable.getName());
                    set.addAll(range.getColumnNames());
                    continue;
                }
                if (name.type != 10) continue;
                set.addAll(range.getColumnNames());
            }
            Routine[] routines = this.getRoutines();
            for (int i2 = 0; i2 < routines.length; ++i2) {
                set.add(routines[i2].getSpecificName());
            }
            return set;
        }
    }
}

