/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Comparator;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.QueryExpression;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.TableDerived;
import org.hsqldb.TableUtil;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.navigator.RowSetNavigatorDataTable;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;

class SubQuery
implements Comparator {
    int level;
    private boolean isResolved;
    private boolean isCorrelated;
    private boolean isExistsPredicate;
    private boolean isRecursive;
    private boolean uniqueRows;
    private boolean fullOrder;
    QueryExpression queryExpression;
    Database database;
    private TableDerived table;
    View view;
    View parentView;
    String sql;
    Expression dataExpression;
    boolean isDataExpression;
    SubQuery recursiveSubQuery;
    HsqlNameManager.SimpleName[] columnNames;
    int parsePosition;
    public static final SubQuery[] emptySubqueryArray = new SubQuery[0];

    SubQuery(Database database, int level, QueryExpression queryExpression, int mode) {
        this.level = level;
        this.queryExpression = queryExpression;
        this.database = database;
        switch (mode) {
            case 55: {
                this.isExistsPredicate = true;
                break;
            }
            case 54: {
                this.uniqueRows = true;
                if (queryExpression == null) break;
                queryExpression.setFullOrder();
                break;
            }
            case 57: {
                this.fullOrder = true;
                if (queryExpression == null) break;
                queryExpression.setFullOrder();
            }
        }
    }

    SubQuery(Database database, int level, QueryExpression queryExpression, SubQuery sq) {
        this.level = level;
        this.queryExpression = queryExpression;
        this.database = database;
        this.isRecursive = true;
        this.recursiveSubQuery = sq;
    }

    SubQuery(Database database, int level, Expression dataExpression, int mode) {
        this.level = level;
        this.database = database;
        this.dataExpression = dataExpression;
        dataExpression.subQuery = this;
        this.isDataExpression = true;
        switch (mode) {
            case 54: {
                this.uniqueRows = true;
            }
        }
    }

    SubQuery(Database database, int level, QueryExpression queryExpression, View view) {
        this.level = level;
        this.queryExpression = queryExpression;
        this.database = database;
        this.view = view;
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    public boolean isCorrelated() {
        return this.isCorrelated;
    }

    public void setCorrelated() {
        this.isCorrelated = true;
    }

    public void setUniqueRows() {
        this.uniqueRows = true;
    }

    public TableDerived getTable() {
        return this.table;
    }

    public void createTable() {
        HsqlNameManager.HsqlName name = this.database.nameManager.getSubqueryTableName();
        this.table = new TableDerived(this.database, name, 2, this.queryExpression, this);
    }

    public void prepareTable(Session session, HsqlNameManager.HsqlName name, HsqlNameManager.HsqlName[] columns) {
        if (this.isResolved) {
            return;
        }
        if (this.table == null) {
            this.table = new TableDerived(this.database, name, 2, this.queryExpression, this);
        }
        this.table.columnCount = this.queryExpression.getColumnCount();
        this.table.columnList = this.queryExpression.getColumns();
        if (columns != null) {
            if (columns.length != this.table.columnList.size()) {
                throw Error.error(5593);
            }
            for (int i = 0; i < this.table.columnCount; ++i) {
                this.table.columnList.setKey(i, columns[i].name);
                ColumnSchema col = (ColumnSchema)this.table.columnList.get(i);
                col.getName().rename(columns[i]);
            }
        }
        TableUtil.setTableIndexesForSubquery(this.table, this.uniqueRows || this.fullOrder, this.uniqueRows);
        this.isResolved = true;
    }

    public void prepareTable(Session session) {
        if (this.isResolved) {
            return;
        }
        if (this.view == null) {
            if (this.table == null) {
                HsqlNameManager.HsqlName name = this.database.nameManager.getSubqueryTableName();
                this.table = new TableDerived(this.database, name, 2, this.queryExpression, this);
            }
            if (this.isDataExpression) {
                TableUtil.addAutoColumns(this.table, this.dataExpression.nodeDataTypes);
                TableUtil.setTableIndexesForSubquery(this.table, this.uniqueRows || this.fullOrder, this.uniqueRows);
            } else {
                this.table.columnList = this.queryExpression.getColumns();
                this.table.columnCount = this.queryExpression.getColumnCount();
                TableUtil.setTableIndexesForSubquery(this.table, this.uniqueRows || this.fullOrder, this.uniqueRows);
            }
        } else {
            this.table = new TableDerived(this.database, this.view.getName(), 8, this.queryExpression, this);
            this.table.columnList = this.view.columnList;
            this.table.columnCount = this.table.columnList.size();
            this.table.createPrimaryKey();
        }
        this.isResolved = true;
    }

    public void setColumnNames(HsqlNameManager.SimpleName[] names) {
        this.columnNames = names;
    }

    public HsqlNameManager.SimpleName[] getColumnNames() {
        return this.columnNames;
    }

    public void materialiseCorrelated(Session session) {
        if (this.isCorrelated) {
            this.materialise(session);
        }
    }

    public void materialise(Session session) {
        if (this.isDataExpression) {
            PersistentStore store = session.sessionData.getSubqueryRowStore(this.table);
            this.dataExpression.insertValuesIntoSubqueryTable(session, store);
            return;
        }
        Result result = this.isRecursive ? this.queryExpression.getResultRecursive(session, this.recursiveSubQuery.table) : this.queryExpression.getResult(session, this.isExistsPredicate ? 1 : 0);
        if (this.uniqueRows) {
            RowSetNavigatorData navigator = (RowSetNavigatorData)result.getNavigator();
            navigator.removeDuplicates(session);
        }
        PersistentStore store = session.sessionData.getSubqueryRowStore(this.table);
        this.table.insertResult(session, store, result);
        result.getNavigator().close();
    }

    public boolean hasUniqueNotNullRows(Session session) {
        RowSetNavigatorDataTable navigator = new RowSetNavigatorDataTable(session, this.table);
        boolean result = ((RowSetNavigatorData)navigator).hasUniqueNotNullRows(session);
        return result;
    }

    public Object[] getValues(Session session) {
        RowIterator it = this.table.rowIterator(session);
        if (it.hasNext()) {
            Row row = it.getNextRow();
            if (it.hasNext()) {
                throw Error.error(3201);
            }
            return row.getData();
        }
        return new Object[this.table.getColumnCount()];
    }

    public Object getValue(Session session) {
        Object[] data = this.getValues(session);
        return data[0];
    }

    public RowSetNavigatorData getNavigator(Session session) {
        RowSetNavigatorDataTable navigator = new RowSetNavigatorDataTable(session, this.table);
        return navigator;
    }

    public int compare(Object a, Object b) {
        SubQuery sqa = (SubQuery)a;
        SubQuery sqb = (SubQuery)b;
        if (sqa.parentView == null && sqb.parentView == null) {
            return sqb.level - sqa.level;
        }
        if (sqa.parentView != null && sqb.parentView != null) {
            int diff;
            int ia = this.database.schemaManager.getTableIndex(sqa.parentView);
            int ib = this.database.schemaManager.getTableIndex(sqb.parentView);
            if (ia == -1) {
                ia = this.database.schemaManager.getTables(sqa.parentView.getSchemaName().name).size();
            }
            if (ib == -1) {
                ib = this.database.schemaManager.getTables(sqb.parentView.getSchemaName().name).size();
            }
            return (diff = ia - ib) == 0 ? sqb.level - sqa.level : diff;
        }
        return sqa.parentView == null ? 1 : -1;
    }
}

