/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.utils;

import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;
import org.incava.util.diff.Diff;
import org.incava.util.diff.Difference;
import org.jamwiki.DataAccessException;
import org.jamwiki.model.WikiDiff;
import org.jamwiki.utils.WikiCache;
import org.jamwiki.utils.WikiLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffUtil {
    private static final WikiLogger logger = WikiLogger.getLogger(DiffUtil.class.getName());
    private static final int DIFF_UNCHANGED_LINE_DISPLAY = 2;
    private static final String CACHE_DIFF_INFORMATION = "org.jamwiki.utils.DiffUtil.CACHE_DIFF_INFORMATION";

    private DiffUtil() {
    }

    private static void addToCache(String newVersion, String oldVersion, List<WikiDiff> results) {
        String key = DiffUtil.generateCacheKey(newVersion, oldVersion);
        WikiCache.addToCache(CACHE_DIFF_INFORMATION, key, results);
    }

    private static boolean canPostBuffer(Difference nextDiff, int current, String[] replacementArray, boolean adding) {
        if (current < 0 || current >= replacementArray.length) {
            return false;
        }
        if (nextDiff == null) {
            return true;
        }
        int nextStart = adding ? nextDiff.getAddedStart() : nextDiff.getDeletedStart();
        return nextStart > current;
    }

    private static boolean canPreBuffer(Difference previousDiff, int current, int currentStart, String[] replacementArray, int bufferAmount, boolean adding) {
        int previousStart;
        int previousEnd;
        if (current < 0 || current >= replacementArray.length) {
            return false;
        }
        if (previousDiff == null) {
            return true;
        }
        if (bufferAmount == -1) {
            return false;
        }
        int n = previousEnd = adding ? previousDiff.getAddedEnd() : previousDiff.getDeletedEnd();
        if (previousEnd != -1) {
            return current > previousEnd + bufferAmount;
        }
        int n2 = previousStart = adding ? previousDiff.getAddedStart() : previousDiff.getDeletedStart();
        if (current <= previousStart + bufferAmount) {
            return false;
        }
        return currentStart > current;
    }

    public static List<WikiDiff> diff(String newVersion, String oldVersion) throws DataAccessException {
        List<WikiDiff> result = DiffUtil.retrieveFromCache(newVersion, oldVersion);
        if (result != null) {
            return result;
        }
        String version1 = newVersion;
        String version2 = oldVersion;
        if (version2 == null) {
            version2 = "";
        }
        if (version1 == null) {
            version1 = "";
        }
        version2 = StringUtils.remove((String)version2, (char)'\r');
        version1 = StringUtils.remove((String)version1, (char)'\r');
        result = DiffUtil.process(version1, version2);
        DiffUtil.addToCache(newVersion, oldVersion, result);
        return result;
    }

    private static String generateCacheKey(String newVersion, String oldVersion) {
        StringBuilder result = new StringBuilder();
        if (newVersion == null) {
            result.append(-1);
        } else if (newVersion.length() <= 10) {
            result.append(newVersion);
        } else {
            result.append(newVersion.substring(0, 10)).append(newVersion.hashCode());
        }
        result.append('-');
        if (oldVersion == null) {
            result.append(-1);
        } else if (oldVersion.length() <= 10) {
            result.append(oldVersion);
        } else {
            result.append(oldVersion.substring(0, 10)).append(oldVersion.hashCode());
        }
        return result.toString();
    }

    private static List<WikiDiff> generateWikiDiffs(List<Difference> diffs, String[] oldArray, String[] newArray) {
        ArrayList<WikiDiff> wikiDiffs = new ArrayList<WikiDiff>();
        Difference previousDiff = null;
        Difference nextDiff = null;
        List<WikiDiff> changedLineWikiDiffs = null;
        Object[] oldLineArray = null;
        Object[] newLineArray = null;
        List changedLineDiffs = null;
        ArrayList<WikiDiff> wikiSubDiffs = null;
        Difference nextLineDiff = null;
        int i = 0;
        for (Difference currentDiff : diffs) {
            ++i;
            wikiDiffs.addAll(DiffUtil.preBufferDifference(currentDiff, previousDiff, oldArray, newArray, 2));
            changedLineWikiDiffs = DiffUtil.processDifference(currentDiff, oldArray, newArray);
            for (WikiDiff changedLineWikiDiff : changedLineWikiDiffs) {
                oldLineArray = DiffUtil.stringToArray(changedLineWikiDiff.getOldText());
                newLineArray = DiffUtil.stringToArray(changedLineWikiDiff.getNewText());
                changedLineDiffs = new Diff(oldLineArray, newLineArray).diff();
                wikiSubDiffs = new ArrayList<WikiDiff>();
                int j = 0;
                for (Difference changedLineDiff : changedLineDiffs) {
                    if (++j == 1) {
                        wikiSubDiffs.addAll(DiffUtil.preBufferDifference(changedLineDiff, null, (String[])oldLineArray, (String[])newLineArray, -1));
                    }
                    wikiSubDiffs.addAll(DiffUtil.processDifference(changedLineDiff, (String[])oldLineArray, (String[])newLineArray));
                    nextLineDiff = j < changedLineDiffs.size() ? (Difference)changedLineDiffs.get(j) : null;
                    wikiSubDiffs.addAll(DiffUtil.postBufferDifference(changedLineDiff, nextLineDiff, (String[])oldLineArray, (String[])newLineArray, -1));
                }
                changedLineWikiDiff.setSubDiffs(wikiSubDiffs);
            }
            wikiDiffs.addAll(changedLineWikiDiffs);
            nextDiff = i < diffs.size() ? diffs.get(i) : null;
            wikiDiffs.addAll(DiffUtil.postBufferDifference(currentDiff, nextDiff, oldArray, newArray, 2));
            previousDiff = currentDiff;
        }
        return wikiDiffs;
    }

    private static boolean hasMoreDiffInfo(int addedCurrent, int deletedCurrent, Difference currentDiff) {
        if (addedCurrent == -1) {
            addedCurrent = 0;
        }
        if (deletedCurrent == -1) {
            deletedCurrent = 0;
        }
        return addedCurrent <= currentDiff.getAddedEnd() || deletedCurrent <= currentDiff.getDeletedEnd();
    }

    private static List<WikiDiff> postBufferDifference(Difference currentDiff, Difference nextDiff, String[] oldArray, String[] newArray, int bufferAmount) {
        ArrayList<WikiDiff> wikiDiffs = new ArrayList<WikiDiff>();
        if (bufferAmount == 0) {
            return wikiDiffs;
        }
        int deletedCurrent = currentDiff.getDeletedEnd() == -1 ? currentDiff.getDeletedStart() : currentDiff.getDeletedEnd() + 1;
        int addedCurrent = currentDiff.getAddedEnd() == -1 ? currentDiff.getAddedStart() : currentDiff.getAddedEnd() + 1;
        int numIterations = bufferAmount;
        if (bufferAmount == -1) {
            numIterations = nextDiff != null ? Math.max(nextDiff.getAddedStart() - addedCurrent, nextDiff.getDeletedStart() - deletedCurrent) : Math.max(oldArray.length - deletedCurrent, newArray.length - addedCurrent);
        }
        String oldText = null;
        String newText = null;
        for (int i = 0; i < numIterations; ++i) {
            int position = deletedCurrent < 0 ? 0 : deletedCurrent;
            oldText = null;
            newText = null;
            if (DiffUtil.canPostBuffer(nextDiff, deletedCurrent, oldArray, false)) {
                oldText = oldArray[deletedCurrent];
                ++deletedCurrent;
            }
            if (DiffUtil.canPostBuffer(nextDiff, addedCurrent, newArray, true)) {
                newText = newArray[addedCurrent];
                ++addedCurrent;
            }
            if (oldText == null && newText == null) {
                logger.debug("Possible DIFF bug: no elements post-buffered.  position: " + position + " / deletedCurrent: " + deletedCurrent + " / addedCurrent " + addedCurrent + " / numIterations: " + numIterations);
                break;
            }
            wikiDiffs.add(new WikiDiff(oldText, newText, position));
        }
        return wikiDiffs;
    }

    private static List<WikiDiff> preBufferDifference(Difference currentDiff, Difference previousDiff, String[] oldArray, String[] newArray, int bufferAmount) {
        int addedCurrent;
        ArrayList<WikiDiff> wikiDiffs = new ArrayList<WikiDiff>();
        if (bufferAmount == 0) {
            return wikiDiffs;
        }
        if (bufferAmount == -1 && previousDiff != null) {
            return wikiDiffs;
        }
        int deletedCurrent = bufferAmount == -1 || bufferAmount > currentDiff.getDeletedStart() ? 0 : currentDiff.getDeletedStart() - bufferAmount;
        int n = addedCurrent = bufferAmount == -1 || bufferAmount > currentDiff.getAddedStart() ? 0 : currentDiff.getAddedStart() - bufferAmount;
        if (previousDiff != null) {
            deletedCurrent = Math.max(previousDiff.getDeletedEnd() + 1, deletedCurrent);
            addedCurrent = Math.max(previousDiff.getAddedEnd() + 1, addedCurrent);
        }
        int numIterations = Math.max(currentDiff.getDeletedStart() - deletedCurrent, currentDiff.getAddedStart() - addedCurrent);
        String oldText = null;
        String newText = null;
        for (int i = 0; i < numIterations; ++i) {
            int position = deletedCurrent < 0 ? 0 : deletedCurrent;
            oldText = null;
            newText = null;
            if (DiffUtil.canPreBuffer(previousDiff, deletedCurrent, currentDiff.getDeletedStart(), oldArray, bufferAmount, false)) {
                oldText = oldArray[deletedCurrent];
                ++deletedCurrent;
            }
            if (DiffUtil.canPreBuffer(previousDiff, addedCurrent, currentDiff.getAddedStart(), newArray, bufferAmount, true)) {
                newText = newArray[addedCurrent];
                ++addedCurrent;
            }
            if (oldText == null && newText == null) {
                logger.debug("Possible DIFF bug: no elements pre-buffered.  position: " + position + " / deletedCurrent: " + deletedCurrent + " / addedCurrent " + addedCurrent + " / numIterations: " + numIterations);
                break;
            }
            wikiDiffs.add(new WikiDiff(oldText, newText, position));
        }
        return wikiDiffs;
    }

    private static List<WikiDiff> process(String newVersion, String oldVersion) {
        logger.trace("Diffing: " + oldVersion + " against: " + newVersion);
        if (newVersion.equals(oldVersion)) {
            return new ArrayList<WikiDiff>();
        }
        Object[] oldArray = DiffUtil.split(oldVersion);
        Object[] newArray = DiffUtil.split(newVersion);
        Diff diffObject = new Diff(oldArray, newArray);
        List diffs = diffObject.diff();
        return DiffUtil.generateWikiDiffs(diffs, (String[])oldArray, (String[])newArray);
    }

    private static List<WikiDiff> processDifference(Difference currentDiff, String[] oldArray, String[] newArray) {
        ArrayList<WikiDiff> wikiDiffs = new ArrayList<WikiDiff>();
        int deletedCurrent = currentDiff.getDeletedStart();
        int addedCurrent = currentDiff.getAddedStart();
        int count = 0;
        String oldText = null;
        String newText = null;
        while (DiffUtil.hasMoreDiffInfo(addedCurrent, deletedCurrent, currentDiff)) {
            int position = deletedCurrent < 0 ? 0 : deletedCurrent;
            oldText = null;
            newText = null;
            if (currentDiff.getDeletedEnd() >= 0 && currentDiff.getDeletedEnd() >= deletedCurrent) {
                oldText = oldArray[deletedCurrent];
                ++deletedCurrent;
            }
            if (currentDiff.getAddedEnd() >= 0 && currentDiff.getAddedEnd() >= addedCurrent) {
                newText = newArray[addedCurrent];
                ++addedCurrent;
            }
            wikiDiffs.add(new WikiDiff(oldText, newText, position));
            if (++count <= 5000) continue;
            logger.warn("Infinite loop in DiffUtils.processDifference");
            break;
        }
        return wikiDiffs;
    }

    private static List<WikiDiff> retrieveFromCache(String newVersion, String oldVersion) throws DataAccessException {
        String key = DiffUtil.generateCacheKey(newVersion, oldVersion);
        Element cachedDiffInformation = WikiCache.retrieveFromCache(CACHE_DIFF_INFORMATION, key);
        return cachedDiffInformation != null ? (List)cachedDiffInformation.getObjectValue() : null;
    }

    private static String[] split(String original) {
        if (original == null) {
            return new String[0];
        }
        return original.split("\n");
    }

    private static String[] stringToArray(String original) {
        if (original == null) {
            return new String[0];
        }
        String[] result = new String[original.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = String.valueOf(original.charAt(i));
        }
        return result;
    }
}

