/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.ogg;

public class CRCUtils {
    protected static final Integer CRC_POLYNOMIAL = 79764919;
    private static int[] CRC_TABLE = new int[256];

    public static int getCRC(byte[] data) {
        return CRCUtils.getCRC(data, 0);
    }

    public static int getCRC(byte[] data, int previous) {
        int crc = previous;
        for (int i = 0; i < data.length; ++i) {
            int a = crc << 8;
            int b = CRC_TABLE[crc >>> 24 & 0xFF ^ data[i] & 0xFF];
            crc = a ^ b;
        }
        return crc;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int crc = i << 24;
            for (int j = 0; j < 8; ++j) {
                if ((crc & Integer.MIN_VALUE) != 0) {
                    crc = crc << 1 ^ CRC_POLYNOMIAL;
                    continue;
                }
                crc <<= 1;
            }
            CRCUtils.CRC_TABLE[i] = crc;
        }
    }
}

