/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaAnnotationImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaClassImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelImpl;

public class JavaFieldImpl
implements JavaField {
    protected Field jField;
    private JavaModelImpl javaModelImpl;

    public JavaFieldImpl(Field javaField, JavaModelImpl javaModelImpl) {
        this.jField = javaField;
        this.javaModelImpl = javaModelImpl;
    }

    public JavaAnnotation getAnnotation(JavaClass arg0) {
        Class annotationClass;
        if (arg0 != null && this.jField.isAnnotationPresent(annotationClass = ((JavaClassImpl)arg0).getJavaClass())) {
            return new JavaAnnotationImpl((Annotation)this.jField.getAnnotation(annotationClass));
        }
        return null;
    }

    public Collection getAnnotations() {
        Annotation[] annotations;
        ArrayList<JavaAnnotationImpl> annotationCollection = new ArrayList<JavaAnnotationImpl>();
        for (Annotation annotation : annotations = this.jField.getAnnotations()) {
            annotationCollection.add(new JavaAnnotationImpl(annotation));
        }
        return annotationCollection;
    }

    public int getModifiers() {
        return this.jField.getModifiers();
    }

    public String getName() {
        return this.jField.getName();
    }

    public JavaClass getOwningClass() {
        return this.javaModelImpl.getClass(this.jField.getDeclaringClass());
    }

    public JavaClass getResolvedType() {
        Class<?> fieldType = this.jField.getType();
        Type genericType = this.jField.getGenericType();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)genericType;
            return new JavaClassImpl(pType, (Class)pType.getRawType(), this.javaModelImpl);
        }
        return this.javaModelImpl.getClass(fieldType);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    public boolean isSynthetic() {
        return this.jField.isSynthetic();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public boolean isEnumConstant() {
        return this.jField.isEnumConstant();
    }

    public JavaAnnotation getDeclaredAnnotation(JavaClass arg0) {
        return null;
    }

    public Collection getDeclaredAnnotations() {
        return null;
    }
}

