/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.tags;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.decorator.AutolinkColumnDecorator;
import org.displaytag.decorator.DisplaytagColumnDecorator;
import org.displaytag.decorator.EscapeXmlColumnDecorator;
import org.displaytag.decorator.MessageFormatColumnDecorator;
import org.displaytag.exception.DecoratorInstantiationException;
import org.displaytag.exception.InvalidTagAttributeValueException;
import org.displaytag.exception.ObjectLookupException;
import org.displaytag.exception.TagStructureException;
import org.displaytag.model.Cell;
import org.displaytag.model.HeaderCell;
import org.displaytag.properties.MediaTypeEnum;
import org.displaytag.properties.SortOrderEnum;
import org.displaytag.tags.TableTag;
import org.displaytag.util.DefaultHref;
import org.displaytag.util.Href;
import org.displaytag.util.HtmlAttributeMap;
import org.displaytag.util.MediaUtil;
import org.displaytag.util.MultipleHtmlAttribute;

public class ColumnTag
extends BodyTagSupport
implements MediaUtil.SupportsMedia {
    private static final long serialVersionUID = 899149338534L;
    private static Log log = LogFactory.getLog((Class)ColumnTag.class);
    private HtmlAttributeMap attributeMap = new HtmlAttributeMap();
    private HtmlAttributeMap headerAttributeMap = new HtmlAttributeMap();
    private String property;
    private String title;
    private boolean nulls;
    private boolean sortable;
    private String sortName;
    private SortOrderEnum defaultorder;
    private Comparator comparator;
    private boolean autolink;
    private boolean escapeXml;
    private String format;
    private int group = -1;
    private Href href;
    private String paramId;
    private String paramName;
    private String paramProperty;
    private String paramScope;
    private int maxLength;
    private int maxWords;
    private String decorator;
    private boolean alreadySorted;
    private List supportedMedia;
    private String titleKey;
    private String sortProperty;
    private boolean totaled;
    private Object value;

    public void setTotal(boolean totals) {
        this.totaled = totals;
    }

    public void setProperty(String value) {
        this.property = value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setComparator(Object comparatorObj) {
        if (comparatorObj instanceof Comparator) {
            this.comparator = (Comparator)comparatorObj;
        } else {
            if (comparatorObj instanceof String) {
                Class<?> compClass;
                String comparatorClassname = (String)comparatorObj;
                try {
                    compClass = Thread.currentThread().getContextClassLoader().loadClass(comparatorClassname);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("InstantiationException setting column comparator as " + comparatorClassname + ": " + e.getMessage(), e);
                }
                try {
                    this.comparator = (Comparator)compClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("InstantiationException setting column comparator as " + comparatorClassname + ": " + e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("IllegalAccessException setting column comparator as " + comparatorClassname + ": " + e.getMessage(), e);
                }
            }
            throw new IllegalArgumentException("Value for comparator: " + comparatorObj + " of type " + comparatorObj.getClass().getName());
        }
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public void setFormat(String value) {
        this.format = value;
    }

    public void setNulls(boolean value) {
        this.nulls = value;
    }

    public void setSortable(boolean value) {
        this.sortable = value;
    }

    public void setAutolink(boolean value) {
        this.autolink = value;
    }

    public void setEscapeXml(boolean value) {
        this.escapeXml = value;
    }

    public void setGroup(int value) {
        this.group = value;
    }

    public void setTitleKey(String value) {
        this.titleKey = value;
    }

    public void setHref(String value) {
        String encodedHref = ((HttpServletResponse)this.pageContext.getResponse()).encodeURL(StringUtils.defaultString((String)value));
        this.href = new DefaultHref(encodedHref);
    }

    public void setUrl(String value) {
        HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
        String encodedHref = ((HttpServletResponse)this.pageContext.getResponse()).encodeURL(StringUtils.defaultString((String)(req.getContextPath() + value)));
        this.href = new DefaultHref(encodedHref);
    }

    public void setParamId(String value) {
        this.paramId = value;
    }

    public void setParamName(String value) {
        this.paramName = value;
    }

    public void setParamProperty(String value) {
        this.paramProperty = value;
    }

    public void setParamScope(String value) {
        this.paramScope = value;
    }

    public void setScope(String value) {
        this.attributeMap.put("scope", value);
    }

    public void setHeaderScope(String value) {
        this.headerAttributeMap.put("scope", value);
    }

    public void setMaxLength(int value) {
        this.maxLength = value;
    }

    public void setMaxWords(int value) {
        this.maxWords = value;
    }

    public void setStyle(String value) {
        this.attributeMap.put("style", value);
    }

    public void setClass(String value) {
        this.attributeMap.put("class", new MultipleHtmlAttribute(value));
    }

    public void setHeaderClass(String value) {
        this.headerAttributeMap.put("class", new MultipleHtmlAttribute(value));
    }

    public void setDecorator(String value) {
        this.decorator = value;
    }

    public void setSortProperty(String value) {
        this.sortProperty = value;
    }

    protected TableTag getTableTag() {
        return (TableTag)ColumnTag.findAncestorWithClass((Tag)this, (Class)TableTag.class);
    }

    public void setMedia(String media) {
        MediaUtil.setMedia(this, media);
    }

    public void setSupportedMedia(List media) {
        this.supportedMedia = media;
    }

    public List getSupportedMedia() {
        return this.supportedMedia;
    }

    public void setSortName(String sortName) {
        this.sortName = sortName;
    }

    public void setDefaultorder(String value) throws InvalidTagAttributeValueException {
        this.defaultorder = SortOrderEnum.fromName(value);
        if (this.defaultorder == null) {
            throw new InvalidTagAttributeValueException(this.getClass(), "defaultorder", value);
        }
    }

    public int doEndTag() throws JspException {
        TableTag tableTag = this.getTableTag();
        MediaTypeEnum currentMediaType = (MediaTypeEnum)this.pageContext.findAttribute("mediaType");
        if (currentMediaType != null && !MediaUtil.availableForMedia(this, currentMediaType)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("skipping column body, currentMediaType=" + currentMediaType));
            }
            return 0;
        }
        if (tableTag.isFirstIteration()) {
            this.addHeaderToTable(tableTag);
        }
        if (!tableTag.isIncludedRow()) {
            return super.doEndTag();
        }
        Cell cell = null;
        if (this.property == null && this.value != null) {
            cell = new Cell(this.value);
        } else if (this.property == null && this.bodyContent != null) {
            cell = new Cell(this.bodyContent.getString());
        }
        Object rowStyle = this.attributeMap.get("style");
        Object rowClass = this.attributeMap.get("class");
        if (rowStyle != null || rowClass != null) {
            HtmlAttributeMap perRowValues = new HtmlAttributeMap();
            if (rowStyle != null) {
                perRowValues.put("style", rowStyle);
            }
            if (rowClass != null) {
                perRowValues.put("class", rowClass);
            }
            if (cell == null) {
                cell = new Cell(null);
            }
            cell.setPerRowAttributes(perRowValues);
        }
        tableTag.addCell(cell != null ? cell : Cell.EMPTY_CELL);
        this.alreadySorted = false;
        return super.doEndTag();
    }

    private void addHeaderToTable(TableTag tableTag) throws DecoratorInstantiationException, ObjectLookupException {
        String evalTitle = this.title;
        if (evalTitle == null && (this.titleKey != null || this.property != null)) {
            evalTitle = tableTag.getProperties().geResourceProvider().getResource(this.titleKey, this.property, (Tag)tableTag, this.pageContext);
        }
        HeaderCell headerCell = new HeaderCell();
        headerCell.setHeaderAttributes((HtmlAttributeMap)this.headerAttributeMap.clone());
        headerCell.setHtmlAttributes((HtmlAttributeMap)this.attributeMap.clone());
        headerCell.setTitle(evalTitle);
        headerCell.setSortable(this.sortable);
        ArrayList<DisplaytagColumnDecorator> decorators = new ArrayList<DisplaytagColumnDecorator>();
        if (StringUtils.isNotEmpty((String)this.decorator)) {
            String[] decoratorNames = StringUtils.split((String)this.decorator);
            for (int j = 0; j < decoratorNames.length; ++j) {
                decorators.add(tableTag.getProperties().getDecoratorFactoryInstance().loadColumnDecorator(this.pageContext, decoratorNames[j]));
            }
        }
        if (this.escapeXml) {
            decorators.add(EscapeXmlColumnDecorator.INSTANCE);
        }
        if (this.autolink) {
            decorators.add(AutolinkColumnDecorator.INSTANCE);
        }
        if (StringUtils.isNotBlank((String)this.format)) {
            decorators.add(new MessageFormatColumnDecorator(this.format, tableTag.getProperties().getLocale()));
        }
        headerCell.setColumnDecorators(decorators.toArray(new DisplaytagColumnDecorator[decorators.size()]));
        headerCell.setBeanPropertyName(this.property);
        headerCell.setShowNulls(this.nulls);
        headerCell.setMaxLength(this.maxLength);
        headerCell.setMaxWords(this.maxWords);
        headerCell.setGroup(this.group);
        headerCell.setSortProperty(this.sortProperty);
        headerCell.setTotaled(this.totaled);
        Comparator headerComparator = this.comparator != null ? this.comparator : tableTag.getProperties().getDefaultComparator();
        headerCell.setComparator(headerComparator);
        headerCell.setDefaultSortOrder(this.defaultorder);
        headerCell.setSortName(this.sortName);
        if (this.href != null) {
            Href colHref = StringUtils.isEmpty((String)this.href.getBaseUrl()) ? (Href)tableTag.getBaseHref().clone() : (Href)this.href.clone();
            if (this.paramId != null) {
                if (this.paramName != null || this.paramScope != null) {
                    StringBuffer expression = new StringBuffer();
                    if (StringUtils.isNotBlank((String)this.paramScope)) {
                        expression.append(this.paramScope).append("Scope.");
                    }
                    if (this.paramId != null) {
                        expression.append(this.paramName);
                    } else {
                        expression.append(tableTag.getName());
                    }
                    if (StringUtils.isNotBlank((String)this.paramProperty)) {
                        expression.append('.').append(this.paramProperty);
                    }
                    Object paramValue = tableTag.evaluateExpression(expression.toString());
                    colHref.addParameter(this.paramId, paramValue);
                } else {
                    headerCell.setParamName(this.paramId);
                    headerCell.setParamProperty(this.paramProperty);
                }
            }
            headerCell.setHref(colHref);
        }
        tableTag.addColumn(headerCell);
        if (log.isDebugEnabled()) {
            log.debug((Object)("columnTag.addHeaderToTable() :: first iteration - adding header " + headerCell));
        }
    }

    public void release() {
        super.release();
        this.attributeMap.clear();
        this.autolink = false;
        this.decorator = null;
        this.group = -1;
        this.headerAttributeMap.clear();
        this.href = null;
        this.maxLength = 0;
        this.maxWords = 0;
        this.nulls = false;
        this.paramId = null;
        this.paramName = null;
        this.paramProperty = null;
        this.paramScope = null;
        this.property = null;
        this.sortable = false;
        this.sortName = null;
        this.supportedMedia = null;
        this.title = null;
        this.titleKey = null;
        this.sortProperty = null;
        this.comparator = null;
        this.defaultorder = null;
        this.escapeXml = false;
        this.format = null;
        this.value = null;
        this.totaled = false;
    }

    public int doStartTag() throws JspException {
        TableTag tableTag = this.getTableTag();
        if (tableTag == null) {
            throw new TagStructureException(this.getClass(), "column", "table");
        }
        if (tableTag.isEmpty() || !tableTag.isIncludedRow()) {
            return 0;
        }
        MediaTypeEnum currentMediaType = (MediaTypeEnum)this.pageContext.findAttribute("mediaType");
        if (!MediaUtil.availableForMedia(this, currentMediaType)) {
            return 0;
        }
        return super.doStartTag();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("bodyContent", (Object)this.bodyContent).append("group", this.group).append("maxLength", this.maxLength).append("decorator", (Object)this.decorator).append("href", (Object)this.href).append("title", (Object)this.title).append("paramScope", (Object)this.paramScope).append("property", (Object)this.property).append("paramProperty", (Object)this.paramProperty).append("headerAttributeMap", (Object)this.headerAttributeMap).append("paramName", (Object)this.paramName).append("autolink", this.autolink).append("format", (Object)this.format).append("nulls", this.nulls).append("maxWords", this.maxWords).append("attributeMap", (Object)this.attributeMap).append("sortable", this.sortable).append("paramId", (Object)this.paramId).append("alreadySorted", this.alreadySorted).append("sortProperty", (Object)this.sortProperty).append("defaultSortOrder", (Object)this.defaultorder).toString();
    }
}

