/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent;

import com.liferay.portal.kernel.concurrent.ReadWriteLockKey;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ReadWriteLockRegistry {
    private ConcurrentMap<ReadWriteLockKey<?>, ReadWriteLock> _readWriteLockMap = new ConcurrentHashMap();

    public Lock acquireLock(ReadWriteLockKey<?> readWriteLockKey) {
        ReentrantReadWriteLock newReadWriteLock;
        ReadWriteLock readWriteLock = (ReadWriteLock)this._readWriteLockMap.get(readWriteLockKey);
        if (readWriteLock == null && (readWriteLock = this._readWriteLockMap.putIfAbsent(readWriteLockKey, newReadWriteLock = new ReentrantReadWriteLock())) == null) {
            readWriteLock = newReadWriteLock;
        }
        if (readWriteLockKey.isWriteLock()) {
            return readWriteLock.writeLock();
        }
        return readWriteLock.readLock();
    }

    public void releaseLock(ReadWriteLockKey<?> readWriteLockKey) {
        if (readWriteLockKey.isWriteLock()) {
            this._readWriteLockMap.remove(readWriteLockKey);
        }
    }
}

