/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.filters.compoundsessionid;

import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.Validator;

public class CompoundSessionIdSplitterUtil {
    private static final boolean _hasSessionDelimiter;
    private static final String _sessionIdDelimiter;

    static {
        String sessionIdDelimiter = PropsUtil.get("session.id.delimiter");
        if (Validator.isNull(sessionIdDelimiter)) {
            sessionIdDelimiter = PropsUtil.get("session.id." + ServerDetector.getServerId() + ".delimiter");
        }
        if (Validator.isNotNull(sessionIdDelimiter)) {
            _hasSessionDelimiter = true;
            _sessionIdDelimiter = sessionIdDelimiter;
        } else {
            _hasSessionDelimiter = false;
            _sessionIdDelimiter = "";
        }
    }

    public static String getSessionIdDelimiter() {
        return _sessionIdDelimiter;
    }

    public static boolean hasSessionDelimiter() {
        return _hasSessionDelimiter;
    }

    public static String parseSessionId(String sessionId) {
        if (!_hasSessionDelimiter) {
            return sessionId;
        }
        int pos = sessionId.indexOf(_sessionIdDelimiter);
        if (pos == -1) {
            return sessionId;
        }
        return sessionId.substring(0, pos);
    }
}

