/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.standard.processors;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import org.apache.lucene.messages.Message;
import org.apache.lucene.messages.MessageImpl;
import org.apache.lucene.queryParser.core.QueryNodeException;
import org.apache.lucene.queryParser.core.QueryNodeParseException;
import org.apache.lucene.queryParser.core.config.FieldConfig;
import org.apache.lucene.queryParser.core.config.QueryConfigHandler;
import org.apache.lucene.queryParser.core.messages.QueryParserMessages;
import org.apache.lucene.queryParser.core.nodes.ParametricQueryNode;
import org.apache.lucene.queryParser.core.nodes.ParametricRangeQueryNode;
import org.apache.lucene.queryParser.core.nodes.QueryNode;
import org.apache.lucene.queryParser.core.processors.QueryNodeProcessorImpl;
import org.apache.lucene.queryParser.core.util.StringUtils;
import org.apache.lucene.queryParser.standard.config.NumericConfig;
import org.apache.lucene.queryParser.standard.config.StandardQueryConfigHandler;
import org.apache.lucene.queryParser.standard.nodes.NumericQueryNode;
import org.apache.lucene.queryParser.standard.nodes.NumericRangeQueryNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericRangeQueryNodeProcessor
extends QueryNodeProcessorImpl {
    @Override
    protected QueryNode postProcessNode(QueryNode node) throws QueryNodeException {
        NumericConfig numericConfig;
        ParametricRangeQueryNode parametricRangeNode;
        FieldConfig fieldConfig;
        QueryConfigHandler config;
        if (node instanceof ParametricRangeQueryNode && (config = this.getQueryConfigHandler()) != null && (fieldConfig = config.getFieldConfig(StringUtils.toString((parametricRangeNode = (ParametricRangeQueryNode)node).getField()))) != null && (numericConfig = fieldConfig.get(StandardQueryConfigHandler.ConfigurationKeys.NUMERIC_CONFIG)) != null) {
            Number upperNumber;
            Number lowerNumber;
            ParametricQueryNode lower = parametricRangeNode.getLowerBound();
            ParametricQueryNode upper = parametricRangeNode.getUpperBound();
            NumberFormat numberFormat = numericConfig.getNumberFormat();
            try {
                lowerNumber = numberFormat.parse(lower.getTextAsString());
            }
            catch (ParseException e) {
                throw new QueryNodeParseException((Message)new MessageImpl(QueryParserMessages.COULD_NOT_PARSE_NUMBER, new Object[]{lower.getTextAsString(), numberFormat.getClass().getCanonicalName()}), (Throwable)e);
            }
            try {
                upperNumber = numberFormat.parse(upper.getTextAsString());
            }
            catch (ParseException e) {
                throw new QueryNodeParseException((Message)new MessageImpl(QueryParserMessages.COULD_NOT_PARSE_NUMBER, new Object[]{upper.getTextAsString(), numberFormat.getClass().getCanonicalName()}), (Throwable)e);
            }
            switch (numericConfig.getType()) {
                case LONG: {
                    upperNumber = upperNumber.longValue();
                    lowerNumber = lowerNumber.longValue();
                    break;
                }
                case INT: {
                    upperNumber = upperNumber.intValue();
                    lowerNumber = lowerNumber.intValue();
                    break;
                }
                case DOUBLE: {
                    upperNumber = upperNumber.doubleValue();
                    lowerNumber = lowerNumber.doubleValue();
                    break;
                }
                case FLOAT: {
                    upperNumber = Float.valueOf(upperNumber.floatValue());
                    lowerNumber = Float.valueOf(lowerNumber.floatValue());
                }
            }
            NumericQueryNode lowerNode = new NumericQueryNode(parametricRangeNode.getField(), lowerNumber, numberFormat);
            NumericQueryNode upperNode = new NumericQueryNode(parametricRangeNode.getField(), upperNumber, numberFormat);
            boolean upperInclusive = upper.getOperator() == ParametricQueryNode.CompareOperator.LE;
            boolean lowerInclusive = lower.getOperator() == ParametricQueryNode.CompareOperator.GE;
            return new NumericRangeQueryNode(lowerNode, upperNode, lowerInclusive, upperInclusive, numericConfig);
        }
        return node;
    }

    @Override
    protected QueryNode preProcessNode(QueryNode node) throws QueryNodeException {
        return node;
    }

    @Override
    protected List<QueryNode> setChildrenOrder(List<QueryNode> children) throws QueryNodeException {
        return children;
    }
}

