/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cluster;

import org.apache.jackrabbit.core.cluster.ClusterRecord;
import org.apache.jackrabbit.core.cluster.ClusterRecordProcessor;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;

public class NamespaceRecord
extends ClusterRecord {
    static final char IDENTIFIER = 'S';
    private String oldPrefix;
    private String newPrefix;
    private String uri;

    public NamespaceRecord(String oldPrefix, String newPrefix, String uri, Record record) {
        super(record);
        this.oldPrefix = oldPrefix;
        this.newPrefix = newPrefix;
        this.uri = uri;
    }

    NamespaceRecord(Record record) {
        super(record);
    }

    protected void doRead() throws JournalException {
        this.oldPrefix = this.record.readString();
        this.newPrefix = this.record.readString();
        this.uri = this.record.readString();
    }

    protected void doWrite() throws JournalException {
        this.record.writeChar('S');
        this.record.writeString(this.oldPrefix);
        this.record.writeString(this.newPrefix);
        this.record.writeString(this.uri);
    }

    public void process(ClusterRecordProcessor processor) {
        processor.process(this);
    }

    public String getOldPrefix() {
        return this.oldPrefix;
    }

    public String getNewPrefix() {
        return this.newPrefix;
    }

    public String getUri() {
        return this.uri;
    }
}

