/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.fs.db;

import javax.sql.DataSource;
import org.apache.jackrabbit.core.fs.db.DatabaseFileSystem;
import org.apache.jackrabbit.core.util.db.ConnectionFactory;
import org.apache.jackrabbit.core.util.db.DatabaseAware;

public class DbFileSystem
extends DatabaseFileSystem
implements DatabaseAware {
    protected String driver;
    protected String url;
    protected String user;
    protected String password;
    protected String dataSourceName;
    private ConnectionFactory connectionFactory;

    public void setConnectionFactory(ConnectionFactory connnectionFactory) {
        this.connectionFactory = connnectionFactory;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DbFileSystem) {
            DbFileSystem other = (DbFileSystem)obj;
            if ((this.driver != null ? this.driver.equals(other.driver) : other.driver == null) && (this.url != null ? this.url.equals(other.url) : other.url == null) && (this.user != null ? this.user.equals(other.user) : other.user == null) && (this.password != null ? this.password.equals(other.password) : other.password == null) && super.equals(other)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    protected final DataSource getDataSource() throws Exception {
        if (this.getDataSourceName() == null || "".equals(this.getDataSourceName())) {
            return this.connectionFactory.getDataSource(this.getDriver(), this.getUrl(), this.getUser(), this.getPassword());
        }
        String dbType = this.connectionFactory.getDataBaseType(this.dataSourceName);
        if (DatabaseFileSystem.class.getResourceAsStream(dbType + ".ddl") != null) {
            this.setSchema(dbType);
        }
        return this.connectionFactory.getDataSource(this.dataSourceName);
    }
}

