/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.serializer;

import java.util.Map;
import org.apache.abdera.Abdera;
import org.apache.abdera.ext.serializer.AbstractSerializationContext;
import org.apache.abdera.ext.serializer.Serializer;
import org.apache.abdera.ext.serializer.SerializerProvider;
import org.apache.abdera.util.Discover;
import org.apache.abdera.writer.StreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSerializationContext
extends AbstractSerializationContext {
    private static final long serialVersionUID = 740460842415905883L;
    private final Iterable<SerializerProvider> providers = DefaultSerializationContext.loadConverterProviders();

    public DefaultSerializationContext(StreamWriter streamWriter) {
        super(streamWriter);
        this.initSerializers();
    }

    public DefaultSerializationContext(Abdera abdera, StreamWriter streamWriter) {
        super(abdera, streamWriter);
        this.initSerializers();
    }

    private void initSerializers() {
        Iterable<SerializerProvider> providers = this.getConverterProviders();
        for (SerializerProvider provider : providers) {
            for (Map.Entry<Class, Serializer> entry : provider) {
                this.setSerializer(entry.getKey(), entry.getValue());
            }
        }
    }

    public Iterable<SerializerProvider> getConverterProviders() {
        return this.providers;
    }

    protected static synchronized Iterable<SerializerProvider> loadConverterProviders() {
        Iterable<SerializerProvider> providers = Discover.locate("org.apache.abdera.converter.ConverterProvider", new Object[0]);
        return providers;
    }
}

