/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.serializer.impl;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.abdera.ext.serializer.BaseSerializer;
import org.apache.abdera.ext.serializer.Conventions;
import org.apache.abdera.ext.serializer.ObjectContext;
import org.apache.abdera.ext.serializer.SerializationContext;
import org.apache.abdera.model.Comment;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ProcessingInstruction;
import org.apache.abdera.model.TextValue;
import org.apache.abdera.writer.StreamWriter;
import org.apache.abdera.xpath.XPath;

public class FOMSerializer
extends BaseSerializer {
    protected void finish(Object source, ObjectContext objectContext, SerializationContext context, Conventions conventions) {
    }

    protected void init(Object source, ObjectContext objectContext, SerializationContext context, Conventions conventions) {
    }

    protected void process(Object source, ObjectContext objectContext, SerializationContext context, Conventions conventions) {
        StreamWriter sw = context.getStreamWriter();
        if (!(source instanceof Element)) {
            return;
        }
        Element element = (Element)source;
        sw.startElement(element.getQName());
        for (QName attr : element.getAttributes()) {
            sw.writeAttribute(attr, element.getAttributeValue(attr));
        }
        XPath xpath = context.getAbdera().getXPath();
        List children = xpath.selectNodes("node()", element);
        for (Object child : children) {
            if (child instanceof Element) {
                this.process(child, new ObjectContext(child), context, conventions);
                continue;
            }
            if (child instanceof Comment) {
                Comment comment = (Comment)child;
                sw.writeComment(comment.getText());
                continue;
            }
            if (child instanceof ProcessingInstruction) {
                ProcessingInstruction pi = (ProcessingInstruction)child;
                sw.writePI(pi.getText(), pi.getTarget());
                continue;
            }
            if (!(child instanceof TextValue)) continue;
            TextValue tv = (TextValue)child;
            sw.writeElementText(tv.getText());
        }
        sw.endElement();
    }
}

